/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.permission.material;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.material.MaterialService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.permission.material.MaterialSinglePermissionService;
import com.ovopark.training.service.permission.material.MaterialTypePermissionService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.util.ContextUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialPermissionFacadeImpl
implements MaterialPermissionFacade {
    private static final Logger log = LoggerFactory.getLogger(MaterialPermissionFacadeImpl.class);
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private MaterialSinglePermissionService materialSinglePermissionService;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private MaterialTypePermissionService materialTypePermissionService;
    @Autowired
    private MaterialTypeService materialTypeService;

    @Override
    public Set<Integer> getValidMaterialTypeIdSet(Users user, int permissionType, List<Integer> materialTypeIds) {
        return this.materialTypePermissionService.getValidMaterialTypeIdSet(user, permissionType, materialTypeIds);
    }

    @Override
    public Set<Integer> getValidResourceIdSet(Users user, int permissionType, List<Integer> resourceIds) {
        boolean global = this.validGlobal(user, permissionType);
        if (global) {
            return Sets.newHashSet(resourceIds);
        }
        return this.resourceSinglePermissionService.getValidResourceIdSet(user, permissionType, resourceIds);
    }

    @Override
    public boolean isTrainContainsAll(Users user, Integer trainId) {
        TrainingResource resource = this.resourceService.getByTrainId(trainId);
        return this.resourceSinglePermissionService.isTrainContainsAll(resource.getId(), 1, user.getGroupId());
    }

    @Override
    public boolean isTrainContainsAll(Integer groupId, Integer trainId) {
        TrainingResource resource = this.resourceService.getByTrainId(trainId);
        return this.resourceSinglePermissionService.isTrainContainsAll(resource.getId(), 1, groupId);
    }

    @Override
    public Map<Integer, List<Integer>> getUserIdMapByTrainIdList(List<Integer> trainingIdList, Users users) {
        return this.resourceSinglePermissionService.getUserIdMapByTrainIdList(trainingIdList, users.getGroupId());
    }

    @Override
    public Map<Integer, List<Integer>> getUserIdMapByTrainIdList(List<Integer> trainingIdList, Integer groupId) {
        return this.resourceSinglePermissionService.getUserIdMapByTrainIdList(trainingIdList, groupId);
    }

    @Override
    public List<Integer> getValidUserIdByTrainId(Users user, Integer trainId) {
        return this.resourceSinglePermissionService.getUserIdByTrainId(trainId, user.getGroupId());
    }

    @Override
    public List<Integer> getValidUserIdByTrainId(Integer groupId, Integer trainId) {
        return this.resourceSinglePermissionService.getUserIdByTrainId(trainId, groupId);
    }

    @Override
    public boolean validMaterialTypeId(Users user, int permissionType, Integer typeId) {
        return this.materialTypePermissionService.valid(typeId, user, permissionType);
    }

    @Override
    public boolean validGlobal(Users user, int permissionType) {
        Boolean isSuper = this.commonRemoteService.isSuper(user.getId());
        return isSuper != false;
    }

    @Override
    public Integer getIsDownload(Integer resourceId, Integer isDownload, Users user) {
        if (isDownload == null) {
            return 0;
        }
        if (isDownload != 1) {
            return isDownload;
        }
        boolean valid = this.validResource(resourceId, user.getId(), 4);
        return valid ? 1 : 0;
    }

    @Override
    public Integer getIsDownload(TrainingMaterial materialVo, Users user) {
        TrainingMaterial material = this.materialService.getById(materialVo.getId());
        Integer isDownload = material.getIsDownload();
        if (isDownload == null) {
            return 0;
        }
        if (isDownload != 1) {
            return isDownload;
        }
        boolean valid = this.validMaterial(material.getId(), user, 4);
        return valid ? 1 : 0;
    }

    @Override
    public boolean validMaterial(Integer materialId, Users user, int permissionType) {
        return this.validMaterial(materialId, user.getId(), permissionType);
    }

    @Override
    public boolean validMaterial(Integer materialId, Integer userId, int permissionType) {
        Integer resourceId = this.resourceService.getIdByMaterialId(materialId);
        return this.validResource(resourceId, userId, permissionType);
    }

    @Override
    public boolean validTrain(Integer trainId, Users user, int permissionType) {
        return this.validTrain(trainId, user.getId(), permissionType);
    }

    @Override
    public boolean validTrain(Integer trainId, Integer userId, int permissionType) {
        Integer resourceId = this.resourceService.getIdByTrainId(trainId);
        return this.validResource(resourceId, userId, permissionType);
    }

    @Override
    public boolean validResource(Integer resourceId, Integer userId, int permissionType) {
        if (ContextUtil.getEnterpriseId() == null) {
            return false;
        }
        boolean global = this.validGlobal(userId);
        if (global) {
            return true;
        }
        return this.resourceSinglePermissionService.valid(resourceId, userId, permissionType);
    }

    private boolean validGlobal(Integer userId) {
        Boolean isSuper = this.commonRemoteService.isSuper(userId);
        return isSuper != false;
    }

    @Override
    public List<Integer> getValidTypeIdsWhenGlobalIsNull(Users user, int permissionType, Integer categoryId) {
        if (categoryId != null && categoryId > 0) {
            List<Integer> materialTypeIds = this.materialTypeService.getChildTypeIdListNest(categoryId);
            materialTypeIds.add(categoryId);
            Set<Integer> validMaterialTypeIdSet = this.getValidMaterialTypeIdSet(user, permissionType, materialTypeIds);
            return Lists.newArrayList(validMaterialTypeIdSet);
        }
        boolean global = this.validGlobal(user, permissionType);
        if (global) {
            return null;
        }
        Set<Integer> validMaterialTypeIdSet = this.materialTypePermissionService.getValidMaterialTypeIdSet(user, permissionType);
        return Lists.newArrayList(validMaterialTypeIdSet);
    }
}

