/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.permission.material;

import com.ovopark.training.domain.UnitDO;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.Users;
import com.ovopark.training.param.material.MaterialBatchUpdatePermissionParam;
import com.ovopark.training.service.permission.material.MaterialSinglePermissionService;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.vo.TrainingMaterialVo;
import com.ovopark.training.vo.unit.UnitShowVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MaterialSinglePermissionServiceImpl
implements MaterialSinglePermissionService {
    private static final Logger log = LoggerFactory.getLogger(MaterialSinglePermissionServiceImpl.class);
    @Autowired
    private ResourceService resourceService;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;

    @Override
    public boolean insertMaterial(TrainingMaterialVo materialVo) {
        return true;
    }

    @Override
    public boolean updateMaterial(TrainingMaterial materialOld, TrainingMaterialVo materialVo) {
        return true;
    }

    @Override
    public boolean onMaterialTypePermissionChange(Integer materialTypeId) {
        return true;
    }

    @Override
    public void resetTypePermissionByMaterialIdList(List<Integer> materIdList) {
        List<Integer> resourceIdList = this.resourceService.getIdListByMaterialIdList(materIdList);
        this.resourceSinglePermissionService.resetTypePermissionByResourceIdList(resourceIdList);
    }

    @Override
    public boolean onMaterialTypeListPermissionChange(List<Integer> materialTypeIdList) {
        return true;
    }

    @Override
    public String syncMaterialPermission(Integer startMaterialTypeId, Integer endMaterialTypeId) {
        return "";
    }

    @Override
    public void batchUpdate(MaterialBatchUpdatePermissionParam param) {
        this.resourceSinglePermissionService.batchUpdate(param);
    }

    @Override
    public List<UnitShowVo> getSingleUnitShowListByMaterial(Integer materialId, int permissionType) {
        TrainingResource resource = this.resourceService.getByMaterialId(materialId);
        return this.resourceSinglePermissionService.getSingleUnitShowListByMaterial(resource.getId(), permissionType);
    }

    @Override
    public List<UnitDO> getUnitListByMaterialAndPermissionType(Integer materialId, int permissionType) {
        TrainingResource resource = this.resourceService.getByMaterialId(materialId);
        return this.resourceSinglePermissionService.getUnitListByMaterialAndPermissionType(resource.getId(), permissionType);
    }

    @Override
    public boolean validMaterial(Integer materialId, Users user, int permissionType) {
        TrainingResource resource = this.resourceService.getByMaterialId(materialId);
        return this.resourceSinglePermissionService.valid(resource.getId(), user, permissionType);
    }

    @Override
    public List<Integer> getMaterialTypeIdListByPermissionTypeAndSource(Users user, Integer permissionType, int permissionSource) {
        return this.resourceSinglePermissionService.getMaterialTypeIdListByPermissionTypeAndSource(user, permissionType, permissionSource);
    }
}

