/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.resource;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.bo.Page;
import com.ovopark.training.constants.PermissionConst;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.event.EventHelper;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingResourceMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.bo.ResourceUpdateBo;
import com.ovopark.training.model.view.ResourcesVo;
import com.ovopark.training.param.resource.ResourceQueryParam;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.enterprise.HistoryService;
import com.ovopark.training.service.material.MaterialService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.permission.UnitService;
import com.ovopark.training.service.permission.material.MaterialPermissionFacade;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import com.ovopark.training.service.train.TrainService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.DcStorageUrlUtils;
import com.ovopark.training.vo.TrainingResourceVo;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ResourceServiceImpl
implements ResourceService {
    private static final Logger log = LoggerFactory.getLogger(ResourceServiceImpl.class);
    @Autowired
    private TrainingResourceMapper trainingResourceMapper;
    @Autowired
    private MaterialTypeService materialTypeService;
    @Autowired
    private MaterialPermissionFacade materialPermissionFacade;
    @Autowired
    private UnitService unitService;
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;
    @Autowired
    private TrainingMaterialMapper materialMapper;
    @Autowired
    private TrainingMapper trainingMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingCommonService trainingCommonService;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainService trainService;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private HistoryService historyService;

    @Override
    public Integer valid(Integer resourceId, Users user, int permissionType) {
        TrainingResource trainingResource = (TrainingResource)this.trainingResourceMapper.selectById(resourceId);
        if (ObjectUtils.isEmpty((Object)trainingResource)) {
            return 1;
        }
        if (trainingResource.getIsDel() == 1) {
            return 1;
        }
        if (trainingResource.getEnterpriseId() != null && user.getGroupId() != null && trainingResource.getEnterpriseId().compareTo(user.getGroupId()) != 0) {
            return 2;
        }
        boolean global = this.materialPermissionFacade.validGlobal(user, permissionType);
        if (global) {
            return 0;
        }
        boolean valid = this.resourceSinglePermissionService.valid(resourceId, user, permissionType);
        if (!valid) {
            return 3;
        }
        return 0;
    }

    @Override
    public String getResourceStatus(Integer objectId, int permissionType, Integer types, Users user, Integer learnType) {
        if (learnType == 1 || learnType == 0) {
            boolean valid;
            TrainingResource trainingResource = null;
            if (types == 1) {
                trainingResource = this.getByMaterialId(objectId);
            } else if (types == 2) {
                trainingResource = this.getByTrainId(objectId);
            } else if (types == 3) {
                trainingResource = (TrainingResource)this.trainingResourceMapper.selectById(objectId);
            }
            if (ObjectUtils.isEmpty((Object)trainingResource)) {
                return "2";
            }
            if (trainingResource.getIsDel() != null && trainingResource.getIsDel() == 1) {
                return "2";
            }
            if (trainingResource.getIsUsing() != null && trainingResource.getIsUsing() == 0) {
                return "3";
            }
            if (trainingResource.getIsShow() != null && trainingResource.getIsShow() == 0 && (trainingResource.getFileType() == 8 && learnType == 1 || learnType == 0)) {
                return "3";
            }
            if (trainingResource.getEnterpriseId() != null && user.getGroupId() != null && trainingResource.getEnterpriseId().compareTo(user.getGroupId()) != 0) {
                return "4";
            }
            boolean global = this.materialPermissionFacade.validGlobal(user, permissionType);
            if (global) {
                return "1";
            }
            if (!ObjectUtils.isEmpty((Object)trainingResource) && user.getGroupId() != null && (trainingResource.getFileType() == 8 && learnType == 1 || learnType == 0) && !(valid = this.resourceSinglePermissionService.valid(trainingResource.getId(), user, permissionType))) {
                return "4";
            }
        } else if (types == 1) {
            TrainingMaterial trainingMaterial = (TrainingMaterial)this.materialMapper.selectById(objectId);
            if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
                return "2";
            }
            if (trainingMaterial.getIsDel() != null && trainingMaterial.getIsDel() == 1) {
                return "2";
            }
            if (trainingMaterial.getIsUsing() != null && trainingMaterial.getIsUsing() == 0) {
                return "3";
            }
            if (trainingMaterial.getEnterpriseId() != null && user.getGroupId() != null && trainingMaterial.getEnterpriseId().compareTo(user.getGroupId()) != 0) {
                return "4";
            }
        } else if (types == 2) {
            Training training = (Training)this.trainingMapper.selectById(objectId);
            if (ObjectUtils.isEmpty((Object)training)) {
                return "2";
            }
            if (training.getIsDel() != null && training.getIsDel() == 1) {
                return "2";
            }
            if (training.getIsUsing() != null && training.getIsUsing() == 0) {
                return "3";
            }
            if (training.getEnterpriseId() != null && user.getGroupId() != null && training.getEnterpriseId().compareTo(user.getGroupId()) != 0) {
                return "4";
            }
        }
        return "1";
    }

    @Override
    public Integer addResource(TrainingResource trainingResource, Users user) {
        Date now = new Date();
        trainingResource.setEnterpriseId(user.getGroupId());
        trainingResource.setCreater(user.getId());
        trainingResource.setCreateTime(now);
        trainingResource.setUpdater(user.getId());
        trainingResource.setUpdateTime(now);
        int insert = this.trainingResourceMapper.insert(trainingResource);
        this.resourceSinglePermissionService.insertResource(trainingResource);
        EventHelper.sendMaterialTypeStatCountEvent(this, trainingResource.getTypeId());
        return insert;
    }

    @Override
    public Integer updateResource(TrainingResource trainingResource, Users user) {
        Date now = new Date();
        trainingResource.setUpdater(user.getId());
        trainingResource.setUpdateTime(now);
        trainingResource.setEnterpriseId(user.getGroupId());
        TrainingResource oldResource = this.getById(trainingResource.getId());
        int i = this.trainingResourceMapper.updateById(trainingResource);
        if (trainingResource.getReadType() == null) {
            trainingResource.setReadType(oldResource.getReadType());
        }
        if (trainingResource.getDownloadType() == null) {
            trainingResource.setDownloadType(oldResource.getDownloadType());
        }
        this.resourceSinglePermissionService.updateResource(oldResource, trainingResource);
        return i;
    }

    @Override
    public TrainingResource getById(Integer id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TrainingResource::getId, (Object)id);
        return (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public void saveBatchResourceInPermission(ResourcesVo resourcesVo, Users user) {
        if (ObjectUtils.isEmpty((Object)resourcesVo)) {
            return;
        }
        List<Integer> objectIdList = resourcesVo.getObjectIdList();
        if (org.springframework.util.CollectionUtils.isEmpty(objectIdList)) {
            return;
        }
        ResourceUpdateBo resourceUpdateBo = resourcesVo.getResourceUpdateBo();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(TrainingResource::getObjectId, objectIdList);
        if (resourceUpdateBo.getType() == 2) {
            wrapper.eq(TrainingResource::getFileType, (Object)8);
        } else if (resourceUpdateBo.getType() == 1) {
            wrapper.in(TrainingResource::getFileType, this.getMaterialFileTypeList());
        }
        wrapper.set(resourceUpdateBo.getReadType() != null, TrainingResource::getReadType, (Object)resourceUpdateBo.getReadType()).set(resourceUpdateBo.getIsDownload() != null, TrainingResource::getIsDownload, (Object)resourceUpdateBo.getIsDownload()).set(resourceUpdateBo.getDownloadType() != null, TrainingResource::getDownloadType, (Object)resourceUpdateBo.getDownloadType()).set(!ObjectUtils.isEmpty((Object)user), TrainingResource::getUpdater, (Object)user.getId()).set(TrainingResource::getUpdateTime, (Object)new Date());
        this.trainingResourceMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    public TrainingResource getResource(Integer objectId, Integer fileType) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingResource::getObjectId, (Object)objectId);
        if (fileType == 8) {
            wrapper1.eq(TrainingResource::getFileType, (Object)fileType);
        } else {
            wrapper1.in(TrainingResource::getFileType, this.getMaterialFileTypeList());
        }
        ((LambdaQueryWrapper)wrapper1.orderByDesc(TrainingResource::getId)).last(" limit 1 ");
        TrainingResource trainingResource = (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)wrapper1);
        return trainingResource;
    }

    @Override
    public List<TrainingResource> getListByTypeId(Integer materialTypeId) {
        LambdaQueryWrapper materialQuery = new LambdaQueryWrapper();
        materialQuery.eq(TrainingResource::getTypeId, (Object)materialTypeId);
        materialQuery.eq(TrainingResource::getIsDel, (Object)0);
        return this.trainingResourceMapper.selectList((Wrapper)materialQuery);
    }

    @Override
    public List<TrainingResource> getListByIdList(List<Integer> idList) {
        if (org.springframework.util.CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper materialQuery = new LambdaQueryWrapper();
        materialQuery.in(TrainingResource::getId, idList);
        return this.trainingResourceMapper.selectList((Wrapper)materialQuery);
    }

    @Override
    public List<Integer> getIdListByMaterialIdList(List<Integer> materialIdList) {
        if (org.springframework.util.CollectionUtils.isEmpty(materialIdList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingResource::getObjectId, materialIdList);
        queryWrapper.in(TrainingResource::getFileType, this.getMaterialFileTypeList());
        queryWrapper.select(new SFunction[]{TrainingResource::getId});
        return this.trainingResourceMapper.selectList((Wrapper)queryWrapper).stream().map(TrainingResource::getId).collect(Collectors.toList());
    }

    @Override
    public List<Integer> getIdListByTrainIdList(List<Integer> trainIdList) {
        if (org.springframework.util.CollectionUtils.isEmpty(trainIdList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingResource::getObjectId, trainIdList);
        queryWrapper.in(TrainingResource::getFileType, this.getTrainFileTypeList());
        queryWrapper.select(new SFunction[]{TrainingResource::getId});
        return this.trainingResourceMapper.selectList((Wrapper)queryWrapper).stream().map(TrainingResource::getId).collect(Collectors.toList());
    }

    @Override
    public Map<Integer, Integer> getMaterialIdResourceIdMap(List<Integer> materialIdList) {
        if (org.springframework.util.CollectionUtils.isEmpty(materialIdList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingResource::getObjectId, materialIdList);
        queryWrapper.in(TrainingResource::getFileType, this.getMaterialFileTypeList());
        queryWrapper.select(new SFunction[]{TrainingResource::getId, TrainingResource::getObjectId});
        return this.trainingResourceMapper.selectList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(TrainingResource::getObjectId, TrainingResource::getId));
    }

    @Override
    public Map<Integer, Integer> getResourceIdTypeIdMapByIdList(List<Integer> resourceIdList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(TrainingResource::getId, resourceIdList);
        wrapper.select(new SFunction[]{TrainingResource::getId, TrainingResource::getTypeId});
        List list = this.trainingResourceMapper.selectList((Wrapper)wrapper);
        return list.stream().collect(Collectors.toMap(TrainingResource::getId, TrainingResource::getTypeId));
    }

    @Override
    public Result<Void> batchUpdateShareable(List<Integer> resourceIdList, int shareable, Users users) {
        int res = this.trainingResourceMapper.batchUpdateShareable(resourceIdList, shareable, users.getId());
        return ResultUtils.success();
    }

    @Override
    public TrainingResource getByMaterialId(Integer materialId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingResource::getFileType, this.getMaterialFileTypeList());
        queryWrapper.eq(TrainingResource::getObjectId, (Object)materialId);
        return (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public TrainingResource getByTrainId(Integer trainId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List<Integer> trainFileTypeList = this.getTrainFileTypeList();
        queryWrapper.in(TrainingResource::getFileType, trainFileTypeList);
        queryWrapper.eq(TrainingResource::getObjectId, (Object)trainId);
        return (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public Integer getIdByMaterialId(Integer materialId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingResource::getFileType, this.getMaterialFileTypeList());
        queryWrapper.eq(TrainingResource::getObjectId, (Object)materialId);
        queryWrapper.select(new SFunction[]{TrainingResource::getId});
        return ((TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)queryWrapper)).getId();
    }

    @Override
    public Integer getIdByTrainId(Integer trainId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        List<Integer> trainFileTypeList = this.getTrainFileTypeList();
        queryWrapper.in(TrainingResource::getFileType, trainFileTypeList);
        queryWrapper.eq(TrainingResource::getObjectId, (Object)trainId);
        queryWrapper.select(new SFunction[]{TrainingResource::getId});
        return ((TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)queryWrapper)).getId();
    }

    private List<Integer> getMaterialFileTypeList() {
        return Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
    }

    private List<Integer> getTrainFileTypeList() {
        ArrayList list = Lists.newArrayList();
        list.add(8);
        return list;
    }

    @Override
    public void saveResourceAddViewCount(Integer objectId, Integer fileType) {
        TrainingResource trainingResource = this.getResource(objectId, fileType);
        LambdaUpdateWrapper wrapper1 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper1.eq(TrainingResource::getId, (Object)trainingResource.getId())).set(TrainingResource::getViewCount, (Object)((trainingResource.getViewCount() == null ? 0 : trainingResource.getViewCount()) + 1));
        this.trainingResourceMapper.update(null, (Wrapper)wrapper1);
    }

    @Override
    public void saveBatchResourceNoPermission(ResourcesVo resourcesVo, Users user) {
        if (ObjectUtils.isEmpty((Object)resourcesVo)) {
            return;
        }
        List<Integer> objectIdList = resourcesVo.getObjectIdList();
        if (org.springframework.util.CollectionUtils.isEmpty(objectIdList)) {
            return;
        }
        ResourceUpdateBo resourceUpdateBo = resourcesVo.getResourceUpdateBo();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(TrainingResource::getObjectId, objectIdList);
        Integer type = resourceUpdateBo.getType();
        if (type == 2) {
            wrapper.eq(TrainingResource::getFileType, (Object)8);
        } else if (type == 1) {
            ((LambdaUpdateWrapper)wrapper.in(TrainingResource::getFileType, this.getMaterialFileTypeList())).set(!StringUtils.isEmpty((Object)resourceUpdateBo.getPath()), TrainingResource::getPath, (Object)resourceUpdateBo.getPath());
        }
        wrapper.set(resourceUpdateBo.getIsShow() != null, TrainingResource::getIsShow, (Object)resourceUpdateBo.getIsShow()).set(resourceUpdateBo.getIsUsing() != null, TrainingResource::getIsUsing, (Object)resourceUpdateBo.getIsUsing()).set(resourceUpdateBo.getShareable() != null, TrainingResource::getShareable, (Object)resourceUpdateBo.getShareable()).set(resourceUpdateBo.getCoverType() != null, TrainingResource::getCoverType, (Object)resourceUpdateBo.getCoverType()).set(resourceUpdateBo.getCoverUrl() != null, TrainingResource::getCoverUrl, (Object)resourceUpdateBo.getCoverUrl()).set(resourceUpdateBo.getIsDel() != null, TrainingResource::getIsDel, (Object)resourceUpdateBo.getIsDel()).set(TrainingResource::getUpdateTime, (Object)new Date());
        if (!ObjectUtils.isEmpty((Object)user)) {
            wrapper.set(TrainingResource::getUpdater, (Object)user.getId());
        }
        this.trainingResourceMapper.update(null, (Wrapper)wrapper);
        if (resourceUpdateBo.getIsDel() != null && resourceUpdateBo.getIsDel() == 1) {
            List<Integer> idList = Collections.emptyList();
            if (type == 2) {
                idList = this.getIdListByTrainIdList(objectIdList);
            } else if (type == 1) {
                idList = this.getIdListByMaterialIdList(objectIdList);
            }
            EventHelper.sendResourceDelete(this, idList);
        }
    }

    @Override
    public Result<Page<TrainingResourceVo>> getResourceByPage(ResourceQueryParam param, Users user) {
        List<Long> unitIdList;
        List<Integer> materialTypeIds;
        Integer categoryId = param.getMaterialTypeId();
        Integer isShow = param.getIsShow();
        Page page = new Page();
        page.setPageSize(param.getPageSize().intValue());
        page.setPageNumber(param.getPageNumber().intValue());
        if (categoryId == null || categoryId <= 0) {
            materialTypeIds = null;
        } else {
            materialTypeIds = this.materialTypeService.getChildTypeIdListNest(categoryId);
            materialTypeIds.add(categoryId);
        }
        if (!StringUtils.isEmpty((Object)param.getTitle())) {
            this.historyService.saveSearchHistory(param.getTitle(), 1, user);
        }
        int permissionType = param.getPermissionType();
        boolean global = this.materialPermissionFacade.validGlobal(user, permissionType);
        List permissionList = null;
        if (global) {
            unitIdList = null;
        } else {
            permissionList = PermissionConst.getListByPermissionType((int)permissionType);
            unitIdList = this.unitService.getIdListByUserId(user.getId());
            if (org.springframework.util.CollectionUtils.isEmpty(unitIdList)) {
                return ResultUtils.success((Object)page);
            }
        }
        List<TrainingResourceVo> list = this.trainingResourceMapper.getListByPage((Page<TrainingResourceVo>)page, user.getGroupId(), param.getTitle(), materialTypeIds, unitIdList, permissionList, param.getFileTypeList(), isShow, null, param.getOrderByColumn(), param.getOrderType());
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return ResultUtils.success((Object)page);
        }
        this.getResourceData(list, user);
        page.setContent(list);
        return ResultUtils.success((Object)page);
    }

    @Override
    public Result<Page<TrainingResourceVo>> getResourceByPageForAdmin(ResourceQueryParam param, Users user) {
        int permissionType = param.getPermissionType();
        if (permissionType != 5) {
            return ResultUtils.fail((String)"\u4e0d\u5141\u8bb8\u7684\u7c7b\u578b");
        }
        Integer categoryId = param.getMaterialTypeId();
        Integer isShow = param.getIsShow();
        Page page = new Page();
        page.setPageSize(param.getPageSize().intValue());
        page.setPageNumber(param.getPageNumber().intValue());
        List<Integer> materialTypeIds = this.materialPermissionFacade.getValidTypeIdsWhenGlobalIsNull(user, permissionType, categoryId);
        if (materialTypeIds != null && materialTypeIds.isEmpty()) {
            return ResultUtils.success((Object)page);
        }
        List<TrainingResourceVo> list = this.trainingResourceMapper.getListAdminByPage((Page<TrainingResourceVo>)page, user.getGroupId(), param.getTitle(), materialTypeIds, param.getFileTypeList(), isShow, param.getOrderByColumn(), param.getOrderType());
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return ResultUtils.success((Object)page);
        }
        this.getResourceData(list, user);
        page.setContent(list);
        return ResultUtils.success((Object)page);
    }

    private void getResourceData(List<TrainingResourceVo> list, Users user) {
        ArrayList trainingMaterialIdList = list.stream().filter(e -> e.getFileType().compareTo(8) != 0).map(TrainingResource::getObjectId).collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(trainingMaterialIdList)) {
            trainingMaterialIdList = Lists.newArrayList();
        }
        HashSet creatorSet = new HashSet();
        ArrayList materialResourceIdList = Lists.newArrayList();
        for (TrainingResourceVo r : list) {
            Integer creater = r.getCreater();
            CollectionUtils.addIgnoreNull(creatorSet, (Object)creater);
            if (r.getFileType().compareTo(8) == 0) continue;
            materialResourceIdList.add(r.getId());
        }
        List trainingIdList = list.stream().filter(e -> e.getFileType() == 8).map(TrainingResource::getObjectId).collect(Collectors.toList());
        Map<Object, Object> trainingChapterAttachMap = Maps.newHashMap();
        Map<Object, Object> trainingUserPaperMap = Maps.newHashMap();
        HashMap trainingSourceTypeMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(trainingIdList)) {
            List trainingPaperIdList;
            LambdaQueryWrapper queryTrain = (LambdaQueryWrapper)new LambdaQueryWrapper().in(Training::getId, trainingIdList);
            queryTrain.select(new SFunction[]{Training::getId, Training::getSourceType});
            this.trainingMapper.selectList((Wrapper)queryTrain).forEach(e -> trainingSourceTypeMap.put(e.getId(), e.getSourceType()));
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0)).orderByAsc(TrainingChapterAttach::getAttachSort);
            List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
            trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
            List trainingMaterialIds = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!org.springframework.util.CollectionUtils.isEmpty(trainingMaterialIds)) {
                trainingMaterialIdList.addAll(trainingMaterialIds);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(trainingPaperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserPaper::getUserId, (Object)user.getId())).in(TrainingUserPaper::getTrainingPaperId, trainingPaperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).in(TrainingUserPaper::getSourceProjectId, trainingIdList);
                List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper2);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
        }
        Map<Object, Object> trainingMaterialMap = Maps.newHashMap();
        Map<Object, Object> trainingViewMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)trainingMaterialIdList)) {
            List trainingMaterialList = this.materialMapper.selectBatchIds(trainingMaterialIdList);
            trainingMaterialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            List<TrainingUserViewTimeVo> viewList = this.trainingCommonService.selectViewTimeByMaterial(0, user.getId(), trainingMaterialIdList, null, null, null);
            if (!org.springframework.util.CollectionUtils.isEmpty(viewList)) {
                trainingViewMap = viewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
            }
        }
        Map<Integer, UsersPojo> creatorMap = this.userUtilService.selectUserMap(Lists.newArrayList(creatorSet));
        Set<Integer> validDownloadResourceIdSet = this.materialPermissionFacade.getValidResourceIdSet(user, 4, materialResourceIdList);
        for (TrainingResourceVo trainingResourceVo : list) {
            UsersPojo creator = creatorMap.get(trainingResourceVo.getCreater());
            if (creator != null) {
                trainingResourceVo.setCreateName(creator.getShowName());
            }
            trainingResourceVo.setMaterialCount(Integer.valueOf(1));
            Integer studyStatus = 1;
            if (trainingResourceVo.getFileType() == 8) {
                int totalDuration = this.trainingService.getTotalDuration(trainingResourceVo.getObjectId());
                trainingResourceVo.setDuration(Integer.valueOf(totalDuration));
                List trainingChapterAttachList = (List)trainingChapterAttachMap.get(trainingResourceVo.getObjectId());
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                    trainingResourceVo.setMaterialCount(Integer.valueOf(trainingChapterAttachList.size()));
                    studyStatus = this.trainService.getTrainingStudyStatus(trainingChapterAttachList, studyStatus, trainingMaterialMap, trainingViewMap, trainingUserPaperMap);
                }
                trainingResourceVo.setSourceType((Integer)trainingSourceTypeMap.get(trainingResourceVo.getObjectId()));
            } else {
                Integer isDownload = validDownloadResourceIdSet.contains(trainingResourceVo.getId()) ? 1 : 0;
                trainingResourceVo.setIsDownload(isDownload);
                trainingResourceVo.setDuration(this.trainingService.getDuration((TrainingMaterial)trainingMaterialMap.get(trainingResourceVo.getObjectId())));
                studyStatus = this.materialService.getMaterialStudyStatus(trainingResourceVo.getObjectId(), trainingMaterialMap, trainingViewMap, studyStatus);
            }
            trainingResourceVo.setStudyStatus(studyStatus);
            trainingResourceVo.setIsNew(DateUtils.getDifferenceTime(trainingResourceVo.getCreateTime()));
            trainingResourceVo.setPath(DcStorageUrlUtils.urlConvert(trainingResourceVo.getPath()));
            trainingResourceVo.setCoverUrl(DcStorageUrlUtils.urlConvert(trainingResourceVo.getCoverUrl()));
        }
    }

    @Override
    public Result<Void> moveResourceByType(int sourceTypeId, int targetTypeId, Users user) {
        log.info("moveResourceByType sourceTypeId:{}, targetTypeId:{}, user:{}", new Object[]{sourceTypeId, targetTypeId, user});
        LambdaQueryWrapper select = new LambdaQueryWrapper();
        select.select(new SFunction[]{TrainingResource::getId, TrainingResource::getObjectId, TrainingResource::getFileType});
        select.eq(TrainingResource::getTypeId, (Object)sourceTypeId);
        List resourceList = this.trainingResourceMapper.selectList((Wrapper)select);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)resourceList)) {
            log.info("moveResourceByType resourceList is empty");
            return ResultUtils.success();
        }
        ArrayList resourceIdList = Lists.newArrayList();
        ArrayList materialIdList = Lists.newArrayList();
        ArrayList trainIdList = Lists.newArrayList();
        for (TrainingResource resource : resourceList) {
            if (this.getTrainFileTypeList().contains(resource.getFileType())) {
                trainIdList.add(resource.getObjectId());
            } else {
                materialIdList.add(resource.getObjectId());
            }
            resourceIdList.add(resource.getId());
        }
        this.trainingResourceMapper.updateTypeByIdList(resourceIdList, targetTypeId, user.getId());
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)materialIdList)) {
            this.materialMapper.updateTypeByIdList(materialIdList, targetTypeId, user.getId());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)trainIdList)) {
            this.trainingMapper.updateTypeByIdList(trainIdList, targetTypeId, user.getId());
        }
        this.resourceSinglePermissionService.resetTypePermissionByResourceIdList(resourceIdList);
        EventHelper.sendMaterialTypeStatCountEvent(this, sourceTypeId, targetTypeId);
        return ResultUtils.success();
    }

    @Override
    public void updateResourceRecommend(TrainingResourceVo trainingResourceVo, Users user) {
        LambdaUpdateWrapper wrapper1;
        if (ObjectUtils.isEmpty((Object)trainingResourceVo) || trainingResourceVo.getType() == null) {
            return;
        }
        if (trainingResourceVo.getType() == 2) {
            wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.eq(Training::getId, (Object)trainingResourceVo.getObjectId())).set(Training::getRecommend, (Object)trainingResourceVo.getRecommend())).set(Training::getUpdateTime, (Object)new Date())).set(Training::getUpdater, (Object)user.getId());
            this.trainingMapper.update(null, (Wrapper)wrapper1);
        } else if (trainingResourceVo.getType() == 1) {
            wrapper1 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper1.eq(TrainingMaterial::getId, (Object)trainingResourceVo.getObjectId())).set(TrainingMaterial::getRecommend, (Object)trainingResourceVo.getRecommend())).set(TrainingMaterial::getUpdateTime, (Object)new Date())).set(TrainingMaterial::getUpdater, (Object)user.getId());
            this.materialMapper.update(null, (Wrapper)wrapper1);
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        if (trainingResourceVo.getType() == 2) {
            wrapper.eq(TrainingResource::getFileType, (Object)8);
        } else if (trainingResourceVo.getType() == 1) {
            wrapper.in(TrainingResource::getFileType, this.getMaterialFileTypeList());
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(TrainingResource::getObjectId, (Object)trainingResourceVo.getObjectId())).set(TrainingResource::getRecommend, (Object)trainingResourceVo.getRecommend())).set(TrainingResource::getUpdateTime, (Object)new Date())).set(TrainingResource::getUpdater, (Object)user.getId());
        this.trainingResourceMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    public Result<Void> batchUpdateTypeId(List<Integer> resourceIdList, int typeId, Integer userId) {
        int res = this.trainingResourceMapper.updateTypeByIdList(resourceIdList, typeId, userId);
        this.resourceSinglePermissionService.resetTypePermissionByResourceIdList(resourceIdList);
        return ResultUtils.success();
    }

    @Override
    public int countMaterialByType(Integer materialTypeId) {
        return this.trainingResourceMapper.countByType(materialTypeId, this.getMaterialFileTypeList());
    }

    @Override
    public int countTrainByType(Integer materialTypeId) {
        return this.trainingResourceMapper.countByType(materialTypeId, this.getTrainFileTypeList());
    }

    @Override
    public Map<Integer, Integer> getTrainIdResourceIdMap(List<Integer> trainIdList) {
        if (org.springframework.util.CollectionUtils.isEmpty(trainIdList)) {
            return Maps.newHashMap();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingResource::getObjectId, trainIdList);
        queryWrapper.in(TrainingResource::getFileType, this.getTrainFileTypeList());
        queryWrapper.select(new SFunction[]{TrainingResource::getId, TrainingResource::getObjectId});
        return this.trainingResourceMapper.selectList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(TrainingResource::getObjectId, TrainingResource::getId));
    }

    @Override
    public List<TrainingResourceVo> getResourceListData(List<TrainingResourceVo> list, Users user) {
        ArrayList trainingMaterialIdList = list.stream().filter(e -> e.getFileType().compareTo(8) != 0).map(TrainingResource::getObjectId).collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(trainingMaterialIdList)) {
            trainingMaterialIdList = Lists.newArrayList();
        }
        List trainingIdList = list.stream().filter(e -> e.getFileType() == 8).map(TrainingResource::getObjectId).collect(Collectors.toList());
        Map<Object, Object> trainingChapterAttachMap = Maps.newHashMap();
        Map<Object, Object> trainingUserPaperMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty(trainingIdList)) {
            List trainingPaperIdList;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingChapterAttach::getTrainingId, trainingIdList)).eq(TrainingChapterAttach::getIsDel, (Object)0)).orderByAsc(TrainingChapterAttach::getAttachSort);
            List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper1);
            trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
            List trainingMaterialIds = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!org.springframework.util.CollectionUtils.isEmpty(trainingMaterialIds)) {
                trainingMaterialIdList.addAll(trainingMaterialIds);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(trainingPaperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(TrainingUserPaper::getUserId, (Object)user.getId())).in(TrainingUserPaper::getTrainingPaperId, trainingPaperIdList)).eq(TrainingUserPaper::getSourceType, (Object)1)).in(TrainingUserPaper::getSourceProjectId, trainingIdList);
                List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper2);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    trainingUserPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
        }
        Map<Object, Object> trainingMaterialMap = Maps.newHashMap();
        Map<Object, Object> trainingViewMap = Maps.newHashMap();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)trainingMaterialIdList)) {
            List trainingMaterialList = this.materialMapper.selectBatchIds(trainingMaterialIdList);
            trainingMaterialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            List<TrainingUserViewTimeVo> viewList = this.trainingCommonService.selectViewTimeByMaterial(0, user.getId(), trainingMaterialIdList, null, null, null);
            if (!org.springframework.util.CollectionUtils.isEmpty(viewList)) {
                trainingViewMap = viewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
            }
        }
        for (TrainingResourceVo trainingResourceVo : list) {
            trainingResourceVo.setMaterialCount(Integer.valueOf(1));
            Integer studyStatus = 1;
            if (trainingResourceVo.getFileType() == 8) {
                List trainingChapterAttachList = (List)trainingChapterAttachMap.get(trainingResourceVo.getObjectId());
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
                    trainingResourceVo.setMaterialCount(Integer.valueOf(trainingChapterAttachList.size()));
                    studyStatus = this.trainService.getTrainingStudyStatus(trainingChapterAttachList, studyStatus, trainingMaterialMap, trainingViewMap, trainingUserPaperMap);
                }
            } else {
                studyStatus = this.materialService.getMaterialStudyStatus(trainingResourceVo.getObjectId(), trainingMaterialMap, trainingViewMap, studyStatus);
            }
            trainingResourceVo.setStudyStatus(studyStatus);
            trainingResourceVo.setIsNew(DateUtils.getDifferenceTime(trainingResourceVo.getCreateTime()));
        }
        return list;
    }

    @Override
    public Result<Page<TrainingResourceVo>> getFirstPageResourceByPage(ResourceQueryParam param, Users user) {
        Page page = new Page();
        int pageSize = 10;
        int pageNumber = 1;
        ArrayList materialTypeIds = null;
        List resourceIds = null;
        Integer orderByColumn = 2;
        List<Long> unitIdList = null;
        List permissionList = null;
        if (!ObjectUtils.isEmpty((Object)param)) {
            List materialTypeIdList;
            pageSize = param.getPageSize() == null ? pageSize : param.getPageSize();
            int n = pageNumber = param.getPageNumber() == null ? pageNumber : param.getPageNumber();
            if (!StringUtils.isEmpty((Object)param.getMaterialTypeIds()) && !org.springframework.util.CollectionUtils.isEmpty(materialTypeIdList = Arrays.stream(param.getMaterialTypeIds().split(",")).map(Integer::parseInt).distinct().collect(Collectors.toList()))) {
                materialTypeIds = Lists.newArrayList();
                materialTypeIds.addAll(materialTypeIdList);
                for (Integer materialTypeId : materialTypeIdList) {
                    List<Integer> ids = this.materialTypeService.getChildTypeIdListNest(materialTypeId);
                    if (org.springframework.util.CollectionUtils.isEmpty(ids)) continue;
                    materialTypeIds.addAll(ids);
                }
            }
            if (param.getOrderByColumn() != null) {
                orderByColumn = param.getOrderByColumn();
            }
            if (!StringUtils.isEmpty((Object)param.getIdList())) {
                resourceIds = Arrays.stream(param.getIdList().split(",")).map(Integer::parseInt).distinct().collect(Collectors.toList());
                orderByColumn = null;
            } else {
                int permissionType = 1;
                boolean global = this.materialPermissionFacade.validGlobal(user, permissionType);
                if (!global) {
                    permissionList = PermissionConst.getListByPermissionType((int)permissionType);
                    unitIdList = this.unitService.getIdListByUserId(user.getId());
                    if (org.springframework.util.CollectionUtils.isEmpty(unitIdList)) {
                        return ResultUtils.success((Object)page);
                    }
                }
            }
        }
        page.setPageSize(pageSize);
        page.setPageNumber(pageNumber);
        List<TrainingResourceVo> list = this.trainingResourceMapper.getFirstPageListByPage((Page<TrainingResourceVo>)page, user.getGroupId(), null, materialTypeIds, unitIdList, permissionList, null, resourceIds, orderByColumn);
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return ResultUtils.success((Object)page);
        }
        page.setContent(list);
        return ResultUtils.success((Object)page);
    }

    @Override
    public Result<TrainingResource> getResourceById(Integer resourceId) {
        TrainingResource resource = (TrainingResource)this.trainingResourceMapper.selectById(resourceId);
        return ResultUtils.success((Object)resource);
    }

    @Override
    public Result<TrainingResource> getResourceByObject(Integer objectId, Integer fileType) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(TrainingResource::getObjectId, (Object)objectId);
        wrapper.eq(TrainingResource::getFileType, (Object)fileType);
        TrainingResource resource = (TrainingResource)this.trainingResourceMapper.selectOne((Wrapper)wrapper);
        return ResultUtils.success((Object)resource);
    }

    @Override
    public Result<Page<TrainingResourceVo>> getMyResourceByPage(ResourceQueryParam param, Users user) {
        Page page = new Page();
        int pageSize = 10;
        int pageNumber = 1;
        if (!ObjectUtils.isEmpty((Object)param)) {
            pageSize = param.getPageSize() == null ? pageSize : param.getPageSize();
            pageNumber = param.getPageNumber() == null ? pageNumber : param.getPageNumber();
        }
        page.setPageSize(pageSize);
        page.setPageNumber(pageNumber);
        List<TrainingResourceVo> list = this.trainingResourceMapper.getMyResourceByPage((Page<TrainingResourceVo>)page, user.getId());
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return ResultUtils.success((Object)page);
        }
        this.getResourceData(list, user);
        page.setContent(list);
        return ResultUtils.success((Object)page);
    }

    @Override
    public Result<Page<TrainingResourceVo>> getMyCollectResourceByPage(ResourceQueryParam param, Users user) {
        Page page = new Page();
        int pageSize = 10;
        int pageNumber = 1;
        if (!ObjectUtils.isEmpty((Object)param)) {
            pageSize = param.getPageSize() == null ? pageSize : param.getPageSize();
            pageNumber = param.getPageNumber() == null ? pageNumber : param.getPageNumber();
        }
        page.setPageSize(pageSize);
        page.setPageNumber(pageNumber);
        List<TrainingResourceVo> list = this.trainingResourceMapper.getMyCollectResourceByPage((Page<TrainingResourceVo>)page, user.getId());
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return ResultUtils.success((Object)page);
        }
        this.getResourceData(list, user);
        page.setContent(list);
        return ResultUtils.success((Object)page);
    }

    @Override
    public Result<Page<TrainingResourceVo>> getMyHistoryResourceByPage(ResourceQueryParam param, Users user) {
        Page page = new Page();
        int pageSize = 10;
        int pageNumber = 1;
        if (!ObjectUtils.isEmpty((Object)param)) {
            pageSize = param.getPageSize() == null ? pageSize : param.getPageSize();
            pageNumber = param.getPageNumber() == null ? pageNumber : param.getPageNumber();
        }
        page.setPageSize(pageSize);
        page.setPageNumber(pageNumber);
        List<TrainingResourceVo> list = this.trainingResourceMapper.getMyHistoryResourceByPage((Page<TrainingResourceVo>)page, user.getId());
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return ResultUtils.success((Object)page);
        }
        this.getResourceData(list, user);
        page.setContent(list);
        return ResultUtils.success((Object)page);
    }
}

