/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.viewTime;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ovopark.training.mapper.TrainingChapterAttachMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.mapper.TrainingCourseUserAnalyseMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingCourseUserTaskMapper;
import com.ovopark.training.mapper.TrainingJobCertificationMapper;
import com.ovopark.training.mapper.TrainingJobStageTaskMapper;
import com.ovopark.training.mapper.TrainingJobStudentAnalyseMapper;
import com.ovopark.training.mapper.TrainingJobUserTaskMapper;
import com.ovopark.training.mapper.TrainingLearnShiftMapper;
import com.ovopark.training.mapper.TrainingLearnTaskUserMapper;
import com.ovopark.training.mapper.TrainingLearnUserMapper;
import com.ovopark.training.mapper.TrainingMaterialMapper;
import com.ovopark.training.mapper.TrainingStudyStatusMapper;
import com.ovopark.training.mapper.TrainingTaskScheduleMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeMaterialMapper;
import com.ovopark.training.mapper.TrainingUserViewTimeTrainingMapper;
import com.ovopark.training.model.TrainingChapterAttach;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingCourseUserAnalyse;
import com.ovopark.training.model.TrainingCourseUserTask;
import com.ovopark.training.model.TrainingJobCertification;
import com.ovopark.training.model.TrainingJobStageTask;
import com.ovopark.training.model.TrainingJobStudentAnalyse;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingLearnUser;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.TrainingStudyStatus;
import com.ovopark.training.model.TrainingTaskSchedule;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.TrainingUserViewTimeMaterial;
import com.ovopark.training.model.TrainingUserViewTimeTraining;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.bo.UserTrainingStatusBo;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.material.MaterialService;
import com.ovopark.training.service.train.TrainService;
import com.ovopark.training.service.viewTime.ViewTimeService;
import com.ovopark.training.vo.TrainingUserViewTimeVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ViewTimeServiceImpl
implements ViewTimeService {
    private static final Logger log = LoggerFactory.getLogger(ViewTimeServiceImpl.class);
    @Autowired
    private TrainingTaskScheduleMapper trainingTaskScheduleMapper;
    @Autowired
    private TrainingMaterialMapper trainingMaterialMapper;
    @Autowired
    private TrainingLearnShiftMapper trainingLearnShiftMapper;
    @Autowired
    private TrainingLearnTaskUserMapper trainingLearnTaskUserMapper;
    @Autowired
    private TrainingLearnUserMapper trainingLearnUserMapper;
    @Autowired
    private TrainingCommonService trainingCommonService;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private TrainService trainService;
    @Autowired
    private AppTrainingLearnProjectService appTrainingLearnProjectService;
    @Autowired
    private TrainingCourseMapper trainingCourseMapper;
    @Autowired
    private TrainingCourseUserMapper trainingCourseUserMapper;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private TrainingCourseUserAnalyseMapper trainingCourseUserAnalyseMapper;
    @Autowired
    private TrainingCourseUserTaskMapper trainingCourseUserTaskMapper;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private TrainingJobCertificationMapper trainingJobCertificationMapper;
    @Autowired
    private TrainingJobStageTaskMapper trainingJobStageTaskMapper;
    @Autowired
    private TrainingJobUserTaskMapper trainingJobUserTaskMapper;
    @Autowired
    private TrainingJobStudentAnalyseMapper trainingJobStudentAnalyseMapper;
    @Autowired
    private TrainingJobCertificationService trainingJobCertificationService;
    @Resource(name="syncUserProjectProgress")
    private Executor syncUserProjectProgressExecutor;
    @Autowired
    private TrainingUserViewTimeMapper trainingUserViewTimeMapper;
    @Autowired
    private TrainingUserViewTimeMaterialMapper trainingUserViewTimeMaterialMapper;
    @Autowired
    private TrainingUserViewTimeTrainingMapper trainingUserViewTimeTrainingMapper;
    @Autowired
    private TrainingStudyStatusMapper trainingStudyStatusMapper;
    @Autowired
    private TrainingChapterAttachMapper trainingChapterAttachMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;

    @Override
    public void syncLearnViewTime(Integer projectId, Users user) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingLearnShift::getProjectId, (Object)projectId)).eq(TrainingLearnShift::getEnterpriseId, (Object)user.getGroupId())).in(TrainingLearnShift::getStatus, Arrays.asList(2, 4, 5));
        List trainingLearnShiftList = this.trainingLearnShiftMapper.selectList((Wrapper)wrapper);
        if (ObjectUtils.isEmpty((Object)trainingLearnShiftList)) {
            return;
        }
        List shiftIdList = trainingLearnShiftList.stream().map(TrainingLearnShift::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.eq(TrainingTaskSchedule::getProjectId, (Object)projectId)).in(TrainingTaskSchedule::getShiftId, shiftIdList)).eq(TrainingTaskSchedule::getIsSync, (Object)1)).in(TrainingTaskSchedule::getTaskType, Arrays.asList(1, 5));
        List trainingTaskScheduleList = this.trainingTaskScheduleMapper.selectList((Wrapper)wrapper3);
        if (CollectionUtils.isEmpty((Collection)trainingTaskScheduleList)) {
            return;
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.in(TrainingLearnUser::getShiftId, shiftIdList)).in(TrainingLearnUser::getLearnStatus, Arrays.asList(1, 2))).eq(TrainingLearnUser::getIsDelete, (Object)0);
        List trainingLearnUserList = this.trainingLearnUserMapper.selectList((Wrapper)wrapper1);
        if (CollectionUtils.isEmpty((Collection)trainingLearnUserList)) {
            return;
        }
        List learnUserIdList = trainingLearnUserList.stream().map(TrainingLearnUser::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.in(TrainingLearnTaskUser::getLearnUserId, learnUserIdList)).in(TrainingLearnTaskUser::getTaskStatus, Arrays.asList(0, 1));
        List trainingLearnTaskUserList = this.trainingLearnTaskUserMapper.selectList((Wrapper)wrapper2);
        if (CollectionUtils.isEmpty((Collection)trainingLearnTaskUserList)) {
            return;
        }
        this.syncLearnMainLogic(projectId, trainingTaskScheduleList, trainingLearnUserList, trainingLearnTaskUserList);
    }

    @Override
    public void syncCourseViewTime(Integer projectId, Users user) {
        List passUserIdList;
        TrainingCourse trainingCourse = (TrainingCourse)this.trainingCourseMapper.selectById(projectId);
        if (ObjectUtils.isEmpty((Object)trainingCourse)) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingCourseStageTask::getCourseId, (Object)projectId)).eq(TrainingCourseStageTask::getIsProgress, (Object)1);
        List trainingCourseStageTaskList = this.trainingCourseStageTaskMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)trainingCourseStageTaskList)) {
            return;
        }
        List<Integer> materialIdList = trainingCourseStageTaskList.stream().filter(task -> task.getTaskType() == 5 && task.getMaterialId() != null).map(TrainingCourseStageTask::getMaterialId).distinct().collect(Collectors.toList());
        List trainingIdList = trainingCourseStageTaskList.stream().filter(task -> task.getTaskType() == 1 && task.getTrainingId() != null).map(TrainingCourseStageTask::getTrainingId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialIdList) && CollectionUtils.isEmpty(trainingIdList)) {
            return;
        }
        List<Integer> userIdList = this.getCourseUserList(projectId, user, trainingCourse);
        if (CollectionUtils.isEmpty(userIdList)) {
            return;
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUserAnalyse::getCourseId, (Object)projectId)).eq(TrainingCourseUserAnalyse::getPassStatus, (Object)1);
        List trainingCourseUserAnalyseList = this.trainingCourseUserAnalyseMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingCourseUserAnalyseList) && !CollectionUtils.isEmpty(passUserIdList = trainingCourseUserAnalyseList.stream().map(TrainingCourseUserAnalyse::getUserId).collect(Collectors.toList()))) {
            userIdList.removeAll(passUserIdList);
        }
        if (CollectionUtils.isEmpty(userIdList)) {
            return;
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.eq(TrainingCourseUserTask::getCourseId, (Object)projectId)).eq(TrainingCourseUserTask::getIsLast, (Object)1);
        List trainingCourseUserTaskList = this.trainingCourseUserTaskMapper.selectList((Wrapper)wrapper2);
        Map<Object, Object> userTaskMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingCourseUserTaskList)) {
            userTaskMap = trainingCourseUserTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getUserId));
        }
        this.syncCourseMainLogic(trainingCourse, userIdList, userTaskMap, trainingCourseStageTaskList, materialIdList, user);
    }

    private void syncCourseMainLogic(TrainingCourse trainingCourse, List<Integer> userIdList, Map<Integer, List<TrainingCourseUserTask>> userTaskMap, List<TrainingCourseStageTask> trainingCourseStageTaskList, List<Integer> materialIdList, Users user) {
        Date now = new Date();
        Map<Object, Object> materialMap = new HashMap();
        if (!CollectionUtils.isEmpty(materialIdList)) {
            List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIdList);
            materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        int status = trainingCourse.getStatus() == 3 ? 4 : 3;
        ArrayList allUserIds = Lists.newArrayList(userIdList);
        for (TrainingCourseStageTask trainingCourseStageTask : trainingCourseStageTaskList) {
            TrainingMaterial trainingMaterial = null;
            Map<Object, Object> viewTimeMap = Maps.newHashMap();
            Map<Object, Object> isFinishTrainingMap = Maps.newHashMap();
            if (trainingCourseStageTask.getTaskType() == 5 && trainingCourseStageTask.getMaterialId() != null) {
                trainingMaterial = (TrainingMaterial)materialMap.get(trainingCourseStageTask.getMaterialId());
                if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
                    allUserIds = Lists.newArrayList();
                    break;
                }
                List<TrainingUserViewTimeVo> trainingUserViewTimeVoList = this.trainingCommonService.selectViewTimeByUserId(0, userIdList, Collections.singletonList(trainingMaterial.getId()), null, null);
                if (CollectionUtils.isEmpty(trainingUserViewTimeVoList)) {
                    allUserIds = Lists.newArrayList();
                    break;
                }
                viewTimeMap = trainingUserViewTimeVoList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
            } else if (trainingCourseStageTask.getTaskType() == 1 && trainingCourseStageTask.getTrainingId() != null) {
                isFinishTrainingMap = this.trainService.isFinishTraining(trainingCourseStageTask.getTrainingId(), userIdList, 5, trainingCourse.getId(), trainingCourseStageTask.getId());
            }
            List<Integer> limitUserIds = this.getFinishTaskUsers(user, trainingCourse, userIdList, userTaskMap, trainingCourseStageTask, viewTimeMap, trainingMaterial, status, now, isFinishTrainingMap);
            if (!CollectionUtils.isEmpty(limitUserIds)) {
                allUserIds.retainAll(limitUserIds);
                continue;
            }
            allUserIds = Lists.newArrayList();
            break;
        }
        if (!CollectionUtils.isEmpty((Collection)allUserIds)) {
            ArrayList finalAllUserIds = allUserIds;
            this.syncUserProjectProgressExecutor.execute(() -> {
                for (Integer userId : finalAllUserIds) {
                    this.trainingCourseService.getIsFinishCourse(Collections.singletonList(trainingCourse.getId()), userId);
                }
            });
        }
    }

    private List<Integer> getFinishTaskUsers(Users user, TrainingCourse trainingCourse, List<Integer> userIdList, Map<Integer, List<TrainingCourseUserTask>> userTaskMap, TrainingCourseStageTask trainingCourseStageTask, Map<Integer, List<TrainingUserViewTimeVo>> viewTimeMap, TrainingMaterial trainingMaterial, int status, Date now, Map<Integer, UserTrainingStatusBo> isFinishTrainingMap) {
        ArrayList limitUserIds = Lists.newArrayList();
        for (Integer userId : userIdList) {
            UserTrainingStatusBo userTrainingStatusBo;
            List<TrainingCourseUserTask> userTaskList = userTaskMap.get(userId);
            Map<Object, Object> courseUserTaskMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(userTaskList)) {
                courseUserTaskMap = userTaskList.stream().collect(Collectors.groupingBy(TrainingCourseUserTask::getTaskId));
            }
            List courseUserTaskList = (List)courseUserTaskMap.get(trainingCourseStageTask.getId());
            TrainingCourseUserTask trainingCourseUserTask = null;
            if (!(CollectionUtils.isEmpty((Collection)courseUserTaskList) || (trainingCourseUserTask = (TrainingCourseUserTask)courseUserTaskList.get(0)).getTaskStatus() != 3 && trainingCourseUserTask.getTaskStatus() != 4)) {
                limitUserIds.add(userId);
                continue;
            }
            if (trainingCourseStageTask.getTaskType() == 5 && trainingCourseStageTask.getMaterialId() != null) {
                TrainingUserViewTimeVo trainingUserViewTimeVo;
                Integer viewTimes;
                BigDecimal readRate;
                List<TrainingUserViewTimeVo> trainingUserViewTimeVoList = viewTimeMap.get(userId);
                if (CollectionUtils.isEmpty(trainingUserViewTimeVoList) || (readRate = this.materialService.getMaterialFinishRate(trainingMaterial, viewTimes = (trainingUserViewTimeVo = trainingUserViewTimeVoList.get(0)).getViewTimes())).compareTo(BigDecimal.ONE) < 0) continue;
                this.saveCourseUserTasks(trainingCourse, trainingCourseStageTask, userId, trainingCourseUserTask, status, now, user);
                limitUserIds.add(userId);
                continue;
            }
            if (trainingCourseStageTask.getTaskType() != 1 || trainingCourseStageTask.getTrainingId() == null || ObjectUtils.isEmpty((Object)(userTrainingStatusBo = isFinishTrainingMap.get(userId))) || !userTrainingStatusBo.isIsFinish()) continue;
            this.saveCourseUserTasks(trainingCourse, trainingCourseStageTask, userId, trainingCourseUserTask, status, now, user);
            limitUserIds.add(userId);
        }
        return limitUserIds;
    }

    private void saveCourseUserTasks(TrainingCourse trainingCourse, TrainingCourseStageTask trainingCourseStageTask, Integer userId, TrainingCourseUserTask trainingCourseUserTask, int status, Date now, Users user) {
        if (ObjectUtils.isEmpty((Object)trainingCourseUserTask)) {
            trainingCourseUserTask = new TrainingCourseUserTask();
            trainingCourseUserTask.setCourseId(trainingCourse.getId());
            trainingCourseUserTask.setUserId(userId);
            trainingCourseUserTask.setTaskId(trainingCourseStageTask.getId());
            trainingCourseUserTask.setTaskStatus(Integer.valueOf(status));
            trainingCourseUserTask.setStartTime(now);
            trainingCourseUserTask.setEndTime(now);
            trainingCourseUserTask.setEnterpriseId(trainingCourse.getEnterpriseId());
            trainingCourseUserTask.setCreateTime(now);
            trainingCourseUserTask.setCreater(user.getId());
            this.trainingCourseUserTaskMapper.insert(trainingCourseUserTask);
        } else {
            LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper4.eq(TrainingCourseUserTask::getId, (Object)trainingCourseUserTask.getId())).eq(TrainingCourseUserTask::getUserId, (Object)userId)).eq(TrainingCourseUserTask::getTaskId, (Object)trainingCourseStageTask.getId())).eq(TrainingCourseUserTask::getIsLast, (Object)1)).set(TrainingCourseUserTask::getTaskStatus, (Object)status)).set(TrainingCourseUserTask::getEndTime, (Object)now);
            this.trainingCourseUserTaskMapper.update(null, (Wrapper)wrapper4);
        }
    }

    private List<Integer> getCourseUserList(Integer projectId, Users user, TrainingCourse trainingCourse) {
        List<Object> userIdList = Lists.newArrayList();
        if (trainingCourse.getAppointType() != null && trainingCourse.getAppointType() == 1) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingCourseUser::getCourseId, (Object)projectId)).eq(TrainingCourseUser::getCourseType, (Object)1)).eq(TrainingCourseUser::getEnterpriseId, (Object)user.getGroupId());
            List trainingCourseUserList = this.trainingCourseUserMapper.selectList((Wrapper)wrapper);
            if (CollectionUtils.isEmpty((Collection)trainingCourseUserList)) {
                return userIdList;
            }
            List userIds = trainingCourseUserList.stream().map(TrainingCourseUser::getUserId).filter(Objects::nonNull).collect(Collectors.toList());
            List<Integer> roleIds = trainingCourseUserList.stream().map(TrainingCourseUser::getRoleId).filter(Objects::nonNull).collect(Collectors.toList());
            List<String> orgIds = trainingCourseUserList.stream().map(TrainingCourseUser::getOrganizeId).filter(Objects::nonNull).collect(Collectors.toList());
            List<Integer> tagIds = trainingCourseUserList.stream().map(TrainingCourseUser::getTagId).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)) {
                userIdList.addAll(userIds);
            }
            if (!CollectionUtils.isEmpty(roleIds)) {
                userIdList.addAll(this.userUtilService.selectUsersByRoles(roleIds, user.getId()));
            }
            if (!CollectionUtils.isEmpty(orgIds)) {
                userIdList.addAll(this.userUtilService.selectUserIdsByOrganizeIds(orgIds, user.getGroupId()));
            }
            if (!CollectionUtils.isEmpty(tagIds)) {
                userIdList.addAll(this.userUtilService.selectUserIdsByTagIds(tagIds, user.getGroupId(), user.getId()));
            }
        } else {
            userIdList = this.userUtilService.getUserListByGroupId(user.getGroupId());
        }
        if (!CollectionUtils.isEmpty((Collection)userIdList)) {
            userIdList = userIdList.stream().distinct().collect(Collectors.toList());
        }
        return userIdList;
    }

    @Override
    public void syncJobViewTime(Integer projectId, Users user) {
        List passUserIdList;
        TrainingJobCertification trainingJobCertification = (TrainingJobCertification)this.trainingJobCertificationMapper.selectById(projectId);
        if (ObjectUtils.isEmpty((Object)trainingJobCertification)) {
            return;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TrainingJobStageTask::getJobId, (Object)projectId)).eq(TrainingJobStageTask::getIsSync, (Object)1);
        List trainingJobStageTaskList = this.trainingJobStageTaskMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)trainingJobStageTaskList)) {
            return;
        }
        List<Integer> materialIdList = trainingJobStageTaskList.stream().filter(task -> task.getTaskType() == 5 && task.getMaterialId() != null).map(TrainingJobStageTask::getMaterialId).distinct().collect(Collectors.toList());
        List trainingIdList = trainingJobStageTaskList.stream().filter(task -> task.getTaskType() == 1 && task.getTrainingId() != null).map(TrainingJobStageTask::getTrainingId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(materialIdList) && CollectionUtils.isEmpty(trainingIdList)) {
            return;
        }
        List<Integer> userIdList = this.trainingJobCertificationService.selectJobUserListByJobId(projectId);
        if (CollectionUtils.isEmpty(userIdList)) {
            return;
        }
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingJobStudentAnalyse::getJobId, (Object)projectId)).in(TrainingJobStudentAnalyse::getLearnStatus, Arrays.asList(3, 4));
        List trainingJobStudentAnalyseList = this.trainingJobStudentAnalyseMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)trainingJobStudentAnalyseList) && !CollectionUtils.isEmpty(passUserIdList = trainingJobStudentAnalyseList.stream().map(TrainingJobStudentAnalyse::getUserId).collect(Collectors.toList()))) {
            userIdList.removeAll(passUserIdList);
        }
        if (CollectionUtils.isEmpty(userIdList)) {
            return;
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(TrainingJobUserTask::getJobId, (Object)projectId);
        List trainingJobUserTaskList = this.trainingJobUserTaskMapper.selectList((Wrapper)wrapper2);
        Map<Object, Object> userTaskMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingJobUserTaskList)) {
            userTaskMap = trainingJobUserTaskList.stream().collect(Collectors.groupingBy(TrainingJobUserTask::getUserId));
        }
        this.syncJobMainLogic(trainingJobCertification, userIdList, userTaskMap, trainingJobStageTaskList, materialIdList, user);
    }

    private void syncJobMainLogic(TrainingJobCertification trainingJobCertification, List<Integer> userIdList, Map<Integer, List<TrainingJobUserTask>> userTaskMap, List<TrainingJobStageTask> trainingJobStageTaskList, List<Integer> materialIdList, Users user) {
        Date now = new Date();
        Map<Object, Object> materialMap = new HashMap();
        if (!CollectionUtils.isEmpty(materialIdList)) {
            List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIdList);
            materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        ArrayList allUserIds = Lists.newArrayList(userIdList);
        for (TrainingJobStageTask trainingJobStageTask : trainingJobStageTaskList) {
            TrainingMaterial trainingMaterial = null;
            Map<Object, Object> viewTimeMap = Maps.newHashMap();
            Map<Object, Object> isFinishTrainingMap = Maps.newHashMap();
            if (trainingJobStageTask.getTaskType() == 5 && trainingJobStageTask.getMaterialId() != null) {
                trainingMaterial = (TrainingMaterial)materialMap.get(trainingJobStageTask.getMaterialId());
                if (ObjectUtils.isEmpty((Object)trainingMaterial)) {
                    allUserIds = Lists.newArrayList();
                    break;
                }
                List<TrainingUserViewTimeVo> trainingUserViewTimeVoList = this.trainingCommonService.selectViewTimeByUserId(0, userIdList, Collections.singletonList(trainingMaterial.getId()), null, null);
                if (CollectionUtils.isEmpty(trainingUserViewTimeVoList)) {
                    allUserIds = Lists.newArrayList();
                    break;
                }
                viewTimeMap = trainingUserViewTimeVoList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
            } else if (trainingJobStageTask.getTaskType() == 1 && trainingJobStageTask.getTrainingId() != null) {
                isFinishTrainingMap = this.trainService.isFinishTraining(trainingJobStageTask.getTrainingId(), userIdList, 4, trainingJobCertification.getId(), trainingJobStageTask.getId());
            }
            List<Integer> limitUserIds = this.getJobFinishTaskUsers(user, trainingJobCertification, userIdList, userTaskMap, trainingJobStageTask, viewTimeMap, trainingMaterial, now, isFinishTrainingMap);
            if (!CollectionUtils.isEmpty(limitUserIds)) {
                allUserIds.retainAll(limitUserIds);
                continue;
            }
            allUserIds = Lists.newArrayList();
            break;
        }
        if (!CollectionUtils.isEmpty((Collection)allUserIds)) {
            ArrayList finalAllUserIds = allUserIds;
            this.syncUserProjectProgressExecutor.execute(() -> {
                for (Integer userId : finalAllUserIds) {
                    this.trainingJobCertificationService.getIsFinishAllTask(trainingJobCertification.getId(), userId);
                }
            });
        }
    }

    private List<Integer> getJobFinishTaskUsers(Users user, TrainingJobCertification trainingJobCertification, List<Integer> userIdList, Map<Integer, List<TrainingJobUserTask>> userTaskMap, TrainingJobStageTask trainingJobStageTask, Map<Integer, List<TrainingUserViewTimeVo>> viewTimeMap, TrainingMaterial trainingMaterial, Date now, Map<Integer, UserTrainingStatusBo> isFinishTrainingMap) {
        ArrayList limitUserIds = Lists.newArrayList();
        for (Integer userId : userIdList) {
            UserTrainingStatusBo userTrainingStatusBo;
            List<TrainingJobUserTask> userTaskList = userTaskMap.get(userId);
            Map<Object, Object> jobUserTaskMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty(userTaskList)) {
                jobUserTaskMap = userTaskList.stream().collect(Collectors.groupingBy(TrainingJobUserTask::getStageTaskId));
            }
            List jobUserTaskList = (List)jobUserTaskMap.get(trainingJobStageTask.getId());
            TrainingJobUserTask trainingJobUserTask = null;
            if (!CollectionUtils.isEmpty((Collection)jobUserTaskList) && (trainingJobUserTask = (TrainingJobUserTask)jobUserTaskList.get(0)).getTaskStatus() == 4) {
                limitUserIds.add(userId);
                continue;
            }
            if (trainingJobStageTask.getTaskType() == 5 && trainingJobStageTask.getMaterialId() != null) {
                TrainingUserViewTimeVo trainingUserViewTimeVo;
                Integer viewTimes;
                BigDecimal readRate;
                List<TrainingUserViewTimeVo> trainingUserViewTimeVoList = viewTimeMap.get(userId);
                if (CollectionUtils.isEmpty(trainingUserViewTimeVoList) || (readRate = this.materialService.getMaterialFinishRate(trainingMaterial, viewTimes = (trainingUserViewTimeVo = trainingUserViewTimeVoList.get(0)).getViewTimes())).compareTo(BigDecimal.ONE) < 0) continue;
                this.saveJobUserTasks(trainingJobCertification, trainingJobStageTask, userId, trainingJobUserTask, now, user, viewTimes);
                limitUserIds.add(userId);
                continue;
            }
            if (trainingJobStageTask.getTaskType() != 1 || trainingJobStageTask.getTrainingId() == null || ObjectUtils.isEmpty((Object)(userTrainingStatusBo = isFinishTrainingMap.get(userId))) || !userTrainingStatusBo.isIsFinish()) continue;
            this.saveJobUserTasks(trainingJobCertification, trainingJobStageTask, userId, trainingJobUserTask, now, user, userTrainingStatusBo.getViewTimes());
            limitUserIds.add(userId);
        }
        return limitUserIds;
    }

    private void saveJobUserTasks(TrainingJobCertification trainingJobCertification, TrainingJobStageTask trainingJobStageTask, Integer userId, TrainingJobUserTask trainingJobUserTask, Date now, Users user, Integer viewTimes) {
        if (ObjectUtils.isEmpty((Object)trainingJobUserTask)) {
            trainingJobUserTask = new TrainingJobUserTask();
            trainingJobUserTask.setJobId(trainingJobCertification.getId());
            trainingJobUserTask.setUserId(userId);
            trainingJobUserTask.setStageTaskId(trainingJobStageTask.getId());
            trainingJobUserTask.setTaskType(trainingJobStageTask.getTaskType());
            trainingJobUserTask.setTaskStatus(Integer.valueOf(4));
            trainingJobUserTask.setStartTime(now);
            trainingJobUserTask.setEndTime(now);
            trainingJobUserTask.setUseTime(viewTimes);
            trainingJobUserTask.setEnterpriseId(trainingJobCertification.getEnterpriseId());
            trainingJobUserTask.setCreateTime(now);
            trainingJobUserTask.setCreaterId(user.getId());
            this.trainingJobUserTaskMapper.insert(trainingJobUserTask);
        } else {
            LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper4.eq(TrainingJobUserTask::getId, (Object)trainingJobUserTask.getId())).eq(TrainingJobUserTask::getUserId, (Object)userId)).eq(TrainingJobUserTask::getStageTaskId, (Object)trainingJobStageTask.getId())).set(TrainingJobUserTask::getUseTime, (Object)viewTimes)).set(TrainingJobUserTask::getTaskStatus, (Object)4)).set(TrainingJobUserTask::getEndTime, (Object)now);
            this.trainingJobUserTaskMapper.update(null, (Wrapper)wrapper4);
        }
    }

    private void syncLearnMainLogic(Integer projectId, List<TrainingTaskSchedule> trainingTaskScheduleList, List<TrainingLearnUser> trainingLearnUserList, List<TrainingLearnTaskUser> trainingLearnTaskUserList) {
        List materialIdList = trainingTaskScheduleList.stream().filter(task -> task.getTaskType() == 5 && task.getMaterialId() != null).map(TrainingTaskSchedule::getMaterialId).distinct().collect(Collectors.toList());
        HashMap<Integer, TrainingMaterial> materialMap = new HashMap();
        if (!CollectionUtils.isEmpty(materialIdList)) {
            List trainingMaterialList = this.trainingMaterialMapper.selectBatchIds(materialIdList);
            materialMap = trainingMaterialList.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
        }
        Map<Integer, List<TrainingLearnUser>> learnUserMap = trainingLearnUserList.stream().collect(Collectors.groupingBy(TrainingLearnUser::getShiftId));
        Map<Integer, List<TrainingLearnTaskUser>> learnTaskUserMap = trainingLearnTaskUserList.stream().collect(Collectors.groupingBy(TrainingLearnTaskUser::getProjectTaskScheduleId));
        Map<Integer, List<TrainingTaskSchedule>> taskScheduleMap = trainingTaskScheduleList.stream().collect(Collectors.groupingBy(TrainingTaskSchedule::getShiftId));
        Map<Integer, List<Integer>> allUserIdMap = this.getFinishUserIdList(projectId, taskScheduleMap, learnUserMap, learnTaskUserMap, materialMap);
        if (!ObjectUtils.isEmpty(allUserIdMap) && !CollectionUtils.isEmpty(allUserIdMap.keySet())) {
            this.syncUserProjectProgressExecutor.execute(() -> {
                for (Integer shiftId : allUserIdMap.keySet()) {
                    List userIdList = (List)allUserIdMap.get(shiftId);
                    if (CollectionUtils.isEmpty((Collection)userIdList)) continue;
                    for (Integer userId : userIdList) {
                        this.appTrainingLearnProjectService.updateLearUserStatus(shiftId, userId);
                    }
                }
            });
        }
    }

    private Map<Integer, List<Integer>> getFinishUserIdList(Integer projectId, Map<Integer, List<TrainingTaskSchedule>> taskScheduleMap, Map<Integer, List<TrainingLearnUser>> learnUserMap, Map<Integer, List<TrainingLearnTaskUser>> learnTaskUserMap, Map<Integer, TrainingMaterial> materialMap) {
        HashMap allUserIdMap = Maps.newHashMap();
        for (Integer shiftId : taskScheduleMap.keySet()) {
            List<TrainingLearnUser> learnUserList = learnUserMap.get(shiftId);
            if (CollectionUtils.isEmpty(learnUserList)) continue;
            List<Integer> allUserIdList = learnUserList.stream().map(TrainingLearnUser::getUserId).distinct().collect(Collectors.toList());
            List<TrainingTaskSchedule> taskScheduleList = taskScheduleMap.get(shiftId);
            if (CollectionUtils.isEmpty(taskScheduleList)) continue;
            for (TrainingTaskSchedule trainingTaskSchedule : taskScheduleList) {
                List<TrainingLearnTaskUser> learnTaskUserList = learnTaskUserMap.get(trainingTaskSchedule.getId());
                if (CollectionUtils.isEmpty(learnTaskUserList)) continue;
                List<Integer> userIdList = learnTaskUserList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
                if (trainingTaskSchedule.getTaskType() == 5 && trainingTaskSchedule.getMaterialId() != null) {
                    TrainingMaterial trainingMaterial = materialMap.get(trainingTaskSchedule.getMaterialId());
                    if (ObjectUtils.isEmpty((Object)trainingMaterial)) continue;
                    allUserIdList = this.syncMaterial(trainingTaskSchedule, trainingMaterial, userIdList, allUserIdList);
                    continue;
                }
                if (trainingTaskSchedule.getTaskType() != 1 || trainingTaskSchedule.getTrainingId() == null) continue;
                this.syncTrain(projectId, trainingTaskSchedule, userIdList, allUserIdList);
            }
            if (CollectionUtils.isEmpty(allUserIdList)) continue;
            allUserIdMap.put(shiftId, allUserIdList);
        }
        return allUserIdMap;
    }

    private void syncTrain(Integer projectId, TrainingTaskSchedule trainingTaskSchedule, List<Integer> userIdList, List<Integer> allUserIdList) {
        Map<Integer, UserTrainingStatusBo> isFinishTrainingMap = this.trainService.isFinishTraining(trainingTaskSchedule.getTrainingId(), userIdList, 3, projectId, trainingTaskSchedule.getId());
        for (Integer userId : userIdList) {
            UserTrainingStatusBo userTrainingStatusBo = isFinishTrainingMap.get(userId);
            if (!ObjectUtils.isEmpty((Object)userTrainingStatusBo) && userTrainingStatusBo.isIsFinish()) {
                LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper4.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId())).eq(TrainingLearnTaskUser::getUserId, (Object)userId)).set(TrainingLearnTaskUser::getTaskStatus, (Object)4)).set(TrainingLearnTaskUser::getEndTime, (Object)new Date())).set(TrainingLearnTaskUser::getRate, (Object)100);
                this.trainingLearnTaskUserMapper.update(null, (Wrapper)wrapper4);
                continue;
            }
            allUserIdList.remove(userId);
        }
    }

    private List<Integer> syncMaterial(TrainingTaskSchedule trainingTaskSchedule, TrainingMaterial trainingMaterial, List<Integer> userIdList, List<Integer> allUserIdList) {
        List<TrainingUserViewTimeVo> trainingUserViewTimeVoList = this.trainingCommonService.selectViewTimeByUserId(0, userIdList, Collections.singletonList(trainingMaterial.getId()), null, null);
        if (CollectionUtils.isEmpty(trainingUserViewTimeVoList)) {
            return Lists.newArrayList();
        }
        Map<Integer, List<TrainingUserViewTimeVo>> viewTimeMap = trainingUserViewTimeVoList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getUserId));
        for (Integer userId : userIdList) {
            TrainingUserViewTimeVo trainingUserViewTimeVo = viewTimeMap.get(userId).get(0);
            Integer viewTimes = trainingUserViewTimeVo.getViewTimes();
            BigDecimal readRate = this.materialService.getMaterialFinishRate(trainingMaterial, viewTimes);
            if (readRate.compareTo(BigDecimal.ONE) >= 0) {
                LambdaUpdateWrapper wrapper4 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper4.eq(TrainingLearnTaskUser::getProjectTaskScheduleId, (Object)trainingTaskSchedule.getId())).eq(TrainingLearnTaskUser::getUserId, (Object)userId)).set(TrainingLearnTaskUser::getTaskStatus, (Object)4)).set(TrainingLearnTaskUser::getEndTime, (Object)new Date())).set(TrainingLearnTaskUser::getUseTime, (Object)viewTimes)).set(TrainingLearnTaskUser::getRate, (Object)100);
                this.trainingLearnTaskUserMapper.update(null, (Wrapper)wrapper4);
                continue;
            }
            allUserIdList.remove(userId);
        }
        return allUserIdList;
    }

    @Override
    public void saveViewTimeFinishTime(Integer startId, Integer endId, Integer type) {
        block7: {
            block6: {
                if (type != 1) break block6;
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.ge(TrainingUserViewTime::getId, (Object)startId)).le(TrainingUserViewTime::getId, (Object)endId)).isNotNull(TrainingUserViewTime::getMaterialId)).isNotNull(TrainingUserViewTime::getUserId)).isNull(TrainingUserViewTimeMaterial::getFinishTime);
                List userViewTimeMaterials = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)wrapper1);
                if (CollectionUtils.isEmpty((Collection)userViewTimeMaterials)) {
                    return;
                }
                List trainingMaterialIds = userViewTimeMaterials.stream().map(TrainingUserViewTime::getMaterialId).distinct().collect(Collectors.toList());
                List trainingMaterials = this.trainingMaterialMapper.selectBatchIds(trainingMaterialIds);
                Map materialMap = trainingMaterials.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
                for (TrainingUserViewTimeMaterial userViewTimeMaterial : userViewTimeMaterials) {
                    BigDecimal rate;
                    TrainingMaterial trainingMaterial = (TrainingMaterial)materialMap.get(userViewTimeMaterial.getMaterialId());
                    if (ObjectUtils.isEmpty((Object)trainingMaterial) || (rate = this.materialService.getMaterialFinishRate(trainingMaterial, userViewTimeMaterial.getViewTime())).compareTo(BigDecimal.ONE) != 0) continue;
                    int totalViewTime = 0;
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserViewTime::getUserId, (Object)userViewTimeMaterial.getUserId())).eq(TrainingUserViewTime::getMaterialId, (Object)userViewTimeMaterial.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)0)).orderByAsc(TrainingUserViewTime::getCreateTime);
                    List viewTimeList = this.trainingUserViewTimeMapper.selectList((Wrapper)wrapper);
                    if (CollectionUtils.isEmpty((Collection)viewTimeList)) continue;
                    for (TrainingUserViewTime userViewTime : viewTimeList) {
                        if ((totalViewTime += userViewTime.getViewTime().intValue()) < userViewTimeMaterial.getViewTime()) continue;
                        userViewTimeMaterial.setFinishTime(userViewTime.getCreateTime());
                        break;
                    }
                    LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)wrapper2.eq(TrainingUserViewTime::getId, (Object)userViewTimeMaterial.getId())).set(TrainingUserViewTimeMaterial::getFinishTime, (Object)userViewTimeMaterial.getFinishTime());
                    this.trainingUserViewTimeMaterialMapper.update(null, (Wrapper)wrapper2);
                }
                break block7;
            }
            if (type != 2) break block7;
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.ge(TrainingUserViewTime::getId, (Object)startId)).le(TrainingUserViewTime::getId, (Object)endId)).isNotNull(TrainingUserViewTime::getMaterialId)).isNotNull(TrainingUserViewTime::getUserId)).isNull(TrainingUserViewTimeTraining::getFinishTime);
            List userViewTimeTrainings = this.trainingUserViewTimeTrainingMapper.selectList((Wrapper)wrapper1);
            if (CollectionUtils.isEmpty((Collection)userViewTimeTrainings)) {
                return;
            }
            List trainingMaterialIds = userViewTimeTrainings.stream().map(TrainingUserViewTime::getMaterialId).distinct().collect(Collectors.toList());
            List trainingMaterials = this.trainingMaterialMapper.selectBatchIds(trainingMaterialIds);
            Map materialMap = trainingMaterials.stream().collect(Collectors.toMap(TrainingMaterial::getId, Function.identity()));
            for (TrainingUserViewTimeTraining userViewTimeTraining : userViewTimeTrainings) {
                BigDecimal rate;
                TrainingMaterial trainingMaterial = (TrainingMaterial)materialMap.get(userViewTimeTraining.getMaterialId());
                if (ObjectUtils.isEmpty((Object)trainingMaterial) || (rate = this.materialService.getMaterialFinishRate(trainingMaterial, userViewTimeTraining.getViewTime())).compareTo(BigDecimal.ONE) != 0) continue;
                int totalViewTime = 0;
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserViewTime::getUserId, (Object)userViewTimeTraining.getUserId())).eq(TrainingUserViewTime::getMaterialId, (Object)userViewTimeTraining.getMaterialId())).eq(TrainingUserViewTime::getLearnType, (Object)1)).orderByAsc(TrainingUserViewTime::getCreateTime);
                List viewTimeList = this.trainingUserViewTimeMapper.selectList((Wrapper)wrapper);
                if (CollectionUtils.isEmpty((Collection)viewTimeList)) continue;
                for (TrainingUserViewTime userViewTime : viewTimeList) {
                    if ((totalViewTime += userViewTime.getViewTime().intValue()) < userViewTimeTraining.getViewTime()) continue;
                    userViewTimeTraining.setFinishTime(userViewTime.getCreateTime());
                    break;
                }
                LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)wrapper2.eq(TrainingUserViewTime::getId, (Object)userViewTimeTraining.getId())).set(TrainingUserViewTimeTraining::getFinishTime, (Object)userViewTimeTraining.getFinishTime());
                this.trainingUserViewTimeTrainingMapper.update(null, (Wrapper)wrapper2);
            }
        }
    }

    @Override
    public void saveStudyStatus(Integer startId, Integer endId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.ge(TrainingStudyStatus::getId, (Object)startId)).le(TrainingStudyStatus::getId, (Object)endId)).eq(TrainingStudyStatus::getStatus, (Object)2)).isNull(TrainingStudyStatus::getFinishTime);
        List trainingStudyStatusList = this.trainingStudyStatusMapper.selectList((Wrapper)wrapper1);
        if (CollectionUtils.isEmpty((Collection)trainingStudyStatusList)) {
            return;
        }
        List trainingIds = trainingStudyStatusList.stream().map(TrainingStudyStatus::getTrainingId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(trainingIds)) {
            return;
        }
        List userIds = trainingStudyStatusList.stream().map(TrainingStudyStatus::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper2.in(TrainingChapterAttach::getTrainingId, trainingIds)).eq(TrainingChapterAttach::getIsDel, (Object)0);
        List trainingChapterAttachList = this.trainingChapterAttachMapper.selectList((Wrapper)wrapper2);
        Map<Object, Object> trainingChapterAttachMap = new HashMap();
        Map<Object, Object> viewMaterialMap = new HashMap();
        Map<Object, Object> userPaperMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)trainingChapterAttachList)) {
            List paperIdList;
            trainingChapterAttachMap = trainingChapterAttachList.stream().collect(Collectors.groupingBy(TrainingChapterAttach::getTrainingId));
            List materialIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getMaterialId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(materialIdList)) {
                LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper3.in(TrainingUserViewTime::getMaterialId, materialIdList)).in(TrainingUserViewTime::getUserId, userIds)).isNotNull(TrainingUserViewTimeMaterial::getFinishTime)).orderByAsc(TrainingUserViewTimeMaterial::getFinishTime);
                List materialViewList = this.trainingUserViewTimeMaterialMapper.selectList((Wrapper)wrapper3);
                if (!CollectionUtils.isEmpty((Collection)materialViewList)) {
                    viewMaterialMap = materialViewList.stream().collect(Collectors.groupingBy(TrainingUserViewTime::getMaterialId));
                }
            }
            if (!CollectionUtils.isEmpty(paperIdList = trainingChapterAttachList.stream().map(TrainingChapterAttach::getPaperId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper4.in(TrainingUserPaper::getTrainingPaperId, paperIdList)).in(TrainingUserPaper::getUserId, userIds)).eq(TrainingUserPaper::getSourceType, (Object)1)).isNotNull(TrainingUserPaper::getSubmitTime)).orderByAsc(TrainingUserPaper::getSubmitTime);
                List trainingUserPaperList = this.trainingUserPaperMapper.selectList((Wrapper)wrapper4);
                if (!CollectionUtils.isEmpty((Collection)trainingUserPaperList)) {
                    userPaperMap = trainingUserPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
                }
            }
        }
        Date now = new Date();
        for (TrainingStudyStatus trainingStudyStatus : trainingStudyStatusList) {
            List chapterAttachList = (List)trainingChapterAttachMap.get(trainingStudyStatus.getTrainingId());
            if (CollectionUtils.isEmpty((Collection)chapterAttachList)) continue;
            Date finishTime = now;
            for (TrainingChapterAttach chapterAttach : chapterAttachList) {
                if (chapterAttach.getMaterialId() != null) {
                    List viewTimeMaterialList = (List)viewMaterialMap.get(chapterAttach.getMaterialId());
                    if (CollectionUtils.isEmpty((Collection)viewTimeMaterialList)) break;
                    TrainingUserViewTimeMaterial viewTimeMaterial = (TrainingUserViewTimeMaterial)viewTimeMaterialList.get(0);
                    if (finishTime.compareTo(viewTimeMaterial.getFinishTime()) <= 0) continue;
                    finishTime = viewTimeMaterial.getFinishTime();
                    continue;
                }
                if (chapterAttach.getPaperId() == null) continue;
                List userPaperList = (List)userPaperMap.get(chapterAttach.getPaperId());
                if (CollectionUtils.isEmpty((Collection)userPaperList)) break;
                TrainingUserPaper userPaper = (TrainingUserPaper)userPaperList.get(0);
                if (finishTime.compareTo(userPaper.getSubmitTime()) <= 0) continue;
                finishTime = userPaper.getSubmitTime();
            }
            if (finishTime.compareTo(now) >= 0) continue;
            this.trainingStudyStatusMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TrainingStudyStatus::getId, (Object)trainingStudyStatus.getId())).set(TrainingStudyStatus::getFinishTime, (Object)finishTime));
        }
    }
}

