/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import java.math.BigDecimal;

public class Arith {
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final int DEF_DIV_SCALE = 2;
    private static final double DEF_DIFF = 1.0E-7;

    private Arith() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double add(double v1, double v2, int scale) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).setScale(scale, 4).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double sub(double v1, double v2, int scale) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).setScale(scale, 4).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double mul(double v1, double v2, int scale) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).setScale(scale, 4).doubleValue();
    }

    public static double div(double v1, double v2) {
        return Arith.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static boolean isEquals(BigDecimal source, BigDecimal destination) {
        if (source == null) {
            source = ZERO;
        }
        if (destination == null) {
            destination = ZERO;
        }
        return source.compareTo(destination) == 0;
    }

    public static boolean equalsWithDiff(double d1, double d2) {
        return Arith.equalsWithDiff(d1, d2, 1.0E-7);
    }

    public static boolean equalsWithDiff(double d1, double d2, double diff) {
        return Math.abs(d1 - d2) < diff;
    }
}

