/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.alibaba.fastjson.JSON;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.ExportTaskPojo;
import com.ovopark.organize.sdk.api.ExportTaskApi;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.util.OssHelper;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtils.class);
    @Autowired
    private ExportTaskApi exportTaskApi;
    private static ExportTaskApi sExportTaskApi;
    private static final int PENDING = 1;
    private static final int SUCCESS = 2;
    private static final int ERROR = 3;

    @PostConstruct
    public void init() {
        sExportTaskApi = this.exportTaskApi;
    }

    public static ExportTaskPojo saveExportTask(String fileName, String params) {
        Users user = Authenticator.getUser();
        ExportTaskPojo exportTaskPojo = new ExportTaskPojo();
        exportTaskPojo.setCreatorId(user.getId());
        exportTaskPojo.setEnterpriseId(user.getGroupId());
        exportTaskPojo.setModuleType(Integer.valueOf(11));
        exportTaskPojo.setTaskType(Integer.valueOf(1));
        exportTaskPojo.setName(fileName);
        exportTaskPojo.setParams(params);
        exportTaskPojo.setStatus(Integer.valueOf(1));
        exportTaskPojo.setCreateTime(new Date());
        boolean saveSuccess = DownloadUtils.saveExportTask(exportTaskPojo);
        return saveSuccess ? exportTaskPojo : null;
    }

    private static boolean saveExportTask(ExportTaskPojo exportTaskPojo) {
        try {
            BaseResult result = sExportTaskApi.saveExportTask(exportTaskPojo);
            log.info("saveExportTask result {} ,params:{}", (Object)JSON.toJSONString((Object)result), (Object)JSON.toJSONString((Object)exportTaskPojo));
            if (result != null && result.getData() != null) {
                exportTaskPojo.setId((Integer)result.getData());
                return true;
            }
        }
        catch (Exception e) {
            log.error("saveExportTask error {}", (Throwable)e);
        }
        return false;
    }

    public static ExportTaskPojo successExportTask(Workbook workbook, ExportTaskPojo exportTaskPojo) {
        log.info("successExportTask:", (Object)JSON.toJSONString((Object)exportTaskPojo));
        String url = OssHelper.uploadExcel(workbook, exportTaskPojo.getName());
        exportTaskPojo.setUpdateTime(new Date());
        exportTaskPojo.setStatus(Integer.valueOf(2));
        exportTaskPojo.setUrl(url);
        if (DownloadUtils.saveExportTask(exportTaskPojo)) {
            return exportTaskPojo;
        }
        return null;
    }

    public static ExportTaskPojo successExportTask(ByteArrayOutputStream bos, ExportTaskPojo exportTaskPojo) {
        log.info("successExportTask:", (Object)JSON.toJSONString((Object)exportTaskPojo));
        String url = OssHelper.uploadOutputStream(bos, exportTaskPojo.getName());
        log.info("successExportTask url:{}", (Object)url);
        exportTaskPojo.setUpdateTime(new Date());
        exportTaskPojo.setStatus(Integer.valueOf(2));
        exportTaskPojo.setUrl(url);
        if (DownloadUtils.saveExportTask(exportTaskPojo)) {
            return exportTaskPojo;
        }
        return null;
    }

    public static ExportTaskPojo errorExportTask(ExportTaskPojo exportTaskPojo) {
        if (exportTaskPojo == null) {
            log.error("errorExportTask exportTaskPojo is null");
            return null;
        }
        exportTaskPojo.setUpdateTime(new Date());
        exportTaskPojo.setStatus(Integer.valueOf(3));
        if (DownloadUtils.saveExportTask(exportTaskPojo)) {
            return exportTaskPojo;
        }
        return null;
    }
}

