/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class I18nUtils {
    public static void main(String[] args) {
        File[] files2;
        File[] files;
        File dir = new File("D:\\Java\\workspace\\ovopark-training\\ovopark-training-server\\src\\main\\java\\com\\ovopark\\training\\controller\\");
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                I18nUtils.iterateDirectory(file);
                continue;
            }
            List<String> result = I18nUtils.readChineseFromFile("D:\\Java\\workspace\\ovopark-training\\ovopark-training-server\\src\\main\\java\\com\\ovopark\\training\\controller\\" + file.getName());
            for (String string : result) {
                System.out.println(string);
            }
        }
        File dir2 = new File("D:\\Java\\workspace\\ovopark-training\\ovopark-training-server\\src\\main\\java\\com\\ovopark\\training\\service\\impl\\");
        for (File file : files2 = dir2.listFiles()) {
            if (file.isDirectory()) {
                I18nUtils.iterateDirectory(file);
                continue;
            }
            List<String> result = I18nUtils.readChineseFromFile("D:\\Java\\workspace\\ovopark-training\\ovopark-training-server\\src\\main\\java\\com\\ovopark\\training\\service\\impl\\" + file.getName());
            for (String string : result) {
                System.out.println(string);
            }
        }
    }

    private static void iterateDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    System.out.println("Subdirectory: " + file.getName());
                    I18nUtils.iterateDirectory(file);
                    continue;
                }
                System.out.println("File: " + file.getName());
            }
        }
    }

    public static List<String> readChinese(String line) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile("(?<!//)(?<!\\*)([\u4e00-\u9fa5]+)");
        Matcher m = p.matcher(line);
        while (m.find()) {
            result.add(m.group());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readChineseFromFile(String fileName) {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            String line = null;
            HashSet<String> set = new HashSet<String>();
            while ((line = br.readLine()) != null) {
                List<String> rowChineseList = I18nUtils.readChinese(line);
                set.addAll(rowChineseList);
            }
            result.addAll(set);
            Collections.sort(result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
        finally {
            if (null != br) {
                try {
                    try {
                        br.close();
                        br = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        br = null;
                    }
                }
                catch (Throwable throwable) {
                    br = null;
                    throw throwable;
                }
            }
        }
    }
}

