/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.ovopark.training.bo.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class ListUtil {
    public static <T> List<List<T>> splistList(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int index = (source.size() + n - 1) / n;
        for (int i = 0; i < index; ++i) {
            List<T> subList = null;
            if (i != index - 1) {
                subList = source.subList(i * n, (i + 1) * n);
                result.add(subList);
                continue;
            }
            subList = source.subList(i * n, source.size());
            result.add(subList);
        }
        return result;
    }

    public static <T> Page<T> myPage(List<T> list, int pageNum, int pageSize) {
        int pageEnd;
        List<Object> lastList = new ArrayList();
        int size = list.size();
        int pageStart = pageNum == 1 ? 0 : (pageNum - 1) * pageSize;
        int n = pageEnd = size < pageNum * pageSize ? size : pageNum * pageSize;
        if (size > pageStart) {
            lastList = list.subList(pageStart, pageEnd);
        }
        int totalPageNum = (int)Math.ceil((double)(list.size() / pageSize) * 1.0);
        Page myPage = new Page();
        myPage.setContent(lastList);
        myPage.setPageCount(Long.valueOf(totalPageNum));
        myPage.setPageNumber(pageNum);
        myPage.setPageSize(pageSize);
        myPage.setTotalCount(Long.valueOf(list.size()));
        return myPage;
    }

    public static <T> List<T> page(List<T> data, int pageNum, int pageSize) {
        if (data == null || data.size() == 0) {
            return data;
        }
        if (pageNum == 0 || pageSize == 0) {
            throw new RuntimeException("pageNum\u6216\u8005pageSize\u4e0d\u80fd\u7b49\u4e8e0");
        }
        if (pageNum < 0 || pageSize < 0) {
            throw new RuntimeException("pageNum\u6216\u8005pageSize\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        int dataSize = data.size();
        int pageCount = 0;
        if (dataSize <= pageSize) {
            return data;
        }
        pageCount = dataSize / pageSize + 1;
        if (pageNum <= 1) {
            return data.subList(0, pageSize);
        }
        if (pageNum * pageSize > data.size()) {
            return data.subList((pageCount - 1) * pageSize, dataSize);
        }
        return data.subList((pageNum - 1) * pageSize, pageNum * pageSize);
    }

    public static <T> List<T> disOrder(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        Collections.shuffle(list);
        return list;
    }
}

