/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.util.AliyunPropUtil;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.HttpUtils;
import com.ovopark.training.util.StorageModule;
import com.ovopark.training.util.StorageType;
import com.ovopark.training.util.StorageUploader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OssHelper {
    private static final Logger log = LoggerFactory.getLogger(OssHelper.class);
    private static String ossBucketName;
    private static String ossEndPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String accessUrl;
    private static String roleArn;
    private static String authAccessKeyId;
    private static String authAccessKeySecret;
    private static String region;
    private static String roleSessionName;
    private static String enterpriseId;
    private static StorageType storageType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadExcel(Workbook workbook, String fileName) {
        OSSClient client = null;
        client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        byte[] brray = bos.toByteArray();
        String imagePath = OssHelper.getFilePath(fileName);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
        meta.setCacheControl("no-cache");
        client.putObject(ossBucketName, imagePath, (InputStream)new ByteArrayInputStream(brray));
        return accessUrl + "/" + imagePath;
    }

    public static String uploadOutputStream(ByteArrayOutputStream bos, String fileName) {
        OSSClient client = null;
        client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
        byte[] brray = bos.toByteArray();
        String imagePath = OssHelper.getFilePath(fileName);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
        meta.setCacheControl("no-cache");
        client.putObject(ossBucketName, imagePath, (InputStream)new ByteArrayInputStream(brray));
        return accessUrl + "/" + imagePath;
    }

    public static String getFilePath(String imageName) {
        return "oa/" + DateUtil.format((Date)new Date(), (String)"yyyy/MM/dd") + "/" + imageName;
    }

    public static String getCircle(String imageUrl) {
        if (!StringUtils.isEmpty((Object)imageUrl)) {
            Map<String, String> map = OssHelper.getImageInfo(imageUrl);
            if (map.get("ImageHeight") != null && map.get("ImageWidth") != null) {
                if (Integer.parseInt(map.get("ImageHeight")) > Integer.parseInt(map.get("ImageWidth"))) {
                    return imageUrl + "?x-oss-process=image/circle,r_" + map.get("ImageWidth");
                }
                return imageUrl + "?x-oss-process=image/circle,r_" + map.get("ImageHeight");
            }
            return imageUrl;
        }
        return null;
    }

    public static String getSquare(String imageUrl) {
        if (!StringUtils.isEmpty((Object)imageUrl)) {
            Map<String, String> map = OssHelper.getImageInfo(imageUrl);
            if (map.get("ImageHeight") != null && map.get("ImageWidth") != null) {
                if (Integer.parseInt(map.get("ImageHeight")) > Integer.parseInt(map.get("ImageWidth"))) {
                    return imageUrl + "?x-oss-process=image/crop,x_0,y_0,w_" + map.get("ImageWidth") + ",h_" + map.get("ImageWidth") + ",g_center";
                }
                return imageUrl + "?x-oss-process=image/crop,x_0,y_0,w_" + map.get("ImageHeight") + ",h_" + map.get("ImageHeight") + ",g_center";
            }
            return imageUrl;
        }
        return null;
    }

    private static Map<String, String> getImageInfo(String url) {
        HashMap<String, String> result = new HashMap<String, String>();
        String json = HttpUtils.sendGetToOtherServer(url + "?x-oss-process=image/info");
        if (!StringUtils.isEmpty((Object)json)) {
            Map value;
            Map map = (Map)JSONObject.parseObject((String)json, Map.class);
            if (map.get("ImageHeight") != null) {
                value = (Map)JSONObject.parseObject((String)map.get("ImageHeight").toString(), Map.class);
                result.put("ImageHeight", value.get("value").toString());
            }
            if (map.get("ImageWidth") != null) {
                value = (Map)JSONObject.parseObject((String)map.get("ImageWidth").toString(), Map.class);
                result.put("ImageWidth", value.get("value").toString());
            }
            return result;
        }
        return null;
    }

    public static String uploadFile(File file, StorageModule module) {
        if (storageType == StorageType.aliyun) {
            String newFileName = OssHelper.genImageName(file.getName());
            String imagePath = OssHelper.getImagePath(newFileName, module);
            OssHelper.putObject(file, newFileName, imagePath, null);
            return imagePath;
        }
        return StorageUploader.upload(file, storageType, module);
    }

    public static String uploadFileName(File file, StorageModule module, String urlName) {
        if (storageType == StorageType.aliyun) {
            String newFileName = OssHelper.genImageName(file.getName());
            String imagePath = OssHelper.getImagePath(newFileName, module);
            OssHelper.putObject(file, newFileName, imagePath, urlName);
            return imagePath;
        }
        return StorageUploader.upload(file, storageType, module);
    }

    public static String uploadFile(InputStream inputStream, String ext, StorageModule module) {
        if (storageType == StorageType.aliyun) {
            String newFileName = OssHelper.genImageName(ext);
            String imagePath = OssHelper.getImagePath(newFileName, module);
            OssHelper.putObject(inputStream, newFileName, imagePath);
            return imagePath;
        }
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        try {
            File tempFile = File.createTempFile(str, ext);
            OssHelper.toFile(inputStream, tempFile);
            return StorageUploader.upload(tempFile, storageType, module);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return "error";
        }
    }

    public static String uploadFileNew(InputStream inputStream, String ext, StorageModule module) {
        if (storageType == StorageType.aliyun) {
            String newFileName = OssHelper.genImageName(ext);
            String imagePath = OssHelper.getImagePath(newFileName, module);
            OssHelper.putObject(inputStream, newFileName, imagePath);
            return accessUrl + "/" + imagePath;
        }
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        try {
            File tempFile = File.createTempFile(str, ext);
            OssHelper.toFile(inputStream, tempFile);
            return StorageUploader.upload(tempFile, storageType, module);
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return "error";
        }
    }

    private static void toFile(InputStream ins, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
    }

    private static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadFile(String imagePath, String localPath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            client.getObject(new GetObjectRequest(imagePath.substring(8, imagePath.lastIndexOf("oss-cn-hangzhou") - 1), imagePath.substring(imagePath.lastIndexOf("aliyuncs.com/") + 13)), new File(localPath));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String bucketName, String key) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            if (key.indexOf("http") != -1) {
                key = OssHelper.getFileNameByUrl(key);
            }
            client.deleteObject(bucketName, key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            client.shutdown();
        }
    }

    private static String getFileNameByUrl(String fileUrl) {
        int beginIndex = fileUrl.indexOf(accessUrl);
        int endIndex = fileUrl.indexOf("?");
        int endIndex2 = fileUrl.indexOf("@!");
        if (beginIndex == -1) {
            return null;
        }
        if (endIndex != -1) {
            return fileUrl.substring(beginIndex + accessUrl.length(), endIndex);
        }
        if (endIndex2 != -1) {
            return fileUrl.substring(beginIndex + accessUrl.length(), endIndex2);
        }
        return fileUrl.substring(beginIndex + accessUrl.length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOssPolicy() {
        OSSClient client = null;
        String dir = "front";
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            long expireTime = 30L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = client.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = client.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", accessKeyId);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", accessUrl);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            String string = JSONObject.toJSONString(respMap);
            return string;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            client.shutdown();
        }
        return null;
    }

    public static AssumeRoleResponse getStsPolicy() {
        String policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:*\"\n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:*\" \n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
        try {
            DefaultProfile.addEndpoint((String)"", (String)"", (String)ossBucketName, (String)ossEndPoint);
            DefaultProfile profile = DefaultProfile.getProfile((String)region, (String)authAccessKeyId, (String)authAccessKeySecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setMethod(MethodType.POST);
            request.setRoleArn(roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
            return response;
        }
        catch (Exception e) {
            log.error("Failed\uff1a", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObject(File file, String fileName, String imagePath, String urlName) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            FileInputStream input = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            if (!StringUtils.isEmpty((Object)urlName)) {
                meta.setContentDisposition("attachment;filename=" + urlName);
            }
            client.putObject(ossBucketName, imagePath, (InputStream)input, meta);
        }
        catch (FileNotFoundException e) {
            log.error("", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    public static String uploadFile(byte[] file, String fileName, StorageModule module) {
        String newFileName = OssHelper.genImageName(fileName);
        String imagePath = OssHelper.getImagePath(newFileName, module);
        OssHelper.putObject(file, newFileName, imagePath);
        return imagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObject(byte[] file, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, (InputStream)new ByteArrayInputStream(file));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            client.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putObject(InputStream input, String fileName, String imagePath) {
        OSSClient client = null;
        try {
            client = new OSSClient(ossEndPoint, accessKeyId, accessKeySecret);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(OssHelper.contentType(fileName.substring(fileName.lastIndexOf(".") + 1)));
            meta.setCacheControl("no-cache");
            client.putObject(ossBucketName, imagePath, input, meta);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            client.shutdown();
        }
    }

    private static String contentType(String fileType) {
        fileType = fileType.toLowerCase();
        String contentType = "";
        switch (fileType) {
            case "bmp": {
                contentType = "image/bmp";
                break;
            }
            case "gif": {
                contentType = "image/gif";
                break;
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                contentType = "image/jpeg";
                break;
            }
            case "html": {
                contentType = "text/html";
                break;
            }
            case "txt": {
                contentType = "text/plain";
                break;
            }
            case "vsd": {
                contentType = "application/vnd.visio";
                break;
            }
            case "ppt": 
            case "pptx": {
                contentType = "application/vnd.ms-powerpoint";
                break;
            }
            case "doc": 
            case "docx": {
                contentType = "application/msword";
                break;
            }
            case "xml": {
                contentType = "text/xml";
                break;
            }
            case "mp4": {
                contentType = "video/mp4";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        return contentType;
    }

    public static String genImageName(String suffix) {
        String extName = suffix.substring(suffix.lastIndexOf("."));
        long millis = System.currentTimeMillis();
        Random random = new Random();
        int end3 = random.nextInt(999);
        String str = millis + String.format("%03d", end3);
        return str + extName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushUpFileList(List<Map<String, String>> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (Map<String, String> map : list) {
                String file = "";
                HttpURLConnection conn = null;
                try {
                    String srcPath = map.get("srcPath");
                    URL url = new URL(srcPath);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(5000);
                    InputStream inStream = conn.getInputStream();
                    String fileName = map.get("fileName");
                    String imagePath = map.get("imagePath");
                    OssHelper.putObject(inStream, fileName, imagePath);
                    file = imagePath;
                    inStream.close();
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u4e0b\u8f7d\u540e\u4e0a\u4f20" + file, (Throwable)e);
                }
                finally {
                    assert (conn != null);
                    conn.disconnect();
                }
            }
        }
    }

    public static void pushFileList(List<Map<String, Object>> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (Map<String, Object> map : list) {
                String file = "";
                try {
                    PictureData srcFile = (PictureData)map.get("srcPath");
                    String fileName = map.get("fileName").toString();
                    String imagePath = map.get("imagePath").toString();
                    OssHelper.putObject(srcFile.getData(), fileName, imagePath);
                    file = imagePath;
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u4e0b\u8f7d\u540e\u4e0a\u4f20" + file, (Throwable)e);
                }
            }
        }
    }

    public static String getImagePath(String imageName, StorageModule module) {
        Users user = Authenticator.getInstance().getCurrentUser();
        String dir = Objects.nonNull(user) && Objects.nonNull(user.getGroupId()) ? module.name() + "/" + user.getGroupId() + "/" + DateUtils.format(new Date(), "yyyy/MM/dd") + "/" + imageName : module.name() + "/" + enterpriseId + "/" + DateUtils.format(new Date(), "yyyy/MM/dd") + "/" + imageName;
        return dir;
    }

    public static String getOssBucketName() {
        return ossBucketName;
    }

    public static String getOssEndPoint() {
        return ossEndPoint;
    }

    static {
        storageType = StorageType.aliyun;
        accessKeyId = AliyunPropUtil.readStringValue("aliyun.accessKeyId");
        accessKeySecret = AliyunPropUtil.readStringValue("aliyun.accessKeySecret");
        ossEndPoint = AliyunPropUtil.readStringValue("oss.endpoint");
        ossBucketName = AliyunPropUtil.readStringValue("oss.bucketName");
        accessUrl = AliyunPropUtil.readStringValue("oss.accessUrl");
        enterpriseId = AliyunPropUtil.readStringValue("oss.enterpriseId");
    }
}

