/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.ovopark.training.model.TrainingLearnShift;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisTemplateUtil {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public Long del(String ... keys) {
        Set keySet = Stream.of(keys).collect(Collectors.toSet());
        return this.redisTemplate.delete(keySet);
    }

    public boolean persist(String key) {
        Boolean result = this.redisTemplate.persist((Object)key);
        if (null == result) {
            return false;
        }
        return result;
    }

    public Long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public Long pTtl(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MILLISECONDS);
    }

    public boolean expire(String key, int ttl) {
        Boolean result = this.redisTemplate.expire((Object)key, (long)ttl, TimeUnit.SECONDS);
        if (null == result) {
            return false;
        }
        return result;
    }

    public boolean pExpire(String key, Long ttl) {
        Boolean result = this.redisTemplate.expire((Object)key, ttl.longValue(), TimeUnit.MILLISECONDS);
        if (null == result) {
            return false;
        }
        return result;
    }

    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public void setSecond(String key, Object value, int ttl) {
        this.redisTemplate.opsForValue().set((Object)key, value, (long)ttl, TimeUnit.SECONDS);
    }

    public void setMinutes(String key, Object value, int ttl) {
        this.redisTemplate.opsForValue().set((Object)key, value, (long)ttl, TimeUnit.MINUTES);
    }

    public void setMillisecond(String key, Object value, long ttl) {
        this.redisTemplate.opsForValue().set((Object)key, value, ttl, TimeUnit.MILLISECONDS);
    }

    public void mSet(Map<String, Object> keyValueMap) {
        this.redisTemplate.opsForValue().multiSetIfAbsent(keyValueMap);
    }

    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public List<Object> mGet(String ... keys) {
        Set keySet = Stream.of(keys).collect(Collectors.toSet());
        return this.redisTemplate.opsForValue().multiGet(keySet);
    }

    public void boundHashOps(String key1, int key2, TrainingLearnShift shift) {
        this.redisTemplate.boundHashOps((Object)key1).put((Object)key2, (Object)shift);
    }

    public TrainingLearnShift boundHashOps(String key1, int key2) {
        return (TrainingLearnShift)this.redisTemplate.boundHashOps((Object)key1).values().get(key2);
    }

    public Boolean setStock(String key, String value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, Duration.ofSeconds(60L));
    }
}

