/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.training.util.AliyunPropUtil;
import com.ovopark.training.util.StorageModule;
import com.ovopark.training.util.StorageType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUploader {
    private static final Logger log = LoggerFactory.getLogger(StorageUploader.class);
    private static String fileStorageType = AliyunPropUtil.readStringValue("fileStorageType");
    private static String fileUploadAddress = AliyunPropUtil.readStringValue("fileUploadAddress");
    private static String uploadUrl = fileUploadAddress + "api/dc/storage/oss/upload";
    private static String deleteUrl = fileUploadAddress + "api/dc/storage/oss/delete";

    public static String upload(File file, StorageType type, StorageModule moduleId) {
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        extraHeaders.put("storageType", type.name());
        extraHeaders.put("moduleId", String.valueOf(moduleId.ordinal()));
        String result = null;
        try {
            result = StorageUploader.doPost(uploadUrl, extraHeaders, file, null);
            JSONObject obj = JSONObject.parseObject((String)result);
            int code = obj.getInteger("code");
            if (code == 0) {
                result = obj.getJSONObject("data").getString("ossUrl");
            } else {
                log.info("uploadFileToStorage:" + obj.getString("result"));
                result = obj.getString("result");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return result;
    }

    public static void deleteFile(StorageType type, String filePath) {
        HashMap<String, String> extraHeaders = new HashMap<String, String>();
        extraHeaders.put("storageType", type.name());
        String result = null;
        try {
            result = StorageUploader.deleteFromStorage(deleteUrl, extraHeaders, filePath, null);
            JSONObject obj = JSONObject.parseObject((String)result);
            int code = obj.getInteger("code");
            if (code == 0) {
                log.info("deleteFileSuccess:" + filePath);
            } else {
                log.info("deleteFileFailed:" + filePath + "; result:" + obj.getString("result"));
            }
        }
        catch (Exception e) {
            log.error("deleteFile", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String url, Map<String, String> extraHeaders, File file, Integer timeOut) throws Exception {
        if (timeOut == null) {
            timeOut = 10000;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addBinaryBody("file", file);
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            int state = response.getStatusLine().getStatusCode();
            if (state == 200) {
                HttpEntity responseEntity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
                log.info("request url:" + url + "; response:" + result);
                String string = result;
                return string;
            }
            log.error("\u8bf7\u6c42\u8fd4\u56de:" + state + "(" + url + ")");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String deleteFromStorage(String url, Map<String, String> extraHeaders, String filePath, Integer timeOut) throws Exception {
        if (timeOut == null) {
            timeOut = 10000;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("filePath", filePath));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            int state = response.getStatusLine().getStatusCode();
            if (state == 200) {
                HttpEntity responseEntity = response.getEntity();
                String result = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
                log.info("request url:" + url + "; response:" + result);
                String string = result;
                return string;
            }
            log.error("\u8bf7\u6c42\u8fd4\u56de:" + state + "(" + url + ")");
        }
        catch (Exception e) {
            log.error("deleteFromStorage", (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return null;
    }
}

