/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import com.ovopark.training.util.OssHelper;
import com.ovopark.training.util.StorageModule;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.AudioAttributes;
import ws.schild.jave.Encoder;
import ws.schild.jave.EncodingAttributes;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.VideoAttributes;

public class VideoCompressionUtil {
    private static final Logger log = LoggerFactory.getLogger(VideoCompressionUtil.class);

    public static Map<String, Object> videoCompression(String srcImgPath, String tarImgPath, String linuxDownUrl, String ossUpUrl, String urlName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            OssHelper.downLoadFile(srcImgPath, linuxDownUrl + tarImgPath);
            File srcFile = new File(linuxDownUrl + tarImgPath);
            File targetFile = new File(linuxDownUrl + "copy" + tarImgPath);
            AudioAttributes audio = new AudioAttributes();
            audio.setCodec("aac");
            audio.setBitRate(Integer.valueOf(64000));
            audio.setChannels(Integer.valueOf(1));
            audio.setSamplingRate(Integer.valueOf(22050));
            VideoAttributes video = new VideoAttributes();
            video.setCodec("h264");
            video.setBitRate(Integer.valueOf(1600000));
            video.setFrameRate(Integer.valueOf(15));
            EncodingAttributes attrs = new EncodingAttributes();
            attrs.setFormat("mp4");
            attrs.setAudioAttributes(audio);
            attrs.setVideoAttributes(video);
            Encoder encoder = new Encoder();
            encoder.encode(new MultimediaObject(srcFile), targetFile, attrs);
            String url = ossUpUrl + OssHelper.uploadFileName(targetFile, StorageModule.TRAINING, urlName);
            map.put("size", targetFile.length());
            map.put("url", url);
            srcFile.delete();
            targetFile.delete();
        }
        catch (Exception e) {
            log.error("videoCompression", (Throwable)e);
        }
        return map;
    }
}

