/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.training.util.CompletableFutureUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WeChatBotUtils {
    private static final Logger log = LoggerFactory.getLogger(WeChatBotUtils.class);
    private static String MARK_DOWN_MSG = " `\u4efb\u52a1\u544a\u8b66` \n    >**\u8be6\u60c5** \n    >\u73af \u5883\uff1a%s \n    >\u63a5 \u53e3\uff1a<font color=\"info\">%s</font> \n    >\u53c2 \u6570\uff1a%s \n    >\u7528 \u6237\uff1a%s \n    >\u4f01 \u4e1a\uff1a<font color=\"info\">%s</font>\n    >\u65f6 \u95f4\uff1a<font color=\"warning\">%s</font>\n    >\u5907 \u6ce8\uff1a<font color=\"red\">%s</font>\n    >\n";
    @Value(value="${wechat.botUrl}")
    private String botUrl;
    @Value(value="${spring.profiles.active}")
    private String env;
    private static WeChatBotUtils utils;

    @PostConstruct
    public void init() {
        utils = this;
        WeChatBotUtils.utils.botUrl = this.botUrl;
        WeChatBotUtils.utils.env = this.env;
    }

    private static Boolean sendTextMsg(String msg) {
        JSONObject text = new JSONObject();
        text.put("content", (Object)msg);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)"text");
        reqBody.put("text", (Object)text);
        reqBody.put("safe", (Object)0);
        return WeChatBotUtils.callWeChatBot(reqBody.toString());
    }

    private static Boolean sendMarKDownMsg(String msg) {
        JSONObject markdown = new JSONObject();
        markdown.put("content", (Object)msg);
        JSONObject reqBody = new JSONObject();
        reqBody.put("msgtype", (Object)"markdown");
        reqBody.put("markdown", (Object)markdown);
        reqBody.put("safe", (Object)0);
        return WeChatBotUtils.callWeChatBot(reqBody.toString());
    }

    public static Boolean callWeChatBot(String reqBody) {
        try {
            String respMsg;
            if (WeChatBotUtils.utils.botUrl != null && !StringUtils.isEmpty((CharSequence)(respMsg = HttpUtil.createPost((String)WeChatBotUtils.utils.botUrl).body(reqBody).execute().body())) && "0".equals(respMsg.substring(11, 12))) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u7fa4\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\uff1a{}", (Object)reqBody);
        }
        return Boolean.FALSE;
    }

    public static void sendMarkDownMsg(String method, String params, String userId, String enterpriseId, String remark) {
        CompletableFutureUtils.runAsync(() -> {
            String markdownMsg = String.format(MARK_DOWN_MSG, WeChatBotUtils.utils.env, method, params, userId, enterpriseId, DateUtil.now(), remark);
            WeChatBotUtils.sendMarKDownMsg(markdownMsg);
        });
    }
}

