/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.aop;

import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SqlTimeInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SqlTimeInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = invocation.proceed();
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        String sql = ms.getBoundSql(parameter).getSql();
        if (elapsedTime > 500000L) {
            log.warn("SQL\u6267\u884c\u8017\u65f6\u8fc7\u957f SQL\u6267\u884c\u8017\u65f6\uff1a{}\u6beb\u79d2 {}", (Object)elapsedTime, (Object)sql);
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

