/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.config;

import com.ovopark.training.enhancer.subject.env.EnvService;
import com.ovopark.training.enhancer.subject.resp.IResultWrapper;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EnhancerConfig {
    private static final Logger log = LoggerFactory.getLogger(EnhancerConfig.class);
    @Autowired
    private EnvService envService;

    @PostConstruct
    public void init() {
        if (this.envService.isDevelopment()) {
            log.info("init EnhancerConfig");
            final IResultWrapper traceIdWrapper = new IResultWrapper(){

                public <T> Result<T> wrap(Result<T> result) {
                    result.setRequestId(EhContextUtil.getTraceId());
                    return result;
                }
            };
            IResultWrapper logWrapper = new IResultWrapper(){

                public <T> Result<T> wrap(Result<T> result) {
                    log.info("result:{}", result);
                    return traceIdWrapper.wrap(result);
                }
            };
            ResultUtils.setResultWrapper((IResultWrapper)logWrapper);
        }
    }
}

