/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.enterprise;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingMaterialComment;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.enterprise.CommentService;
import com.ovopark.training.vo.TrainingCommentVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/comment"})
public class CommentController {
    private static final Logger log = LoggerFactory.getLogger(CommentController.class);
    @Autowired
    private CommentService commentService;

    @RequestMapping(value={"/saveMaterialComment"})
    @ResponseBody
    public String addTrainingTrain(@RequestBody TrainingMaterialComment trainingMaterialComment) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.commentService.saveMaterialComment(trainingMaterialComment, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getCommentByPage"})
    @ResponseBody
    public String getCommentByPage(Page<TrainingCommentVo> page, Integer id, Integer commentType) {
        page = this.commentService.getCommentByPage(page, id, commentType);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/getUserCommentStars"})
    @ResponseBody
    public String getUserCommentStars(Integer id, Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.commentService.getUserCommentStars(id, type, user));
    }

    @RequestMapping(value={"/saveComment"})
    @ResponseBody
    public String saveComment(@RequestBody TrainingCommentVo trainingCommentVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.commentService.saveComment(trainingCommentVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteComment"})
    @ResponseBody
    public String deleteComment(Integer id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.commentService.deleteComment(id, user);
        return JsonResult.success();
    }
}

