/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.enterprise;

import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.domain.EnterpriseConfigDo;
import com.ovopark.training.model.param.EnterpriseConfigParam;
import com.ovopark.training.service.enterprise.EnterpriseConfigService;
import com.ovopark.training.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/enterprise/config"})
public class EnterpriseConfigController {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseConfigController.class);
    @Autowired
    private EnterpriseConfigService enterpriseConfigService;

    @RequestMapping(value={"/getEnterpriseConfig"})
    @ResponseBody
    public Result<EnterpriseConfigDo> getEnterpriseConfig(@RequestBody EnterpriseConfigParam enterpriseConfigParam) {
        Users user = ContextUtil.getUser();
        return ResultUtils.success((Object)this.enterpriseConfigService.getEnterpriseConfig(enterpriseConfigParam, user));
    }

    @RequestMapping(value={"/saveEnterpriseConfig"})
    @ResponseBody
    public Result<EnterpriseConfigDo> saveEnterpriseConfig(@RequestBody EnterpriseConfigDo enterpriseConfigDo) {
        Users user = ContextUtil.getUser();
        return ResultUtils.success((Object)this.enterpriseConfigService.saveEnterpriseConfig(enterpriseConfigDo, user));
    }
}

