/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.feign;

import com.ovopark.training.bo.Page;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.mapper.OperateCheckMapper;
import com.ovopark.training.mapper.TrainingActivityMapper;
import com.ovopark.training.mapper.TrainingCourseStageTaskMapper;
import com.ovopark.training.model.OperateCheck;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingActivity;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseStageTask;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.model.UsersDutiesPojo;
import com.ovopark.training.model.param.MaterialStudyExportParam;
import com.ovopark.training.model.param.TrainingReportParam;
import com.ovopark.training.model.param.UserReportParam;
import com.ovopark.training.model.view.DepartmentTrainingReportVo;
import com.ovopark.training.request.DeptSummarizeExportRequest;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.request.PaperManagementRequest;
import com.ovopark.training.response.DeptSummarizeResponse;
import com.ovopark.training.service.IDeptStatisticService;
import com.ovopark.training.service.TrainingActivityService;
import com.ovopark.training.service.TrainingCertificateService;
import com.ovopark.training.service.TrainingCourseExportService;
import com.ovopark.training.service.TrainingCourseService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.TrainingJobExcelService;
import com.ovopark.training.service.TrainingJobParticipantsManagementService;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.TrainingLearnTaskUserService;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.TrainingOperateService;
import com.ovopark.training.service.TrainingPaperService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.service.TrainingShiftExeclService;
import com.ovopark.training.service.exam.ITrainingPaperRefactorService;
import com.ovopark.training.service.report.ReportService;
import com.ovopark.training.vo.ExaminerAnalysisReq;
import com.ovopark.training.vo.ExaminerAnalysisVo;
import com.ovopark.training.vo.MaterialStudyVo;
import com.ovopark.training.vo.OpenShiftExcelVo;
import com.ovopark.training.vo.PaperDetailExcelVo;
import com.ovopark.training.vo.PaperManagementBaseInfoVo;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperUserDetailVo;
import com.ovopark.training.vo.StudentReportVo;
import com.ovopark.training.vo.TraineeAnalysisReq;
import com.ovopark.training.vo.TraineeAnalysisVo;
import com.ovopark.training.vo.TrainingActivityUserVo;
import com.ovopark.training.vo.TrainingCertificateDetailVo;
import com.ovopark.training.vo.TrainingCourseUserTaskVo;
import com.ovopark.training.vo.TrainingExeclVo;
import com.ovopark.training.vo.TrainingJobStudentAnalyseVo;
import com.ovopark.training.vo.TrainingJobUserTaskVo;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import com.ovopark.training.vo.TrainingLearnTaskUserVo;
import com.ovopark.training.vo.TrainingLearnUserVo;
import com.ovopark.training.vo.TrainingLearnerAnalysisVo;
import com.ovopark.training.vo.TrainingLearnerMaterialDetailVo;
import com.ovopark.training.vo.TrainingLearnerPaperDetailVo;
import com.ovopark.training.vo.TrainingMaterialDownloadsVo;
import com.ovopark.training.vo.UserReportVo;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/export/feign"})
public class TrainingExportFeign {
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainingShiftExeclService trainingShiftExeclService;
    @Autowired
    private TrainingLearnProjectService trainingLearnProjectService;
    @Autowired
    private TrainingJobExcelService trainingJobExcelService;
    @Autowired
    private TrainingCertificateService trainingCertificateService;
    @Autowired
    private TrainingPaperService trainingPaperService;
    @Autowired
    private TrainingCourseService trainingCourseService;
    @Autowired
    private TrainingCourseExportService trainingCourseExportService;
    @Autowired
    private TrainingOperateService trainingOperateService;
    @Autowired
    private TrainingJobCertificationService trainingJobCertificationService;
    @Autowired
    private TrainingCourseStageTaskMapper trainingCourseStageTaskMapper;
    @Autowired
    private OperateCheckMapper operateCheckMapper;
    @Autowired
    private TrainingLearnTaskUserService trainingLearnTaskUserService;
    @Autowired
    private TrainingJobParticipantsManagementService trainingJobParticipantsManagementService;
    @Autowired
    private TrainingActivityService trainingActivityService;
    @Autowired
    private TrainingActivityMapper trainingActivityMapper;
    @Autowired
    private TrainingMaterialService trainingMaterialService;
    @Autowired
    private IDeptStatisticService deptStatisticService;
    @Autowired
    private ITrainingPaperRefactorService trainingPaperRefactorService;
    @Autowired
    private ReportService reportService;

    @PostMapping(value={"/selectExeclVoByUser"})
    @ResponseBody
    public List<TrainingExeclVo> selectExeclVoByUser(@RequestBody TrainingExeclVo trainingExeclVo) {
        List<TrainingExeclVo> list = this.trainingService.selectExeclVoByUser(trainingExeclVo, trainingExeclVo.getUser());
        return list;
    }

    @PostMapping(value={"/selectUserTraining"})
    @ResponseBody
    public List<TrainingExeclVo> selectUserTraining(@RequestBody TrainingExeclVo trainingExeclVo) {
        List<TrainingExeclVo> list = this.trainingService.selectUserTraining(trainingExeclVo, trainingExeclVo.getUser());
        return list;
    }

    @PostMapping(value={"/selectTrainingByUser"})
    @ResponseBody
    public List<TrainingExeclVo> selectTrainingByUser(@RequestBody TrainingExeclVo trainingExeclVo) {
        List<TrainingExeclVo> list = this.trainingService.selectTrainingByUser(trainingExeclVo, trainingExeclVo.getUser());
        return list;
    }

    @PostMapping(value={"/selectExeclVoByDep"})
    @ResponseBody
    public List<TrainingExeclVo> selectExeclVoByDep(@RequestBody TrainingExeclVo trainingExeclVo) {
        List<TrainingExeclVo> list = this.trainingService.selectExeclVoByDep(trainingExeclVo, trainingExeclVo.getUser());
        return list;
    }

    @PostMapping(value={"/selectExeclVoByRole"})
    @ResponseBody
    public List<TrainingExeclVo> selectExeclVoByRole(@RequestBody TrainingExeclVo trainingExeclVo) {
        List<TrainingExeclVo> list = this.trainingService.selectExeclVoByRole(trainingExeclVo, trainingExeclVo.getUser());
        return list;
    }

    @PostMapping(value={"/selectExeclVoByTrain"})
    @ResponseBody
    public List<TrainingExeclVo> selectExeclVoByTrain(@RequestBody TrainingExeclVo trainingExeclVo) {
        List<TrainingExeclVo> list = this.trainingService.selectExeclVoByTrain(trainingExeclVo, trainingExeclVo.getUser());
        return list;
    }

    @PostMapping(value={"/selectOpenShift"})
    @ResponseBody
    public List<TrainingLearnShiftVo> selectOpenShift(@RequestBody OpenShiftExcelVo openShiftExcelVo) {
        List<TrainingLearnShiftVo> list = this.trainingShiftExeclService.selectOpenShift(openShiftExcelVo.getUser(), openShiftExcelVo.getCreaterList(), openShiftExcelVo.getStartTime(), openShiftExcelVo.getEndTime(), openShiftExcelVo.getSourceId());
        return list;
    }

    @PostMapping(value={"/selectStudentReport"})
    @ResponseBody
    public List<StudentReportVo> selectStudentReport(@RequestBody StudentReportVo vo) {
        List<StudentReportVo> list = this.trainingShiftExeclService.selectStudentReport(vo, vo.getUser());
        return list;
    }

    @PostMapping(value={"/selectMainByStudentByExecl"})
    @ResponseBody
    public List<TrainingExeclVo> selectMainByStudentByExecl(@RequestBody TrainingExeclVo vo) {
        List<TrainingExeclVo> list = this.trainingService.selectMainByStudentByExecl(vo, vo.getUser());
        return list;
    }

    @PostMapping(value={"/getMaterialDetailExcelList"})
    @ResponseBody
    public List<TrainingLearnerMaterialDetailVo> getMaterialDetailExcelList(@RequestParam Integer userId, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam(required=false) Integer groupId, @RequestParam Integer materialId, @RequestParam(required=false) String nameOrNumber) {
        List<TrainingLearnerMaterialDetailVo> list = this.trainingService.getMaterialDetailExcelList(userId, status, trainingId, groupId, materialId, nameOrNumber);
        return list;
    }

    @PostMapping(value={"/getPaperDetailExcelList"})
    @ResponseBody
    public List<TrainingLearnerPaperDetailVo> getPaperDetailExcelList(@RequestParam Integer userId, @RequestParam(required=false) Integer status, @RequestParam(required=false) Integer groupId, @RequestParam Integer trainingId, @RequestParam Integer paperId, @RequestParam(required=false) String nameOrNumber, @RequestParam String excelStr, @RequestParam(required=false) Integer exportStatus) {
        List<TrainingLearnerPaperDetailVo> list = this.trainingService.getPaperDetailExcelList(userId, status, groupId, trainingId, paperId, nameOrNumber, excelStr, exportStatus);
        return list;
    }

    @PostMapping(value={"/getLearnerExcelList"})
    @ResponseBody
    public List<TrainingLearnerAnalysisVo> getLearnerExcelList(@RequestParam Integer userId, @RequestParam Integer groupId, @RequestParam(required=false) Integer status, @RequestParam Integer trainingId, @RequestParam String excelStr, @RequestParam(required=false) String organizeIds, @RequestParam(required=false) String depIds, @RequestParam(required=false) String nameOrNumber, Locale locale) {
        List<TrainingLearnerAnalysisVo> list = this.trainingService.getLearnerExcelList(userId, status, trainingId, groupId, organizeIds, depIds, nameOrNumber, excelStr, locale);
        return list;
    }

    @PostMapping(value={"/getUserTrainTaskExcel"})
    @ResponseBody
    public List<TrainingLearnTaskUserVo> getUserTrainTaskExcel(@RequestBody Map project) {
        List<TrainingLearnTaskUserVo> list = this.trainingService.getUserTrainTask(project);
        return list;
    }

    @PostMapping(value={"/getUserWorkTaskExcel"})
    @ResponseBody
    public List<TrainingLearnTaskUserVo> getUserWorkTaskExcel(@RequestBody Map<String, Object> project) {
        List<TrainingLearnTaskUserVo> list = this.trainingLearnTaskUserService.getUserWorkTask(project);
        return list;
    }

    @PostMapping(value={"/getUserPaperTaskExcel"})
    @ResponseBody
    public List<TrainingLearnTaskUserVo> getUserPaperTaskExcel(@RequestBody Map<String, Object> project) {
        List<TrainingLearnTaskUserVo> list = this.trainingLearnProjectService.getUserPaperTask(project);
        return list;
    }

    @PostMapping(value={"/getUserAllPaperTaskExcel"})
    @ResponseBody
    public List<TrainingLearnTaskUserVo> getUserAllPaperTaskExcel(@RequestBody Map<String, Object> project) {
        List<TrainingLearnTaskUserVo> list = this.trainingLearnProjectService.getUserPaperTask2(project);
        return list;
    }

    @PostMapping(value={"/getUserOfflineTaskExcel"})
    @ResponseBody
    public List<TrainingLearnTaskUserVo> getUserOfflineTaskExcel(@RequestBody Map<String, Object> project) {
        List<TrainingLearnTaskUserVo> list = this.trainingLearnProjectService.getUserOfflineTask(project);
        return list;
    }

    @PostMapping(value={"/getUserTaskExcel"})
    @ResponseBody
    public List<TrainingLearnUserVo> getUserTaskExcel(@RequestBody Map<String, Object> project) {
        List<TrainingLearnUserVo> list = this.trainingLearnProjectService.getUserTask(project);
        return list;
    }

    @PostMapping(value={"/selectUserJobsDetailByExcel"})
    @ResponseBody
    public List<TrainingJobStudentAnalyseVo> selectUserJobsDetailByExcel(@RequestBody TrainingJobStudentAnalyseVo jobUserTaskVo) {
        List<TrainingJobStudentAnalyseVo> list = this.trainingJobExcelService.selectUserJobsDetailByExcel(jobUserTaskVo);
        return list;
    }

    @PostMapping(value={"/selectTrainingByDepExcel"})
    @ResponseBody
    public List<TrainingExeclVo> selectTrainingByDepExcel(@RequestBody TrainingExeclVo trainingExeclVo) {
        List<TrainingExeclVo> list = this.trainingService.selectTrainingByDep(trainingExeclVo, trainingExeclVo.getUser());
        return list;
    }

    @PostMapping(value={"/getTrainingById"})
    @ResponseBody
    public Training selectTrainingByDepExcel(@RequestParam Integer trainingId) {
        return this.trainingService.getById(trainingId);
    }

    @PostMapping(value={"/getCertificateDetailList"})
    @ResponseBody
    public List<TrainingCertificateDetailVo> getCertificateDetailList(@RequestParam(required=false) Integer enterpriseId, @RequestParam(required=false) List<Integer> userIds, @RequestParam(required=false) String userName, @RequestParam(required=false) Integer status, @RequestParam Integer certificateId) {
        return this.trainingCertificateService.getCertificateDetailList(enterpriseId, userIds, userName, status, certificateId);
    }

    @PostMapping(value={"/selectPaperUserDetailsByList"})
    @ResponseBody
    public List<PaperUserDetailVo> selectPaperUserDetailsByList(@RequestBody PaperDetailExcelVo excelVo) {
        return this.trainingPaperService.selectPaperUserDetailsByList(excelVo);
    }

    @PostMapping(value={"/selectPaperUserDetailsByList2"})
    @ResponseBody
    public List<PaperUserDetailVo> selectPaperUserDetailsByList2(@RequestBody PaperDetailExcelVo excelVo) {
        return this.trainingPaperService.selectPaperUserDetailsByList2(excelVo);
    }

    @PostMapping(value={"/trainingPaperSelectById"})
    @ResponseBody
    public TrainingPaper trainingPaperSelectById(@RequestParam int paperId) {
        return this.trainingPaperService.selectById(paperId);
    }

    @PostMapping(value={"/getCourseUserAnalysisList"})
    @ResponseBody
    public List<TrainingCourseUserTaskVo> getCourseUserAnalysisList(@RequestParam Integer courseId, @RequestParam(required=false) String name, @RequestParam(required=false) Integer status, @RequestParam(required=false) String organizeIds, @RequestParam(required=false) Integer turns, @RequestParam(required=false) String roles, @RequestParam Integer groupId, @RequestParam Integer userId) {
        return this.trainingCourseService.getCourseUserAnalysisList(courseId, name, status, organizeIds, turns, roles, groupId, userId);
    }

    @PostMapping(value={"/getCourseById"})
    @ResponseBody
    public TrainingCourse getCourseById(@RequestParam Integer courseId) {
        return this.trainingCourseService.getTrainingCourseById(courseId);
    }

    @PostMapping(value={"/getCourseTrainingList"})
    @ResponseBody
    public List<TrainingCourseUserTaskVo> getCourseTrainingList(@RequestParam Integer taskId, @RequestParam(required=false) String name, @RequestParam(required=false) Integer status, @RequestParam Integer groupId, @RequestParam Integer userId) {
        return this.trainingCourseExportService.getCourseTrainingList(taskId, name, status, groupId, userId);
    }

    @PostMapping(value={"/getCourseTrainingList2"})
    @ResponseBody
    public List<TrainingCourseUserTaskVo> getCourseTrainingList2(@RequestParam Integer taskId, @RequestParam(required=false) String name, @RequestParam(required=false) Integer status, @RequestParam Integer groupId, @RequestParam Integer userId) {
        return this.trainingCourseExportService.getCourseTrainingList2(taskId, name, status, groupId, userId);
    }

    @PostMapping(value={"/getTrainingCourseStageTaskById"})
    @ResponseBody
    public TrainingCourseStageTask getTrainingCourseStageTaskById(@RequestParam Integer taskId) {
        return (TrainingCourseStageTask)this.trainingCourseStageTaskMapper.selectById(taskId);
    }

    @PostMapping(value={"/getTraineeAnalysis"})
    @ResponseBody
    public TraineeAnalysisVo getTraineeAnalysis(@RequestBody TraineeAnalysisReq req) {
        return this.trainingOperateService.getTraineeAnalysis(req, req.getUsers());
    }

    @PostMapping(value={"/getOperateCheckById"})
    @ResponseBody
    public OperateCheck getOperateCheckById(@RequestParam Integer operateCheckId) {
        return (OperateCheck)this.operateCheckMapper.selectById(operateCheckId);
    }

    @PostMapping(value={"/getJobUserTaskList"})
    @ResponseBody
    public List<TrainingJobUserTaskVo> getJobUserTaskList(@RequestParam Integer stageTaskId, @RequestParam(required=false) Integer taskStatus, @RequestParam(required=false) String userName, @RequestBody Users user) {
        return this.trainingJobCertificationService.getJobUserTaskList(stageTaskId, taskStatus, userName, user);
    }

    @PostMapping(value={"/getExaminerAnalysis"})
    @ResponseBody
    public ExaminerAnalysisVo getExaminerAnalysis(@RequestBody ExaminerAnalysisReq req) {
        return this.trainingOperateService.getExaminerAnalysis(req, req.getUsers());
    }

    @PostMapping(value={"/getJobUserPaperList"})
    @ResponseBody
    public List<TrainingJobUserTaskVo> getJobUserPaperList(@RequestParam Integer stageTaskId, @RequestParam(required=false) Integer taskStatus, @RequestParam(required=false) String userName, @RequestBody Users user) {
        return this.trainingJobCertificationService.getJobUserPaperList(stageTaskId, taskStatus, userName, user);
    }

    @PostMapping(value={"/getJobUserPaperList2"})
    @ResponseBody
    public List<TrainingJobUserTaskVo> getJobUserPaperList2(@RequestParam Integer stageTaskId, @RequestParam(required=false) Integer taskStatus, @RequestParam(required=false) String userName, @RequestBody Users user) {
        return this.trainingJobCertificationService.getJobUserPaperList2(stageTaskId, taskStatus, userName, user);
    }

    @PostMapping(value={"/getUserOfflineList"})
    @ResponseBody
    public List<TrainingJobUserTaskVo> getUserOfflineList(@RequestParam Integer stageTaskId, @RequestParam(required=false) Integer shiftTaskId, @RequestParam(required=false) String userName, @RequestBody(required=false) Users user) {
        return this.trainingJobCertificationService.getUserOfflineList(stageTaskId, shiftTaskId, userName, user);
    }

    @PostMapping(value={"/getStudentAnalyseList"})
    @ResponseBody
    public List<UsersDutiesPojo> getStudentAnalyseList(@RequestParam Integer groupId, @RequestParam Integer jobId, @RequestParam(required=false) String deptIdStr, @RequestParam(required=false) String jobOrName, @RequestParam(required=false) Integer learnStatus, @RequestParam(required=false) Integer passStatus, @RequestParam(required=false) Integer isFrozen, @RequestBody(required=false) Users user) {
        return this.trainingJobParticipantsManagementService.getStudentAnalyseList(groupId, jobId, deptIdStr, jobOrName, learnStatus, passStatus, isFrozen, user);
    }

    @PostMapping(value={"/selectJobStudentDetail"})
    @ResponseBody
    public List<TrainingJobStudentAnalyseVo> selectJobStudentDetail(@RequestBody TrainingJobStudentAnalyseVo jobUserTaskVo) {
        return this.trainingJobExcelService.selectJobStudentDetail(jobUserTaskVo, jobUserTaskVo.getUser());
    }

    @PostMapping(value={"/getTrainingActivityUserVoList"})
    @ResponseBody
    public List<TrainingActivityUserVo> getTrainingActivityUserVoList(@RequestBody Users users, @RequestParam(required=false) String userName, @RequestParam Integer activityId, @RequestParam(required=false) Integer applyMode) {
        return this.trainingActivityService.getTrainingActivityUserVoList(users, userName, activityId, applyMode);
    }

    @PostMapping(value={"/getActivityById"})
    @ResponseBody
    public TrainingActivity getActivityById(@RequestParam Integer activityId) {
        return (TrainingActivity)this.trainingActivityMapper.selectById(activityId);
    }

    @PostMapping(value={"/queryDeptExcelStatistics"})
    @ResponseBody
    public List<DeptSummarizeResponse> queryDeptExcelStatistics(@RequestBody DeptSummarizeExportRequest request) {
        return this.deptStatisticService.queryDeptExcelStatistics(request);
    }

    @PostMapping(value={"/getMaterialDownloadsByExcel"})
    @ResponseBody
    public List<TrainingMaterialDownloadsVo> getMaterialDownloadsByExcel(@RequestParam Integer materialId, @RequestBody Users user) {
        return this.trainingMaterialService.getMaterialDownloads(materialId, user);
    }

    @PostMapping(value={"/selectExamineeDetailsByExecl"})
    @ResponseBody
    public List<PaperManagementExamineeDetailVo> selectExamineeDetails(@RequestBody ExamineeDetailRequest request) {
        return this.trainingPaperRefactorService.selectExamineeDetails(request);
    }

    @PostMapping(value={"/getPaperManagementBaseInfo"})
    @ResponseBody
    public PaperManagementBaseInfoVo getPaperManagementBaseInfo(@RequestBody PaperManagementRequest request) {
        return this.trainingPaperRefactorService.getPaperManagementBaseInfo(request);
    }

    @PostMapping(value={"getMaterialStudyByPage"})
    @ResponseBody
    public Result<Page<MaterialStudyVo>> getMaterialStudyByPage(@RequestBody MaterialStudyExportParam param) {
        return this.trainingMaterialService.getMaterialStudyByPage(param.getPage(), param.getGroupId(), param.getMaterialId(), param.getStatus(), param.getShowName(), param.getRoleId(), param.getOrganizeIds(), param.getDepIds(), param.isForTrain(), param.getTrainId());
    }

    @PostMapping(value={"/getDepartmentTrainingReportByExport"})
    @ResponseBody
    public List<DepartmentTrainingReportVo> getDepartmentTrainingReportByExport(@RequestBody TrainingReportParam trainingReportParam) {
        return this.reportService.getDepartmentTrainingReportByExport(trainingReportParam);
    }

    @PostMapping(value={"/getUserReportByExport"})
    @ResponseBody
    public List<UserReportVo> getUserReportByExport(@RequestBody UserReportParam param) {
        return this.reportService.getUserReportByExport(param);
    }
}

