/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.material;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.Users;
import com.ovopark.training.param.material.MaterialTypeQueryParam;
import com.ovopark.training.service.TrainingMaterialService;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.subject.permission.model.MaterialTypeInfoPermissionVO;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.TrainingMaterialTypeVo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/training/material"})
@RestController
public class MaterialTypeController {
    private static final Logger log = LoggerFactory.getLogger(MaterialTypeController.class);
    @Autowired
    private MaterialTypeService materialTypeService;
    @Autowired
    private TrainingMaterialService materialService;

    @RequestMapping(value={"/insertMaterialType"})
    @ResponseBody
    public String insertMaterialType(TrainingMaterialType materialType) {
        return this.materialTypeService.insertMaterialType(materialType);
    }

    @RequestMapping(value={"/get-all-level-type"})
    public String getAllLevelType(@RequestBody MaterialTypeQueryParam queryParam) {
        Users user = ContextUtil.getUser();
        List<TrainingMaterialTypeVo> list = this.materialTypeService.selectAllMaterialTypeByPermissionType(queryParam, user, queryParam.getPermissionType());
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/selectAllLevelMaterialTypeByManage"})
    public String selectAllLevelMaterialTypeByManage(@RequestBody MaterialTypeQueryParam queryParam) {
        Users user = ContextUtil.getUser();
        int permissionType = 3;
        List<TrainingMaterialTypeVo> list = this.materialTypeService.selectAllMaterialTypeByPermissionType(queryParam, user, permissionType);
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/getAppTrainingMaterialType"})
    public String getAppTrainingMaterialType() {
        Users user = ContextUtil.getUser();
        MaterialTypeQueryParam param = new MaterialTypeQueryParam();
        param.setMaterialTypeName("");
        param.setModuleType(Integer.valueOf(1));
        int permissionType = 1;
        List<TrainingMaterialTypeVo> list = this.materialTypeService.selectAllMaterialTypeByPermissionType(param, user, permissionType);
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/getMaterialTypeByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialTypeByPage(Page<TrainingMaterialTypeVo> page, TrainingMaterialTypeVo materialType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (materialType.getModuleType().compareTo(6) != 0) {
            materialType.setEnterpriseId(user.getGroupId());
        }
        page = this.materialService.getMaterialTypeByPage(page, materialType, user);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/getMaterialType"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMaterialType(TrainingMaterialTypeVo materialType) {
        List<Object> materialTypeList = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (materialType.getModuleType().compareTo(6) != 0) {
                materialType.setEnterpriseId(user.getGroupId());
            }
            materialTypeList = this.materialService.getMaterialType(materialType, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(materialTypeList);
    }

    @PostMapping(value={"type/get-info-with-permission"})
    public Result<MaterialTypeInfoPermissionVO> getInfoWithPermission(@RequestParam Integer materialTypeId) {
        Users user = ContextUtil.getUser();
        return this.materialTypeService.getInfoWithPermission(materialTypeId, user);
    }

    @RequestMapping(value={"/downBatchMaterialType"})
    @ResponseBody
    public String downBatchMaterialType() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialTypeService.downBatchMaterialType(user.getGroupId());
    }

    @RequestMapping(value={"/validBatchMaterialType"})
    @ResponseBody
    public String validBatchMaterialType(@RequestParam(value="file") MultipartFile file) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialTypeService.validBatchMaterialType(user, file);
    }

    @RequestMapping(value={"/importBatchMaterialType"})
    @ResponseBody
    public String importBatchMaterialType(@RequestParam(value="file") MultipartFile file, @RequestParam(value="taskId") Integer taskId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialTypeService.importBatchMaterialType(user, file, taskId);
    }
}

