/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.resource;

import com.google.common.collect.Lists;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingResource;
import com.ovopark.training.model.Users;
import com.ovopark.training.param.resource.ResourceQueryParam;
import com.ovopark.training.service.resource.ResourceService;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.vo.TrainingResourceVo;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/resource"})
public class ResourceController {
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);
    @Autowired
    private ResourceService resourceService;

    @PostMapping(value={"/valid"})
    public Result<Integer> valid(@RequestParam Integer resourceId, @RequestParam int permissionType) {
        Integer valid = this.resourceService.valid(resourceId, ContextUtil.getUser(), permissionType);
        return ResultUtils.success((Object)valid);
    }

    @PostMapping(value={"/getResourceById"})
    public Result<TrainingResource> getResourceById(@RequestParam(required=false) Integer resourceId) {
        return this.resourceService.getResourceById(resourceId);
    }

    @PostMapping(value={"/getResourceByObjectId"})
    public Result<TrainingResource> getResourceByObjectId(@RequestParam(required=false) Integer objectId, Integer fileType) {
        return this.resourceService.getResourceByObject(objectId, fileType);
    }

    @PostMapping(value={"/getResourceStatus"})
    public Result<String> getResourceStatus(@RequestParam(required=false) Integer objectId, @RequestParam int permissionType, @RequestParam Integer types, @RequestParam Integer learnType) {
        if (objectId == null) {
            return ResultUtils.success((Object)"2");
        }
        String valid = this.resourceService.getResourceStatus(objectId, permissionType, types, ContextUtil.getUser(), learnType);
        return ResultUtils.success((Object)valid);
    }

    @RequestMapping(value={"/updateResource"})
    public String updateResource(@RequestBody TrainingResource trainingResource) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.resourceService.updateResource(trainingResource, user);
        return JsonResult.success();
    }

    @PostMapping(value={"/getResourceByPage"})
    public Result<Page<TrainingResourceVo>> getResourceByPage(@RequestBody @Valid ResourceQueryParam param) {
        Users user = ContextUtil.getUser();
        if (param.getOrderType() == null) {
            param.setOrderType(Integer.valueOf(2));
        }
        if (param.getOrderByColumn() == null) {
            param.setOrderByColumn(Integer.valueOf(1));
        }
        if (param.getIsShow() == null) {
            param.setIsShow(Integer.valueOf(1));
        }
        if (param.getFileType() != null) {
            ArrayList fileTypeList = Lists.newArrayList();
            fileTypeList.add(param.getFileType());
            param.setFileTypeList((List)fileTypeList);
        }
        param.setPermissionType(1);
        return this.resourceService.getResourceByPage(param, user);
    }

    @PostMapping(value={"/getResourceByPageForAdmin"})
    public Result<Page<TrainingResourceVo>> getResourceByPageForAdmin(@RequestBody ResourceQueryParam param) {
        Users user = ContextUtil.getUser();
        if (param.getOrderType() == null) {
            param.setOrderType(Integer.valueOf(2));
        }
        if (param.getOrderByColumn() == null) {
            param.setOrderByColumn(Integer.valueOf(4));
        }
        return this.resourceService.getResourceByPageForAdmin(param, user);
    }

    @PostMapping(value={"/move-resource-by-type"})
    @ResponseBody
    public Result<Void> moveResourceByType(@RequestParam int sourceTypeId, @RequestParam int targetTypeId) {
        Users user = ContextUtil.getUser();
        return this.resourceService.moveResourceByType(sourceTypeId, targetTypeId, user);
    }

    @PostMapping(value={"/updateResourceRecommend"})
    @ResponseBody
    public Result<Void> updateResourceRecommend(@RequestBody TrainingResourceVo trainingResourceVo) {
        Users user = ContextUtil.getUser();
        this.resourceService.updateResourceRecommend(trainingResourceVo, user);
        return ResultUtils.success();
    }

    @PostMapping(value={"/getFirstPageResourceByPage"})
    public Result<Page<TrainingResourceVo>> getFirstPageResourceByPage(@RequestBody ResourceQueryParam param) {
        Users user = ContextUtil.getUser();
        return this.resourceService.getFirstPageResourceByPage(param, user);
    }

    @PostMapping(value={"/getMyResourceByPage"})
    public Result<Page<TrainingResourceVo>> getMyResourceByPage(@RequestBody ResourceQueryParam param) {
        Users user = ContextUtil.getUser();
        return this.resourceService.getMyResourceByPage(param, user);
    }

    @PostMapping(value={"/getMyCollectResourceByPage"})
    public Result<Page<TrainingResourceVo>> getMyCollectResourceByPage(@RequestBody ResourceQueryParam param) {
        Users user = ContextUtil.getUser();
        return this.resourceService.getMyCollectResourceByPage(param, user);
    }

    @PostMapping(value={"/getMyHistoryResourceByPage"})
    public Result<Page<TrainingResourceVo>> getMyHistoryResourceByPage(@RequestBody ResourceQueryParam param) {
        Users user = ContextUtil.getUser();
        return this.resourceService.getMyHistoryResourceByPage(param, user);
    }
}

