/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.viewTime;

import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.viewTime.ViewTimeService;
import com.ovopark.training.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/training/viewTime"})
public class ViewTimeController {
    private static final Logger log = LoggerFactory.getLogger(ViewTimeController.class);
    @Autowired
    private ViewTimeService viewTimeService;

    @RequestMapping(value={"/syncLearnViewTime"})
    @ResponseBody
    public Result<Void> syncLearnViewTime(@RequestParam Integer projectId) {
        Users user = ContextUtil.getUser();
        this.viewTimeService.syncLearnViewTime(projectId, user);
        return ResultUtils.success();
    }

    @RequestMapping(value={"/syncCourseViewTime"})
    @ResponseBody
    public Result<Void> syncCourseViewTime(@RequestParam Integer projectId) {
        Users user = ContextUtil.getUser();
        this.viewTimeService.syncCourseViewTime(projectId, user);
        return ResultUtils.success();
    }

    @RequestMapping(value={"/syncJobViewTime"})
    @ResponseBody
    public Result<Void> syncJobViewTime(@RequestParam Integer projectId) {
        Users user = ContextUtil.getUser();
        this.viewTimeService.syncJobViewTime(projectId, user);
        return ResultUtils.success();
    }

    @RequestMapping(value={"/saveViewTimeFinishTime"})
    @ResponseBody
    public Result<Void> saveViewTimeFinishTime(@RequestParam Integer startId, @RequestParam Integer endId, @RequestParam Integer type) {
        this.viewTimeService.saveViewTimeFinishTime(startId, endId, type);
        return ResultUtils.success();
    }

    @RequestMapping(value={"/saveStudyStatus"})
    @ResponseBody
    public Result<Void> saveStudyStatus(@RequestParam Integer startId, @RequestParam Integer endId) {
        this.viewTimeService.saveStudyStatus(startId, endId);
        return ResultUtils.success();
    }
}

