/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingHomePageService;
import com.ovopark.training.util.DateUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/app/home"})
public class AppHomeController {
    private static final Logger log = LoggerFactory.getLogger(AppHomeController.class);
    @Autowired
    private TrainingHomePageService trainingHomePageService;

    @RequestMapping(value={"/getStudyInfo"})
    @ResponseBody
    public String getStudyInfo(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getStudyInfo(user.getGroupId(), user.getId(), startTime, endTime);
    }

    @RequestMapping(value={"/getProjectDataInfo"})
    @ResponseBody
    public String getProjectDataInfo(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getProjectDataInfo(user.getGroupId(), user.getId(), startTime, endTime);
    }

    @RequestMapping(value={"/getPlanDataInfo"})
    @ResponseBody
    public String getPlanDataInfo(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getPlanDataInfo(user.getGroupId(), user.getId(), startTime, endTime);
    }

    @RequestMapping(value={"/getTrainingDataInfo"})
    @ResponseBody
    public String getTrainingDataInfo(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getTrainingDataInfo(user.getGroupId(), user.getId(), startTime, endTime);
    }

    @RequestMapping(value={"/getOperateDataInfo"})
    @ResponseBody
    public String getOperateDataInfo(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getOperateDataInfo(user.getGroupId(), user.getId(), startTime, endTime);
    }

    @RequestMapping(value={"/getPaperDataInfo"})
    @ResponseBody
    public String getPaperDataInfo(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getPaperDataInfo(user.getGroupId(), user.getId(), startTime, endTime);
    }

    @RequestMapping(value={"/getTrainingRanking"})
    @ResponseBody
    public String getTrainingRanking(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getTrainingRanking(user.getGroupId(), user.getId(), startTime, endTime);
    }

    @RequestMapping(value={"/getMemberRanking"})
    @ResponseBody
    public String getMemberRanking(Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Date startTime = DateUtils.getStartTimeOfDay(new Date());
        Date endTime = DateUtils.getEndTimeOfDay(new Date());
        if (type != null) {
            if (type == 2) {
                LocalDate mondayDate = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                Date date = Date.from(mondayDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 3) {
                LocalDate firstDayOfMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
                Date date = Date.from(firstDayOfMonth.atStartOfDay(ZoneId.systemDefault()).toInstant());
                startTime = DateUtils.getStartTimeOfDay(date);
            } else if (type == 0) {
                startTime = DateUtils.addDay(startTime, -1);
                endTime = DateUtils.addDay(endTime, -1);
            }
        }
        return this.trainingHomePageService.getMemberRanking(user.getGroupId(), user.getId(), startTime, endTime);
    }
}

