/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingActivityService;
import com.ovopark.training.vo.TrainingActivityUserVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/app/activity"})
public class AppTrainingActivityController {
    private static final Logger log = LoggerFactory.getLogger(AppTrainingActivityController.class);
    @Autowired
    private TrainingActivityService trainingActivityService;

    @RequestMapping(value={"/getAttachById"})
    @ResponseBody
    public String getAttachById(Integer attachId) {
        if (attachId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingActivityService.getAttachById(attachId);
    }

    @RequestMapping(value={"/getActivityBanner"})
    @ResponseBody
    public String getActivityBanner() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getActivityBanner(user.getGroupId());
    }

    @RequestMapping(value={"/getActivityById"})
    @ResponseBody
    public String getActivityById(Integer activityId) {
        if (activityId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getActivityById(activityId, user.getId(), user.getGroupId());
    }

    @RequestMapping(value={"/getActivityList"})
    @ResponseBody
    public String getActivityList() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getActivityList(user.getGroupId());
    }

    @RequestMapping(value={"/getMyActivityList"})
    @ResponseBody
    public String getMyActivityList(Integer isSend) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getMyActivityList(user.getGroupId(), user.getId(), isSend);
    }

    @RequestMapping(value={"/getActivityRewards"})
    @ResponseBody
    public String getActivityRewards(Integer activityId) {
        if (activityId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getActivityRewards(activityId, user.getId());
    }

    @RequestMapping(value={"/applyActivity"})
    @ResponseBody
    public String applyActivity(Integer activityId) {
        if (activityId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.applyActivity(activityId, user.getId());
    }

    @RequestMapping(value={"/getActivityUserListByPage"})
    @ResponseBody
    public String getActivityUserListByPage(Page<TrainingActivityUserVo> page, Integer activityId) {
        if (activityId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingActivityService.getActivityUserListByPage(page, activityId);
    }
}

