/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingFeeDetailService;
import com.ovopark.training.vo.AppFeeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/app/fee"})
public class AppTrainingFeeController {
    @Autowired
    private TrainingFeeDetailService trainingFeeDetailService;

    @RequestMapping(value={"/getTypeFreeList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTypeFreeList() {
        return this.trainingFeeDetailService.getTypeFreeList();
    }

    @RequestMapping(value={"/getFreeByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getFreeByPage(Page<AppFeeVo> page, Integer materialTypeId) {
        return this.trainingFeeDetailService.getFreeByPage(page, materialTypeId);
    }

    @RequestMapping(value={"/getFeeDetailById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getFeeDetailById(Integer feeId) {
        if (feeId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingFeeDetailService.getFeeDetailById(user.getGroupId(), feeId);
    }

    @RequestMapping(value={"/getFeeChapterAttachUrl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getFeeChapterAttachUrl(Integer feeId, Integer feeChapterAttachId) {
        if (feeId == null || feeChapterAttachId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingFeeDetailService.getFeeChapterAttachUrl(feeId, user.getGroupId(), feeChapterAttachId);
    }
}

