/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.AppTrainingLearnProjectService;
import com.ovopark.training.vo.AppAttendMessageVo;
import com.ovopark.training.vo.AppAttendScanCodeVo;
import com.ovopark.training.vo.AppAttendTaskVo;
import com.ovopark.training.vo.AppAttendUserVo;
import com.ovopark.training.vo.AppAuditUserVo;
import com.ovopark.training.vo.AppTrainingProgressVo;
import com.ovopark.training.vo.AppTrainingProjectVo;
import com.ovopark.training.vo.AppTrainingShiftVo;
import com.ovopark.training.vo.AppTrainingTaskVo;
import com.ovopark.training.vo.TrainingAttendAuditDetailVo;
import com.ovopark.training.vo.TrainingAttendAuditSaveVo;
import com.ovopark.training.vo.TrainingTaskScheduleVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/app/learn"})
public class AppTrainingLearnProjectController {
    @Resource
    private AppTrainingLearnProjectService appTrainingLearnProjectService;

    @RequestMapping(value={"/selectMyProject"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectMyProjectByPage(Page<AppTrainingShiftVo> page, @RequestParam Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        page = this.appTrainingLearnProjectService.selectMyProjectByPage(page, user.getId(), status);
        return JsonResult.successMapNullValue(page);
    }

    @RequestMapping(value={"/getAppTrainingShift"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAppTrainingShift(@RequestParam Integer shiftId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            AppTrainingShiftVo shiftVo = this.appTrainingLearnProjectService.getAppTrainingShift(shiftId, user.getId());
            return JsonResult.successMapNullValue((Object)shiftVo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectTaskByShiftId"})
    @ResponseBody
    public String selectTaskByShiftId(Page<AppTrainingTaskVo> page, @RequestParam Integer shiftId, String versions) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            List<Object> list = new ArrayList();
            if (page.getPageNumber() == 1) {
                list = this.appTrainingLearnProjectService.selectTaskByShiftId(user.getId(), shiftId, versions);
            }
            HashMap map = new HashMap();
            map.put("content", list);
            return JsonResult.successMapNullValue(map);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getShowDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getShowDetail(@RequestParam Integer shiftId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Map<String, Object> reMap = this.appTrainingLearnProjectService.getShowDetail(user.getId(), shiftId);
            return JsonResult.successMapNullValue(reMap);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectProjectById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectProjectById(@RequestParam Integer projectId, @RequestParam Integer shiftId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            AppTrainingProjectVo projectVo = this.appTrainingLearnProjectService.selectProjectById(projectId, shiftId, user.getId());
            return JsonResult.successMapNullValue((Object)projectVo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/clickTask"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String clickTask(@RequestParam Integer shiftId, @RequestParam Integer taskId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            String str = this.appTrainingLearnProjectService.clickTask(shiftId, taskId, user.getId());
            return str;
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectAttendList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectAttendList(Page<AppAttendTaskVo> page, @RequestParam Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        page = this.appTrainingLearnProjectService.selectAttendList(page, user.getId(), status);
        return JsonResult.successMapNullValue(page);
    }

    @RequestMapping(value={"/selectRoleByScheduleId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectRoleByScheduleId(@RequestParam Integer scheduleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Map<String, Object> map = this.appTrainingLearnProjectService.selectRoleByScheduleId(scheduleId, user.getId());
            return JsonResult.successMapNullValue(map);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectAttendDetailByScheduleId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectAttendDetailByScheduleId(@RequestParam Integer scheduleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            TrainingTaskScheduleVo scheduleVo = this.appTrainingLearnProjectService.selectAttendDetailByScheduleId(scheduleId);
            return JsonResult.successMapNullValue((Object)scheduleVo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getManagerScanCode"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getManagerScanCode(@RequestParam Integer scheduleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            AppAttendScanCodeVo attendScanCodeVo = this.appTrainingLearnProjectService.getManagerScanCode(scheduleId);
            return JsonResult.successMapNullValue((Object)attendScanCodeVo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getAttendUserList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttendUserList(Page<AppAttendUserVo> page, @RequestParam Integer scheduleId, @RequestParam Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            page = this.appTrainingLearnProjectService.getAttendUserList(page, scheduleId, type);
            return JsonResult.successMapNullValue(page);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getAttendUserNum"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttendUserNum(@RequestParam Integer scheduleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Map<String, Object> map = this.appTrainingLearnProjectService.getAttendUserNum(scheduleId);
            return JsonResult.successMapNullValue(map);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/scanCode"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String scanCode(@RequestParam String codeStr) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        this.appTrainingLearnProjectService.scanCode(codeStr, user.getId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/leaveSign"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String leaveSign(@RequestParam String codeStr) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        this.appTrainingLearnProjectService.leaveSign(codeStr, user.getId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/getMyAttendRecord"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getMyAttendRecord(@RequestParam Integer scheduleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            AppAttendScanCodeVo record = this.appTrainingLearnProjectService.getMyAttendRecord(scheduleId, user.getId());
            return JsonResult.successMapNullValue((Object)record);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/preAttend"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttendMessage(@RequestParam Integer scheduleId, @RequestParam Integer attendType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            AppAttendMessageVo record = this.appTrainingLearnProjectService.getAttendMessage(scheduleId, user.getId(), attendType);
            if (!StringUtils.isEmpty((Object)record.getErrorStr())) {
                return JsonResult.error((String)record.getErrorStr(), null);
            }
            return JsonResult.successMapNullValue((Object)record);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getAuditList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAuditList(Page<AppAuditUserVo> page, @RequestParam Integer scheduleId, @RequestParam Integer type) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            page = this.appTrainingLearnProjectService.getAuditList(page, scheduleId, type);
            return JsonResult.successMapNullValue(page);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getAuditNum"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAuditNum(@RequestParam Integer scheduleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            Map<String, Object> map = this.appTrainingLearnProjectService.getAuditNum(scheduleId);
            return JsonResult.successMapNullValue(map);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getAuditDetail"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAuditDetail(@RequestParam Integer scheduleId, @RequestParam Integer userId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            TrainingAttendAuditDetailVo vo = this.appTrainingLearnProjectService.getAuditDetail(scheduleId, userId);
            return JsonResult.successMapNullValue((Object)vo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/saveAudit"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveAudit(@RequestBody TrainingAttendAuditSaveVo saveVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            this.appTrainingLearnProjectService.saveAudit(saveVo, user.getId());
            return JsonResult.success();
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getAuditResult"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAuditResult(@RequestParam Integer scheduleId, @RequestParam(required=false) Integer userId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            TrainingAttendAuditSaveVo vo;
            if (Objects.isNull(userId)) {
                userId = user.getId();
            }
            if (!StringUtils.isEmpty((Object)(vo = this.appTrainingLearnProjectService.getAuditResult(scheduleId, userId)).getErrorStr())) {
                return JsonResult.error((String)vo.getErrorStr(), null);
            }
            return JsonResult.successMapNullValue((Object)vo);
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/getTrainingProgressList"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingProgressList() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            List<AppTrainingProgressVo> list = this.appTrainingLearnProjectService.getTrainingProgressList(user.getId());
            return JsonResult.successMapNullValue(list);
        }
        return "INVALID_TOKEN";
    }
}

