/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingActivityService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.TrainingActivityUserVo;
import com.ovopark.training.vo.TrainingActivityVo;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/activity"})
public class TrainingActivityController {
    private static final Logger log = LoggerFactory.getLogger(TrainingActivityController.class);
    @Autowired
    private TrainingActivityService trainingActivityService;

    @RequestMapping(value={"/addOrUpdateActivity"})
    @ResponseBody
    public String addOrUpdateActivity(@RequestBody TrainingActivityVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (vo.getId() == null) {
            vo.setCreateTime(new Date());
            vo.setCreator(user.getId());
        }
        if (vo.getActivityStatus() == null) {
            vo.setActivityStatus(Integer.valueOf(2));
        }
        vo.setEnterpriseId(user.getGroupId());
        return this.trainingActivityService.addOrUpdateActivity(vo);
    }

    @RequestMapping(value={"/recommendActivityById"})
    @ResponseBody
    public String recommendActivityById(Integer activityId) {
        if (activityId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingActivityService.recommendActivityById(activityId);
    }

    @RequestMapping(value={"/deleteActivityById"})
    @ResponseBody
    public String deleteActivityById(HttpServletRequest req, String activityIds) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (StringUtils.isEmpty((Object)activityIds)) {
            return "INVALID_PARAMETER";
        }
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("activity_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.activity_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingActivityService.deleteActivityById(activityIds, pojo);
    }

    @RequestMapping(value={"/getActivityById"})
    @ResponseBody
    public String getActivityById(Integer activityId) {
        if (activityId == null) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getActivityById(activityId, user.getId(), user.getGroupId());
    }

    @RequestMapping(value={"/getActivityByPage"})
    @ResponseBody
    public String getActivityByPage(Page<TrainingActivityVo> page, String activityName, Integer activityStatus, String activityStartTime, String activityEndTime) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getActivityByPage(user.getGroupId(), page, activityName, activityStatus, activityStartTime, activityEndTime);
    }

    @RequestMapping(value={"/getUserListByPage"})
    @ResponseBody
    public String getUserListByPage(Page<TrainingActivityUserVo> page, String userName, Integer activityId, Integer applyMode) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingActivityService.getUserListByPage(user, page, userName, activityId, applyMode);
    }

    @RequestMapping(value={"/downUserAnalysis"})
    @ResponseBody
    public String downUserAnalysis(String userName, Integer activityId, Integer applyMode, HttpServletResponse resp) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingActivityService.downUserAnalysis(resp, user, userName, activityId, applyMode);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteActivityUserById"})
    @ResponseBody
    public String deleteActivityUserById(Integer activityUserId) {
        if (activityUserId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingActivityService.deleteActivityUserById(activityUserId);
    }

    @RequestMapping(value={"/addActivityUser"})
    @ResponseBody
    public String addActivityUser(Integer activityId, String userIds) {
        if (activityId == null || StringUtils.isEmpty((Object)userIds)) {
            return "INVALID_PARAMETER";
        }
        return this.trainingActivityService.addActivityUser(activityId, userIds);
    }

    @RequestMapping(value={"/manualSend"})
    @ResponseBody
    public String manualSend(Integer activityId, String trainingIds) {
        if (activityId == null || StringUtils.isEmpty((Object)trainingIds)) {
            return "INVALID_PARAMETER";
        }
        return this.trainingActivityService.manualSend(activityId, trainingIds);
    }

    @RequestMapping(value={"/getActivityRewards"})
    @ResponseBody
    public String getActivityRewards(Integer activityId) {
        if (activityId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingActivityService.getActivityRewards(activityId, null);
    }

    @RequestMapping(value={"/activityFinish"})
    @ResponseBody
    public String activityFinish() {
        return this.trainingActivityService.activityFinish();
    }

    @RequestMapping(value={"/activityApply"})
    @ResponseBody
    public String activityApply() {
        return this.trainingActivityService.activityApply();
    }

    @RequestMapping(value={"/activityApplyFinish"})
    @ResponseBody
    public String activityApplyFinish() {
        return this.trainingActivityService.activityApplyFinish();
    }
}

