/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.SysParams;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.TrainingConfig;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.CommonRemoteService;
import com.ovopark.training.service.SysParamsRemoteService;
import com.ovopark.training.service.TrainingCommonService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.service.UserServiceNew;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.vo.TrainingAddVo;
import com.ovopark.training.vo.TrainingAttachVo;
import com.ovopark.training.vo.TrainingChapterVo;
import com.ovopark.training.vo.TrainingVo;
import com.ovopark.training.vo.TrainingsVo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/config"})
public class TrainingConfigController {
    private static final Logger log = LoggerFactory.getLogger(TrainingConfigController.class);
    @Autowired
    private CommonRemoteService commonRemoteService;
    @Autowired
    private TrainingRemoteService trainingRemoteService;
    @Autowired
    private SysParamsRemoteService sysParamsRemoteService;
    @Autowired
    private TrainingPaperRemoteService trainingPaperRemoteService;
    @Autowired
    private UserServiceNew userServiceNew;
    @Autowired
    private TrainingCommonService trainingCommonService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/getTrainingConfig"})
    @ResponseBody
    public String getTrainingConfig() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingCommonService.getTrainingConfig(user));
    }

    @RequestMapping(value={"/updateTrainingConfig"})
    @ResponseBody
    public String updateTrainingConfig(@RequestBody TrainingConfig trainingConfig) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingCommonService.updateTrainingConfig(user, trainingConfig);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingById"})
    @ResponseBody
    public String getTrainingById(Integer id) {
        if (id == null) {
            return JsonResult.paramError();
        }
        TrainingAddVo training = this.trainingRemoteService.getTraining(id);
        if (training != null && !StringUtils.isEmpty((Object)training.getPath())) {
            String path = training.getPath();
            training.setPath(this.makePicUrl(path));
        }
        return JsonResult.success((Object)training);
    }

    @RequestMapping(value={"/getAttachByTrainingId"})
    @ResponseBody
    public String getAttachByTrainingId(Integer trainingId) {
        if (trainingId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingAttachVo training = this.trainingRemoteService.getAttachByTrainingId(trainingId, user.getId());
        if (training != null && !StringUtils.isEmpty((Object)training.getPath())) {
            String path = training.getPath();
            training.setPath(this.makePicUrl(path));
        }
        return JsonResult.success((Object)training);
    }

    @RequestMapping(value={"/updateTrainingStatusById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateTrainingStatusById(Integer id) {
        if (id == null) {
            return JsonResult.paramError();
        }
        Training training = this.trainingRemoteService.getTrainingById(id);
        training.setStatus(Integer.valueOf(2));
        this.trainingRemoteService.updateTraining(training);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteTrainingByIds"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingByIds(String ids) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) && StringUtils.isEmpty((Object)ids)) {
            return JsonResult.paramError();
        }
        this.trainingRemoteService.deleteTrainingByIds(ids, user.getGroupId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteTrainingById"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingById(String id) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) && StringUtils.isEmpty((Object)id)) {
            return JsonResult.paramError();
        }
        this.trainingRemoteService.deleteTrainingByIds(id, user.getGroupId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/getWebTrainingByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebTrainingByPage(Page<TrainingVo> page, Integer enterpriseId, String trainingName, Integer navId, Integer isRoom) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getWebTrainingByPage(page, enterpriseId, trainingName, navId, isRoom));
    }

    @RequestMapping(value={"/selectWebTrainingByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectWebTrainingByPage(Page<TrainingsVo> page, String trainingName, Integer trainingLabelId, Integer projectShow) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingRemoteService.selectWebTrainingByPage(page, user.getGroupId(), trainingName, trainingLabelId, projectShow));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateCollect"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateCollect(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        this.trainingRemoteService.updateCollect(user.getId(), trainingId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/getCollect"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getCollect(Page<TrainingsVo> page) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.trainingRemoteService.getCollect(page, user);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/getTrainingCollectState"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingCollectState(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        return JsonResult.success((Object)this.trainingRemoteService.getTrainingCollectState(user.getId(), trainingId));
    }

    @RequestMapping(value={"/getRecommend"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getRecommend() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        return JsonResult.success(this.trainingRemoteService.getRecommend(user.getGroupId()));
    }

    @RequestMapping(value={"/updateRecommend"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateRecommend(Integer trainingId) {
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        int i = this.trainingRemoteService.updateRecommend(trainingId, user.getGroupId());
        if (i == 1) {
            String recommendLimit = this.messageSource.getMessage("training.course.recommend.limit", null, locale);
            return JSONObject.toJSONString((Object)JsonResult.newInstance((String)"RECOMMEND_EXISTING", (Object)recommendLimit, (Boolean)true));
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateRecommends"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateRecommends(String ids) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        this.trainingRemoteService.updateRecommends(ids, user.getGroupId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/getVideoTotalTime"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getVideoTotalTime() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        return JsonResult.success((Object)this.trainingPaperRemoteService.getVideoTotalTime(user.getId(), user.getGroupId()));
    }

    @RequestMapping(value={"/getTrainingByNavId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingByNavId(Page<TrainingVo> page, Integer navId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        return JsonResult.success(this.trainingRemoteService.selectByNavIdByPage(page, navId, user.getGroupId(), user.getId()));
    }

    @RequestMapping(value={"/getHistoryByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getHistoryByPage(Page<TrainingVo> page) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        Page<TrainingVo> trainingVos = this.trainingRemoteService.getHistoryByPage(page, user);
        List list = trainingVos.getContent();
        for (TrainingVo trainingVo : list) {
            if (StringUtils.isEmpty((Object)trainingVo.getPath()) || trainingVo.getPath().length() <= 4) continue;
            String path = trainingVo.getPath();
            if (trainingVo.getPath().substring(0, 4).equals("http")) continue;
            trainingVo.setPath(this.makePicUrl(path));
        }
        trainingVos.setContent(list);
        return JsonResult.success(trainingVos);
    }

    @RequestMapping(value={"/updateHistory"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateHistory(Integer trainingId, Integer trainingFeeId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        this.trainingRemoteService.updateHistory(user.getId(), trainingId, trainingFeeId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateProgressIsPaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateProgressIsPaper(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        this.trainingRemoteService.updateProgressIsPaper(trainingId, user.getId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTotalVideoTime"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTotalVideoTime(Integer trainingId) {
        return JsonResult.success((Object)this.trainingPaperRemoteService.getTotalVideoTime(trainingId));
    }

    @RequestMapping(value={"/getTrainingByLabelIdByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingByLabelIdByPage(Page<TrainingsVo> page, Integer labelId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        return JsonResult.success(this.trainingRemoteService.getTrainingByLabelIdByPage(page, labelId, user.getId()));
    }

    @RequestMapping(value={"/updateTrainingUserLook"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateTrainingUserLook(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        this.trainingRemoteService.updateTrainingUserLook(trainingId, user.getId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingChapter"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingChapter(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        return JsonResult.success(this.trainingRemoteService.getTrainingChapterVo(trainingId, user.getId()));
    }

    @RequestMapping(value={"/getUserMessageByTrainingPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserMessageByTrainingPage(String category) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        if (StringUtils.isEmpty((Object)category)) {
            category = "TYPE_TRAINING";
        }
        return JsonResult.success(this.trainingRemoteService.getUserMessageByTrainingPage(user.getId(), category));
    }

    @RequestMapping(value={"/updateUserTrainingChapter"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateUserTrainingChapter(Integer trainingId, Integer chapterId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        this.trainingRemoteService.updateTrainingChapter(user.getId(), trainingId, chapterId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateTrainingProgress"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateTrainingProgress(Integer trainingId, Integer chapterId, Integer attachId, Integer isVideo, Integer playSize) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        this.trainingRemoteService.updateTrainingProgress(trainingId, chapterId, attachId, isVideo, user, playSize);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateOldTrainingProgress"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateOldTrainingProgress(Integer trainingId, Integer attachId, Integer isVideo, Integer playSize) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return JsonResult.paramError();
        }
        this.trainingRemoteService.updateOldTrainingProgress(trainingId, attachId, isVideo, user, playSize);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateUserChapterPaper"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateUserChapterPaper(Integer trainingId, Integer paperId, Double score) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return JsonResult.paramError();
        }
        this.trainingRemoteService.updateUserChapterPaper(user.getId(), trainingId, paperId, score);
        return JsonResult.success();
    }

    public String makePicUrl(String srcPath) {
        if (!srcPath.startsWith("http")) {
            SysParams sysParams = this.sysParamsRemoteService.getSysParams();
            String filePath = srcPath.replace("/extend/shopweb/snapshot", "/snapshot");
            return "http://" + sysParams.getFileServerAddress() + ":" + sysParams.getFileServerPort() + filePath;
        }
        return srcPath;
    }

    @RequestMapping(value={"/saveTrainingVideoLook"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingVideoLook(Integer trainingId, Integer videoId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return JsonResult.paramError();
        }
        this.trainingRemoteService.saveTrainingVideoLook(videoId, user.getId(), trainingId, user.getGroupId());
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingUserLook"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingUserLook(Integer enterpriseId, String trainingIdsStr) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getTrainingUserLook(enterpriseId, trainingIdsStr));
    }

    @RequestMapping(value={"/getTrainingUserLookDetails"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingUserLookDetails(Integer pageSize, Integer videoId, Integer pageNumber, Integer type, Integer enterpriseId, String trainingIdsStr) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return JsonResult.paramError();
        }
        if (user.getGroupId() != null) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getTrainingUserLookDetails(pageSize, pageNumber, videoId, type, enterpriseId));
    }

    @RequestMapping(value={"/getVideoIsLookExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getVideoIsLookExcel(HttpServletResponse response, Integer enterpriseId, String trainingIdsStr, String videoIds) {
        try {
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null) {
                return JsonResult.paramError();
            }
            if (user != null && user.getGroupId() != null) {
                enterpriseId = user.getGroupId();
            }
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("videoIsLook");
            HSSFRow row = sheet.createRow(0);
            if (!StringUtils.isEmpty((Object)trainingIdsStr)) {
                List<TrainingVo> trainingUserLook;
                List<Object> vIds = new ArrayList();
                if (!StringUtils.isEmpty((Object)videoIds)) {
                    vIds = StringsUtils.StringToList(videoIds, ",");
                }
                if (!CollectionUtils.isEmpty(trainingUserLook = this.trainingRemoteService.getTrainingUserLook(enterpriseId, trainingIdsStr))) {
                    int count = 0;
                    int trainingVideoCount = 0;
                    for (int i = 0; i < trainingUserLook.size(); ++i) {
                        HSSFCell createCell;
                        HSSFRow createRow;
                        HSSFCell createCell2;
                        HSSFRow rowc;
                        int c;
                        if ((CollectionUtils.isEmpty(vIds) || !vIds.contains(trainingUserLook.get(i).getId())) && !CollectionUtils.isEmpty(vIds)) continue;
                        HSSFCell cell = row.createCell(trainingVideoCount + count);
                        cell.setCellValue(trainingUserLook.get(i).getFileName());
                        HSSFCell cell1 = row.createCell(trainingVideoCount + 1 + count);
                        String viewNumber = this.messageSource.getMessage("training.course.view.number", null, locale);
                        cell1.setCellValue(viewNumber + "\uff1a" + trainingUserLook.get(i).getLookNumber());
                        HSSFCell cell2 = row.createCell(trainingVideoCount + 2 + count);
                        String unviewNumber = this.messageSource.getMessage("training.course.unview.number", null, locale);
                        cell2.setCellValue(unviewNumber + "\uff1a" + trainingUserLook.get(i).getNoLookNumber());
                        List<Users> noLookDetails = this.trainingRemoteService.getTrainingUserLookDetails(9999, 1, trainingUserLook.get(i).getId(), 0, enterpriseId);
                        List<Users> isLookDetails = this.trainingRemoteService.getTrainingUserLookDetails(9999, 1, trainingUserLook.get(i).getId(), 1, enterpriseId);
                        if (!CollectionUtils.isEmpty(isLookDetails)) {
                            c = 1;
                            for (Users users : isLookDetails) {
                                rowc = sheet.getRow(c);
                                if (rowc != null) {
                                    createCell2 = rowc.createCell(trainingVideoCount + 1 + count);
                                    createCell2.setCellValue(users.getShowName());
                                } else {
                                    createRow = sheet.createRow(c);
                                    createCell = createRow.createCell(trainingVideoCount + 1 + count);
                                    createCell.setCellValue(users.getShowName());
                                }
                                ++c;
                            }
                        }
                        if (!CollectionUtils.isEmpty(noLookDetails)) {
                            c = 1;
                            for (Users users : noLookDetails) {
                                rowc = sheet.getRow(c);
                                if (rowc != null) {
                                    createCell2 = rowc.createCell(trainingVideoCount + 2 + count);
                                    createCell2.setCellValue(users.getShowName());
                                } else {
                                    createRow = sheet.createRow(c);
                                    createCell = createRow.createCell(trainingVideoCount + 2 + count);
                                    createCell.setCellValue(users.getShowName());
                                }
                                ++c;
                            }
                        }
                        trainingVideoCount = trainingVideoCount + 2 + ++count;
                    }
                }
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getWebTrainingProgressByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebTrainingProgressByPage(Page<TrainingVo> page, Integer enterpriseId, String trainingName, Integer navId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getWebTrainingProgressByPage(page, enterpriseId, trainingName, navId));
    }

    @RequestMapping(value={"/getAttachProgress"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttachProgress(Integer trainingId, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getAttachProgressByPage(trainingId, enterpriseId));
    }

    @RequestMapping(value={"/getUserProgress"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getUserProgress(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingPaperRemoteService.getUserProgressNew(user.getId(), trainingId));
    }

    @RequestMapping(value={"/selectRateByTree"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectRateByTree(Integer organizeId, Integer trainingId, String userName, Integer roleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        List list = this.trainingRemoteService.selectRateByTree(user, organizeId, trainingId, userName, roleId);
        return JsonResult.success((Object)list);
    }

    @RequestMapping(value={"/getTrainingProgressRateByTreeNew"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingProgressRateByTreeNew(String organizeIds, Integer trainingId, String userName, Integer roleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingRemoteService.getTrainingProgressRateByTreeNew(organizeIds, trainingId, user, userName, roleId));
    }

    @RequestMapping(value={"/getTrainingProgressByTreeNew"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingProgressByTreeNew(Page<TrainingVo> page, String organizeIds, Integer trainingId, String userName, Integer roleId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingRemoteService.getTrainingProgressByTreeNew(page, organizeIds, trainingId, user, userName, roleId));
    }

    @RequestMapping(value={"/getTrainingProgressByTree"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingProgressByTree(Page<TrainingVo> page, String organizeIds, Integer trainingId, String userName, Integer enterpriseId, Integer taskId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getTrainingProgressByTree(page, organizeIds, trainingId, user, userName, enterpriseId, taskId));
    }

    @RequestMapping(value={"/getTrainingProgressByTreeExcelNew"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingProgressByTreeExcelNew(HttpServletResponse response, String organizeIds, Integer trainingId, String userName, String trainingName, String organizeName, Integer roleId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            Page page = new Page();
            page.setPageSize(9999);
            Page<TrainingVo> pageTrainingVo = this.trainingRemoteService.getTrainingProgressByTreeNew((Page<TrainingVo>)page, organizeIds, trainingId, user, userName, roleId);
            List trainingAttachVos = pageTrainingVo.getContent();
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            HSSFWorkbook workbook = new HSSFWorkbook();
            String condition = this.messageSource.getMessage("training.course.view.condition", null, locale);
            HSSFSheet excelSheet = workbook.createSheet(condition);
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            String title = trainingName + "\u2014\u2014" + organizeName;
            String showName = this.messageSource.getMessage("training.user.details.name", null, locale);
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String shopName = this.messageSource.getMessage("training.course.analysis.department", null, locale);
            String status = "\u5b8c\u6210\u72b6\u6001";
            String finishTime = this.messageSource.getMessage("training.course.analysis.endtime", null, locale);
            String depName = this.messageSource.getMessage("training.course.analysis.superior", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            String[] titles = new String[]{showName, employeeNumber, shopName, status, finishTime, depName};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            titleSty.setAlignment(HorizontalAlignment.CENTER);
            titleSty.setWrapText(true);
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 5);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1000);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            for (int i = 0; i < trainingAttachVos.size(); ++i) {
                TrainingVo vo = (TrainingVo)trainingAttachVos.get(i);
                HSSFRow row1 = excelSheet.createRow(i + 2);
                row1.createCell(0).setCellValue(vo.getUserName());
                row1.createCell(1).setCellValue(vo.getEmployeeNumber());
                row1.createCell(2).setCellValue(vo.getOrganizeName() == null ? "" : vo.getOrganizeName());
                String unfinish = this.messageSource.getMessage("training.course.unfinish", null, locale);
                row1.createCell(3).setCellValue(vo.getStatus() == 0 ? unfinish : completed);
                row1.createCell(4).setCellValue(DateUtils.format(vo.getUpdateTime()));
                row1.createCell(5).setCellValue(vo.getLeaderName() == null ? "" : vo.getLeaderName());
                row1.setHeight((short)400);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingProgressByTreeExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingProgressByTreeExcel(HttpServletResponse response, String organizeIds, Integer trainingId, String userName, Integer enterpriseId, String trainingName, String organizeName, Integer taskId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
                enterpriseId = user.getGroupId();
            }
            Page page = new Page();
            page.setPageSize(9999);
            Page<TrainingVo> pageTrainingVo = this.trainingRemoteService.getTrainingProgressByTree((Page<TrainingVo>)page, organizeIds, trainingId, user, userName, enterpriseId, taskId);
            List trainingAttachVos = pageTrainingVo.getContent();
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            HSSFWorkbook workbook = new HSSFWorkbook();
            String condition = this.messageSource.getMessage("training.course.view.condition", null, locale);
            HSSFSheet excelSheet = workbook.createSheet(condition);
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            String title = trainingName + "\u2014\u2014" + organizeName + "\u2014\u2014" + ((TrainingVo)trainingAttachVos.get(0)).getFinishPercentage();
            String showName = this.messageSource.getMessage("training.user.details.name", null, locale);
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String status = "\u5b8c\u6210\u72b6\u6001";
            String finishTime = this.messageSource.getMessage("training.course.analysis.endtime", null, locale);
            String depName = this.messageSource.getMessage("training.course.organize", null, locale);
            String shopName = this.messageSource.getMessage("training.course.analysis.dep", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            String[] titles = new String[]{showName, employeeNumber, status, finishTime, depName, shopName};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            titleSty.setAlignment(HorizontalAlignment.CENTER);
            titleSty.setWrapText(true);
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 5);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1000);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            for (int i = 0; i < trainingAttachVos.size(); ++i) {
                TrainingVo vo = (TrainingVo)trainingAttachVos.get(i);
                HSSFRow row1 = excelSheet.createRow(i + 2);
                row1.createCell(0).setCellValue(vo.getUserName());
                row1.createCell(1).setCellValue(vo.getEmployeeNumber());
                String unfinish = this.messageSource.getMessage("training.course.unfinish", null, locale);
                row1.createCell(2).setCellValue(vo.getStatus() == 0 ? unfinish : completed);
                row1.createCell(3).setCellValue(DateUtils.format(vo.getUpdateTime()));
                row1.createCell(4).setCellValue(vo.getOrganizeName() == null ? "" : vo.getOrganizeName());
                row1.createCell(5).setCellValue(vo.getShopName() == null ? "" : vo.getShopName());
                row1.setHeight((short)400);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getAttachProgressByTree"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttachProgressByTree(Page<TrainingAttachVo> page, String organizeIds, Integer trainingId, String userName, Integer enterpriseId, Integer attachId, Integer isVideo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getAttachProgressByTree(page, organizeIds, trainingId, user, userName, enterpriseId, attachId, isVideo));
    }

    @RequestMapping(value={"/getAttachProgressByTreeExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttachProgressByTreeExcel(HttpServletResponse response, String organizeIds, Integer trainingId, String userName, Integer enterpriseId, Integer attachId, Integer isVideo, String trainingName, String organizeName) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
                enterpriseId = user.getGroupId();
            }
            Page page = new Page();
            page.setPageSize(9999);
            Page<TrainingAttachVo> pageTrainingVo = this.trainingRemoteService.getAttachProgressByTree((Page<TrainingAttachVo>)page, organizeIds, trainingId, user, userName, enterpriseId, attachId, isVideo);
            List trainingAttachVos = pageTrainingVo.getContent();
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            HSSFWorkbook workbook = new HSSFWorkbook();
            String condition = this.messageSource.getMessage("training.course.view.condition", null, locale);
            HSSFSheet excelSheet = workbook.createSheet(condition);
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            String title = trainingName + "\u2014\u2014" + organizeName + "\u2014\u2014" + ((TrainingAttachVo)trainingAttachVos.get(0)).getFinishPercentage();
            String showName = this.messageSource.getMessage("training.user.details.name", null, locale);
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String userOrganizeName = this.messageSource.getMessage("training.course.organize", null, locale);
            String shopName = this.messageSource.getMessage("training.course.analysis.dep", null, locale);
            String status = "\u5b8c\u6210\u72b6\u6001";
            String finishTime = this.messageSource.getMessage("training.course.analysis.endtime", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            String[] titles = new String[]{showName, employeeNumber, userOrganizeName, shopName, status, finishTime};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 5);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1000);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            for (int i = 0; i < trainingAttachVos.size(); ++i) {
                TrainingAttachVo vo = (TrainingAttachVo)trainingAttachVos.get(i);
                HSSFRow row1 = excelSheet.createRow(i + 2);
                row1.createCell(0).setCellValue(vo.getUserName());
                row1.createCell(1).setCellValue(vo.getEmployeeNumber());
                row1.createCell(2).setCellValue(vo.getOrganizeName());
                row1.createCell(3).setCellValue(vo.getShopName());
                String unfinish = this.messageSource.getMessage("training.course.unfinish", null, locale);
                row1.createCell(4).setCellValue(vo.getStatus() == 0 ? unfinish : completed);
                row1.createCell(5).setCellValue(DateUtils.format(vo.getUpdateTime()));
                row1.setHeight((short)400);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingVosByUserId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingVosByUserId(Page<TrainingVo> page, Integer userId, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getTrainingVosByUserId(page, userId, enterpriseId));
    }

    @RequestMapping(value={"/getTrainingVosByUserIdExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingVosByUserIdExcel(HttpServletResponse response, Integer userId, Integer enterpriseId) {
        try {
            String schedule;
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
                enterpriseId = user.getGroupId();
            }
            Page page = new Page();
            page.setPageSize(9999);
            Page<TrainingVo> pageTrainingVo = this.trainingRemoteService.getTrainingVosByUserId((Page<TrainingVo>)page, userId, enterpriseId);
            List paperVos = pageTrainingVo.getContent();
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet excelSheet = workbook.createSheet(this.messageSource.getMessage("training.view.condition", null, locale));
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            Users users = this.userServiceNew.getById(userId);
            String studyStatus = this.messageSource.getMessage("training.course.study.status", null, locale);
            String title = users.getShowName() + "\u2014\u2014" + studyStatus;
            String showName = this.messageSource.getMessage("training.course.name", null, locale);
            String updateTime = this.messageSource.getMessage("training.course.update.time", null, locale);
            String finishPercentage = schedule = this.messageSource.getMessage("training.task.complete.schedule", null, locale);
            String[] titles = new String[]{showName, updateTime, finishPercentage};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 2);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1000);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            for (int i = 0; i < paperVos.size(); ++i) {
                TrainingVo vo = (TrainingVo)paperVos.get(i);
                HSSFRow row1 = excelSheet.createRow(i + 2);
                row1.createCell(0).setCellValue(vo.getTitle());
                row1.createCell(1).setCellValue(DateUtils.format(vo.getUpdateTime()));
                row1.createCell(2).setCellValue(vo.getPercentage());
                row1.setHeight((short)400);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingUsers"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingUsers(Page<TrainingVo> page, String organizeIds, String userName) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingRemoteService.getTrainingUsers(page, organizeIds, user, userName));
    }

    @RequestMapping(value={"/getTrainingUsersExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingUsersExcel(HttpServletResponse response, String organizeIds, String organizeNames, String userName) {
        try {
            String finish;
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            Users user = Authenticator.getInstance().getCurrentUser();
            Page page = new Page();
            page.setPageSize(9999);
            Page<TrainingVo> pageTrainingVo = this.trainingRemoteService.getTrainingUsers((Page<TrainingVo>)page, organizeIds, user, userName);
            List paperVos = pageTrainingVo.getContent();
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet excelSheet = workbook.createSheet(this.messageSource.getMessage("training.view.condition", null, locale));
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            String title = finish = this.messageSource.getMessage("training.course.finish", null, locale);
            String showName = this.messageSource.getMessage("training.user.details.name", null, locale);
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String allNum = this.messageSource.getMessage("training.course.need.finish.number", null, locale);
            String finishNum = this.messageSource.getMessage("training.course.finish.number", null, locale);
            String finishPercentage = "\u5b8c\u6210\u7387";
            String[] titles = new String[]{showName, employeeNumber, allNum, finishNum, finishPercentage};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 4);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1000);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            for (int i = 0; i < paperVos.size(); ++i) {
                TrainingVo vo = (TrainingVo)paperVos.get(i);
                HSSFRow row1 = excelSheet.createRow(i + 2);
                row1.createCell(0).setCellValue(vo.getUserName());
                row1.createCell(1).setCellValue(vo.getEmployeeNumber());
                row1.createCell(2).setCellValue((double)vo.getAllNumber().intValue());
                row1.createCell(3).setCellValue((double)vo.getFinishNumber().intValue());
                row1.createCell(4).setCellValue(vo.getFinishPercentage());
                row1.setHeight((short)400);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            e.printStackTrace();
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getAttachVosByUserId"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttachVosByUserId(Integer trainingId, Integer userId, Integer enterpriseId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
            enterpriseId = user.getGroupId();
        }
        return JsonResult.success(this.trainingRemoteService.getAttachVosByUserId(trainingId, userId, enterpriseId));
    }

    @RequestMapping(value={"/getWebTrainingProgressByPageExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getWebTrainingProgressByPageExcel(HttpServletResponse response, Integer enterpriseId, String trainingName, Integer navId) {
        try {
            String needNumber;
            String lastUpdateTime;
            String courseName;
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            Users user = Authenticator.getInstance().getCurrentUser();
            Page page = new Page();
            page.setPageSize(9999);
            if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
                enterpriseId = user.getGroupId();
            }
            Page<TrainingVo> pageTrainingVo = this.trainingRemoteService.getWebTrainingProgressByPage((Page<TrainingVo>)page, enterpriseId, trainingName, navId);
            List paperVos = pageTrainingVo.getContent();
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet excelSheet = workbook.createSheet(this.messageSource.getMessage("training.view.condition", null, locale));
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            String title = this.messageSource.getMessage("training.course.total.finish.rate", null, locale);
            String name = courseName = this.messageSource.getMessage("training.course.name", null, locale);
            String updateTime = lastUpdateTime = this.messageSource.getMessage("training.course.last.update.time", null, locale);
            String allNum = needNumber = this.messageSource.getMessage("training.course.need.view.number", null, locale);
            String finishNum = this.messageSource.getMessage("training.finish.number", null, locale);
            String finishPercentage = "\u5b8c\u6210\u7387";
            String[] titles = new String[]{name, updateTime, allNum, finishNum, finishPercentage};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 4);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1000);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            StringBuffer sb = new StringBuffer();
            HSSFCellStyle newTitleSty = workbook.createCellStyle();
            HSSFFont newfont = workbook.createFont();
            newfont.setFontHeightInPoints((short)12);
            newTitleSty.setFont((Font)newfont);
            for (int i = 0; i < paperVos.size(); ++i) {
                TrainingVo vo = (TrainingVo)paperVos.get(i);
                HSSFRow row1 = excelSheet.createRow(i + 2);
                row1.createCell(0).setCellValue(vo.getTitle());
                row1.createCell(1).setCellValue(vo.getCreateTimeStr());
                row1.createCell(2).setCellValue((double)vo.getAllNumber().intValue());
                row1.createCell(3).setCellValue((double)vo.getFinishNumber().intValue());
                row1.createCell(4).setCellValue(vo.getFinishPercentage());
                row1.setHeight((short)400);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getAttachProgressExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttachProgressExcel(HttpServletResponse response, Integer trainingId, Integer enterpriseId, String trainingName) {
        try {
            String needNumber;
            String filename;
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
                enterpriseId = user.getGroupId();
            }
            List<TrainingChapterVo> trainingChapterVos = this.trainingRemoteService.getAttachProgressByPage(trainingId, enterpriseId);
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet excelSheet = workbook.createSheet(this.messageSource.getMessage("training.view.condition", null, locale));
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            String finishDetail = this.messageSource.getMessage("training.course.finish.detail", null, locale);
            String title = trainingName + "\u2014\u2014" + finishDetail;
            String name = filename = this.messageSource.getMessage("training.course.filename", null, locale);
            String updateTime = this.messageSource.getMessage("training.course.update.time", null, locale);
            String allNum = needNumber = this.messageSource.getMessage("training.course.need.view.number", null, locale);
            String finishNum = this.messageSource.getMessage("training.finish.number", null, locale);
            String finishPercentage = "\u5b8c\u6210\u7387";
            String[] titles = new String[]{name, updateTime, allNum, finishNum, finishPercentage};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            titleSty.setAlignment(HorizontalAlignment.CENTER);
            titleSty.setWrapText(true);
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 4);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1200);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            int j = 2;
            for (int i = 0; i < trainingChapterVos.size(); ++i) {
                TrainingChapterVo vo = trainingChapterVos.get(i);
                if (CollectionUtils.isEmpty((Collection)vo.getAttachVos())) continue;
                for (TrainingAttachVo attachVo : vo.getAttachVos()) {
                    HSSFRow row1 = excelSheet.createRow(j);
                    row1.createCell(0).setCellValue(attachVo.getFileName());
                    row1.createCell(1).setCellValue(attachVo.getCreateTime() == null ? "" : DateUtils.format(attachVo.getCreateTime()));
                    row1.createCell(2).setCellValue((double)attachVo.getAllNumber().intValue());
                    row1.createCell(3).setCellValue((double)attachVo.getFinishNumber().intValue());
                    row1.createCell(4).setCellValue(attachVo.getFinishPercentage());
                    row1.setHeight((short)400);
                    ++j;
                }
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getAttachVosByUserIdExcel"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getAttachVosByUserIdExcel(HttpServletResponse response, Integer trainingId, Integer userId, Integer enterpriseId, String trainingName, String percentage) {
        try {
            String filename;
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && !this.commonRemoteService.isRoot(user.getId()).booleanValue()) {
                enterpriseId = user.getGroupId();
            }
            List<TrainingChapterVo> trainingChapterVos = this.trainingRemoteService.getAttachVosByUserId(trainingId, userId, enterpriseId);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet excelSheet = workbook.createSheet(this.messageSource.getMessage("training.view.condition", null, locale));
            excelSheet.setDefaultColumnWidth(15);
            ExcelUtil.setDataCellStyles(workbook, excelSheet);
            excelSheet.setColumnHidden(40, true);
            Users users = this.userServiceNew.getById(userId);
            String finishDetail = this.messageSource.getMessage("training.course.finish.detail", null, locale);
            String title = users.getShowName() + "\u2014\u2014" + users.getEmployeeNumber() + trainingName + "\u2014\u2014" + finishDetail + "\u2014\u2014\u603b\u8fdb\u5ea6\uff1a" + percentage;
            String name = filename = this.messageSource.getMessage("training.course.filename", null, locale);
            String updateTime = this.messageSource.getMessage("training.course.update.time", null, locale);
            String status = this.messageSource.getMessage("training.paper.status", null, locale);
            String finishTime = this.messageSource.getMessage("training.course.analysis.endtime", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            String[] titles = new String[]{name, updateTime, status, finishTime};
            HSSFRow row = excelSheet.createRow(1);
            CellStyle style = ExcelUtil.getHeadStyle((Workbook)workbook);
            for (int i = 0; i < titles.length; ++i) {
                row.setHeight((short)450);
                ExcelUtil.initCell(row.createCell(i), style, titles[i]);
            }
            HSSFCellStyle titleSty = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            CellRangeAddress region1 = new CellRangeAddress(0, 0, 0, 3);
            excelSheet.addMergedRegion(region1);
            HSSFRow row0 = excelSheet.createRow(0);
            row0.setHeight((short)1000);
            ExcelUtil.initCell(row0.createCell(0), (CellStyle)titleSty, title);
            int j = 2;
            for (int i = 0; i < trainingChapterVos.size(); ++i) {
                TrainingChapterVo vo = trainingChapterVos.get(i);
                if (CollectionUtils.isEmpty((Collection)vo.getAttachVos())) continue;
                for (TrainingAttachVo attachVo : vo.getAttachVos()) {
                    HSSFRow row1 = excelSheet.createRow(j);
                    row1.createCell(0).setCellValue(attachVo.getFileName());
                    row1.createCell(1).setCellValue(DateUtils.format(attachVo.getUpdateTime()));
                    String unfinish = this.messageSource.getMessage("training.course.unfinish", null, locale);
                    row1.createCell(2).setCellValue(attachVo.getStatus() == 0 ? unfinish : completed);
                    row1.createCell(3).setCellValue(DateUtils.format(attachVo.getCreateTime()));
                    row1.setHeight((short)400);
                    ++j;
                }
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=test_ranking.xls");
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
            workbook.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingByPage(Page<TrainingsVo> page) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success(this.trainingRemoteService.getTrainingByPage(page, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.info("selectNewTrainingContent: " + e);
            return JsonResult.error();
        }
    }

    @RequestMapping(value={"/selectTrainingById"})
    @ResponseBody
    public String selectTrainingById(Integer id) {
        if (id == null) {
            return JsonResult.paramError();
        }
        Training training = this.trainingRemoteService.getTrainingById(id);
        return JsonResult.success((Object)training);
    }
}

