/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.DynamicTask;
import com.ovopark.training.model.Training;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.DynamicTaskService;
import com.ovopark.training.service.TrainingPaperRemoteService;
import com.ovopark.training.service.TrainingService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.TrainingExeclVo;
import com.ovopark.training.vo.TrainingsVo;
import com.ovopark.training.vo.UserCommentVo;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/training"})
public class TrainingController {
    private static final Logger log = LoggerFactory.getLogger(TrainingController.class);
    @Autowired
    private TrainingService trainingService;
    @Autowired
    private TrainingPaperRemoteService trainingPaperRemoteService;
    @Autowired
    private DynamicTaskService taskService;

    @RequestMapping(value={"/updateUserView"})
    @ResponseBody
    public String updateUserView(String startDate, String endDate) {
        Date startTime = DateUtils.getStartTimeOfDay(DateUtils.parse(startDate, "yyyy-MM-dd"));
        Date endTime = DateUtils.getEndTimeOfDay(DateUtils.parse(endDate, "yyyy-MM-dd"));
        this.trainingPaperRemoteService.updateUserView(startTime, endTime);
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveTraining"})
    @ResponseBody
    public String saveTraining(Training training) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) || Objects.nonNull(user.getGroupId())) {
            this.trainingService.saveTraining(training, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingsByParams"})
    @ResponseBody
    public String selectTrainingsByParams(@RequestBody TrainingsVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectTrainingsByParams(vo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/updateTrainingByOld"})
    @ResponseBody
    public String updateTrainingByOld() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.updateTrainingByOld(user);
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectOldTrainingRemove"})
    @ResponseBody
    public String selectOldTrainingRemove() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.trainingService.selectOldTrainingRemove(user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingExeclVoCount"})
    @ResponseBody
    public String selectTrainingExeclVoCount(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.trainingService.selectTrainingExeclVoCount(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByUserByPage"})
    @ResponseBody
    public String selectExeclVoByUserByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectExeclVoByUserByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingByUserByPage"})
    @ResponseBody
    public String selectTrainingByUserByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectTrainingByUserByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByUserByExecl"})
    @ResponseBody
    public String selectExeclVoByUserByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return this.trainingService.selectExeclVoByUserByExecl(response, trainingExeclVo, user);
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectUserTrainingByExecl"})
    @ResponseBody
    public String selectUserTrainingByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectUserTrainingByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingByUserByExecl"})
    @ResponseBody
    public String selectTrainingByUserByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectTrainingByUserByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByDepByPage"})
    @ResponseBody
    public String selectExeclVoByDepByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectExeclVoByDepByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingByDepByPage"})
    @ResponseBody
    public String selectTrainingByDepByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectTrainingByDepByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByDepByExecl"})
    @ResponseBody
    public String selectExeclVoByDepByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectExeclVoByDepByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingByDepByExecl"})
    @ResponseBody
    public String selectTrainingByDepByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectTrainingByDepByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByRoleByPage"})
    @ResponseBody
    public String selectExeclVoByRoleByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectExeclVoByRoleByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByRoleByExecl"})
    @ResponseBody
    public String selectExeclVoByRoleByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectExeclVoByRoleByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByTrainByPage"})
    @ResponseBody
    public String selectExeclVoByTrainByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectExeclVoByTrainByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectExeclVoByTrainByExecl"})
    @ResponseBody
    public String selectExeclVoByTrainByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectExeclVoByTrainByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectMainByStudentByPage"})
    @ResponseBody
    public String selectMainByStudentByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectMainByStudentByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectMainByStudentByExecl"})
    @ResponseBody
    public String selectMainByStudentByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectMainByStudentByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectUserTrainingsByPage"})
    @ResponseBody
    public String selectUserTrainingsByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.trainingService.selectUserTrainingsByPage(trainingExeclVo, user));
    }

    @RequestMapping(value={"/selectUserTrainingsTotal"})
    @ResponseBody
    public String selectUserTrainingsTotal(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.trainingService.selectUserTrainingsTotal(trainingExeclVo, user));
    }

    @RequestMapping(value={"/selectStudentPaperStatus"})
    @ResponseBody
    public String selectStudentPaperStatus(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.trainingService.selectStudentPaperStatus(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectStudentPaperByPage"})
    @ResponseBody
    public String selectStudentPaperByPage(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.selectStudentPaperByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/getStudentPaperList"})
    @ResponseBody
    public String getStudentPaperList(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.trainingService.getStudentPaperList(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectStudentPaperByExecl"})
    @ResponseBody
    public String selectStudentPaperByExecl(HttpServletResponse response, @RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectStudentPaperByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingByPage"})
    @ResponseBody
    public String selectTrainingByPage(TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getGroupId())) {
            return JsonResult.success(this.trainingService.selectTrainingByPage(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingStatus"})
    @ResponseBody
    public String selectTrainingStatus(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.nonNull(user) && Objects.nonNull(user.getGroupId())) {
            return JsonResult.success(this.trainingService.selectTrainingStatus(trainingExeclVo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectTrainingByExecl"})
    @ResponseBody
    public String selectTrainingByExecl(HttpServletResponse response, TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingService.selectTrainingByExecl(response, trainingExeclVo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectUserScore"})
    @ResponseBody
    public String selectUserScoreVo(int trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.trainingService.selectUserScoreVo(trainingId));
    }

    @RequestMapping(value={"/selectUserComment"})
    @ResponseBody
    public String selectUserCommentVo(Page<UserCommentVo> page, int trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.trainingService.selectUserCommentVo(page, trainingId));
    }

    @RequestMapping(value={"/selectUserArchives"})
    @ResponseBody
    public String selectUserArchives(TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.trainingService.selectUserArchives(trainingExeclVo));
    }

    @RequestMapping(value={"/selectProjectByPage"})
    @ResponseBody
    public String selectProjectByPage(TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        TrainingController.extractTrainingProjectStatus(trainingExeclVo);
        return JsonResult.success(this.trainingService.selectProjectByPage(trainingExeclVo, user));
    }

    @RequestMapping(value={"/getProjectList"})
    @ResponseBody
    public String getProjectList(TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        TrainingController.extractTrainingProjectStatus(trainingExeclVo);
        return JsonResult.success(this.trainingService.getProjectList(trainingExeclVo, user));
    }

    private static void extractTrainingProjectStatus(TrainingExeclVo trainingExeclVo) {
        if (Objects.nonNull(trainingExeclVo) && Objects.nonNull(trainingExeclVo.getStatus()) && Objects.equals(trainingExeclVo.getStatus(), 2)) {
            trainingExeclVo.setStatus(Integer.valueOf(4));
        }
    }

    @RequestMapping(value={"/selectProjectByStatus"})
    @ResponseBody
    public String selectProjectByStatus(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.trainingService.selectProjectByStatus(trainingExeclVo, user));
    }

    @RequestMapping(value={"/selectProjectByExecl"})
    @ResponseBody
    public String selectProjectByExecl(HttpServletResponse response, TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        this.trainingService.selectProjectByExecl(response, trainingExeclVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/addTask"})
    @ResponseBody
    public String addTask(DynamicTask task) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.taskService.add(task));
    }

    @RequestMapping(value={"/stopTask"})
    @ResponseBody
    public String stopTask(String name) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success((Object)this.taskService.stop(name));
    }

    @RequestMapping(value={"/selectTask"})
    @ResponseBody
    public String selectTask() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.taskService.selectDynamicTask());
    }

    @RequestMapping(value={"/selectTask2"})
    @ResponseBody
    public String selectTask2() {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.taskService.selectDynamicTask2());
    }

    @RequestMapping(value={"/selectIsTrainingPower"})
    @ResponseBody
    public String selectIsTrainingPower(Integer trainingId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingService.selectIsTrainingPower(trainingId, user));
    }

    @RequestMapping(value={"/getUserCertification"})
    @ResponseBody
    public String getUserCertification(@RequestBody TrainingExeclVo trainingExeclVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getGroupId())) {
            return JsonResult.error();
        }
        return JsonResult.success(this.trainingService.getUserCertification(trainingExeclVo, user));
    }
}

