/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.DeptSummarizeQueryRequest;
import com.ovopark.training.service.IDeptStatisticService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/dept"})
public class TrainingDeptSummarizeController {
    private static final Logger log = LoggerFactory.getLogger(TrainingDeptSummarizeController.class);
    @Resource
    private IDeptStatisticService deptStatisticService;

    @PostMapping(value={"/getDeptStatistics"})
    @ResponseBody
    public String getDeptStatistics(@RequestBody DeptSummarizeQueryRequest request) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getGroupId() == null) {
            return JsonResult.error();
        }
        return JsonResult.success(this.deptStatisticService.queryDeptStatistics(request, user));
    }
}

