/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingFee;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingFeeService;
import com.ovopark.training.vo.TrainingFeeVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/fee"})
public class TrainingFeeController {
    private static final Logger log = LoggerFactory.getLogger(TrainingFeeController.class);
    @Autowired
    private TrainingFeeService trainingFeeService;

    @RequestMapping(value={"/saveTrainingFee"})
    @ResponseBody
    public String saveTraining(@RequestBody TrainingFeeVo trainingFeeVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!this.trainingFeeService.cheackSameTrainingName(trainingFeeVo, user).booleanValue()) {
            return JsonResult.success((Object)"TRAINING_NAME_EXISTING");
        }
        this.trainingFeeService.saveTrainingFee(trainingFeeVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectTrainingFeeDetail"})
    @ResponseBody
    public String selectTrainingFeeDetail(@RequestBody TrainingFeeVo trainingFeeVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success((Object)this.trainingFeeService.selectTrainingFeeDetail(trainingFeeVo, user));
    }

    @RequestMapping(value={"/selectTrainingFeeByPage"})
    @ResponseBody
    public String selectTrainingFeeByPage(@RequestBody TrainingFeeVo trainingFeeVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return JsonResult.success(this.trainingFeeService.selectTrainingFeeByPage(trainingFeeVo, user));
    }

    @RequestMapping(value={"/updateTrainingFeeStatus"})
    @ResponseBody
    public String updateTrainingFeeStatus(@RequestBody List<TrainingFee> trainingFeeList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingFeeService.updateTrainingFeeStatus(trainingFeeList, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateTrainingFeeType"})
    @ResponseBody
    public String updateTrainingFeeType(@RequestBody List<TrainingFee> trainingFeeList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingFeeService.updateTrainingFeeType(trainingFeeList, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteTrainingFee"})
    @ResponseBody
    public String deleteTrainingFee(@RequestBody List<TrainingFee> trainingFeeList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingFeeService.deleteTrainingFee(trainingFeeList, user);
        return JsonResult.success();
    }
}

