/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.ChecckUsersApiMo;
import com.ovopark.organize.common.model.mo.ChecckUsersMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingJobUserTask;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingJobCertificationService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ExcelUtil;
import com.ovopark.training.vo.TrainingJobCertificationVo;
import com.ovopark.training.vo.TrainingJobShiftTaskVo;
import com.ovopark.training.vo.TrainingJobStageTaskVo;
import com.ovopark.training.vo.TrainingJobStageVo;
import com.ovopark.training.vo.TrainingJobUserTaskVo;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/training/jobCertification"})
public class TrainingJobCertificationController {
    private static final Logger log = LoggerFactory.getLogger(TrainingJobCertificationController.class);
    @Autowired
    private TrainingJobCertificationService jobCertificationService;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private RoleApi roleApi;
    @Autowired
    private UserOrganizeApi userOrganizeApi;

    @RequestMapping(value={"/selectJobCertificationByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobCertificationByPage(Page<TrainingJobCertificationVo> page, Integer enterpriseId, String name, Integer status) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.jobCertificationService.selectJobCertificationByPage(page, enterpriseId, user, name, status);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectJobPageNum"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobPageNum(Page<TrainingJobCertificationVo> page, Integer id, Integer enterpriseId, String name, Integer status) {
        Integer pageSize = 1;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (id == null) {
            return JsonResult.paramError();
        }
        pageSize = this.jobCertificationService.selectJobPageNum(page, id, enterpriseId, user, name, status);
        return JsonResult.success((Object)pageSize);
    }

    @RequestMapping(value={"/selectJobCertificationAndMapByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobCertificationAndMapByPage(Page<TrainingJobCertificationVo> page, Integer enterpriseId, String name) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        page = this.jobCertificationService.selectJobCertificationAndMapByPage(page, enterpriseId, user, name);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectJobCertification"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobCertification(@RequestBody TrainingJobCertificationVo job) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        job = this.jobCertificationService.selectJobCertification(job);
        return JsonResult.success((Object)job);
    }

    @RequestMapping(value={"/insertJobCertification"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertJobCertification(@RequestBody TrainingJobCertificationVo job) {
        Integer id;
        block8: {
            id = 0;
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (user != null && user.getId() != null) {
                    job.setCreater(user.getId());
                    job.setCreateTime(new Date());
                    job.setEnterpriseId(user.getGroupId());
                    if (job.getAwardGold() == null) {
                        job.setAwardGold(Integer.valueOf(0));
                    }
                    if (job.getAwardGold() < 0 || job.getAwardGold() > 999) {
                        return JsonResult.error((String)"\u5956\u52b1\u91d1\u5e01\u8bbe\u7f6e\u9519\u8bef", null);
                    }
                    Integer jobCertificationList = this.jobCertificationService.selectJobCertificationByName(job);
                    if (jobCertificationList == 0) {
                        id = this.jobCertificationService.insertJobCertification(job);
                    } else if (jobCertificationList == 1) {
                        return JsonResult.error((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0", null);
                    }
                    break block8;
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("insertJobCertification:" + e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/updateJobCertification"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateJobCertification(@RequestBody TrainingJobCertificationVo job) {
        Integer id;
        block6: {
            id = 0;
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (user != null && user.getId() != null) {
                    Integer jobCertificationList = this.jobCertificationService.selectJobCertificationByName(job);
                    if (jobCertificationList == 0) {
                        id = this.jobCertificationService.updateJobCertification(job);
                    } else if (jobCertificationList == 1) {
                        return JsonResult.error((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0", null);
                    }
                    break block6;
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("updateJobCertification:" + e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/deleteJobCertification"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteJobCertification(HttpServletRequest req, @RequestBody TrainingJobCertificationVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                LogPojo pojo = new LogPojo();
                pojo.setUserId(user.getId());
                pojo.setOperation("job_certification_delete");
                pojo.setCreateTime(new Date());
                pojo.setRemoteIp(req.getRemoteAddr());
                pojo.setEnterpriseId(user.getGroupId());
                pojo.setUserName(user.getUserName());
                pojo.setI18nKey("operation.job_certification_delete.description");
                pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                return this.jobCertificationService.deleteJobCertification(job, pojo);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("deleteJobCertification:" + e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/updateJobCertificationStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateJobCertificationStatus(@RequestBody TrainingJobCertificationVo job) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            id = this.jobCertificationService.updateJobCertificationStatus(job);
        }
        catch (Exception e) {
            log.error("updateJobCertificationStatus:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/selectJobStages"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobStages(@RequestBody TrainingJobCertificationVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            job = this.jobCertificationService.selectJobStages(job);
        }
        catch (Exception e) {
            log.error("selectJobStages:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)job);
    }

    @RequestMapping(value={"/selectJobStageTasks"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobStageTasks(@RequestBody TrainingJobStageTaskVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            job = this.jobCertificationService.selectJobStageTasks(job);
        }
        catch (Exception e) {
            log.error("selectJobStageTasks:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)job);
    }

    @RequestMapping(value={"/insertJobStage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertJobStage(@RequestBody TrainingJobStageVo job) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            job.setCreater(user.getId());
            job.setCreateTime(new Date());
            id = this.jobCertificationService.insertJobStage(job);
        }
        catch (Exception e) {
            log.error("insertJobStage:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/updateJobStage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateJobStage(@RequestBody TrainingJobStageVo job) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            id = this.jobCertificationService.updateJobStage(job);
        }
        catch (Exception e) {
            log.error("updateJobStage:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/deleteJobStage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteJobStage(@RequestBody TrainingJobStageVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.deleteJobStage(job);
        }
        catch (Exception e) {
            log.error("deleteJobStage:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveStageSort"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveStageSort(@RequestBody List<TrainingJobStageVo> job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.saveStageSort(job);
        }
        catch (Exception e) {
            log.error("saveStageSort:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/insertJobStageTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertJobStageTask(@RequestBody List<TrainingJobStageTaskVo> job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.insertJobStageTask(job, user);
        }
        catch (Exception e) {
            log.error("insertJobStageTask:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateJobStageTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateJobStageTask(@RequestBody TrainingJobStageTaskVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.updateJobStageTask(job);
        }
        catch (Exception e) {
            log.error("updateJobStageTask:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteJobStageTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteJobStageTask(@RequestBody TrainingJobStageTaskVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.deleteJobStageTask(job);
        }
        catch (Exception e) {
            log.error("updateJobStageTask:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveStageTaskSort"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveStageTaskSort(@RequestBody List<TrainingJobStageTaskVo> job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.saveStageTaskSort(job);
        }
        catch (Exception e) {
            log.error("saveStageTaskSort:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveStageTaskIsBinding"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveStageTaskIsBinding(@RequestBody TrainingJobStageTaskVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.saveStageTaskIsBinding(job, user);
        }
        catch (Exception e) {
            log.error("saveStageTaskIsBinding:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectJobOfflineTasks"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobOfflineTasks(@RequestBody TrainingJobStageTaskVo job) {
        List<Object> jobs = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            jobs = this.jobCertificationService.selectJobOfflineTasks(job);
        }
        catch (Exception e) {
            log.error("selectJobOfflineTasks:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(jobs);
    }

    @RequestMapping(value={"/selectJobTaskOrganizes"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobTaskOrganizes(@RequestBody TrainingJobShiftTaskVo job) {
        List<Object> jobs = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            jobs = this.jobCertificationService.selectJobTaskOrganizes(job);
        }
        catch (Exception e) {
            log.error("selectJobTaskOrganizes:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(jobs);
    }

    @RequestMapping(value={"/selectJobOfflineTasksByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobOfflineTasksByPage(Page<TrainingJobStageTaskVo> page, Integer jobId, String taskName) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            page = this.jobCertificationService.selectJobOfflineTasksByPage(page, jobId, taskName, user);
        }
        catch (Exception e) {
            log.error("selectJobOfflineTasksByPage:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectJobShiftTasksByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobShiftTasksByPage(Page<TrainingJobShiftTaskVo> page, Integer jobId, Integer taskId, String taskOrganize, Integer creater, String startTime, String endTime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            page = this.jobCertificationService.selectJobShiftTasksByPage(page, user, jobId, taskId, taskOrganize, creater, startTime, endTime);
            List<Integer> managerList = this.jobCertificationService.selectJobManagerList(jobId);
            map.put("data", page);
            map.put("managerList", managerList);
        }
        catch (Exception e) {
            log.error("selectJobShiftTasksByPage:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/selectJobShiftTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobShiftTask(@RequestBody TrainingJobShiftTaskVo job) {
        TrainingJobShiftTaskVo jobs = new TrainingJobShiftTaskVo();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            jobs = this.jobCertificationService.selectJobShiftTask(job);
        }
        catch (Exception e) {
            log.error("selectJobShiftTasks:" + e);
        }
        return JsonResult.success((Object)jobs);
    }

    @RequestMapping(value={"/insertJobShiftTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertJobShiftTask(@RequestBody TrainingJobShiftTaskVo job) {
        Integer id = 0;
        Users user = Authenticator.getInstance().getCurrentUser();
        try {
            job.setCreater(user.getId());
            job.setCreateTime(new Date());
            if (org.springframework.util.StringUtils.isEmpty((Object)job.getEnterpriseId())) {
                job.setEnterpriseId(user.getGroupId());
            }
            id = this.jobCertificationService.insertJobShiftTask(job);
        }
        catch (Exception e) {
            log.error("insertJobShiftTask:" + e);
            return "EXCEPTION";
        }
        if (user != null && user.getId() != null && user.getId() != null) {
            try {
                this.jPushService.deleteMessages(job.getTaskId(), "TYPE_OFFLINETASK_SYSTEM", user.getId(), null, 1);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/updateJobShiftTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateJobShiftTask(@RequestBody TrainingJobShiftTaskVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.updateJobShiftTask(job);
        }
        catch (Exception e) {
            log.error("updateJobShiftTask:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteJobShiftTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteJobShiftTask(@RequestBody TrainingJobShiftTaskVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.deleteJobShiftTask(job);
        }
        catch (Exception e) {
            log.error("deleteJobShiftTask:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectJobStageTaskAndNum"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobStageTaskAndNum(@RequestBody TrainingJobStageVo job) {
        List<Object> jobs = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            jobs = this.jobCertificationService.selectJobStageTaskAndNum(job, user);
        }
        catch (Exception e) {
            log.error("selectJobStageTaskAndNum:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(jobs);
    }

    @RequestMapping(value={"/selectJobUserTaskStatusAndNum"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectJobUserTaskStatusAndNum(@RequestBody TrainingJobUserTaskVo job) {
        Map jobs = new HashMap();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            jobs = this.jobCertificationService.selectJobUserTaskStatusAndNum(job, user);
        }
        catch (Exception e) {
            log.error("selectJobUserTaskStatusAndNum:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(jobs);
    }

    @RequestMapping(value={"/selectJobUserTaskByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobUserTaskByPage(Page<TrainingJobUserTaskVo> page, Integer stageTaskId, Integer taskStatus, String userName) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            page = this.jobCertificationService.selectJobUserTaskByPage(page, stageTaskId, taskStatus, userName, user);
        }
        catch (Exception e) {
            log.error("selectJobUserTaskByPage:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectJobUserTaskByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobUserTaskByExecl(HttpServletResponse response, Integer stageTaskId, String taskName, Integer taskStatus, String userName) {
        Page<TrainingJobUserTaskVo> page = new Page<TrainingJobUserTaskVo>();
        page.setPageSize(9999);
        page.setPageNumber(1);
        try {
            HSSFWorkbook wb;
            Locale locale;
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                page = this.jobCertificationService.selectJobUserTaskByPage(page, stageTaskId, taskStatus, userName, user);
                List voList = page.getContent();
                locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
                String statusNames = this.messageSource.getMessage("training.paper.status", null, locale);
                String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = this.messageSource.getMessage("training.job.status.going", null, locale);
                String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
                taskName = ExcelUtil.getFileName(taskName);
                wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(taskName);
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(1).setCellValue(employeeNumber);
                row.createCell(2).setCellValue(department);
                row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                row.createCell(6).setCellValue(statusNames);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingJobUserTaskVo vo = (TrainingJobUserTaskVo)voList.get(i);
                    row.createCell(0).setCellValue(vo.getUserName());
                    row.createCell(1).setCellValue(vo.getEmployeeNumber());
                    row.createCell(2).setCellValue(vo.getOrganizeName());
                    row.createCell(3).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(4).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    row.createCell(5).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                    String statusName = "";
                    if (vo.getTaskStatus() == 0) {
                        statusName = unStart;
                    } else if (vo.getTaskStatus() == 1) {
                        statusName = going;
                    } else if (vo.getTaskStatus() == 2) {
                        statusName = waitRead;
                    } else if (vo.getTaskStatus() == 3) {
                        statusName = unPassName;
                    } else if (vo.getTaskStatus() == 4) {
                        statusName = completed;
                    }
                    row.createCell(6).setCellValue(statusName);
                }
            } else {
                return "INVALID_TOKEN";
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            log.error("selectJobUserTaskByExecl:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectJobUserPaperByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectJobUserPaperByPage(Page<TrainingJobUserTaskVo> page, Integer stageTaskId, Integer taskStatus, String userName) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            page = this.jobCertificationService.selectJobUserPaperByPage(page, stageTaskId, taskStatus, userName, user);
        }
        catch (Exception e) {
            log.error("selectJobUserPaperByPage:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectUserPaperByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperTaskByExecl(HttpServletResponse response, String taskName, Integer stageTaskId, Integer taskStatus, String userName, Integer exportStatus) {
        block61: {
            Page<TrainingJobUserTaskVo> page = new Page<TrainingJobUserTaskVo>();
            page.setPageSize(9999);
            page.setPageNumber(1);
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (user != null && user.getId() != null) {
                    taskName = ExcelUtil.getFileName(taskName);
                    if (exportStatus == null || exportStatus == 1) {
                        page = this.jobCertificationService.selectJobUserPaperByPage(page, stageTaskId, taskStatus, userName, user);
                        List voList = page.getContent();
                        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                        List<Integer> userIdList = voList.stream().map(TrainingJobUserTask::getUserId).distinct().collect(Collectors.toList());
                        Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                        Map<Object, Object> roleMap = new HashMap();
                        Map<Object, Object> parentMap = new HashMap();
                        Map organMap1 = new HashMap();
                        Map organMap2 = new HashMap();
                        Map organMap3 = new HashMap();
                        Map organMap4 = new HashMap();
                        Map organMap5 = new HashMap();
                        Map shopMap = new HashMap();
                        Map shopDetailMap = new HashMap();
                        if (!CollectionUtils.isEmpty(userIdList)) {
                            roleMap = this.userUtilService.selectRolesByUsers(userIdList, ((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            parentMap = this.userUtilService.selectParentMap(userIdList, ((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            UsersAndOrgsMo mo = new UsersAndOrgsMo();
                            mo.setGroupId(((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            mo.setLevelList(Collections.singletonList(1));
                            mo.setUserIdList(userIdList);
                            mo.setShowDepartment(Boolean.valueOf(false));
                            BaseResult base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base1 != null) {
                                organMap1 = (Map)base1.getData();
                            }
                            mo.setLevelList(Collections.singletonList(2));
                            BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base2 != null) {
                                organMap2 = (Map)base2.getData();
                            }
                            mo.setLevelList(Collections.singletonList(3));
                            BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base3 != null) {
                                organMap3 = (Map)base3.getData();
                            }
                            mo.setLevelList(Collections.singletonList(4));
                            BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base4 != null) {
                                organMap4 = (Map)base4.getData();
                            }
                            mo.setLevelList(Collections.singletonList(5));
                            BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base5 != null) {
                                organMap5 = (Map)base5.getData();
                            }
                            UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                            mo1.setGroupId(((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            mo1.setUserIdList(userIdList);
                            mo1.setShowDepartment(Boolean.valueOf(true));
                            BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                            if (base != null && base.getData() != null) {
                                shopMap = (Map)base.getData();
                            }
                            mo1.setShowAllPath(Boolean.valueOf(true));
                            BaseResult bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                            if (bases != null && bases.getData() != null) {
                                shopDetailMap = (Map)bases.getData();
                            }
                        }
                        String unExam = this.messageSource.getMessage("training.course.status.unexam", null, locale);
                        String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                        String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                        String passName = this.messageSource.getMessage("training.paper.pass", null, locale);
                        HSSFWorkbook wb = new HSSFWorkbook();
                        HSSFSheet sheet = wb.createSheet(taskName);
                        HSSFCellStyle titleSty = wb.createCellStyle();
                        HSSFFont font = wb.createFont();
                        font.setFontHeightInPoints((short)16);
                        titleSty.setFont((Font)font);
                        HSSFRow row = sheet.createRow(0);
                        row.createCell(0).setCellValue("id");
                        row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                        row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                        row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                        row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                        row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
                        row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                        row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                        row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                        row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                        row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                        row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                        row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.finish.time", null, locale));
                        row.createCell(13).setCellValue(this.messageSource.getMessage("training.paper.num", null, locale));
                        row.createCell(14).setCellValue(this.messageSource.getMessage("training.course.average.time", null, locale));
                        row.createCell(15).setCellValue(this.messageSource.getMessage("training.certificate.paper.score", null, locale));
                        row.createCell(16).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        for (int i = 0; i < voList.size(); ++i) {
                            List pojoList;
                            List pojoList2;
                            List pojoList3;
                            List pojoList4;
                            List pojoList5;
                            List pojoList6;
                            List pojoList7;
                            row = sheet.createRow(i + 1);
                            TrainingJobUserTaskVo vo = (TrainingJobUserTaskVo)voList.get(i);
                            row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                            row.createCell(1).setCellValue(vo.getUserName());
                            row.createCell(2).setCellValue(vo.getEmployeeNumber());
                            String roleName = "";
                            if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                                List listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                                roleName = StringUtils.join(listStr, (String)",");
                            }
                            row.createCell(3).setCellValue(roleName);
                            String parentName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                                parentName = (String)parentMap.get(vo.getUserId());
                            }
                            row.createCell(4).setCellValue(parentName);
                            String organName1 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                                pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                                organName1 = StringUtils.join(pojoList6, (String)",");
                            }
                            String departName = "";
                            List<String> nameList = organizeMap.get(vo.getUserId());
                            if (!CollectionUtils.isEmpty(nameList)) {
                                departName = String.join((CharSequence)";\n", nameList);
                            }
                            row.createCell(5).setCellValue(departName);
                            row.createCell(6).setCellValue(organName1);
                            String organName2 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                                pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                                organName2 = StringUtils.join(pojoList5, (String)",");
                            }
                            row.createCell(7).setCellValue(organName2);
                            String organName3 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                                pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                                organName3 = StringUtils.join(pojoList4, (String)",");
                            }
                            row.createCell(8).setCellValue(organName3);
                            String organName4 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                                pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                                organName4 = StringUtils.join(pojoList3, (String)",");
                            }
                            row.createCell(9).setCellValue(organName4);
                            String organName5 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                                pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                                organName5 = StringUtils.join(pojoList2, (String)",");
                            }
                            row.createCell(10).setCellValue(organName5);
                            String shopName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                shopName = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(11).setCellValue(shopName);
                            row.createCell(12).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                            row.createCell(13).setCellValue(vo.getPaperCount() == null ? "-" : vo.getPaperCount().toString());
                            row.createCell(14).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                            row.createCell(15).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                            String statusName = "";
                            if (vo.getTaskStatus() == 0) {
                                statusName = unExam;
                            } else if (vo.getTaskStatus() == 1) {
                                statusName = this.messageSource.getMessage("training.paper.ing", null, locale);
                            } else if (vo.getTaskStatus() == 2) {
                                statusName = waitRead;
                            } else if (vo.getTaskStatus() == 3) {
                                statusName = unPassName;
                            } else if (vo.getTaskStatus() == 4) {
                                statusName = passName;
                            }
                            row.createCell(16).setCellValue(statusName);
                        }
                        response.setContentType("application/vnd.ms-excel; charset=utf-8");
                        response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
                        ServletOutputStream out = response.getOutputStream();
                        wb.write((OutputStream)out);
                        out.flush();
                        out.close();
                        wb.close();
                    } else if (exportStatus == 2) {
                        page = this.jobCertificationService.selectJobUserPaperByPage2(page, stageTaskId, taskStatus, userName, user);
                        List voList = page.getContent();
                        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                        List<Integer> userIdList = voList.stream().map(TrainingJobUserTask::getUserId).distinct().collect(Collectors.toList());
                        Map<Integer, List<String>> organizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                        Map<Object, Object> roleMap = new HashMap();
                        Map<Object, Object> parentMap = new HashMap();
                        Map organMap1 = new HashMap();
                        Map organMap2 = new HashMap();
                        Map organMap3 = new HashMap();
                        Map organMap4 = new HashMap();
                        Map organMap5 = new HashMap();
                        Map shopMap = new HashMap();
                        Map shopDetailMap = new HashMap();
                        if (!CollectionUtils.isEmpty(userIdList)) {
                            roleMap = this.userUtilService.selectRolesByUsers(userIdList, ((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            parentMap = this.userUtilService.selectParentMap(userIdList, ((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            UsersAndOrgsMo mo = new UsersAndOrgsMo();
                            mo.setGroupId(((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            mo.setLevelList(Collections.singletonList(1));
                            mo.setUserIdList(userIdList);
                            mo.setShowDepartment(Boolean.valueOf(false));
                            BaseResult base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base1 != null) {
                                organMap1 = (Map)base1.getData();
                            }
                            mo.setLevelList(Collections.singletonList(2));
                            BaseResult base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base2 != null) {
                                organMap2 = (Map)base2.getData();
                            }
                            mo.setLevelList(Collections.singletonList(3));
                            BaseResult base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base3 != null) {
                                organMap3 = (Map)base3.getData();
                            }
                            mo.setLevelList(Collections.singletonList(4));
                            BaseResult base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base4 != null) {
                                organMap4 = (Map)base4.getData();
                            }
                            mo.setLevelList(Collections.singletonList(5));
                            BaseResult base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base5 != null) {
                                organMap5 = (Map)base5.getData();
                            }
                            UsersAndOrgsMo mo1 = new UsersAndOrgsMo();
                            mo1.setGroupId(((TrainingJobUserTaskVo)voList.get(0)).getEnterpriseId());
                            mo1.setUserIdList(userIdList);
                            mo1.setShowDepartment(Boolean.valueOf(true));
                            BaseResult base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                            if (base != null && base.getData() != null) {
                                shopMap = (Map)base.getData();
                            }
                            mo1.setShowAllPath(Boolean.valueOf(true));
                            BaseResult bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                            if (bases != null && bases.getData() != null) {
                                shopDetailMap = (Map)bases.getData();
                            }
                        }
                        String unExam = this.messageSource.getMessage("training.course.status.unexam", null, locale);
                        String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                        String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                        String passName = this.messageSource.getMessage("training.paper.pass", null, locale);
                        HSSFWorkbook wb = new HSSFWorkbook();
                        HSSFSheet sheet = wb.createSheet(taskName);
                        HSSFCellStyle titleSty = wb.createCellStyle();
                        HSSFFont font = wb.createFont();
                        font.setFontHeightInPoints((short)16);
                        titleSty.setFont((Font)font);
                        HSSFRow row = sheet.createRow(0);
                        row.createCell(0).setCellValue("id");
                        row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                        row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                        row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                        row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                        row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
                        row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                        row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                        row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                        row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                        row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                        row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                        row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.handtime", null, locale));
                        row.createCell(13).setCellValue(this.messageSource.getMessage("training.operate.usetime", null, locale));
                        row.createCell(14).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
                        row.createCell(15).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        for (int i = 0; i < voList.size(); ++i) {
                            List pojoList;
                            List pojoList8;
                            List pojoList9;
                            List pojoList10;
                            List pojoList11;
                            List pojoList12;
                            List pojoList13;
                            row = sheet.createRow(i + 1);
                            TrainingJobUserTaskVo vo = (TrainingJobUserTaskVo)voList.get(i);
                            row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                            row.createCell(1).setCellValue(vo.getUserName());
                            row.createCell(2).setCellValue(vo.getEmployeeNumber());
                            String roleName = "";
                            if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList13 = (List)roleMap.get(vo.getUserId())))) {
                                List listStr = pojoList13.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                                roleName = StringUtils.join(listStr, (String)",");
                            }
                            row.createCell(3).setCellValue(roleName);
                            String parentName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                                parentName = (String)parentMap.get(vo.getUserId());
                            }
                            row.createCell(4).setCellValue(parentName);
                            String organName1 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList12 = (List)organMap1.get(vo.getUserId())))) {
                                pojoList12 = pojoList12.stream().distinct().collect(Collectors.toList());
                                organName1 = StringUtils.join(pojoList12, (String)",");
                            }
                            String departName = "";
                            List<String> nameList = organizeMap.get(vo.getUserId());
                            if (!CollectionUtils.isEmpty(nameList)) {
                                departName = String.join((CharSequence)";\n", nameList);
                            }
                            row.createCell(5).setCellValue(departName);
                            row.createCell(6).setCellValue(organName1);
                            String organName2 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList11 = (List)organMap2.get(vo.getUserId())))) {
                                pojoList11 = pojoList11.stream().distinct().collect(Collectors.toList());
                                organName2 = StringUtils.join(pojoList11, (String)",");
                            }
                            row.createCell(7).setCellValue(organName2);
                            String organName3 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList10 = (List)organMap3.get(vo.getUserId())))) {
                                pojoList10 = pojoList10.stream().distinct().collect(Collectors.toList());
                                organName3 = StringUtils.join(pojoList10, (String)",");
                            }
                            row.createCell(8).setCellValue(organName3);
                            String organName4 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList9 = (List)organMap4.get(vo.getUserId())))) {
                                pojoList9 = pojoList9.stream().distinct().collect(Collectors.toList());
                                organName4 = StringUtils.join(pojoList9, (String)",");
                            }
                            row.createCell(9).setCellValue(organName4);
                            String organName5 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList8 = (List)organMap5.get(vo.getUserId())))) {
                                pojoList8 = pojoList8.stream().distinct().collect(Collectors.toList());
                                organName5 = StringUtils.join(pojoList8, (String)",");
                            }
                            row.createCell(10).setCellValue(organName5);
                            String shopName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                shopName = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(11).setCellValue(shopName);
                            if (vo.getSubmitTime() != null) {
                                row.createCell(12).setCellValue(format.format(vo.getSubmitTime()));
                            }
                            row.createCell(13).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                            String statusName = "";
                            String score = "";
                            if (vo.getTaskStatus() == 1 || vo.getTaskStatus() == 0) {
                                String unexam;
                                statusName = unexam = this.messageSource.getMessage("training.paper.unexam", null, locale);
                                score = "-";
                            } else if (vo.getTaskStatus() == 2) {
                                statusName = this.messageSource.getMessage("training.paper.ing", null, locale);
                                score = "-";
                            } else if (vo.getTaskStatus() == 3) {
                                statusName = passName;
                                score = String.valueOf(vo.getScore());
                            } else if (vo.getTaskStatus() == 4) {
                                statusName = unPassName;
                                score = String.valueOf(vo.getScore());
                            } else if (vo.getTaskStatus() == 5) {
                                statusName = waitRead;
                                score = "-";
                            }
                            row.createCell(14).setCellValue(score);
                            row.createCell(15).setCellValue(statusName);
                        }
                        response.setContentType("application/vnd.ms-excel; charset=utf-8");
                        response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
                        ServletOutputStream out = response.getOutputStream();
                        wb.write((OutputStream)out);
                        out.flush();
                        out.close();
                        wb.close();
                    }
                    break block61;
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("selectUserPaperTaskByExecl:", (Throwable)e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectUserPaperDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperDetail(@RequestBody TrainingJobUserTaskVo project) {
        List<Object> vo = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            vo = this.jobCertificationService.selectUserPaperDetail(project);
        }
        catch (Exception e) {
            log.error("selectUserPaperDetail:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(vo);
    }

    @RequestMapping(value={"/selectOfflineShift"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectOfflineShift(@RequestBody TrainingJobShiftTaskVo job) {
        List<Object> jobs = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            jobs = this.jobCertificationService.selectOfflineShift(job);
        }
        catch (Exception e) {
            log.error("selectOfflineShift:" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(jobs);
    }

    @RequestMapping(value={"/selectUserOfflineByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUserOfflineByPage(Page<TrainingJobUserTaskVo> page, Integer stageTaskId, Integer shiftTaskId, String userName) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            page = this.jobCertificationService.selectUserOfflineByPage(page, stageTaskId, shiftTaskId, userName, user);
        }
        catch (Exception e) {
            log.error("selectUserOfflineByPage:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectUserOfflineByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUserOfflineTaskByExecl(HttpServletResponse response, String taskName, Integer stageTaskId, Integer shiftTaskId, String userName) {
        Page<TrainingJobUserTaskVo> page = new Page<TrainingJobUserTaskVo>();
        page.setPageSize(9999);
        page.setPageNumber(1);
        try {
            HSSFWorkbook wb;
            Locale locale;
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                page = this.jobCertificationService.selectUserOfflineByPage(page, stageTaskId, shiftTaskId, userName, user);
                List voList = page.getContent();
                locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
                String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
                String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
                String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(taskName);
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(this.messageSource.getMessage("training.certificate.offline.class", null, locale));
                row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(2).setCellValue(employeeNumber);
                row.createCell(3).setCellValue(department);
                row.createCell(4).setCellValue(this.messageSource.getMessage("training.certificate.activity.validity", null, locale));
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.certificate.activity.time", null, locale) + this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.certificate.sign.time", null, locale));
                row.createCell(7).setCellValue(this.messageSource.getMessage("training.certificate.signout.time", null, locale));
                row.createCell(8).setCellValue(this.messageSource.getMessage("training.job.participation.number", null, locale) + this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(9).setCellValue(this.messageSource.getMessage("training.absences.number", null, locale) + this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.attendance", null, locale));
                row.createCell(11).setCellValue(this.messageSource.getMessage("training.certificate.mark", null, locale));
                row.createCell(12).setCellValue(passStatusName);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingJobUserTaskVo vo = (TrainingJobUserTaskVo)voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName());
                    row.createCell(1).setCellValue(vo.getUserName());
                    row.createCell(2).setCellValue(vo.getEmployeeNumber());
                    row.createCell(3).setCellValue(vo.getOrganizeName());
                    row.createCell(4).setCellValue((vo.getTaskStartTime() == null ? "" : format.format(vo.getTaskStartTime())) + " - " + (vo.getTaskEndTime() == null ? "" : format.format(vo.getTaskEndTime())));
                    row.createCell(5).setCellValue(vo.getActTime() == null ? "" : vo.getActTime().toString());
                    row.createCell(6).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(7).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    int allTime = vo.getIsAllTime();
                    String useTimeVo = "";
                    String cutTimeVo = "";
                    String outRate = "";
                    if (allTime == 0) {
                        useTimeVo = vo.getUseTimeVo() == null ? "" : vo.getUseTimeVo().toString();
                        cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                        outRate = vo.getOutRate() == null ? "" : vo.getOutRate().toString() + "%";
                    } else if (allTime == 1) {
                        useTimeVo = "-";
                        cutTimeVo = "-";
                        outRate = "-";
                    } else if (allTime == 2) {
                        if (vo.getTaskEndTime() == null || vo.getTaskEndTime().compareTo(new Date()) >= 0) {
                            useTimeVo = "-";
                            cutTimeVo = "-";
                            outRate = "-";
                        } else {
                            useTimeVo = "0";
                            cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                            outRate = "0%";
                        }
                    }
                    row.createCell(8).setCellValue(useTimeVo);
                    row.createCell(9).setCellValue(cutTimeVo);
                    row.createCell(10).setCellValue(outRate);
                    row.createCell(11).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                    String statusName = "";
                    statusName = vo.getTaskStatus() != null && vo.getTaskStatus() == 3 ? unPassName : (vo.getTaskStatus() != null && vo.getTaskStatus() == 4 ? passName : "-");
                    row.createCell(12).setCellValue(statusName);
                }
            } else {
                return "INVALID_TOKEN";
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            log.error("selectUserOfflineByExecl:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/updateUserTaskStatus"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String updateUserTaskStatus(Integer id, Integer userId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.jobCertificationService.updateUserTaskStatus(id, userId);
        }
        catch (Exception e) {
            log.error("updateUserTaskStatus:", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectUserPower"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserPower(@RequestBody TrainingJobCertificationVo job) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                return JsonResult.success((Object)this.jobCertificationService.selectUserPower(job, user));
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("selectUserPower:", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/saveIsMatchUser"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String saveIsMatchUser(@RequestParam(value="file") MultipartFile file, Integer jobId) {
        try {
            ArrayList resultList = new ArrayList();
            if (!file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xls") && !file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1).equals("xlsx")) {
                return JsonResult.error((String)"4", (Object)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef");
            }
            List<Object> page = new ArrayList();
            List<List<Object>> excelList0 = ExcelUtil.getBankListByExcel(file.getInputStream(), file.getOriginalFilename(), 0);
            if (!CollectionUtils.isEmpty(excelList0)) {
                ArrayList<ChecckUsersMo> usersMoList = new ArrayList<ChecckUsersMo>();
                for (int i = 1; i < excelList0.size(); ++i) {
                    List<Object> list = excelList0.get(i);
                    if (CollectionUtils.isEmpty(list)) continue;
                    ChecckUsersMo mo = new ChecckUsersMo();
                    Integer index = 0;
                    if (list.size() >= 1 && !org.springframework.util.StringUtils.isEmpty((Object)list.get(0))) {
                        String showName = list.get(0).toString().trim();
                        mo.setUserName(showName);
                        index = 1;
                    }
                    if (list.size() >= 2 && !org.springframework.util.StringUtils.isEmpty((Object)list.get(1))) {
                        String mobilePhone = list.get(1).toString().trim();
                        mo.setMobilePhone(mobilePhone);
                        index = 1;
                    }
                    if (list.size() >= 3 && !org.springframework.util.StringUtils.isEmpty((Object)list.get(2))) {
                        String employeeNumber = list.get(2).toString().trim();
                        mo.setEmployeeNumber(employeeNumber);
                        index = 1;
                    }
                    if (org.springframework.util.StringUtils.isEmpty((Object)mo) || index != 1) continue;
                    usersMoList.add(mo);
                }
                ChecckUsersApiMo usersApiMo = new ChecckUsersApiMo();
                usersApiMo.setUsersMoList(usersMoList);
                page = this.jobCertificationService.selectIsMatchUser(usersApiMo, jobId);
            }
            return JsonResult.success(page);
        }
        catch (Exception e) {
            log.error("\u5c97\u4f4d\u8ba4\u8bc1\u5b66\u5458\u7ba1\u7406\u662f\u5426\u5339\u914d:", (Object)e.getMessage());
            return JsonResult.error((String)"", (Object)e.getMessage());
        }
    }
}

