/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingLearnExamineService;
import com.ovopark.training.vo.TrainingLearnExamineVo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/trainingLearnExamine"})
public class TrainingLearnExamineController {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearnExamineController.class);
    @Autowired
    private TrainingLearnExamineService trainingLearnExamineService;

    @RequestMapping(value={"/addTrainingLearnExamine"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String addTrainingLearnExamine(@RequestBody TrainingLearnExamineVo trainingLearnExamineVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null && user.getId() == null) {
            return "INVALID_TOKEN";
        }
        Integer examineId = 0;
        if (trainingLearnExamineVo.getId() == null) {
            trainingLearnExamineVo.setExecutorId(user.getId());
            examineId = this.trainingLearnExamineService.saveTrainingLearnExamine(trainingLearnExamineVo);
        }
        return JsonResult.success((Object)examineId);
    }

    @RequestMapping(value={"/selectTrainingLearnExamine"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectTrainingLearnExamine(Integer userId, Integer shiftId, Integer learnUserId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null && user.getId() == null) {
            return "INVALID_TOKEN";
        }
        List<TrainingLearnExamineVo> trainingLearnExamineVos = this.trainingLearnExamineService.selectTrainingLearnExamine(learnUserId);
        return JsonResult.success(trainingLearnExamineVos);
    }
}

