/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.pojo.RolePojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingLearnShift;
import com.ovopark.training.model.TrainingLearnTaskUser;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingWorkDocument;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingLearnProjectService;
import com.ovopark.training.service.TrainingLearnUserService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.StudentReportCountVo;
import com.ovopark.training.vo.StudentReportRequestVo;
import com.ovopark.training.vo.StudentReportVo;
import com.ovopark.training.vo.TrainingLearnProjectVo;
import com.ovopark.training.vo.TrainingLearnShiftRecordVo;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import com.ovopark.training.vo.TrainingLearnTaskUserVo;
import com.ovopark.training.vo.TrainingLearnUserVo;
import com.ovopark.training.vo.TrainingProjectTaskVo;
import com.ovopark.training.vo.TrainingTaskScheduleVo;
import com.ovopark.training.vo.TrainingWorkUserAnswerVo;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/learn"})
public class TrainingLearnProjectController {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearnProjectController.class);
    @Autowired
    private TrainingLearnProjectService learnService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private UserUtilService userUtilService;
    @Autowired
    private UserOrganizeApi userOrganizeApi;
    @Autowired
    private TrainingLearnUserService taskUserService;
    @Autowired
    private TrainingLearnUserService learnUserService;

    @RequestMapping(value={"/selectLearnByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectLearnByPage(Page<TrainingLearnShiftVo> page, String creaters, String startTime, String endTime) {
        List creater;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            creater = null;
            if (!org.springframework.util.StringUtils.isEmpty((Object)creaters)) {
                String[] createrStr = creaters.split(",");
                List<String> createrS = Arrays.asList(createrStr);
                creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
        } else {
            return "INVALID_TOKEN";
        }
        page = this.learnService.selectLearnByPage(page, user, creater, startTime, endTime);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectLearnByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectLearnByExecl(HttpServletResponse response, String creaters, String startTime, String endTime) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                Page<TrainingLearnShiftVo> page = new Page<TrainingLearnShiftVo>();
                page.setPageNumber(1);
                page.setPageSize(9999);
                List creater = null;
                if (!org.springframework.util.StringUtils.isEmpty((Object)creaters)) {
                    String[] createrStr = creaters.split(",");
                    List<String> createrS = Arrays.asList(createrStr);
                    creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
                }
                page = this.learnService.selectLearnByPage(page, user, creater, startTime, endTime);
                List list = page.getContent();
                Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String openCount = this.messageSource.getMessage("training.shift.open.count", null, locale);
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String draft = this.messageSource.getMessage("training.job.status.draft", null, locale);
                String doing = this.messageSource.getMessage("training.job.status.doing", null, locale);
                String pending = this.messageSource.getMessage("training.job.status.pending", null, locale);
                String shiftClosed = this.messageSource.getMessage("training.job.status.shift.closed", null, locale);
                HSSFWorkbook wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(openCount);
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(employeeNumber);
                row.createCell(1).setCellValue(this.messageSource.getMessage("training.learn.class.founder", null, locale));
                row.createCell(2).setCellValue(this.messageSource.getMessage("training.learn.department", null, locale));
                row.createCell(3).setCellValue(this.messageSource.getMessage("training.learn.class.number", null, locale));
                row.createCell(4).setCellValue(draft);
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.learn.wait.online", null, locale));
                row.createCell(6).setCellValue(doing);
                row.createCell(7).setCellValue(pending);
                row.createCell(8).setCellValue(shiftClosed);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < list.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnShiftVo vo = (TrainingLearnShiftVo)list.get(i);
                    row.createCell(0).setCellValue(vo.getUserName());
                    row.createCell(1).setCellValue(vo.getCreatorName());
                    row.createCell(2).setCellValue(vo.getOrganizeName());
                    row.createCell(3).setCellValue(vo.getShiftNum());
                    row.createCell(4).setCellValue(vo.getNotNum());
                    row.createCell(5).setCellValue(vo.getWaitNum());
                    row.createCell(6).setCellValue(vo.getGoingNum());
                    row.createCell(7).setCellValue(vo.getClosingNum());
                    row.createCell(8).setCellValue(vo.getFinishNum());
                }
                response.setContentType("application/vnd.ms-excel; charset=utf-8");
                response.setHeader("Content-Disposition", "attachment; filename=" + openCount + ".xls");
                ServletOutputStream out = response.getOutputStream();
                wb.write((OutputStream)out);
                out.flush();
                out.close();
                wb.close();
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.info("selectLearnByExecl" + e);
            e.printStackTrace();
            return JsonResult.error();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/selectLearnPageNum"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectLearnPageNum(Page<TrainingLearnProjectVo> page, Integer id, String projectName, Integer projectType, Integer status, String creaters, String startTime, String endTime) {
        Integer pageSize = 1;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) return "INVALID_TOKEN";
        if (id == null) return JsonResult.paramError();
        List creater = null;
        if (!org.springframework.util.StringUtils.isEmpty((Object)creaters)) {
            String[] createrStr = creaters.split(",");
            List<String> createrS = Arrays.asList(createrStr);
            creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        pageSize = this.learnService.selectLearnPageNum(page, user, id, projectName, projectType, status, creater, startTime, endTime);
        return JsonResult.success((Object)pageSize);
    }

    @RequestMapping(value={"/selectLearnProjectByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectLearnProjectByPage(Page<TrainingLearnProjectVo> page, String projectName, Integer projectType, String status, String creaters, String startTime, String endTime) {
        List creater;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            creater = null;
            if (!org.springframework.util.StringUtils.isEmpty((Object)creaters)) {
                String[] createrStr = creaters.split(",");
                List<String> createrS = Arrays.asList(createrStr);
                creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
        } else {
            return "INVALID_TOKEN";
        }
        page = this.learnService.selectLearnProjectByPage(page, user, projectName, projectType, status, creater, startTime, endTime);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectLearnProject"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectLearnProject(@RequestBody TrainingLearnProjectVo project) {
        List<TrainingLearnProjectVo> projectList = null;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        projectList = this.learnService.selectLearnProject(project, user);
        return JsonResult.success(projectList);
    }

    @RequestMapping(value={"/selectLearnProjectRate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectLearnProjectRate(@RequestBody TrainingTaskScheduleVo scheduleVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.learnService.selectLearnProjectRate(scheduleVo, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/saveLearnProject"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveLearnProject(@RequestBody TrainingLearnProjectVo project) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                if (project.getAwardGold() != null && (project.getAwardGold() < 0 || project.getAwardGold() > 999)) {
                    return JsonResult.error((String)"\u91d1\u5e01\u8bbe\u7f6e\u8303\u56f4\u4e3a0-999", null);
                }
            } else {
                return "INVALID_TOKEN";
            }
            id = this.learnService.saveLearnProject(project, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/saveProjectPassRate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveProjectPassRate(@RequestBody TrainingLearnProjectVo project) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            if (project.getId() == null) {
                project.setEnterpriseId(user.getGroupId());
                project.setCreater(user.getId());
                project.setCreateTime(new Date());
            }
            this.taskUserService.saveProjectPassRate(project);
            return JsonResult.success();
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/deleteLearnProject"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteLearnProject(HttpServletRequest req, @RequestBody TrainingLearnProjectVo project) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                LogPojo pojo = new LogPojo();
                pojo.setUserId(user.getId());
                pojo.setOperation("study_program_delete");
                pojo.setCreateTime(new Date());
                pojo.setRemoteIp(req.getRemoteAddr());
                pojo.setEnterpriseId(user.getGroupId());
                pojo.setUserName(user.getUserName());
                pojo.setI18nKey("operation.study_program_delete.description");
                pojo.setPlatform(CommonUtil.getTerminalByToken(req));
                return this.learnService.deleteLearnProject(project, user, pojo);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectIsShift"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectIsShift(@RequestBody TrainingLearnShiftVo project) {
        Integer num = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            num = this.learnService.selectIsShift(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)num);
    }

    @RequestMapping(value={"/selectProjectTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectProjectTask(@RequestBody TrainingProjectTaskVo project) {
        TrainingProjectTaskVo projectList = null;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getId() == null) {
            return "INVALID_TOKEN";
        }
        projectList = this.learnService.selectProjectTask(project);
        return JsonResult.success((Object)projectList);
    }

    @RequestMapping(value={"/saveProjectTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveProjectTask(@RequestBody TrainingProjectTaskVo project) {
        Integer id = 0;
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            if (project.getId() == null) {
                project.setCreater(user.getId());
                project.setCreateTime(new Date());
            }
        } else {
            return "INVALID_TOKEN";
        }
        id = this.learnService.saveProjectTask(project, user);
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/saveProjectTaskSort"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveProjectTaskSort(@RequestBody TrainingProjectTaskVo project) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.learnService.saveProjectTaskSort(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectIsFinishShift"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectIsFinishShift(@RequestBody TrainingLearnShift project) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            id = this.learnService.selectIsFinishShift(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/deleteProjectTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteProjectTask(@RequestBody TrainingProjectTaskVo project) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.learnService.deleteProjectTask(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveTaskSchedule"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTaskSchedule(@RequestBody TrainingTaskScheduleVo project) {
        block4: {
            Integer id = 1;
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (user != null && user.getId() != null) {
                    id = this.learnService.saveTaskSchedule(project, user);
                    if (id == 0) {
                        return JsonResult.error((String)"\u73ed\u6b21\u65e0\u9879\u76ee\u4efb\u52a1\uff0c\u9700\u8981\u91cd\u5efa\u73ed\u6b21", null);
                    }
                    break block4;
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectShiftStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectShiftStatus(@RequestBody TrainingLearnShiftVo project) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            id = this.learnService.selectShiftStatus(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/saveFinishShift"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveFinishShift(@RequestBody TrainingLearnShiftVo project) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.learnService.saveFinishShift(project, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectNotFinishShift"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectNotFinishShift(@RequestBody TrainingLearnProjectVo project) {
        Integer id = 0;
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            id = this.learnService.selectNotFinishShift(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/selectFinishShift"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectFinishShift(@RequestBody TrainingLearnShiftVo project) {
        TrainingLearnShiftVo id = new TrainingLearnShiftVo();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            id = this.learnService.selectFinishShift(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/selectFinishProject"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectFinishProject(@RequestBody TrainingLearnProjectVo project) {
        TrainingLearnProjectVo id = new TrainingLearnProjectVo();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            id = this.learnService.selectFinishProject(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)id);
    }

    @RequestMapping(value={"/saveFinishProject"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveFinishProject(@RequestBody TrainingLearnProjectVo project) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.learnUserService.saveFinishProject(project, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectShiftTask"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectShiftTask(@RequestBody TrainingProjectTaskVo project) {
        TrainingLearnProjectVo vo = new TrainingLearnProjectVo();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            vo = this.learnService.selectShiftTask(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/selectShiftName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectShiftName(@RequestBody TrainingLearnShiftVo project) {
        List<Object> vo = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            vo = this.learnService.selectShiftName(project, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(vo);
    }

    @RequestMapping(value={"/selectShiftGroupName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectShiftGroupName(@RequestBody TrainingLearnShiftVo project) {
        List<Object> vo = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            vo = this.learnService.selectShiftGroupName(project, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(vo);
    }

    @RequestMapping(value={"/selectTaskAnalysis"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectTaskAnalysis(@RequestBody TrainingLearnShiftVo project) {
        Map<Object, Object> vo = new HashMap();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            vo = this.learnService.selectTaskAnalysis(project, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(vo);
    }

    @RequestMapping(value={"/selectUserTrainTaskByPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserTrainTaskByPage(@RequestBody Map<String, Object> project) {
        Page<TrainingLearnTaskUserVo> page = new Page<TrainingLearnTaskUserVo>();
        page.setPageSize(Integer.parseInt(project.get("pageSize").toString()));
        page.setPageNumber(Integer.parseInt(project.get("pageNumber").toString()));
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            project.put("user", user);
            page = this.learnService.selectUserTrainTaskByPage(page, project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectUserTrainTaskByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUserTrainTaskByExecl(HttpServletResponse response, String taskName, Integer taskId, Integer shiftId, Integer taskStatus, String creater) {
        Page<TrainingLearnTaskUserVo> page = new Page<TrainingLearnTaskUserVo>();
        page.setPageSize(9999);
        page.setPageNumber(1);
        HashMap<String, Object> project = new HashMap<String, Object>();
        project.put("taskId", taskId);
        project.put("shiftId", shiftId);
        project.put("taskStatus", taskStatus);
        project.put("creater", creater);
        try {
            HSSFWorkbook wb;
            Locale locale;
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                project.put("user", user);
                page = this.learnService.selectUserTrainTaskByPage(page, project);
                List voList = page.getContent();
                locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
                String statusNames = this.messageSource.getMessage("training.paper.status", null, locale);
                String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = this.messageSource.getMessage("training.job.status.going", null, locale);
                String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
                wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(taskName);
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFDataFormat dataFormat = wb.createDataFormat();
                titleSty.setDataFormat(dataFormat.getFormat("@"));
                sheet.setDefaultColumnStyle(1, (CellStyle)titleSty);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
                row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.id", null, locale));
                row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.username", null, locale));
                row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(4).setCellValue(employeeNumber);
                row.createCell(5).setCellValue(department);
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                row.createCell(7).setCellValue(this.messageSource.getMessage("training.job.post.name", null, locale));
                row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                row.createCell(9).setCellValue(this.messageSource.getMessage("training.learn.course.validity", null, locale));
                row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(12).setCellValue(this.messageSource.getMessage("training.course.analysis.study.time", null, locale));
                row.createCell(13).setCellValue(statusNames);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnTaskUserVo vo = (TrainingLearnTaskUserVo)voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                    row.createCell(1).setCellValue((double)vo.getUserId().intValue());
                    row.createCell(2).setCellValue(vo.getUserAccount());
                    row.createCell(3).setCellValue(vo.getUserName());
                    row.createCell(4).setCellValue(vo.getEmployeeNumber());
                    row.createCell(5).setCellValue(vo.getOrganizeName());
                    row.createCell(6).setCellValue(vo.getRole());
                    row.createCell(7).setCellValue(vo.getPost());
                    row.createCell(8).setCellValue(vo.getParentName());
                    row.createCell(9).setCellValue((vo.getTaskStartTime() == null ? "" : format.format(vo.getTaskStartTime())) + " - " + (vo.getTaskEndTime() == null ? "" : format.format(vo.getTaskEndTime())));
                    row.createCell(10).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(11).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    row.createCell(12).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                    String statusName = "";
                    if (vo.getTaskStatus() == 0) {
                        statusName = unStart;
                    } else if (vo.getTaskStatus() == 1) {
                        statusName = going;
                    } else if (vo.getTaskStatus() == 2) {
                        statusName = waitRead;
                    } else if (vo.getTaskStatus() == 3) {
                        statusName = unPassName;
                    } else if (vo.getTaskStatus() == 4) {
                        statusName = completed;
                    }
                    row.createCell(13).setCellValue(statusName);
                }
            } else {
                return "INVALID_TOKEN";
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectUserPaperStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperStatus(@RequestBody Map<String, Object> project) {
        Map<Object, Object> map = new HashMap();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            project.put("user", user);
            map = this.learnService.selectUserPaperStatus(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/selectUserPaperTaskByPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperTaskByPage(@RequestBody Map<String, Object> project) {
        Page<TrainingLearnTaskUserVo> page = new Page<TrainingLearnTaskUserVo>();
        page.setPageSize(Integer.parseInt(project.get("pageSize").toString()));
        page.setPageNumber(Integer.parseInt(project.get("pageNumber").toString()));
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (!Objects.nonNull(user) && !Objects.nonNull(user.getId())) {
                return "INVALID_TOKEN";
            }
            project.put("user", user);
            page = this.learnService.selectUserPaperTaskByPage(page, project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectUserPaperTaskByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperTaskByExecl(HttpServletResponse response, String taskName, Integer taskId, Integer shiftId, Integer taskStatus, String creater, Integer exportStatus) {
        block59: {
            Page<TrainingLearnTaskUserVo> page = new Page<TrainingLearnTaskUserVo>();
            page.setPageSize(9999);
            page.setPageNumber(1);
            HashMap<String, Object> project = new HashMap<String, Object>();
            project.put("taskId", taskId);
            project.put("shiftId", shiftId);
            project.put("taskStatus", taskStatus);
            project.put("creater", creater);
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (Objects.nonNull(user) || Objects.nonNull(user.getId())) {
                    String statusName;
                    List pojoList;
                    String shopName;
                    List pojoList2;
                    String organName5;
                    List pojoList3;
                    String organName4;
                    List pojoList4;
                    String organName3;
                    List pojoList5;
                    String organName2;
                    List<String> nameList;
                    String departName;
                    List pojoList6;
                    String organName1;
                    String parentName;
                    List listStr;
                    List pojoList7;
                    String roleName;
                    TrainingLearnTaskUserVo vo;
                    SimpleDateFormat format;
                    HSSFRow row;
                    HSSFFont font;
                    HSSFCellStyle titleSty;
                    HSSFSheet sheet;
                    HSSFWorkbook wb;
                    String passName;
                    String unPassName;
                    String waitRead;
                    String unStart;
                    BaseResult bases;
                    BaseResult base;
                    UsersAndOrgsMo mo1;
                    BaseResult base5;
                    BaseResult base4;
                    BaseResult base3;
                    BaseResult base2;
                    BaseResult base1;
                    UsersAndOrgsMo mo;
                    Map shopDetailMap;
                    Map shopMap;
                    Map organMap5;
                    Map organMap4;
                    Map organMap3;
                    Map organMap2;
                    Map organMap1;
                    Map<Object, Object> parentMap;
                    Map<Object, Object> roleMap;
                    Map<Integer, List<String>> organizeMap;
                    List<Integer> userIdList;
                    Locale locale;
                    List voList;
                    project.put("user", user);
                    if (exportStatus == null || exportStatus == 1) {
                        page = this.learnService.selectUserPaperTaskByPage(page, project);
                        voList = page.getContent();
                        locale = Authenticator.getInstance().getCurrentClient().getLocale();
                        userIdList = voList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
                        organizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                        roleMap = new HashMap();
                        parentMap = new HashMap();
                        organMap1 = new HashMap();
                        organMap2 = new HashMap();
                        organMap3 = new HashMap();
                        organMap4 = new HashMap();
                        organMap5 = new HashMap();
                        shopMap = new HashMap();
                        shopDetailMap = new HashMap();
                        if (!CollectionUtils.isEmpty(userIdList)) {
                            roleMap = this.userUtilService.selectRolesByUsers(userIdList, ((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            parentMap = this.userUtilService.selectParentMap(userIdList, ((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            mo = new UsersAndOrgsMo();
                            mo.setGroupId(((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            mo.setLevelList(Collections.singletonList(1));
                            mo.setUserIdList(userIdList);
                            mo.setShowDepartment(Boolean.valueOf(false));
                            base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base1 != null) {
                                organMap1 = (Map)base1.getData();
                            }
                            mo.setLevelList(Collections.singletonList(2));
                            base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base2 != null) {
                                organMap2 = (Map)base2.getData();
                            }
                            mo.setLevelList(Collections.singletonList(3));
                            base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base3 != null) {
                                organMap3 = (Map)base3.getData();
                            }
                            mo.setLevelList(Collections.singletonList(4));
                            base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base4 != null) {
                                organMap4 = (Map)base4.getData();
                            }
                            mo.setLevelList(Collections.singletonList(5));
                            base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base5 != null) {
                                organMap5 = (Map)base5.getData();
                            }
                            mo1 = new UsersAndOrgsMo();
                            mo1.setGroupId(((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            mo1.setUserIdList(userIdList);
                            mo1.setShowDepartment(Boolean.valueOf(true));
                            base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                            if (base != null && base.getData() != null) {
                                shopMap = (Map)base.getData();
                            }
                            mo1.setShowAllPath(Boolean.valueOf(true));
                            bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                            if (bases != null && bases.getData() != null) {
                                shopDetailMap = (Map)bases.getData();
                            }
                        }
                        unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                        waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                        unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                        passName = this.messageSource.getMessage("training.paper.pass", null, locale);
                        wb = new HSSFWorkbook();
                        sheet = wb.createSheet(taskName);
                        titleSty = wb.createCellStyle();
                        font = wb.createFont();
                        font.setFontHeightInPoints((short)16);
                        titleSty.setFont((Font)font);
                        row = sheet.createRow(0);
                        row.createCell(0).setCellValue("id");
                        row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                        row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                        row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                        row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                        row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
                        row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                        row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                        row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                        row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                        row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                        row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                        row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.finish.time", null, locale));
                        row.createCell(13).setCellValue(this.messageSource.getMessage("training.paper.num", null, locale));
                        row.createCell(14).setCellValue(this.messageSource.getMessage("training.course.average.time", null, locale));
                        row.createCell(15).setCellValue(this.messageSource.getMessage("training.certificate.paper.score", null, locale));
                        row.createCell(16).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
                        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        for (int i = 0; i < voList.size(); ++i) {
                            row = sheet.createRow(i + 1);
                            vo = (TrainingLearnTaskUserVo)voList.get(i);
                            row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                            row.createCell(1).setCellValue(vo.getUserName());
                            row.createCell(2).setCellValue(vo.getEmployeeNumber());
                            roleName = "";
                            if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                                listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                                roleName = StringUtils.join(listStr, (String)",");
                            }
                            row.createCell(3).setCellValue(roleName);
                            parentName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                                parentName = (String)parentMap.get(vo.getUserId());
                            }
                            row.createCell(4).setCellValue(parentName);
                            organName1 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                                pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                                organName1 = StringUtils.join(pojoList6, (String)",");
                            }
                            departName = "";
                            nameList = organizeMap.get(vo.getUserId());
                            if (!CollectionUtils.isEmpty(nameList)) {
                                departName = String.join((CharSequence)";\n", nameList);
                            }
                            row.createCell(5).setCellValue(departName);
                            row.createCell(6).setCellValue(organName1);
                            organName2 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                                pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                                organName2 = StringUtils.join(pojoList5, (String)",");
                            }
                            row.createCell(7).setCellValue(organName2);
                            organName3 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                                pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                                organName3 = StringUtils.join(pojoList4, (String)",");
                            }
                            row.createCell(8).setCellValue(organName3);
                            organName4 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                                pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                                organName4 = StringUtils.join(pojoList3, (String)",");
                            }
                            row.createCell(9).setCellValue(organName4);
                            organName5 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                                pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                                organName5 = StringUtils.join(pojoList2, (String)",");
                            }
                            row.createCell(10).setCellValue(organName5);
                            shopName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                shopName = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(11).setCellValue(shopName);
                            row.createCell(12).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                            row.createCell(13).setCellValue(vo.getPaperCount() == null ? "-" : vo.getPaperCount().toString());
                            row.createCell(14).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                            row.createCell(15).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                            statusName = "";
                            if (vo.getTaskStatus() == 0) {
                                statusName = unStart;
                            } else if (vo.getTaskStatus() == 1) {
                                statusName = this.messageSource.getMessage("training.course.status.ing", null, locale);
                            } else if (vo.getTaskStatus() == 2) {
                                statusName = waitRead;
                            } else if (vo.getTaskStatus() == 3) {
                                statusName = unPassName;
                            } else if (vo.getTaskStatus() == 4) {
                                statusName = passName;
                            }
                            row.createCell(16).setCellValue(statusName);
                        }
                        response.setContentType("application/vnd.ms-excel; charset=utf-8");
                        response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
                        ServletOutputStream out = response.getOutputStream();
                        wb.write((OutputStream)out);
                        out.flush();
                        out.close();
                        wb.close();
                    }
                    if (exportStatus == 2) {
                        page = this.learnService.selectUserPaperTaskByPage2(page, project);
                        voList = page.getContent();
                        locale = Authenticator.getInstance().getCurrentClient().getLocale();
                        userIdList = voList.stream().map(TrainingLearnTaskUser::getUserId).distinct().collect(Collectors.toList());
                        organizeMap = this.userUtilService.selectOrganizeMap(userIdList, user.getGroupId());
                        roleMap = new HashMap();
                        parentMap = new HashMap();
                        organMap1 = new HashMap();
                        organMap2 = new HashMap();
                        organMap3 = new HashMap();
                        organMap4 = new HashMap();
                        organMap5 = new HashMap();
                        shopMap = new HashMap();
                        shopDetailMap = new HashMap();
                        if (!CollectionUtils.isEmpty(userIdList)) {
                            roleMap = this.userUtilService.selectRolesByUsers(userIdList, ((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            parentMap = this.userUtilService.selectParentMap(userIdList, ((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            mo = new UsersAndOrgsMo();
                            mo.setGroupId(((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            mo.setLevelList(Collections.singletonList(1));
                            mo.setUserIdList(userIdList);
                            mo.setShowDepartment(Boolean.valueOf(false));
                            base1 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base1 != null) {
                                organMap1 = (Map)base1.getData();
                            }
                            mo.setLevelList(Collections.singletonList(2));
                            base2 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base2 != null) {
                                organMap2 = (Map)base2.getData();
                            }
                            mo.setLevelList(Collections.singletonList(3));
                            base3 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base3 != null) {
                                organMap3 = (Map)base3.getData();
                            }
                            mo.setLevelList(Collections.singletonList(4));
                            base4 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base4 != null) {
                                organMap4 = (Map)base4.getData();
                            }
                            mo.setLevelList(Collections.singletonList(5));
                            base5 = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo);
                            if (base5 != null) {
                                organMap5 = (Map)base5.getData();
                            }
                            mo1 = new UsersAndOrgsMo();
                            mo1.setGroupId(((TrainingLearnTaskUserVo)voList.get(0)).getEnterpriseId());
                            mo1.setUserIdList(userIdList);
                            mo1.setShowDepartment(Boolean.valueOf(true));
                            base = this.userOrganizeApi.getUserOrganizeLevelByUserIds(mo1);
                            if (base != null && base.getData() != null) {
                                shopMap = (Map)base.getData();
                            }
                            mo1.setShowAllPath(Boolean.valueOf(true));
                            bases = this.userOrganizeApi.getUserOrganizePathtByUserIds(mo1);
                            if (bases != null && bases.getData() != null) {
                                shopDetailMap = (Map)bases.getData();
                            }
                        }
                        unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                        waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
                        unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                        passName = this.messageSource.getMessage("training.paper.pass", null, locale);
                        wb = new HSSFWorkbook();
                        sheet = wb.createSheet(taskName);
                        titleSty = wb.createCellStyle();
                        font = wb.createFont();
                        font.setFontHeightInPoints((short)16);
                        titleSty.setFont((Font)font);
                        row = sheet.createRow(0);
                        row.createCell(0).setCellValue("id");
                        row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                        row.createCell(2).setCellValue(this.messageSource.getMessage("training.user.details.employeeNumber", null, locale));
                        row.createCell(3).setCellValue(this.messageSource.getMessage("training.course.analysis.role", null, locale));
                        row.createCell(4).setCellValue(this.messageSource.getMessage("training.course.analysis.superior", null, locale));
                        row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.analysis.department", null, locale));
                        row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.first.organize", null, locale));
                        row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.second.organize", null, locale));
                        row.createCell(8).setCellValue(this.messageSource.getMessage("training.course.analysis.third.organize", null, locale));
                        row.createCell(9).setCellValue(this.messageSource.getMessage("training.course.analysis.fourth.organize", null, locale));
                        row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.analysis.fifth.organize", null, locale));
                        row.createCell(11).setCellValue(this.messageSource.getMessage("training.course.analysis.dep", null, locale));
                        row.createCell(12).setCellValue(this.messageSource.getMessage("training.paper.handtime", null, locale));
                        row.createCell(13).setCellValue(this.messageSource.getMessage("training.operate.usetime", null, locale));
                        row.createCell(14).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
                        row.createCell(15).setCellValue(this.messageSource.getMessage("training.paper.status", null, locale));
                        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        for (int i = 0; i < voList.size(); ++i) {
                            row = sheet.createRow(i + 1);
                            vo = (TrainingLearnTaskUserVo)voList.get(i);
                            row.createCell(0).setCellValue(String.valueOf(vo.getUserId()));
                            row.createCell(1).setCellValue(vo.getUserName());
                            row.createCell(2).setCellValue(vo.getEmployeeNumber());
                            roleName = "";
                            if (!CollectionUtils.isEmpty(roleMap) && !CollectionUtils.isEmpty((Collection)(pojoList7 = (List)roleMap.get(vo.getUserId())))) {
                                listStr = pojoList7.stream().map(RolePojo::getRoleName).filter(Objects::nonNull).collect(Collectors.toList());
                                roleName = StringUtils.join(listStr, (String)",");
                            }
                            row.createCell(3).setCellValue(roleName);
                            parentName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(parentMap)) {
                                parentName = (String)parentMap.get(vo.getUserId());
                            }
                            row.createCell(4).setCellValue(parentName);
                            organName1 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap1) && !CollectionUtils.isEmpty((Collection)(pojoList6 = (List)organMap1.get(vo.getUserId())))) {
                                pojoList6 = pojoList6.stream().distinct().collect(Collectors.toList());
                                organName1 = StringUtils.join(pojoList6, (String)",");
                            }
                            departName = "";
                            nameList = organizeMap.get(vo.getUserId());
                            if (!CollectionUtils.isEmpty(nameList)) {
                                departName = String.join((CharSequence)";\n", nameList);
                            }
                            row.createCell(5).setCellValue(departName);
                            row.createCell(6).setCellValue(organName1);
                            organName2 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap2) && !CollectionUtils.isEmpty((Collection)(pojoList5 = (List)organMap2.get(vo.getUserId())))) {
                                pojoList5 = pojoList5.stream().distinct().collect(Collectors.toList());
                                organName2 = StringUtils.join(pojoList5, (String)",");
                            }
                            row.createCell(7).setCellValue(organName2);
                            organName3 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap3) && !CollectionUtils.isEmpty((Collection)(pojoList4 = (List)organMap3.get(vo.getUserId())))) {
                                pojoList4 = pojoList4.stream().distinct().collect(Collectors.toList());
                                organName3 = StringUtils.join(pojoList4, (String)",");
                            }
                            row.createCell(8).setCellValue(organName3);
                            organName4 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap4) && !CollectionUtils.isEmpty((Collection)(pojoList3 = (List)organMap4.get(vo.getUserId())))) {
                                pojoList3 = pojoList3.stream().distinct().collect(Collectors.toList());
                                organName4 = StringUtils.join(pojoList3, (String)",");
                            }
                            row.createCell(9).setCellValue(organName4);
                            organName5 = "";
                            if (!org.springframework.util.StringUtils.isEmpty(organMap5) && !CollectionUtils.isEmpty((Collection)(pojoList2 = (List)organMap5.get(vo.getUserId())))) {
                                pojoList2 = pojoList2.stream().distinct().collect(Collectors.toList());
                                organName5 = StringUtils.join(pojoList2, (String)",");
                            }
                            row.createCell(10).setCellValue(organName5);
                            shopName = "";
                            if (!org.springframework.util.StringUtils.isEmpty(shopMap) && !CollectionUtils.isEmpty((Collection)(pojoList = (List)shopMap.get(vo.getUserId())))) {
                                pojoList = pojoList.stream().distinct().collect(Collectors.toList());
                                shopName = StringUtils.join(pojoList, (String)",");
                            }
                            row.createCell(11).setCellValue(shopName);
                            row.createCell(12).setCellValue(vo.getCommitTime() == null ? "-" : format.format(vo.getCommitTime()));
                            row.createCell(13).setCellValue(vo.getUseTimeFormal() == null ? "-" : vo.getUseTimeFormal());
                            statusName = "";
                            String score = "";
                            if (vo.getTaskStatus() == 1 || vo.getTaskStatus() == 0) {
                                String unexam;
                                statusName = unexam = this.messageSource.getMessage("training.paper.unexam", null, locale);
                                score = "-";
                            } else if (vo.getTaskStatus() == 2) {
                                statusName = this.messageSource.getMessage("training.paper.ing", null, locale);
                                score = "-";
                            } else if (vo.getTaskStatus() == 3) {
                                statusName = passName;
                                score = String.valueOf(vo.getScore());
                            } else if (vo.getTaskStatus() == 4) {
                                statusName = unPassName;
                                score = String.valueOf(vo.getScore());
                            } else if (vo.getTaskStatus() == 5) {
                                statusName = waitRead;
                                score = "-";
                            }
                            row.createCell(14).setCellValue(score);
                            row.createCell(15).setCellValue(statusName);
                        }
                        response.setContentType("application/vnd.ms-excel; charset=utf-8");
                        response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
                        ServletOutputStream out = response.getOutputStream();
                        wb.write((OutputStream)out);
                        out.flush();
                        out.close();
                        wb.close();
                    }
                    break block59;
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectUserPaperDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserPaperDetail(@RequestBody TrainingUserPaper project) {
        List<Object> vo = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            vo = this.learnService.selectUserPaperDetail(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(vo);
    }

    @RequestMapping(value={"/selectUserOfflineTaskByPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserOfflineTaskByPage(@RequestBody Map project) {
        Page<TrainingLearnTaskUserVo> page = new Page<TrainingLearnTaskUserVo>();
        page.setPageSize(Integer.parseInt(project.get("pageSize").toString()));
        page.setPageNumber(Integer.parseInt(project.get("pageNumber").toString()));
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            project.put("user", user);
            page = this.learnService.selectUserOfflineTaskByPage(page, project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectUserOfflineTaskByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUserOfflineTaskByExecl(HttpServletResponse response, String taskName, Integer taskId, Integer shiftId, String creater) {
        Page<TrainingLearnTaskUserVo> page = new Page<TrainingLearnTaskUserVo>();
        page.setPageSize(9999);
        page.setPageNumber(1);
        HashMap<String, Object> project = new HashMap<String, Object>();
        project.put("taskId", taskId);
        project.put("shiftId", shiftId);
        project.put("creater", creater);
        try {
            HSSFWorkbook wb;
            Locale locale;
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                project.put("user", user);
                page = this.learnService.selectUserOfflineTaskByPage(page, project);
                List voList = page.getContent();
                locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
                String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
                String passName = this.messageSource.getMessage("training.learn.pass", null, locale);
                String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(taskName);
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
                row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
                row.createCell(2).setCellValue(employeeNumber);
                row.createCell(3).setCellValue(department);
                row.createCell(4).setCellValue(this.messageSource.getMessage("training.certificate.activity.validity", null, locale));
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.certificate.activity.time", null, locale) + this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.certificate.sign.time", null, locale));
                row.createCell(7).setCellValue(this.messageSource.getMessage("training.certificate.signout.time", null, locale));
                row.createCell(8).setCellValue(this.messageSource.getMessage("training.job.participation.number", null, locale) + this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(9).setCellValue(this.messageSource.getMessage("training.absences.number", null, locale) + this.messageSource.getMessage("training.material.hours", null, locale));
                row.createCell(10).setCellValue(this.messageSource.getMessage("training.course.attendance", null, locale));
                row.createCell(11).setCellValue(this.messageSource.getMessage("training.certificate.mark", null, locale));
                row.createCell(12).setCellValue(passStatusName);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnTaskUserVo vo = (TrainingLearnTaskUserVo)voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                    row.createCell(1).setCellValue(vo.getUserName());
                    row.createCell(2).setCellValue(vo.getEmployeeNumber());
                    row.createCell(3).setCellValue(vo.getOrganizeName());
                    row.createCell(4).setCellValue((vo.getTaskStartTime() == null ? "" : format.format(vo.getTaskStartTime())) + " - " + (vo.getTaskEndTime() == null ? "" : format.format(vo.getTaskEndTime())));
                    row.createCell(5).setCellValue(vo.getActTime() == null ? "" : vo.getActTime().toString());
                    row.createCell(6).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(7).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    int allTime = vo.getIsAllTime();
                    String useTimeVo = "";
                    String cutTimeVo = "";
                    String outRate = "";
                    if (allTime == 0) {
                        useTimeVo = vo.getUseTimeVo() == null ? "" : vo.getUseTimeVo().toString();
                        cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                        outRate = vo.getOutRate() == null ? "" : vo.getOutRate().toString() + "%";
                    } else if (allTime == 1) {
                        useTimeVo = "-";
                        cutTimeVo = "-";
                        outRate = "-";
                    } else if (allTime == 2) {
                        if (vo.getTaskEndTime() == null || vo.getTaskEndTime().compareTo(new Date()) >= 0) {
                            useTimeVo = "-";
                            cutTimeVo = "-";
                            outRate = "-";
                        } else {
                            useTimeVo = "0";
                            cutTimeVo = vo.getCutTimeVo() == null ? "" : vo.getCutTimeVo().toString();
                            outRate = "0%";
                        }
                    }
                    row.createCell(8).setCellValue(useTimeVo);
                    row.createCell(9).setCellValue(cutTimeVo);
                    row.createCell(10).setCellValue(outRate);
                    row.createCell(11).setCellValue(vo.getScore() == null ? "-" : vo.getScore().toString());
                    String statusName = "";
                    statusName = vo.getTaskStatus() != null && vo.getTaskStatus() == 3 ? unPassName : (vo.getTaskStatus() != null && vo.getTaskStatus() == 4 ? passName : "-");
                    row.createCell(12).setCellValue(statusName);
                }
            } else {
                return "INVALID_TOKEN";
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.task.detail", null, locale) + "_" + taskName + ".xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectUserWorkTaskByPage"})
    @ResponseBody
    public String selectUserWorkTaskByPage(@RequestBody Map project) {
        Page<TrainingLearnTaskUserVo> page = new Page<TrainingLearnTaskUserVo>();
        page.setPageSize(Integer.parseInt(project.get("pageSize").toString()));
        page.setPageNumber(Integer.parseInt(project.get("pageNumber").toString()));
        Users user = Authenticator.getInstance().getCurrentUser();
        project.put("user", user);
        page = this.learnService.selectUserWorkTaskByPage(page, project);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectUserWorkTaskByExecl"})
    @ResponseBody
    public String selectUserWorkTaskByExecl(HttpServletResponse response, String taskName, Integer taskId, Integer shiftId, String creater, Integer taskStatus) {
        HashMap<String, Object> project = new HashMap<String, Object>();
        project.put("taskId", taskId);
        project.put("shiftId", shiftId);
        project.put("creater", creater);
        project.put("taskStatus", taskStatus);
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            project.put("user", user);
            List<TrainingLearnTaskUserVo> voList = this.learnService.selectUserWorkTaskByExecl(project);
            TrainingTaskScheduleVo trainingTaskScheduleVo = new TrainingTaskScheduleVo();
            trainingTaskScheduleVo.setTaskId(taskId);
            TrainingLearnProjectVo learnProjectVo = this.learnService.selectLearnProjectVo(trainingTaskScheduleVo);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
            String statusNames = this.messageSource.getMessage("training.paper.status", null, locale);
            String reviewerName = this.messageSource.getMessage("training.job.reviewer", null, locale);
            String waitRead = this.messageSource.getMessage("training.learn.wait.read", null, locale);
            String passName = this.messageSource.getMessage("training.job.status.pass", null, locale);
            String notPassName = this.messageSource.getMessage("training.job.status.not.pass", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(taskName);
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            HSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.user.details.name", null, locale));
            row.createCell(2).setCellValue(employeeNumber);
            row.createCell(3).setCellValue(department);
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.learn.job.validity", null, locale));
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.course.submit.time", null, locale));
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.learn.respond.content", null, locale));
            row.createCell(7).setCellValue(this.messageSource.getMessage("training.learn.attach", null, locale));
            row.createCell(8).setCellValue(statusNames);
            row.createCell(9).setCellValue(this.messageSource.getMessage("training.paper.score", null, locale));
            row.createCell(10).setCellValue(reviewerName);
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.learn.comment.content", null, locale));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            SimpleDateFormat formats = new SimpleDateFormat("yyyyMMdd");
            String execlName = learnProjectVo.getProjectName() + "_" + taskName + "_" + formats.format(new Date());
            if (!CollectionUtils.isEmpty(voList)) {
                for (int i = 0; i < voList.size(); ++i) {
                    List pathList;
                    row = sheet.createRow(i + 1);
                    TrainingLearnTaskUserVo vo = voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                    row.createCell(1).setCellValue(vo.getUserName());
                    row.createCell(2).setCellValue(vo.getEmployeeNumber());
                    row.createCell(3).setCellValue(vo.getOrganizeName());
                    row.createCell(4).setCellValue(vo.getStartTime() == null ? "" : format.format(vo.getStartTime()) + " -> " + format.format(vo.getEndTime()));
                    TrainingWorkUserAnswerVo userAnswerVo = vo.getWorkUserAnswerVo();
                    row.createCell(5).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) && !org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo.getCommitTime()) ? format.format(userAnswerVo.getCommitTime()) : "");
                    row.createCell(6).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) ? userAnswerVo.getAnswer() : "");
                    String url = "";
                    if (!(org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) || CollectionUtils.isEmpty((Collection)userAnswerVo.getWorkDocumentList()) || CollectionUtils.isEmpty(pathList = userAnswerVo.getWorkDocumentList().stream().map(TrainingWorkDocument::getPath).filter(Objects::nonNull).distinct().collect(Collectors.toList())))) {
                        url = String.join((CharSequence)";", pathList);
                    }
                    row.createCell(7).setCellValue(url);
                    String statusName = "";
                    statusName = vo.getTaskStatus() != null && vo.getTaskStatus() == 2 ? waitRead : (vo.getTaskStatus() != null && vo.getTaskStatus() == 3 ? notPassName : (vo.getTaskStatus() != null && vo.getTaskStatus() == 4 ? passName : this.messageSource.getMessage("training.course.unsubmit", null, locale)));
                    row.createCell(8).setCellValue(statusName);
                    row.createCell(9).setCellValue(vo.getScore() == null ? "" : vo.getScore().toString());
                    row.createCell(10).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) ? userAnswerVo.getRemarkerName() : "");
                    row.createCell(11).setCellValue(!org.springframework.util.StringUtils.isEmpty((Object)userAnswerVo) ? userAnswerVo.getComment() : "");
                }
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + execlName + ".xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectLearnUserStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectLearnUserStatus(@RequestBody Map project) {
        Map<Object, Object> map = new HashMap();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            project.put("user", user);
            map = this.learnService.selectLearnUserStatus(project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/selectUserTaskByPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectUserTaskByPage(@RequestBody Map project) {
        Page<TrainingLearnUserVo> page = new Page<TrainingLearnUserVo>();
        page.setPageSize(Integer.parseInt(project.get("pageSize").toString()));
        page.setPageNumber(Integer.parseInt(project.get("pageNumber").toString()));
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            project.put("user", user);
            page = this.learnUserService.selectUserTaskByPage(page, project);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectUserTaskByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectUserTaskByExecl(HttpServletResponse response, Integer projectId, Integer id, String groupName, Integer creatorId, String userName) {
        Page<TrainingLearnUserVo> page = new Page<TrainingLearnUserVo>();
        page.setPageSize(9999);
        page.setPageNumber(1);
        HashMap<String, Object> project = new HashMap<String, Object>();
        project.put("projectId", projectId);
        project.put("id", id);
        project.put("groupName", groupName);
        project.put("creatorId", creatorId);
        project.put("userName", userName);
        try {
            HSSFWorkbook wb;
            Locale locale;
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                project.put("user", user);
                page = this.learnUserService.selectUserTaskByPage(page, project);
                List voList = page.getContent();
                locale = Authenticator.getInstance().getCurrentClient().getLocale();
                String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
                String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
                String leader = this.messageSource.getMessage("training.course.analysis.superior", null, locale);
                String studyStatus = this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
                String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
                String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
                String going = this.messageSource.getMessage("training.job.status.going", null, locale);
                String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
                String unPassName = this.messageSource.getMessage("training.learn.unpass", null, locale);
                String passName = this.messageSource.getMessage("training.paper.pass", null, locale);
                wb = new HSSFWorkbook();
                HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.course.student.analysis", null, locale));
                HSSFCellStyle titleSty = wb.createCellStyle();
                HSSFFont font = wb.createFont();
                font.setFontHeightInPoints((short)16);
                titleSty.setFont((Font)font);
                HSSFRow row = sheet.createRow(0);
                row.createCell(0).setCellValue(this.messageSource.getMessage("training.learn.shift.classes.name", null, locale));
                row.createCell(1).setCellValue(employeeNumber);
                row.createCell(2).setCellValue(this.messageSource.getMessage("training.course.trainee.name", null, locale));
                row.createCell(3).setCellValue(department);
                row.createCell(4).setCellValue(leader);
                row.createCell(5).setCellValue(this.messageSource.getMessage("training.learn.arrival.time", null, locale));
                row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.analysis.starttime", null, locale));
                row.createCell(7).setCellValue(this.messageSource.getMessage("training.course.analysis.endtime", null, locale));
                row.createCell(8).setCellValue(studyStatus);
                row.createCell(9).setCellValue(this.messageSource.getMessage("training.paper.total.score", null, locale));
                row.createCell(10).setCellValue(passStatusName);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (int i = 0; i < voList.size(); ++i) {
                    row = sheet.createRow(i + 1);
                    TrainingLearnUserVo vo = (TrainingLearnUserVo)voList.get(i);
                    row.createCell(0).setCellValue(vo.getShiftName() + "-" + vo.getGroupName() + "-" + vo.getSupplemenName());
                    row.createCell(1).setCellValue(vo.getJobNumber());
                    row.createCell(2).setCellValue(vo.getUserName());
                    row.createCell(3).setCellValue(vo.getDepartment());
                    row.createCell(4).setCellValue(vo.getParentName());
                    row.createCell(5).setCellValue(vo.getCreateTime() == null ? "-" : format.format(vo.getCreateTime()));
                    row.createCell(6).setCellValue(vo.getStartTime() == null ? "-" : format.format(vo.getStartTime()));
                    row.createCell(7).setCellValue(vo.getEndTime() == null ? "-" : format.format(vo.getEndTime()));
                    if (vo.getLearnStatus() != null) {
                        if (vo.getLearnStatus() == 0) {
                            row.createCell(8).setCellValue(unStart + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        } else if (vo.getLearnStatus() == 1) {
                            row.createCell(8).setCellValue(unStart + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        } else if (vo.getLearnStatus() == 2) {
                            row.createCell(8).setCellValue(going + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        } else if (vo.getLearnStatus() == 3) {
                            row.createCell(8).setCellValue(completed + " " + vo.getFinishTask() + "/" + vo.getLearnTask());
                        }
                    } else {
                        row.createCell(8).setCellValue("-");
                    }
                    if (vo.getScore() != null) {
                        row.createCell(9).setCellValue(vo.getScore().setScale(1, 4).toString());
                    } else {
                        row.createCell(9).setCellValue("-");
                    }
                    if (vo.getPassStatus() != null) {
                        if (vo.getPassStatus() == 1) {
                            row.createCell(10).setCellValue(passName);
                            continue;
                        }
                        row.createCell(10).setCellValue(unPassName);
                        continue;
                    }
                    row.createCell(10).setCellValue("-");
                }
            } else {
                return "INVALID_TOKEN";
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + this.messageSource.getMessage("training.course.student.analysis", null, locale) + ".xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @PostMapping(value={"/studentReport"})
    @ResponseBody
    public String studentReport(@RequestBody StudentReportRequestVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getGroupId() == null) {
                return JsonResult.invalidPrivilege();
            }
            vo.setEnterpriseId(user.getGroupId());
            Page<StudentReportVo> studentReportVoPage = this.learnService.studentReportByPage(vo);
            return JsonResult.success(studentReportVoPage);
        }
        catch (Exception e) {
            log.error("studentReport error:", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @PostMapping(value={"/count"})
    @ResponseBody
    public String count(@RequestBody StudentReportRequestVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getGroupId() == null) {
            return JsonResult.invalidPrivilege();
        }
        if (vo.getShiftStatus() == null) {
            vo.setShiftStatus(Integer.valueOf(9));
        } else if (vo.getShiftStatus() == -1 || vo.getShiftStatus() == 0 || vo.getShiftStatus() == 1) {
            StudentReportCountVo res = new StudentReportCountVo();
            res.setFinishNum(Integer.valueOf(0));
            res.setTotal(Integer.valueOf(0));
            res.setPassNum(Integer.valueOf(0));
            res.setNoNum(Integer.valueOf(0));
            res.setIngNum(Integer.valueOf(0));
            return JsonResult.success((Object)res);
        }
        vo.setEnterpriseId(user.getGroupId());
        StudentReportCountVo studentReportCountVo = this.learnService.studentReportCount(vo);
        return JsonResult.success((Object)studentReportCountVo);
    }

    @RequestMapping(value={"/download"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String download(HttpServletResponse response, @RequestBody StudentReportRequestVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null || user.getGroupId() == null) {
            return JsonResult.invalidPrivilege();
        }
        vo.setEnterpriseId(user.getGroupId());
        try {
            List<StudentReportVo> list = this.learnService.studentReports(vo);
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String postName = this.messageSource.getMessage("training.job.post.name", null, locale);
            String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
            String leader = this.messageSource.getMessage("training.course.analysis.superior", null, locale);
            String studyStatus = this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
            String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
            String draft = this.messageSource.getMessage("training.job.status.draft", null, locale);
            String waitOnline = this.messageSource.getMessage("training.job.status.wait.online", null, locale);
            String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
            String waitOpen = this.messageSource.getMessage("training.job.status.wait.open", null, locale);
            String doing = this.messageSource.getMessage("training.job.status.doing", null, locale);
            String going = this.messageSource.getMessage("training.job.status.going", null, locale);
            String pending = this.messageSource.getMessage("training.job.status.pending", null, locale);
            String shiftClosed = this.messageSource.getMessage("training.job.status.shift.closed", null, locale);
            String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.learn.student.report", null, locale));
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            HSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue(this.messageSource.getMessage("training.learn.project.name", null, locale));
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.learn.classes.name", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.learn.class.founder", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.learn.class.time", null, locale));
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.learn.classes.validity", null, locale));
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.learn.classes.status", null, locale));
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.trainee.name", null, locale));
            row.createCell(7).setCellValue(employeeNumber);
            row.createCell(8).setCellValue(postName);
            row.createCell(9).setCellValue(department);
            row.createCell(10).setCellValue(leader);
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.learn.arrival.time", null, locale));
            row.createCell(12).setCellValue(studyStatus);
            row.createCell(13).setCellValue(this.messageSource.getMessage("training.paper.total.score", null, locale));
            row.createCell(14).setCellValue(this.messageSource.getMessage("training.job.online.paper.avgscore", null, locale));
            row.createCell(15).setCellValue(this.messageSource.getMessage("training.job.offline.paper.avgscore", null, locale));
            row.createCell(16).setCellValue(passStatusName);
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1);
                StudentReportVo reportVo = list.get(i);
                row.createCell(0).setCellValue(reportVo.getProjectName());
                row.createCell(1).setCellValue(reportVo.getShiftInfoDesc());
                row.createCell(2).setCellValue(reportVo.getCreatorName());
                row.createCell(3).setCellValue(StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftCreateTime()));
                String shiftTermOfValidity = "-";
                if (reportVo.getShiftCreateTime() != null) {
                    if (reportVo.getIsNotimeLimit() != null && reportVo.getIsNotimeLimit() == 1) {
                        shiftTermOfValidity = StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftCreateTime()) + " -> \u65e0\u9650\u671f";
                    } else if (reportVo.getShiftEndTime() != null) {
                        shiftTermOfValidity = StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftCreateTime()) + " -> " + StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftEndTime());
                    }
                }
                row.createCell(4).setCellValue(shiftTermOfValidity);
                String shiftStatusDesc = "-";
                if (reportVo.getShiftStatus() != null) {
                    if (reportVo.getShiftStatus() == 0) {
                        shiftStatusDesc = draft;
                    } else if (reportVo.getShiftStatus() == 1) {
                        shiftStatusDesc = waitOpen;
                    } else if (reportVo.getShiftStatus() == 2) {
                        shiftStatusDesc = doing;
                    } else if (reportVo.getShiftStatus() == 3) {
                        shiftStatusDesc = pending;
                    } else if (reportVo.getShiftStatus() == 4) {
                        shiftStatusDesc = shiftClosed;
                    } else if (reportVo.getShiftStatus() == 5) {
                        shiftStatusDesc = unStart;
                    } else if (reportVo.getShiftStatus() == 6) {
                        shiftStatusDesc = going;
                    } else if (reportVo.getShiftStatus() == 7) {
                        shiftStatusDesc = ended;
                    }
                }
                row.createCell(5).setCellValue(shiftStatusDesc);
                row.createCell(6).setCellValue(reportVo.getUserName());
                row.createCell(7).setCellValue(reportVo.getJobNumber());
                row.createCell(8).setCellValue(reportVo.getDutiesName());
                row.createCell(9).setCellValue(reportVo.getOrganizeName());
                row.createCell(10).setCellValue(reportVo.getParentName());
                row.createCell(11).setCellValue(StudentReportVo.formatTime((LocalDateTime)reportVo.getCreateTime()));
                String learnStatusDesc = "-";
                if (reportVo.getLearnStatus() != null) {
                    if (reportVo.getLearnStatus() == 0) {
                        learnStatusDesc = waitOnline;
                    } else if (reportVo.getLearnStatus() == 1) {
                        learnStatusDesc = unStart;
                    } else if (reportVo.getLearnStatus() == 2) {
                        learnStatusDesc = going;
                    } else if (reportVo.getLearnStatus() == 3) {
                        learnStatusDesc = completed;
                    }
                    learnStatusDesc = learnStatusDesc + " " + (reportVo.getFinishTask() == null ? "0" : reportVo.getFinishTask()) + "/" + (reportVo.getLearnTask() == null ? "0" : reportVo.getLearnTask());
                }
                row.createCell(12).setCellValue(learnStatusDesc);
                row.createCell(13).setCellValue(reportVo.getScore() == null ? "-" : reportVo.getScore().toString());
                row.createCell(14).setCellValue(reportVo.getXsScore() == null ? "-" : reportVo.getXsScore().toString());
                row.createCell(15).setCellValue(reportVo.getXxScore() == null ? "-" : reportVo.getXxScore().toString());
                String passStatusDesc = "-";
                if (reportVo.getPassStatus() != null) {
                    if (reportVo.getPassStatus() == 0) {
                        passStatusDesc = draft;
                    } else if (reportVo.getPassStatus() == 1) {
                        passStatusDesc = waitOpen;
                    }
                }
                row.createCell(16).setCellValue(passStatusDesc);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(this.messageSource.getMessage("training.learn.student.report", null, locale) + ".xls", "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u51fa\u5b66\u5458\u62a5\u8868\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveTaskRate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTaskRate(@RequestBody List<TrainingTaskScheduleVo> scheduleVoList) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                this.learnService.saveTaskRate(scheduleVoList, user);
                return JsonResult.success();
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectStudyRate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectStudyRate(@RequestBody TrainingTaskScheduleVo scheduleVo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null && user.getId() != null) {
                List<TrainingProjectTaskVo> projectList = this.learnService.selectStudyRate(scheduleVo, user);
                return JsonResult.success(projectList);
            }
            return "INVALID_TOKEN";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectLearnShiftReviewRecord"})
    @ResponseBody
    public String selectLearnShiftReviewRecord(@RequestBody TrainingLearnShiftVo trainingLearnShiftVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        List<TrainingLearnShiftRecordVo> trainingLearnShiftRecordVoList = this.learnService.selectLearnShiftReviewRecord(trainingLearnShiftVo, user);
        return JsonResult.success(trainingLearnShiftRecordVoList);
    }

    @RequestMapping(value={"/saveLearnShiftReviewRecord"})
    @ResponseBody
    public String saveLearnShiftReviewRecord(@RequestBody TrainingLearnShiftVo trainingLearnShiftVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.learnService.saveLearnShiftReviewRecord(trainingLearnShiftVo, user);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectLearnShiftRecordByPage"})
    @ResponseBody
    public String selectLearnShiftRecordByPage(Page<TrainingLearnShiftRecordVo> page, String shiftName, Integer status, String createrName, String startTime, String endTime, Integer sortStatus) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.learnService.selectLearnShiftRecordByPage(page, user, shiftName, status, createrName, startTime, endTime, sortStatus);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectShiftReviewRecord"})
    @ResponseBody
    public String selectShiftReviewRecord(@RequestBody TrainingLearnShiftRecordVo trainingLearnShiftRecordVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingLearnShiftVo trainingLearnShiftVo = this.learnService.selectShiftReviewRecord(trainingLearnShiftRecordVo, user);
        return JsonResult.success((Object)trainingLearnShiftVo);
    }

    @RequestMapping(value={"/saveShiftReviewRecord"})
    @ResponseBody
    public String saveShiftReviewRecord(@RequestBody TrainingLearnShiftRecordVo trainingLearnShiftRecordVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        trainingLearnShiftRecordVo = this.learnService.saveShiftReviewRecord(trainingLearnShiftRecordVo, user);
        return JsonResult.success((Object)trainingLearnShiftRecordVo);
    }

    @RequestMapping(value={"/selectShiftReviewRecordNumber"})
    @ResponseBody
    public String selectShiftReviewRecordNumber() {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingLearnShiftRecordVo trainingLearnShiftRecordVo = this.learnService.selectShiftReviewRecordNumber(user);
        return JsonResult.success((Object)trainingLearnShiftRecordVo);
    }
}

