/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingLearnUserService;
import com.ovopark.training.vo.TrainingLearnUserOperateVo;
import com.ovopark.training.vo.TrainingLearnUserVo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/trainingLearnUser"})
public class TrainingLearnUserController {
    @Autowired
    private TrainingLearnUserService trainingLearnUserService;

    @RequestMapping(value={"/addTrainingLearnUser"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String addTrainingLearnUser(Integer learnStatus, Integer passStatus, String userId, Integer shiftId, Integer enterpriseId, Integer executorId, Integer operate) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Integer learnUserId = 0;
        learnUserId = this.trainingLearnUserService.saveTrainingLearnUser(learnStatus, passStatus, userId, shiftId, enterpriseId, executorId, operate);
        return JsonResult.success((Object)learnUserId);
    }

    @RequestMapping(value={"/deleteTrainingLearnUser"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingUser(Integer trainingLearnUserId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null && user.getId() == null) {
            return "INVALID_TOKEN";
        }
        this.trainingLearnUserService.deleteLearnUser(trainingLearnUserId);
        return JsonResult.success();
    }

    @RequestMapping(value={"/deleteTrainingLearnUsers"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteTrainingUsers(String trainingLearnUserIds, Integer shiftId, Integer enterpriseId, Integer executorId, Integer operate) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null && user.getId() == null) {
            return "INVALID_TOKEN";
        }
        List<Integer> trainingLearnUserId = null;
        if (!StringUtils.isEmpty((Object)trainingLearnUserIds)) {
            String[] learnUserStr = trainingLearnUserIds.split(",");
            List<String> learnUserS = Arrays.asList(learnUserStr);
            trainingLearnUserId = learnUserS.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        Date now = new Date();
        TrainingLearnUserOperateVo trainingLearnUserOperateVo = new TrainingLearnUserOperateVo();
        trainingLearnUserOperateVo.setExecutorId(executorId);
        trainingLearnUserOperateVo.setCreateTime(now);
        trainingLearnUserOperateVo.setShiftId(shiftId);
        trainingLearnUserOperateVo.setEnterpriseId(enterpriseId);
        trainingLearnUserOperateVo.setOperate(operate);
        this.trainingLearnUserService.deleteLearnUsers(trainingLearnUserId, trainingLearnUserOperateVo);
        return JsonResult.success();
    }

    @RequestMapping(value={"/modifyTrainingLearnUser"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String modifyTrainingLearnUser(@RequestBody TrainingLearnUserVo trainingLearnUserVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null && user.getId() == null) {
            return "INVALID_TOKEN";
        }
        this.trainingLearnUserService.updateLearnUser(trainingLearnUserVo);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectTrainingLearnUserByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectTrainingLearnUserByPage(Page<TrainingLearnUserVo> page, Integer learnStatus, Integer shiftId, String enterpriseIds, String userName) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null && user.getId() == null) {
            return "INVALID_TOKEN";
        }
        List enterpriseId = null;
        if (!StringUtils.isEmpty((Object)enterpriseIds)) {
            String[] enterpriseIdStr = enterpriseIds.split(",");
            List<String> enterpriseIdS = Arrays.asList(enterpriseIdStr);
            enterpriseId = enterpriseIdS.stream().map(Integer::parseInt).collect(Collectors.toList());
        }
        page = this.trainingLearnUserService.selectTrainingLearnUserByPage(page, learnStatus, shiftId, enterpriseId, userName, user);
        return JsonResult.success(page);
    }
}

