/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.LearningOverviewReq;
import com.ovopark.training.service.LearningOverviewService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/learningOverview"})
public class TrainingLearningOverviewController {
    private static final Logger log = LoggerFactory.getLogger(TrainingLearningOverviewController.class);
    @Autowired
    private LearningOverviewService learningOverviewService;

    @RequestMapping(value={"/getDataScreening"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getDataScreening(@RequestBody LearningOverviewReq learningOverviewReq) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.learningOverviewService.getDataScreening(learningOverviewReq, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/getStudyTrend"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getStudyTrend(@RequestBody LearningOverviewReq learningOverviewReq) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.learningOverviewService.getStudyTrend(learningOverviewReq, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/getPaperTrend"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperTrend(@RequestBody LearningOverviewReq learningOverviewReq) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.learningOverviewService.getPaperTrend(learningOverviewReq, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/getTrainingInfo"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingInfo(@RequestBody LearningOverviewReq learningOverviewReq) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.learningOverviewService.getTrainingInfo(learningOverviewReq, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/getPaperInfo"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getPaperInfo(@RequestBody LearningOverviewReq learningOverviewReq) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.learningOverviewService.getPaperInfo(learningOverviewReq, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/getTrainingRanking"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingRanking(@RequestBody LearningOverviewReq learningOverviewReq) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.learningOverviewService.getTrainingRanking(learningOverviewReq, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/getStudyRanking"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getStudyRanking(@RequestBody LearningOverviewReq learningOverviewReq) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success(this.learningOverviewService.getStudyRanking(learningOverviewReq, user));
        }
        return JsonResult.error();
    }
}

