/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingMarkPaperService;
import com.ovopark.training.vo.TrainingPaperMarkLogVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/markPaper"})
public class TrainingMarkPaperController {
    private static final Logger log = LoggerFactory.getLogger(TrainingMarkPaperController.class);
    @Autowired
    private TrainingMarkPaperService trainingMarkPaperService;

    @RequestMapping(value={"/selectMarkPapersByPage"})
    @ResponseBody
    public String selectMarkPapersByPage(Page<TrainingUserPaperVo> page, Integer paperStatus, String userName, String paperName, String startTime, String endTime, Integer sourceType, Integer sortStatus, String userPaperName, Integer userPaperType) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.trainingMarkPaperService.selectMarkPapersByPage(page, user, paperStatus, userName, paperName, startTime, endTime, sourceType, sortStatus, userPaperName, userPaperType);
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectMarkPaperNum"})
    @ResponseBody
    public String selectMarkPaperNum() {
        Users user = Authenticator.getInstance().getCurrentUser();
        Map<String, Object> map = this.trainingMarkPaperService.selectMarkPaperNum(user);
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/selectMarkingPaper"})
    @ResponseBody
    public String selectMarkingPaper(@RequestBody TrainingPapersVo trainingPapersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPapersVo vo = this.trainingMarkPaperService.selectMarkingPaper(user, trainingPapersVo);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/saveMarkPaper"})
    @ResponseBody
    public String saveMarkPaper(@RequestBody TrainingPapersVo trainingPapersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPapersVo papersVo = this.trainingMarkPaperService.saveMarkPaper(user, trainingPapersVo);
        return JsonResult.success((Object)papersVo);
    }

    @RequestMapping(value={"/selectPaperMarkLog"})
    @ResponseBody
    public String selectPaperMarkLog(@RequestBody TrainingPaperMarkLogVo trainingPaperMarkLogVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        List<TrainingPaperMarkLogVo> list = this.trainingMarkPaperService.selectPaperMarkLog(user, trainingPaperMarkLogVo);
        return JsonResult.success(list);
    }

    @RequestMapping(value={"/selectMarkingPaperUsers"})
    @ResponseBody
    public String selectMarkingPaperUsers(@RequestBody TrainingPapersVo trainingPapersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Map<String, Object> map = this.trainingMarkPaperService.selectMarkingPaperUsers(user, trainingPapersVo);
        return JsonResult.success(map);
    }

    @RequestMapping(value={"/delMarkingPaperUsers"})
    @ResponseBody
    public String delMarkingPaperUsers(@RequestBody TrainingPapersVo trainingPapersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        this.trainingMarkPaperService.delMarkingPaperUsers(user, trainingPapersVo);
        return JsonResult.success();
    }

    @RequestMapping(value={"/selectNextUserPaper"})
    @ResponseBody
    public String selectNextUserPaper(@RequestBody TrainingPapersVo trainingPapersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPapersVo map = this.trainingMarkPaperService.selectNextUserPaper(user, trainingPapersVo);
        return JsonResult.success((Object)map);
    }
}

