/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingMaterial;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingMaterialProductService;
import com.ovopark.training.vo.TrainingMaterialVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/training/materialProduct"})
public class TrainingMaterialProductController {
    private static final Logger log = LoggerFactory.getLogger(TrainingMaterialProductController.class);
    @Autowired
    private TrainingMaterialProductService materialProductService;

    @RequestMapping(value={"/selectMaterialProduct"})
    @ResponseBody
    public String selectMaterialProduct(@RequestBody TrainingMaterialVo material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialProductService.selectMaterialProduct(material, user);
    }

    @Deprecated
    @RequestMapping(value={"/insertMaterialProduct"})
    @ResponseBody
    public String insertMaterialProduct(@RequestBody TrainingMaterialVo material) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.materialProductService.insertMaterialProduct(material, user);
    }

    @RequestMapping(value={"/updateMaterialProduct"})
    @ResponseBody
    public String updateMaterialProduct(@RequestBody TrainingMaterialVo material) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            return this.materialProductService.updateMaterialProduct(material, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/delMaterial"})
    @ResponseBody
    public String delMaterial(@RequestBody List<TrainingMaterial> material) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            return this.materialProductService.delMaterial(material, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/importMaterialType"})
    @ResponseBody
    public String importMaterialType(@RequestParam(value="file") MultipartFile file) {
        Map<Object, Object> result = new HashMap();
        Users user = Authenticator.getInstance().getCurrentUser();
        try {
            result = this.materialProductService.importMaterialType(file, user);
            return JsonResult.success(result);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u7d20\u6750\u7c7b\u578b\u5f02\u5e38", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/importMaterialProduct"})
    @ResponseBody
    public String importMaterialProduct(@RequestParam(value="file") MultipartFile file) {
        Users user = Authenticator.getInstance().getCurrentUser();
        Map<String, List<TrainingMaterialVo>> result = this.materialProductService.importMaterialProduct(file, user);
        return JsonResult.success(result);
    }

    @RequestMapping(value={"/selectProductParamValues"})
    @ResponseBody
    public String selectProductParamValues(@RequestBody List<Integer> materialIds) {
        return JsonResult.success(this.materialProductService.selectProductParamValues(materialIds));
    }

    @RequestMapping(value={"/updateProductParamShow"})
    @ResponseBody
    public String updateProductParamShow(@RequestBody Map map) {
        this.materialProductService.updateProductParamShow(map);
        return JsonResult.success();
    }
}

