/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingComment;
import com.ovopark.training.model.TrainingLabel;
import com.ovopark.training.model.TrainingNav;
import com.ovopark.training.model.TrainingUserLastView;
import com.ovopark.training.model.TrainingUserViewTime;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingRemoteService;
import com.ovopark.training.service.UserServiceNew;
import com.ovopark.training.util.ImageUtil;
import com.ovopark.training.vo.HomeTrainingVo;
import com.ovopark.training.vo.TrainingCommentVo;
import com.ovopark.training.vo.TrainingLabelVo;
import com.ovopark.training.vo.TrainingNavVo;
import com.ovopark.training.vo.TrainingVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/navigation"})
public class TrainingNavigationController {
    private static final Logger log = LoggerFactory.getLogger(TrainingNavigationController.class);
    @Autowired
    private TrainingRemoteService trainingRemoteService;
    @Autowired
    private UserServiceNew userServiceNew;

    @RequestMapping(value={"/getNavigation"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getNavigation() {
        Users user = Authenticator.getInstance().getCurrentUser();
        List<TrainingNav> navList = this.trainingRemoteService.getTrainingNavByGroupId(user.getId(), user.getGroupId());
        return JsonResult.success(TrainingNavigationController.trainingNavConvert(navList));
    }

    private static List<TrainingNav> trainingNavConvert(List<TrainingNav> trainingList) {
        ArrayList<TrainingNav> resultList = new ArrayList<TrainingNav>();
        if (!CollectionUtils.isEmpty(trainingList)) {
            for (int i = 0; i < trainingList.size(); ++i) {
                TrainingNav training = trainingList.get(i);
                if (!StringUtils.isEmpty((Object)training.getPicUrl())) {
                    training.setPicUrl(ImageUtil.makePicUrl(training.getPicUrl()));
                }
                resultList.add(training);
            }
        }
        return resultList;
    }

    @RequestMapping(value={"/getTrainingNav"})
    @ResponseBody
    public String getTrainingNav(Integer isPublic, Integer isAll) {
        try {
            List<TrainingNav> navList = this.trainingRemoteService.getAllTrainingNav(isPublic, isAll);
            return JsonResult.success(TrainingNavigationController.trainingNavConvert(navList));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "FAILED";
        }
    }

    @RequestMapping(value={"/getTrainingLabelByEnp"})
    @ResponseBody
    public String getTrainingLabelByEnp(Integer enterpriseId) {
        List<Object> vo = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (enterpriseId == null) {
                enterpriseId = user.getGroupId();
            }
            if (enterpriseId == null) {
                return "INVALID_PARAMETER";
            }
            vo = this.trainingRemoteService.getLabelByNameAndNavId(null, 1000000257, enterpriseId);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "FAILED";
        }
        return JsonResult.success(vo);
    }

    @RequestMapping(value={"/getTrainingLabelByNavId"})
    @ResponseBody
    public String getTrainingLabelByNavId(Integer navId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (navId != null) {
                List<TrainingLabelVo> labelList = this.trainingRemoteService.getLabelByNameAndNavId(null, navId, user.getGroupId());
                return JsonResult.success(TrainingNavigationController.trainingLabelVoConvert(labelList));
            }
            return "INVALID_PARAMETER";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "FAILED";
        }
    }

    @RequestMapping(value={"/getLearnTrainingLabelByEnp"})
    @ResponseBody
    public String getLearnTrainingLabelByEnp(Integer projectShow) {
        List<Object> vo = new ArrayList();
        Users user = Authenticator.getInstance().getCurrentUser();
        try {
            if (user.getGroupId() == null) {
                return "INVALID_PARAMETER";
            }
            vo = this.trainingRemoteService.getLearnLabelByNameAndNavId(null, 1000000257, user.getGroupId(), projectShow);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "FAILED";
        }
        return JsonResult.success(vo);
    }

    @RequestMapping(value={"/getNavByCategoryId"})
    @ResponseBody
    public String getNavByCategoryId(Integer id) {
        try {
            List<TrainingNavVo> voList = this.trainingRemoteService.getTncVoByCategoryId(id);
            return JsonResult.success(voList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return "FAILED";
        }
    }

    @RequestMapping(value={"/saveTrainingLabelOrder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingLabelOrder(@RequestBody List<TrainingLabel> order) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user != null) {
                if (order == null) {
                    return "INVALID_PARAMETER";
                }
            } else {
                return "INVALID_TOKEN";
            }
            this.trainingRemoteService.saveTrainingLabelOrder(user, order);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "FAILED";
        }
        return JsonResult.success();
    }

    private static List<TrainingLabelVo> trainingLabelVoConvert(List<TrainingLabelVo> trainingList) {
        ArrayList<TrainingLabelVo> resultList = new ArrayList<TrainingLabelVo>();
        if (!CollectionUtils.isEmpty(trainingList)) {
            for (int i = 0; i < trainingList.size(); ++i) {
                TrainingLabelVo training = trainingList.get(i);
                if (!StringUtils.isEmpty((Object)training.getPicUrl())) {
                    training.setPicUrl(ImageUtil.makePicUrl(training.getPicUrl()));
                }
                resultList.add(training);
            }
        }
        return resultList;
    }

    @RequestMapping(value={"/getTrainingDetailByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingDetailByPage(Page<TrainingVo> page, String type, String keyWord, Integer labelId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user == null) {
            return "INVALID_TOKEN";
        }
        Page<TrainingVo> resultPage = this.trainingRemoteService.getTrainingDetailByPage(page, user.getId(), user.getGroupId(), type, keyWord, labelId);
        resultPage.setContent(TrainingNavigationController.trainingConvert(resultPage.getContent()));
        return JsonResult.successMapNullValue(resultPage);
    }

    @RequestMapping(value={"/getHomeTraining"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getHomeTraining(Integer navId, String keyWord) {
        List<Object> vo = new ArrayList();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null) {
                return "INVALID_TOKEN";
            }
            List<HomeTrainingVo> voList = this.trainingRemoteService.getHomeTraining(user.getId(), user.getGroupId(), navId, keyWord);
            vo = TrainingNavigationController.homeTrainingVoConvert(voList);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.successMapNullValue(vo);
    }

    private static List<HomeTrainingVo> homeTrainingVoConvert(List<HomeTrainingVo> voList) {
        ArrayList<HomeTrainingVo> resultList = new ArrayList<HomeTrainingVo>();
        if (!CollectionUtils.isEmpty(voList)) {
            for (int i = 0; i < voList.size(); ++i) {
                HomeTrainingVo vo = voList.get(i);
                if (!CollectionUtils.isEmpty((Collection)vo.getTrainingList())) {
                    vo.setTrainingList(TrainingNavigationController.trainingConvert(vo.getTrainingList()));
                }
                resultList.add(vo);
            }
        }
        return resultList;
    }

    private static List<TrainingVo> trainingConvert(List<TrainingVo> trainingList) {
        ArrayList<TrainingVo> resultList = new ArrayList<TrainingVo>();
        if (!CollectionUtils.isEmpty(trainingList)) {
            for (int i = 0; i < trainingList.size(); ++i) {
                TrainingVo training = trainingList.get(i);
                if (!StringUtils.isEmpty((Object)training.getPath()) && !training.getPath().startsWith("http")) {
                    training.setPath(ImageUtil.makePicUrl(training.getPath()));
                }
                if (!StringUtils.isEmpty((Object)training.getHeadUrl()) && !training.getHeadUrl().startsWith("http")) {
                    training.setHeadUrl(ImageUtil.makePicUrl(training.getHeadUrl()));
                }
                resultList.add(training);
            }
        }
        return resultList;
    }

    @RequestMapping(value={"/addComment"})
    @ResponseBody
    public String addComment(@RequestBody TrainingComment comment) {
        TrainingCommentVo commentVo = new TrainingCommentVo();
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            Integer userId = user.getId();
            comment.setUserId(userId);
            if (comment == null || comment.getTrainingId() == null) {
                return JsonResult.paramError();
            }
            commentVo = this.trainingRemoteService.addComment(comment);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success((Object)commentVo);
    }

    @RequestMapping(value={"/deleteComment"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String deleteComment(Integer id) {
        try {
            if (id == null) {
                return "EXCEPTION";
            }
            TrainingComment comment = new TrainingComment();
            comment.setId(id);
            this.trainingRemoteService.deleteComment(comment);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/getTrainingComment"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String getTrainingComment(Integer trainingId, Integer pageSize, Integer pageNum, Integer commentType) {
        Page<TrainingCommentVo> page = new Page<TrainingCommentVo>();
        if (pageSize == null || pageNum == null) {
            pageNum = 1;
            pageSize = 20;
        }
        try {
            if (trainingId == null) {
                return JsonResult.paramError();
            }
            page.setPageNumber(pageNum.intValue());
            page.setPageSize(pageSize.intValue());
            page = this.trainingRemoteService.getTrainingCommentByPage(page, trainingId, commentType);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/saveTrainingViewTime"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveTrainingViewTime(@RequestBody TrainingUserViewTime viewTime) {
        block3: {
            try {
                Users user = Authenticator.getInstance().getCurrentUser();
                if (viewTime.getViewTime() == null || viewTime.getViewTime() <= 0) break block3;
                if (user != null && user.getId() != null) {
                    viewTime.setUserId(user.getId());
                    viewTime.setEnterpriseId(user.getGroupId());
                    this.trainingRemoteService.saveTrainingViewTime(viewTime);
                    break block3;
                }
                return "INVALID_TOKEN";
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return "EXCEPTION";
            }
        }
        return JsonResult.success();
    }

    @RequestMapping(value={"/saveUserLastView"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveUserLastView(@RequestBody TrainingUserLastView lastView) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            if (user == null || user.getId() == null) {
                return "INVALID_TOKEN";
            }
            this.trainingRemoteService.saveUserLastView(lastView, user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }
}

