/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingPaperVisitorService;
import com.ovopark.training.vo.TrainingLoginUserVo;
import com.ovopark.training.vo.TrainingPapersVo;
import com.ovopark.training.vo.TrainingUserPaperVo;
import com.ovopark.training.vo.TrainingUserQuestionVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/visitor"})
public class TrainingPaperVisitorController {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperVisitorController.class);
    @Autowired
    private TrainingPaperVisitorService trainingPaperVisitorService;

    @RequestMapping(value={"/selectVisitorLoginVerificationCode"})
    @ResponseBody
    public String selectVisitorLoginVerificationCode(@RequestParam(value="mobilePhone") String mobilePhone, @RequestParam(value="language") String language) {
        return this.trainingPaperVisitorService.selectVisitorLoginVerificationCode(mobilePhone, language);
    }

    @RequestMapping(value={"/saveVisitorLoginInformation"})
    @ResponseBody
    public String saveVisitorLoginInformation(HttpServletRequest request, @RequestBody TrainingLoginUserVo trainingLoginUserVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingPaperVisitorService.saveVisitorLoginInformation(request, trainingLoginUserVo, user);
    }

    @RequestMapping(value={"/selectPapersVoVisitor"})
    @ResponseBody
    public String selectPapersVoVisitor(@RequestBody TrainingPapersVo papersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingPaperVisitorService.selectPapersVoVisitor(papersVo, user);
    }

    @RequestMapping(value={"/selectPaperQuestionsVisitor"})
    @ResponseBody
    public String selectPaperQuestionsVisitor(@RequestBody TrainingUserPaperVo userPaperVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingPaperVisitorService.selectPaperQuestionsVisitor(userPaperVo, user);
    }

    @RequestMapping(value={"/saveUserQuestionsVisitor"})
    @ResponseBody
    public String saveUserQuestionsVisitor(@RequestBody List<TrainingUserQuestionVo> userQuestionVoList) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!CollectionUtils.isEmpty(userQuestionVoList) && !ObjectUtils.isEmpty((Object)userQuestionVoList.get(0))) {
            TrainingUserPaper userPaper = null;
            try {
                userPaper = this.trainingPaperVisitorService.saveUserQuestionsVisitor(userQuestionVoList, user);
            }
            catch (Exception e) {
                log.error("saveUserQuestionsVisitor: " + e);
                return JsonResult.error();
            }
            if (!ObjectUtils.isEmpty((Object)userPaper)) {
                return JsonResult.success((Object)userPaper.getId());
            }
            return "PAPER_SUBMIT_EMPTY";
        }
        log.error("\u6e38\u5ba2\u63d0\u4ea4 \u8bb0\u5f55\u4e3a\u7a7a ", (Object)("userQuestionVoList = " + userQuestionVoList));
        return "PAPER_SUBMIT_EMPTY";
    }

    @RequestMapping(value={"/selectUserPaperResultVisitor"})
    @ResponseBody
    public String selectUserPaperResultVisitor(@RequestBody TrainingUserPaper userPaper) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingUserPaperVo vo = this.trainingPaperVisitorService.selectUserPaperResultVisitor(userPaper, user);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/selectUserPaperListVisitor"})
    @ResponseBody
    public String selectUserPaperListVisitor(@RequestBody TrainingPapersVo papersVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingPaperVisitorService.selectUserPaperListVisitor(papersVo, user);
    }

    @RequestMapping(value={"/selectFinishPaperQuestionsVisitor"})
    @ResponseBody
    public String selectFinishPaperQuestionsVisitor(@RequestBody TrainingUserPaperVo userPaperVo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        TrainingPapersVo vo = this.trainingPaperVisitorService.selectFinishPaperQuestionsVisitor(userPaperVo, user);
        return JsonResult.success((Object)vo);
    }

    @RequestMapping(value={"/addPaperScreenNumVisitor"})
    @ResponseBody
    public String addPaperScreenNumVisitor(Integer userPaperId) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingPaperVisitorService.addPaperScreenNumVisitor(userPaperId, user);
    }

    @RequestMapping(value={"/getVisitorPaperByPage"})
    @ResponseBody
    public String getVisitorPaperByPage(Page<TrainingPapersVo> page, Integer enterpriseId, String title) {
        Users user = Authenticator.getInstance().getCurrentUser();
        page = this.trainingPaperVisitorService.getVisitorPaperByPage(page, enterpriseId, title, user);
        return JsonResult.success(page);
    }
}

