/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingShiftExeclService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.StudentReportCountVo;
import com.ovopark.training.vo.StudentReportRequestVo;
import com.ovopark.training.vo.StudentReportVo;
import com.ovopark.training.vo.TrainingLearnShiftVo;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/shiftExecl"})
public class TrainingShiftExeclController {
    private static final Logger log = LoggerFactory.getLogger(TrainingShiftExeclController.class);
    @Autowired
    private TrainingShiftExeclService shiftExeclService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/selectOpenShiftByPage"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectOpenShiftByPage(Page<TrainingLearnShiftVo> page, String creaters, String startTime, String endTime, Integer sourceId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            List creater = null;
            if (!StringUtils.isEmpty((Object)creaters)) {
                String[] createrStr = creaters.split(",");
                List<String> createrS = Arrays.asList(createrStr);
                creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
            page = this.shiftExeclService.selectOpenShiftByPage(page, user, creater, startTime, endTime, sourceId);
        }
        catch (Exception e) {
            log.info("selectOpenShiftByPage" + e);
            return "EXCEPTION";
        }
        return JsonResult.success(page);
    }

    @RequestMapping(value={"/selectOpenShiftByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectLearnByExecl(HttpServletResponse response, String creaters, String startTime, String endTime, Integer sourceId) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            Page<TrainingLearnShiftVo> page = new Page<TrainingLearnShiftVo>();
            page.setPageNumber(1);
            page.setPageSize(9999);
            List creater = null;
            if (!StringUtils.isEmpty((Object)creaters)) {
                String[] createrStr = creaters.split(",");
                List<String> createrS = Arrays.asList(createrStr);
                creater = createrS.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
            page = this.shiftExeclService.selectOpenShiftByPage(page, user, creater, startTime, endTime, sourceId);
            List list = page.getContent();
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String openCount = this.messageSource.getMessage("training.shift.open.count", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(openCount);
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            HSSFRow row = sheet.createRow(0);
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String draft = this.messageSource.getMessage("training.job.status.draft", null, locale);
            String doing = this.messageSource.getMessage("training.job.status.doing", null, locale);
            String pending = this.messageSource.getMessage("training.job.status.pending", null, locale);
            String shiftClosed = this.messageSource.getMessage("training.job.status.shift.closed", null, locale);
            row.createCell(0).setCellValue(employeeNumber);
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.learn.class.founder", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.learn.department", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.learn.class.number", null, locale));
            row.createCell(4).setCellValue(draft);
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.learn.wait.online", null, locale));
            row.createCell(6).setCellValue(doing);
            row.createCell(7).setCellValue(pending);
            row.createCell(8).setCellValue(shiftClosed);
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1);
                TrainingLearnShiftVo vo = (TrainingLearnShiftVo)list.get(i);
                row.createCell(0).setCellValue(vo.getUserName());
                row.createCell(1).setCellValue(vo.getCreatorName());
                row.createCell(2).setCellValue(vo.getOrganizeName());
                row.createCell(3).setCellValue(vo.getShiftNum());
                row.createCell(4).setCellValue(vo.getNotNum());
                row.createCell(5).setCellValue(vo.getWaitNum());
                row.createCell(6).setCellValue(vo.getGoingNum());
                row.createCell(7).setCellValue(vo.getClosingNum());
                row.createCell(8).setCellValue(vo.getFinishNum());
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + openCount + ".xls");
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
            return JsonResult.success();
        }
        catch (Exception e) {
            log.error("selectLearnByExecl" + e);
            return JsonResult.error();
        }
    }

    @PostMapping(value={"/selectStudentReportByPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectStudentReportByPage(@RequestBody StudentReportRequestVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            Page page = new Page();
            page.setPageNumber(vo.getPageNumber().intValue());
            page.setPageSize(vo.getPageSize().intValue());
            vo.setEnterpriseId(user.getGroupId());
            Page<StudentReportVo> studentReportVoPage = this.shiftExeclService.selectStudentReportByPage((Page<StudentReportVo>)page, vo, user);
            return JsonResult.success(studentReportVoPage);
        }
        catch (Exception e) {
            log.error("studentReport error:", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @PostMapping(value={"/selectStudentReportCount"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String selectStudentReportCount(@RequestBody StudentReportRequestVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            vo.setEnterpriseId(user.getGroupId());
            List<StudentReportVo> list = this.shiftExeclService.selectStudentReport((StudentReportVo)vo, user);
            StudentReportCountVo countVo = new StudentReportCountVo();
            Integer noNum = 0;
            Integer ingNum = 0;
            Integer finishNum = 0;
            Integer total = 0;
            Integer passNum = 0;
            if (!CollectionUtils.isEmpty(list)) {
                total = list.size();
                for (StudentReportVo reportVo : list) {
                    Integer n;
                    Integer n2;
                    if (reportVo.getLearnStatus() <= 1) {
                        n2 = noNum;
                        n = noNum = Integer.valueOf(noNum + 1);
                    } else if (reportVo.getLearnStatus() == 2) {
                        n2 = ingNum;
                        n = ingNum = Integer.valueOf(ingNum + 1);
                    } else if (reportVo.getLearnStatus() == 3) {
                        n2 = finishNum;
                        n = finishNum = Integer.valueOf(finishNum + 1);
                    }
                    if (reportVo.getPassStatus() == null || reportVo.getPassStatus() != 1) continue;
                    n2 = passNum;
                    n = passNum = Integer.valueOf(passNum + 1);
                }
            }
            countVo.setFinishNum(finishNum);
            countVo.setNoNum(noNum);
            countVo.setIngNum(ingNum);
            countVo.setTotal(total);
            countVo.setPassNum(passNum);
            return JsonResult.success((Object)countVo);
        }
        catch (Exception e) {
            log.error("selectStudentReportCount error:", (Throwable)e);
            return "EXCEPTION";
        }
    }

    @RequestMapping(value={"/selectStudentReportByExecl"}, produces={"text/html;charset=UTF-8"})
    @ResponseBody
    public String selectStudentReportByExecl(HttpServletResponse response, @RequestBody StudentReportRequestVo vo) {
        try {
            Users user = Authenticator.getInstance().getCurrentUser();
            vo.setEnterpriseId(user.getGroupId());
            List<StudentReportVo> list = this.shiftExeclService.selectStudentReport((StudentReportVo)vo, user);
            String nameStr = DateUtils.format(new Date(), "yyyyMMdd");
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            String learnName = this.messageSource.getMessage("training.learn.title", null, locale);
            String employeeNumber = this.messageSource.getMessage("training.user.details.employeeNumber", null, locale);
            String postName = this.messageSource.getMessage("training.job.post.name", null, locale);
            String department = this.messageSource.getMessage("training.course.analysis.department", null, locale);
            String leader = this.messageSource.getMessage("training.course.analysis.superior", null, locale);
            String studyStatus = this.messageSource.getMessage("training.course.analysis.study.status", null, locale);
            String passStatusName = this.messageSource.getMessage("training.shift.pass.status", null, locale);
            String draft = this.messageSource.getMessage("training.job.status.draft", null, locale);
            String waitOnline = this.messageSource.getMessage("training.job.status.wait.online", null, locale);
            String unStart = this.messageSource.getMessage("training.course.status.unstart", null, locale);
            String waitOpen = this.messageSource.getMessage("training.job.status.wait.open", null, locale);
            String doing = this.messageSource.getMessage("training.job.status.doing", null, locale);
            String going = this.messageSource.getMessage("training.job.status.going", null, locale);
            String pending = this.messageSource.getMessage("training.job.status.pending", null, locale);
            String shiftClosed = this.messageSource.getMessage("training.job.status.shift.closed", null, locale);
            String ended = this.messageSource.getMessage("training.job.status.ended", null, locale);
            String completed = this.messageSource.getMessage("training.job.status.completed", null, locale);
            String unpass = this.messageSource.getMessage("training.learn.unpass", null, locale);
            String pass = this.messageSource.getMessage("training.paper.pass", null, locale);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(this.messageSource.getMessage("training.learn.shift.student.report", null, locale) + "_" + nameStr);
            HSSFCellStyle titleSty = wb.createCellStyle();
            HSSFFont font = wb.createFont();
            font.setFontHeightInPoints((short)16);
            titleSty.setFont((Font)font);
            HSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue(learnName + "/" + "\u5c97\u4f4d\u8ba4\u8bc1\u540d\u79f0");
            row.createCell(1).setCellValue(this.messageSource.getMessage("training.learn.classes.name", null, locale));
            row.createCell(2).setCellValue(this.messageSource.getMessage("training.learn.class.founder", null, locale));
            row.createCell(3).setCellValue(this.messageSource.getMessage("training.learn.class.time", null, locale));
            row.createCell(4).setCellValue(this.messageSource.getMessage("training.learn.classes.validity", null, locale) + "/" + this.messageSource.getMessage("training.learn.shift.off.activity.time", null, locale));
            row.createCell(5).setCellValue(this.messageSource.getMessage("training.learn.classes.status", null, locale));
            row.createCell(6).setCellValue(this.messageSource.getMessage("training.course.trainee.name", null, locale));
            row.createCell(7).setCellValue(employeeNumber);
            row.createCell(8).setCellValue(postName);
            row.createCell(9).setCellValue(department);
            row.createCell(10).setCellValue(leader);
            row.createCell(11).setCellValue(this.messageSource.getMessage("training.learn.arrival.time", null, locale));
            row.createCell(12).setCellValue(this.messageSource.getMessage("training.shift.start.time", null, locale));
            row.createCell(13).setCellValue(this.messageSource.getMessage("training.shift.end.time", null, locale));
            row.createCell(14).setCellValue(studyStatus);
            row.createCell(15).setCellValue(this.messageSource.getMessage("training.paper.total.score", null, locale));
            row.createCell(16).setCellValue(this.messageSource.getMessage("training.job.online.paper.avgscore", null, locale));
            row.createCell(17).setCellValue(this.messageSource.getMessage("training.job.offline.paper.avgscore", null, locale));
            row.createCell(18).setCellValue(passStatusName);
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1);
                StudentReportVo reportVo = list.get(i);
                row.createCell(0).setCellValue(reportVo.getProjectName());
                row.createCell(1).setCellValue(reportVo.getShiftInfoDesc());
                row.createCell(2).setCellValue(reportVo.getCreatorName());
                row.createCell(3).setCellValue(StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftCreateTime()));
                String shiftTermOfValidity = "-";
                if (reportVo.getShiftCreateTime() != null) {
                    if (reportVo.getIsNotimeLimit() != null && reportVo.getIsNotimeLimit() == 1) {
                        shiftTermOfValidity = StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftCreateTime()) + " -> " + this.messageSource.getMessage("training.learn.shift.indefinite", null, locale);
                    } else if (reportVo.getShiftEndTime() != null) {
                        shiftTermOfValidity = StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftCreateTime()) + " -> " + StudentReportVo.formatTime((LocalDateTime)reportVo.getShiftEndTime());
                    }
                }
                row.createCell(4).setCellValue(shiftTermOfValidity);
                String shiftStatusDesc = "-";
                if (reportVo.getShiftStatus() != null) {
                    if (reportVo.getShiftStatus() == 0) {
                        shiftStatusDesc = draft;
                    } else if (reportVo.getShiftStatus() == 1) {
                        shiftStatusDesc = waitOpen;
                    } else if (reportVo.getShiftStatus() == 2) {
                        shiftStatusDesc = doing;
                    } else if (reportVo.getShiftStatus() == 3) {
                        shiftStatusDesc = pending;
                    } else if (reportVo.getShiftStatus() == 4) {
                        shiftStatusDesc = shiftClosed;
                    } else if (reportVo.getShiftStatus() == 5) {
                        shiftStatusDesc = unStart;
                    } else if (reportVo.getShiftStatus() == 6) {
                        shiftStatusDesc = going;
                    } else if (reportVo.getShiftStatus() == 7) {
                        shiftStatusDesc = ended;
                    }
                }
                row.createCell(5).setCellValue(shiftStatusDesc);
                row.createCell(6).setCellValue(reportVo.getUserName());
                row.createCell(7).setCellValue(reportVo.getJobNumber());
                row.createCell(8).setCellValue(reportVo.getDutiesName());
                row.createCell(9).setCellValue(reportVo.getOrganizeName());
                row.createCell(10).setCellValue(reportVo.getParentName());
                row.createCell(11).setCellValue(StudentReportVo.formatTime((LocalDateTime)reportVo.getCreateTime()));
                row.createCell(12).setCellValue(StudentReportVo.formatTime((LocalDateTime)reportVo.getStartLearnTime()));
                row.createCell(13).setCellValue(StudentReportVo.formatTime((LocalDateTime)reportVo.getEndLearnTime()));
                String learnStatusDesc = "-";
                if (reportVo.getLearnStatus() != null) {
                    if (reportVo.getLearnStatus() == 0) {
                        learnStatusDesc = waitOnline;
                    } else if (reportVo.getLearnStatus() == 1) {
                        learnStatusDesc = unStart;
                    } else if (reportVo.getLearnStatus() == 2) {
                        learnStatusDesc = going;
                    } else if (reportVo.getLearnStatus() == 3) {
                        learnStatusDesc = completed;
                    }
                    learnStatusDesc = learnStatusDesc + " " + (reportVo.getFinishTask() == null ? "0" : reportVo.getFinishTask()) + "/" + (reportVo.getLearnTask() == null ? "0" : reportVo.getLearnTask());
                }
                row.createCell(14).setCellValue(learnStatusDesc);
                row.createCell(15).setCellValue(reportVo.getScore() == null ? "-" : reportVo.getScore().toString());
                row.createCell(16).setCellValue(reportVo.getXsScore() == null ? "-" : reportVo.getXsScore().toString());
                row.createCell(17).setCellValue(reportVo.getXxScore() == null ? "-" : reportVo.getXxScore().toString());
                String passStatusDesc = "-";
                if (reportVo.getPassStatus() != null) {
                    if (reportVo.getPassStatus() == 0) {
                        passStatusDesc = unpass;
                    } else if (reportVo.getPassStatus() == 1) {
                        passStatusDesc = pass;
                    }
                }
                row.createCell(18).setCellValue(passStatusDesc);
            }
            response.setContentType("application/vnd.ms-excel; charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(this.messageSource.getMessage("training.learn.shift.student.report", null, locale) + "_" + nameStr + ".xls", "UTF-8"));
            ServletOutputStream out = response.getOutputStream();
            wb.write((OutputStream)out);
            out.flush();
            out.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u51fa\u5b66\u5458\u62a5\u8868\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
            return "EXCEPTION";
        }
        return JsonResult.success();
    }
}

