/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.TrainingCheckDimension;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingOperateService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.vo.OperateTemplateVo;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/template"})
public class TrainingTemplateController {
    private static final Logger log = LoggerFactory.getLogger(TrainingTemplateController.class);
    @Autowired
    private TrainingOperateService trainingOperateService;

    @RequestMapping(value={"/getCheckDimensionList"})
    @ResponseBody
    public String getCheckDimensionList() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getCheckDimensionList(user.getGroupId());
    }

    @RequestMapping(value={"/saveCheckDimensionOrder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveCheckDimensionOrder(@RequestBody List<TrainingCheckDimension> order) {
        try {
            if (CollectionUtils.isEmpty(order)) {
                return "INVALID_PARAMETER";
            }
            this.trainingOperateService.saveCheckDimensionOrder(order);
            return JsonResult.success();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return "FAILED";
        }
    }

    @RequestMapping(value={"/saveCheckDimension"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveCheckDimension(@RequestBody List<TrainingCheckDimension> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.saveCheckDimension(user.getGroupId(), list);
    }

    @RequestMapping(value={"/vaildCheckDimension"})
    @ResponseBody
    public String vaildCheckDimension(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.vaildCheckDimension(user.getGroupId(), name);
    }

    @RequestMapping(value={"/saveOperateTemplate"})
    @ResponseBody
    public String saveOperateTemplate(@RequestBody OperateTemplateVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        vo.setEnterpriseId(user.getGroupId());
        return this.trainingOperateService.saveOperateTemplate(vo);
    }

    @RequestMapping(value={"/vaildOperateTemplate"})
    @ResponseBody
    public String vaildOperateTemplate(Integer id, String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return "INVALID_PARAMETER";
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.vaildOperateTemplate(user.getGroupId(), id, name);
    }

    @RequestMapping(value={"/deleteOperateTemplateById"})
    @ResponseBody
    public String deleteOperateTemplateById(Integer operateTemplateId) {
        try {
            if (operateTemplateId == null) {
                return "INVALID_PARAMETER";
            }
            this.trainingOperateService.deleteOperateTemplateById(operateTemplateId);
            return JsonResult.success();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            return "FAILED";
        }
    }

    @RequestMapping(value={"/getOperateTemplateByPage"})
    @ResponseBody
    public String getOperateTemplateByPage(Page<OperateTemplateVo> page, String templateName, Integer isEnable) {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingOperateService.getOperateTemplateByPage(page, user.getGroupId(), templateName, isEnable);
    }

    @RequestMapping(value={"/getOperateTemplateById"})
    @ResponseBody
    public String getOperateTemplateById(Integer operateTemplateId) {
        if (operateTemplateId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.getOperateTemplateById(operateTemplateId);
    }

    @RequestMapping(value={"/operateTemplateIsEnable"})
    @ResponseBody
    public String operateTemplateIsEnable(String operateTemplateIds, Integer isEnable) {
        if (StringUtils.isEmpty((Object)operateTemplateIds) || isEnable == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.operateTemplateIsEnable(operateTemplateIds, isEnable);
    }

    @RequestMapping(value={"/deleteOperateTemplate"})
    @ResponseBody
    public String deleteOperateTemplate(HttpServletRequest req, String operateTemplateIds) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (StringUtils.isEmpty((Object)operateTemplateIds)) {
            return "INVALID_PARAMETER";
        }
        LogPojo pojo = new LogPojo();
        pojo.setUserId(user.getId());
        pojo.setOperation("practical_assessment_template_delete");
        pojo.setCreateTime(new Date());
        pojo.setRemoteIp(req.getRemoteAddr());
        pojo.setEnterpriseId(user.getGroupId());
        pojo.setUserName(user.getUserName());
        pojo.setI18nKey("operation.practical_assessment_template_delete.description");
        pojo.setPlatform(CommonUtil.getTerminalByToken(req));
        return this.trainingOperateService.deleteOperateTemplate(operateTemplateIds, pojo);
    }

    @RequestMapping(value={"/vaildDeleteOperate"})
    @ResponseBody
    public String vaildDeleteOperate(Integer operateTemplateId) {
        if (operateTemplateId == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.vaildDeleteOperate(operateTemplateId);
    }

    @RequestMapping(value={"/vaildBatchDeleteOperate"})
    @ResponseBody
    public String vaildBatchDeleteOperate(String operateTemplateIds) {
        if (operateTemplateIds == null) {
            return "INVALID_PARAMETER";
        }
        return this.trainingOperateService.vaildBatchDeleteOperate(operateTemplateIds);
    }
}

