/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingWorkService;
import com.ovopark.training.vo.TrainingWorkUserAnswerVo;
import com.ovopark.training.vo.TrainingWorkVo;
import com.ovopark.training.vo.WorkStatusVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/work"})
public class TrainingWorkController {
    private static final Logger log = LoggerFactory.getLogger(TrainingWorkController.class);
    @Autowired
    private TrainingWorkService trainingWorkService;

    @RequestMapping(value={"/selectTrainingWorkVo"})
    @ResponseBody
    public String selectTrainingWorkVo(@RequestBody TrainingWorkVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.trainingWorkService.selectTrainingWorkVo(vo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/insertWork"})
    @ResponseBody
    public String insertWork(@RequestBody TrainingWorkVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            return JsonResult.success((Object)this.trainingWorkService.insertWork(vo, user));
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/updateWork"})
    @ResponseBody
    public String updateWork(@RequestBody TrainingWorkVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getId() != null) {
            this.trainingWorkService.updateWork(vo, user);
            return JsonResult.success();
        }
        return "INVALID_TOKEN";
    }

    @RequestMapping(value={"/selectTrainingWorkUserAnswerVo"})
    @ResponseBody
    public String selectTrainingWorkUserAnswerVo(@RequestBody TrainingWorkVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            return JsonResult.success((Object)this.trainingWorkService.selectTrainingWorkUserAnswerVo(vo, user));
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectUserWorkAnswerVo"})
    @ResponseBody
    public String selectUserWorkAnswerVo(@RequestBody TrainingWorkUserAnswerVo vo) {
        return JsonResult.success((Object)this.trainingWorkService.selectUserWorkAnswerVo(vo));
    }

    @RequestMapping(value={"/saveUserAnswer"})
    @ResponseBody
    public String saveUserAnswer(@RequestBody TrainingWorkUserAnswerVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingWorkService.saveUserAnswer(vo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/updateTrainingWorkUserAnswerStatus"})
    @ResponseBody
    public String updateTrainingWorkUserAnswerStatus(@RequestBody TrainingWorkUserAnswerVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (user != null && user.getGroupId() != null) {
            this.trainingWorkService.updateTrainingWorkUserAnswerStatus(vo, user);
            return JsonResult.success();
        }
        return JsonResult.error();
    }

    @RequestMapping(value={"/selectWorkIsOverTime"})
    @ResponseBody
    public String selectWorkIsOverTime(@RequestBody TrainingWorkUserAnswerVo vo) {
        Users user = Authenticator.getInstance().getCurrentUser();
        WorkStatusVo workStatus = this.trainingWorkService.selectWorkStatus(vo, user);
        return JsonResult.success((Object)workStatus.getData(), (Object)workStatus.getStatus());
    }
}

