/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.controller.zother;

import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.TrainingWorkReviewerService;
import com.ovopark.training.util.DateUtils;
import com.ovopark.training.vo.ReviewByPageReq;
import com.ovopark.training.vo.UnReviewListVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/training/workReviewer"})
public class TrainingWorkReviewerController {
    @Autowired
    private TrainingWorkReviewerService trainingWorkReviewerService;

    @RequestMapping(value={"/getUnReviewByPage"})
    @ResponseBody
    public String getUnReviewByPage(Page<UnReviewListVo> page, ReviewByPageReq req) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!StringUtils.isEmpty((Object)req.getStartTime())) {
            req.setMyStartTime(DateUtils.getStartTimeOfDay(DateUtils.parse(req.getStartTime(), "yyyy-MM-dd")));
            req.setMyEndTime(DateUtils.getEndTimeOfDay(DateUtils.parse(req.getEndTime(), "yyyy-MM-dd")));
        }
        req.setUserId(user.getId());
        return this.trainingWorkReviewerService.getUnReviewByPage(page, req, user);
    }

    @RequestMapping(value={"/getUserAnswer"})
    @ResponseBody
    public String getUserAnswer(Integer userAnswerId) {
        if (userAnswerId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingWorkReviewerService.getUserAnswer(user.getId(), userAnswerId);
    }

    @RequestMapping(value={"/getUserAnswerNew"})
    @ResponseBody
    public String getUserAnswerNew(Integer userAnswerId, Integer turns) {
        if (userAnswerId == null) {
            return JsonResult.paramError();
        }
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingWorkReviewerService.getUserAnswerNew(user.getId(), userAnswerId, turns);
    }

    @RequestMapping(value={"/workReview"})
    @ResponseBody
    public String workReview(ReviewByPageReq req, Integer userAnswerId, Float score, String comment, Integer isPass) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!StringUtils.isEmpty((Object)req.getStartTime())) {
            req.setMyStartTime(DateUtils.getStartTimeOfDay(DateUtils.parse(req.getStartTime(), "yyyy-MM-dd")));
            req.setMyEndTime(DateUtils.getEndTimeOfDay(DateUtils.parse(req.getEndTime(), "yyyy-MM-dd")));
        }
        req.setUserId(user.getId());
        return this.trainingWorkReviewerService.workReview(req, user, userAnswerId, score, comment, isPass);
    }

    @RequestMapping(value={"/getReviewByPage"})
    @ResponseBody
    public String getReviewByPage(Page<UnReviewListVo> page, ReviewByPageReq req) {
        Users user = Authenticator.getInstance().getCurrentUser();
        if (!StringUtils.isEmpty((Object)req.getStartTime())) {
            req.setMyStartTime(DateUtils.getStartTimeOfDay(DateUtils.parse(req.getStartTime(), "yyyy-MM-dd")));
            req.setMyEndTime(DateUtils.getEndTimeOfDay(DateUtils.parse(req.getEndTime(), "yyyy-MM-dd")));
        }
        req.setUserId(user.getId());
        return this.trainingWorkReviewerService.getReviewByPage(page, req, user);
    }

    @RequestMapping(value={"/getReviewNum"})
    @ResponseBody
    public String getReviewNum() {
        Users user = Authenticator.getInstance().getCurrentUser();
        return this.trainingWorkReviewerService.getReviewNum(user.getGroupId(), user.getId());
    }
}

