/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.event.listener;

import com.ovopark.training.event.model.ResourceDeleteEvent;
import com.ovopark.training.service.resource.ResourceSinglePermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ResourceListener {
    private static final Logger log = LoggerFactory.getLogger(ResourceListener.class);
    @Autowired
    private ResourceSinglePermissionService resourceSinglePermissionService;

    @Async(value="oldCommon")
    @EventListener
    public void resourceDeleteEvent(ResourceDeleteEvent event) {
        log.info("ResourceDeleteEvent: {}", (Object)event);
        this.resourceSinglePermissionService.onResourceDelete(event.getResourceIdList());
    }
}

