/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.exception;

import com.ovopark.training.enhancer.subject.alarm.AlarmHelper;
import com.ovopark.training.enhancer.subject.env.EnvService;
import com.ovopark.training.enhancer.subject.resp.Result;
import com.ovopark.training.enhancer.subject.resp.ResultUtils;
import com.ovopark.training.enhancer.utils.EhContextUtil;
import com.ovopark.training.exception.ResultCodeInfo;
import com.ovopark.training.exception.SysErrorException;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.util.ContextUtil;
import com.ovopark.training.util.DateUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${training.alarm.aop-error.group-id:b89214a7-9884-449a-af60-c3d30a9b22c2}")
    private String alarmGroupId;
    @Autowired
    private EnvService envService;

    @ExceptionHandler(value={SysErrorException.class})
    public Result<ResultCodeInfo> sysErrorException(Exception e, HttpServletRequest request) throws Exception {
        String requestURL = request.getRequestURL() != null ? request.getRequestURL().toString() : "";
        log.warn(requestURL + "---->\u5168\u5c40\u8f93\u51fa\u5f02\u5e38", (Throwable)e);
        SysErrorException er = (SysErrorException)e;
        ResultCodeInfo resultCodeInfo = er.getResultCodeInfo();
        return ResultUtils.fail((String)"RuntimeException", (Object)resultCodeInfo);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<String> httpMessageNotReadableException(Exception e, HttpServletRequest request) throws Exception {
        StringBuilder sb = new StringBuilder();
        GlobalExceptionHandler.buildOne(sb, "queryString", request.getQueryString());
        GlobalExceptionHandler.buildOne(sb, "payload", this.getMessagePayload(request));
        log.warn("http\u8bf7\u6c42\u53c2\u6570\u8f6c\u6362\u5f02\u5e38 {}", (Object)sb, (Object)e);
        return ResultUtils.failData((Object)"\u5e94\u7528\u7248\u672c\u8fc7\u4f4e\u8bf7\u5347\u7ea7\u6700\u65b0\u7248");
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<String> methodArgumentNotValidException(Exception e, HttpServletRequest request) throws Exception {
        log.warn("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
        return ResultUtils.failData((Object)"\u53c2\u6570\u9519\u8bef");
    }

    @ExceptionHandler(value={Exception.class})
    public Result<String> exceptionErrorHandler(Exception e, HttpServletRequest request) throws Exception {
        String requestURL = request.getRequestURL() != null ? request.getRequestURL().toString() : "";
        Long useTime = 0L;
        ClientInfo currentClient = Authenticator.getInstance().getCurrentClient();
        if (currentClient != null && currentClient.getAccessTime() != null) {
            useTime = System.currentTimeMillis() - currentClient.getAccessTime();
        }
        int userId = ContextUtil.getUserId();
        String userAgent = request.getHeader("User-Agent");
        String traceId = MDC.get((String)"traceId");
        log.error("\n\u7528\u6237\uff1a{};\n\u63a5\u53e3\u8017\u65f6\uff1a{};\ntraceId:{}", new Object[]{userId, useTime, traceId, e});
        String title = this.envService.get("\u3010\u751f\u4ea7\u5f02\u5e38\u3011", "\u3010\u6d4b\u8bd5\u5f02\u5e38\u3011");
        StringBuilder sb = new StringBuilder(title + "\n");
        GlobalExceptionHandler.buildOne(sb, "\u65f6\u95f4", DateUtils.getNow());
        GlobalExceptionHandler.buildOne(sb, "\u73af\u5883", this.envService.getProfiles());
        GlobalExceptionHandler.buildOne(sb, "url", requestURL);
        GlobalExceptionHandler.buildOne(sb, "userId", userId);
        GlobalExceptionHandler.buildOne(sb, "\u4f01\u4e1a\u4fe1\u606f", EhContextUtil.getEnterpriseId());
        GlobalExceptionHandler.buildOne(sb, "queryString", request.getQueryString());
        GlobalExceptionHandler.buildOne(sb, "payload", this.getMessagePayload(request));
        GlobalExceptionHandler.buildOne(sb, "\u63a5\u53e3\u8017\u65f6", useTime + "ms");
        GlobalExceptionHandler.buildOne(sb, "userAgent", userAgent);
        GlobalExceptionHandler.buildOne(sb, "traceId", "\n" + traceId);
        String errorMsg = this.getErrorMsg(e);
        GlobalExceptionHandler.buildOne(sb, "\u9519\u8bef\u4fe1\u606f", "\n" + errorMsg);
        AlarmHelper.sentText((String)this.alarmGroupId, (String)StringUtils.left((String)sb.toString(), (int)2000), (String)"T", null);
        Result result = ResultUtils.fail((String)"\u7cfb\u7edf\u9519\u8bef", (Object)traceId);
        boolean development = this.envService.isDevelopment();
        if (development) {
            result.setErrorMessage(errorMsg);
        }
        return result;
    }

    private String getErrorMsg(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private String getLogUrlByTraceId(String traceId) {
        return "https://sls.console.aliyun.com/lognext/project/ovopark-biz-dev/savedsearch/savedsearch-1724400466067-485607";
    }

    private String getLogUrlByDate(long beginTime, long endTime) {
        return MessageFormat.format("https://avengers.ovopark.com/log-phone/#/?appName=ovopark-training&dtTimeFrom={0}&dtTimeTo={1}&source=Java", String.valueOf(beginTime), String.valueOf(endTime));
    }

    private static void buildOne(StringBuilder sb, String key, Object value) {
        sb.append("\n- \u3010").append(key).append("\u3011:  ").append(value).append("\n");
    }

    protected String getMessagePayload(HttpServletRequest request) {
        byte[] buf;
        ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
        if (wrapper != null && (buf = wrapper.getContentAsByteArray()).length > 0) {
            int length = Math.min(buf.length, this.getMaxPayloadLength());
            try {
                return new String(buf, 0, length, wrapper.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException ex) {
                return "[unknown]";
            }
        }
        return null;
    }

    private int getMaxPayloadLength() {
        return 10000;
    }

    public static void main(String[] args) {
        GlobalExceptionHandler.extracted();
    }

    private static void extracted() {
        try {
            GlobalExceptionHandler.error();
        }
        catch (Exception e) {
            System.out.println("r = " + e);
            System.out.println("r.getMessage() = " + e.getMessage());
            System.out.println("r.getLocalizedMessage() = " + e.getLocalizedMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String stackTrace = sw.toString();
            System.out.println("stackTrace = " + stackTrace);
        }
    }

    private static void error() {
        int i = 1 / 0;
    }
}

