/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.exception;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ReadBodyRequest
extends HttpServletRequestWrapper {
    private final String body;

    public String getBody() {
        return this.body;
    }

    public ReadBodyRequest(HttpServletRequest request) throws IOException {
        super(request);
        StringBuilder sb = new StringBuilder();
        ServletInputStream ins = request.getInputStream();
        try (BufferedReader isr = null;){
            if (ins != null) {
                isr = new BufferedReader(new InputStreamReader((InputStream)ins));
                char[] charBuffer = new char[128];
                int readCount = 0;
                while ((readCount = isr.read(charBuffer)) != -1) {
                    sb.append(charBuffer, 0, readCount);
                }
            } else {
                sb.append("");
            }
        }
        sb.toString();
        this.body = sb.toString();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayIns = new ByteArrayInputStream(this.body.getBytes());
        ServletInputStream servletIns = new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayIns.read();
            }
        };
        return servletIns;
    }
}

