/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.intercept;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.pojo.BaseResult;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.TokenBo;
import com.ovopark.training.exception.CommonException;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.ClientInfo;
import com.ovopark.training.model.TokenValueResp;
import com.ovopark.training.model.Users;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ContextUtil;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthenticatorInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatorInterceptor.class);
    @Value(value="${ovopark.sso.server.url}")
    public String ssoServerUrl;
    @Autowired
    private UserUtilService userUtilService;

    public AuthenticatorInterceptor() {
    }

    public AuthenticatorInterceptor(String ssoServerUrl) {
        this.ssoServerUrl = ssoServerUrl;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        boolean isNewLogin = false;
        ClientInfo clientInfo = new ClientInfo();
        String token = request.getParameter("ticket");
        clientInfo.setToken(token);
        String authorization = request.getHeader("Ovo-Authorization");
        String enterpriseId = request.getHeader("Enterprise-Id");
        if (!StringUtils.isEmpty((Object)authorization)) {
            isNewLogin = true;
        }
        if (isNewLogin) {
            return this.newLogin(response, authorization, token, clientInfo, enterpriseId);
        }
        String authenticator = request.getHeader("authenticator");
        if (authenticator != null) {
            String[] auths = authenticator.split(" ");
            token = this.assemblyClientInfo(auths, token, clientInfo);
        }
        Authenticator.getInstance().setCurrentClient(clientInfo);
        if (StringUtils.isEmpty((Object)token)) {
            return this.tokenInvalid(response);
        }
        TokenBo tokenBo = CommonUtil.decodeToken(token);
        Integer kUserId = tokenBo.getUserId();
        if (kUserId == null) {
            return this.tokenInvalid(response);
        }
        UsersPojo usersPojo = this.userUtilService.selectUser(kUserId);
        if (usersPojo == null) {
            return this.tokenInvalid(response);
        }
        Users user = new Users();
        BeanUtils.copyProperties((Object)usersPojo, (Object)user);
        String tokenPassword = tokenBo.getPassword();
        String dbPassword = user.getPassword();
        Date date = new Date();
        Date tokenDate = tokenBo.getDate();
        Date expiredDate = null;
        if (tokenDate != null) {
            if (tokenBo.getExpires() != null) {
                expiredDate = new Date(tokenDate.getTime() + tokenBo.getExpires());
            } else {
                Long expiredTime = Long.parseLong("-1");
                expiredDate = new Date(tokenDate.getTime() + expiredTime);
            }
        }
        if (tokenBo.getUserName() != null && !user.getUserName().equals(tokenBo.getUserName())) {
            return this.tokenInvalid(response);
        }
        if (!StringUtils.isEmpty((Object)tokenPassword) && !tokenPassword.equals(dbPassword)) {
            return this.tokenInvalid(response);
        }
        if (expiredDate != null && date.after(expiredDate)) {
            return this.tokenInvalid(response);
        }
        Authenticator.getInstance().setCurrentUser(user);
        ContextUtil.setUserId(user.getId());
        return true;
    }

    private boolean tokenInvalid(HttpServletResponse response) throws IOException {
        response.getWriter().append(JsonResult.invalidToken());
        return false;
    }

    private boolean newLogin(HttpServletResponse response, String authorization, String token, ClientInfo clientInfo, String headerEnterpriseId) throws IOException {
        String[] auths = authorization.split(" ");
        this.assemblyClientInfo(auths, token, clientInfo);
        log.info(this.ssoServerUrl + "/ovopark-sso/token/parseToken" + "?token=" + clientInfo.getToken());
        HttpResponse ovoResult = HttpUtil.createGet((String)(this.ssoServerUrl + "/ovopark-sso/token/parseToken" + "?token=" + clientInfo.getToken())).timeout(3000).execute();
        if (ovoResult == null || ovoResult.getStatus() != 200 || StringUtils.isEmpty((Object)ovoResult.body())) {
            log.error("\u8c03\u7528sso\u5931\u8d25");
            throw new CommonException("INVALID_TOKEN");
        }
        BaseResult tokenValueBaseResult = null;
        try {
            tokenValueBaseResult = (BaseResult)JSON.parseObject((String)ovoResult.body(), (TypeReference)new TypeReference<BaseResult<TokenValueResp>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new CommonException("INVALID_TOKEN");
        }
        if (!tokenValueBaseResult.getIsError().booleanValue()) {
            TokenValueResp resp = (TokenValueResp)tokenValueBaseResult.getData();
            UsersPojo usersPojo = this.userUtilService.selectUser(resp.getUserId());
            if (ObjectUtils.isEmpty((Object)usersPojo)) {
                log.info("token\u5931\u8d25\uff1a{} ,token= {} , userId = {} ", new Object[]{this.ssoServerUrl + "/ovopark-sso/token/parseToken", clientInfo.getToken(), resp.getUserId()});
                return false;
            }
            Users user = new Users();
            BeanUtils.copyProperties((Object)usersPojo, (Object)user);
            clientInfo.setUser(user);
            Authenticator.getInstance().setCurrentClient(clientInfo);
            Authenticator.getInstance().setCurrentUser(user);
            Integer groupId = user.getGroupId();
            if (groupId == null) {
                ContextUtil.setEnterpriseId(this.getEnterpriseId(headerEnterpriseId));
            } else {
                ContextUtil.setEnterpriseId(groupId);
            }
            user.setGroupId(ContextUtil.getEnterpriseId());
            ContextUtil.setUserId(user.getId());
            return true;
        }
        log.info("token\u5931\u8d25\uff1a{} ,token= {}", (Object)(this.ssoServerUrl + "/ovopark-sso/token/parseToken"), (Object)clientInfo.getToken());
        response.getWriter().append(JSONObject.toJSONString((Object)BaseResult.error((Object)"INVALID_TOKEN", (String)"500", (String)"INVALID_TOKEN")));
        return false;
    }

    private Integer getEnterpriseId(String enterpriseId) {
        if (StringUtils.isEmpty((Object)enterpriseId)) {
            return null;
        }
        return Integer.parseInt(enterpriseId);
    }

    private String assemblyClientInfo(String[] auths, String token, ClientInfo clientInfo) {
        if (auths.length > 0 && StringUtils.isEmpty((Object)token)) {
            token = auths[0];
            clientInfo.setToken(token);
        }
        if (auths.length > 1) {
            clientInfo.setClient(auths[1]);
        }
        if (auths.length > 2) {
            clientInfo.setVersion(auths[2]);
        }
        if (auths.length > 3) {
            clientInfo.setLang(auths[3]);
            if ("ENGLISH".equalsIgnoreCase(auths[3])) {
                clientInfo.setLocale(Locale.US);
            } else if ("TRADITIONAL_CHINESE".equalsIgnoreCase(auths[3])) {
                clientInfo.setLocale(Locale.TRADITIONAL_CHINESE);
            } else if ("INDONESIA".equalsIgnoreCase(auths[3])) {
                clientInfo.setLocale(new Locale("in", "ID"));
            }
        }
        if (auths.length > 4) {
            clientInfo.setTimeZone(auths[4]);
        }
        return token;
    }

    private CommonException pareCodeToCommonException(String code) {
        switch (code) {
            case "9990001": {
                return new CommonException("INVALID_TOKEN");
            }
            case "9990002": {
                return new CommonException("TOKEN_EXPIRED");
            }
        }
        return new CommonException("TOKEN_EXPIRED");
    }

    private String pareCodeToCommonString(String code) {
        switch (code) {
            case "9990001": {
                return "INVALID_TOKEN";
            }
            case "9990002": {
                return "TOKEN_EXPIRED";
            }
        }
        return "TOKEN_EXPIRED";
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object object, Exception exception) throws Exception {
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object object, ModelAndView modelAndView) throws Exception {
    }
}

