/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.training.mapper.TrainingAppShowMapper;
import com.ovopark.training.mapper.TrainingCourseMapper;
import com.ovopark.training.mapper.TrainingCourseUserMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mo.KafkaUserRoleChangeEventMo;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingAppShow;
import com.ovopark.training.model.TrainingCourse;
import com.ovopark.training.model.TrainingCourseUser;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.vo.TrainingCourseMobile;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class KafakaUserListener {
    private static final Logger log = LoggerFactory.getLogger(KafakaUserListener.class);
    @Resource
    private TrainingCourseUserMapper courseUserMapper;
    @Resource
    private TrainingCourseMapper courseMapper;
    @Resource
    private TrainingAppShowMapper appShowMapper;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private UserUtilService userUtilService;
    @Resource
    private TrainingPaperUserMapper paperUserMapper;
    @Resource
    private TrainingPaperMapper paperMapper;
    @Autowired
    private MessageSource messageSource;

    @KafkaListener(topics={"#{'${kafka.topic.updateRole}'}"})
    public void roleUpdateListener(ConsumerRecord<String, String> record) {
        block11: {
            log.info("\u89d2\u8272\u53d8\u66f4\u8bb0\u5f55{}", record.value());
            try {
                ArrayList userIds;
                UsersPojo userPojo;
                KafkaUserRoleChangeEventMo roleEventMo = (KafkaUserRoleChangeEventMo)JSONObject.parseObject((String)((String)record.value()), KafkaUserRoleChangeEventMo.class);
                if (StringUtils.isEmpty((Object)roleEventMo) || StringUtils.isEmpty((Object)roleEventMo.getState())) break block11;
                if (roleEventMo.getState() == 1) {
                    ArrayList userIds2;
                    UsersPojo userPojo2;
                    if (CollectionUtil.isEmpty((Collection)roleEventMo.getRoleIds()) || CollectionUtil.isEmpty((Collection)roleEventMo.getUserIds()) || (userPojo2 = this.userUtilService.selectUser((Integer)(userIds2 = new ArrayList(roleEventMo.getUserIds())).get(0))) == null || userPojo2.getGroupId() == null) break block11;
                    try {
                        this.addCourseRoleUsers(roleEventMo, userPojo2.getGroupId());
                    }
                    catch (Exception e) {
                        log.error("\u89d2\u8272\u53d8\u66f4\uff1a\u57f9\u8bad\u8ba1\u5212", (Throwable)e);
                    }
                    try {
                        this.addPaperRoleUsers(roleEventMo, userPojo2.getGroupId());
                    }
                    catch (Exception e) {
                        log.error("\u89d2\u8272\u53d8\u66f4\uff1a\u8003\u8bd5", (Throwable)e);
                    }
                    break block11;
                }
                if (roleEventMo.getState() != 2 || CollectionUtil.isEmpty((Collection)roleEventMo.getRoleIds()) || CollectionUtil.isEmpty((Collection)roleEventMo.getUserIds()) || (userPojo = this.userUtilService.selectUser((Integer)(userIds = new ArrayList(roleEventMo.getUserIds())).get(0))) == null || userPojo.getGroupId() == null) break block11;
                try {
                    this.deleteCourseRoleUsers(roleEventMo, userPojo.getGroupId());
                }
                catch (Exception e) {
                    log.error("\u89d2\u8272\u53d8\u66f4\uff1a\u57f9\u8bad\u8ba1\u5212", (Throwable)e);
                }
                try {
                    this.deletePaperRoleUsers(roleEventMo, userPojo.getGroupId());
                }
                catch (Exception e) {
                    log.error("\u89d2\u8272\u53d8\u66f4\uff1a\u8003\u8bd5", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("roleUpdateListener error:", (Throwable)e);
            }
        }
    }

    public void addCourseRoleUsers(KafkaUserRoleChangeEventMo roleEventMo, Integer enterpriseId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getEnterpriseId, (Object)enterpriseId)).in(TrainingCourseUser::getRoleId, (Collection)roleEventMo.getRoleIds())).eq(TrainingCourseUser::getCourseType, (Object)1);
        List courseUsers = this.courseUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtil.isEmpty((Collection)courseUsers)) {
            List courseIds = courseUsers.stream().map(TrainingCourseUser::getCourseId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.in(TrainingCourse::getId, courseIds)).eq(TrainingCourse::getStatus, (Object)3);
            List courseList = this.courseMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtil.isEmpty((Collection)courseList) && !CollectionUtil.isEmpty((Collection)roleEventMo.getUserIds())) {
                ArrayList<TrainingAppShow> appShowList = new ArrayList<TrainingAppShow>();
                for (TrainingCourse course : courseList) {
                    for (Integer userId : roleEventMo.getUserIds()) {
                        TrainingAppShow appShow = new TrainingAppShow();
                        appShow.setUserId(userId);
                        appShow.setProjectId(course.getId());
                        appShow.setTaskType(Integer.valueOf(4));
                        appShow.setRemoveType(Integer.valueOf(1));
                        appShow.setCreateTime(new Date());
                        appShow.setEnterpriseId(course.getEnterpriseId());
                        appShowList.add(appShow);
                    }
                }
                if (!CollectionUtil.isEmpty(appShowList)) {
                    this.appShowMapper.insertList(appShowList);
                }
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.eq(TrainingCourse::getStatus, (Object)2)).in(TrainingCourse::getId, courseIds);
            List courses = this.courseMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtil.isEmpty((Collection)courses)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                TaskMessageBody body = null;
                String startName = "\u57f9\u8bad\u8ba1\u5212\u5f00\u59cb : \u300a{0}\u300b";
                String newName = "\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u57f9\u8bad\u4efb\u52a1\uff0c\u8bf7\u5c3d\u5feb\u5b8c\u6210";
                String exName = "\u6709\u6548\u671f";
                String toName = "\u81f3";
                for (TrainingCourse course : courses) {
                    body = new TaskMessageBody();
                    body.setType(98);
                    TrainingCourseMobile push = new TrainingCourseMobile();
                    BeanUtils.copyProperties((Object)course, (Object)push);
                    body.setTaskJson(JSONObject.toJSONString((Object)push));
                    if (CollectionUtil.isEmpty((Collection)roleEventMo.getUserIds())) continue;
                    ArrayList<Integer> userIds = new ArrayList<Integer>(roleEventMo.getUserIds());
                    try {
                        this.jPushService.sendWebSocketAll(course.getCourseName(), MessageFormat.format(startName, course.getCourseName()), userIds, course.getEnterpriseId(), course.getId(), "TYPE_COURSE_SYSTEM", JSONObject.toJSONString((Object)course), course.getEndTime(), 1, 1, "training.job.course.start", course.getCourseName());
                        this.jPushService.pushNotificationAll(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_COURSE_SYSTEM", userIds, course.getCourseName(), newName + "\n" + exName + ":" + format.format(course.getStartTime()) + toName + format.format(course.getEndTime()), body);
                    }
                    catch (Exception e) {
                        log.error("\u63a8\u9001\u57f9\u8bad\u8ba1\u5212", (Throwable)e);
                    }
                }
            }
        }
    }

    public void deleteCourseRoleUsers(KafkaUserRoleChangeEventMo roleEventMo, Integer enterpriseId) {
        if (!CollectionUtil.isEmpty((Collection)roleEventMo.getRoleIds())) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(TrainingCourseUser::getEnterpriseId, (Object)enterpriseId)).in(TrainingCourseUser::getRoleId, (Collection)roleEventMo.getRoleIds())).eq(TrainingCourseUser::getCourseType, (Object)1);
            List courseUsers = this.courseUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtil.isEmpty((Collection)courseUsers)) {
                List courseIds = courseUsers.stream().map(TrainingCourseUser::getCourseId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingCourse::getId, courseIds)).eq(TrainingCourse::getEnterpriseId, (Object)enterpriseId)).eq(TrainingCourse::getStatus, (Object)2);
                List courseList = this.courseMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtil.isEmpty((Collection)courseList) && !CollectionUtil.isEmpty((Collection)roleEventMo.getUserIds())) {
                    for (TrainingCourse course : courseList) {
                        for (Integer userId : roleEventMo.getUserIds()) {
                            this.jPushService.deleteMessages(course.getId(), "TYPE_COURSE_SYSTEM", userId, null, 1);
                        }
                    }
                }
            }
        }
    }

    public void addPaperRoleUsers(KafkaUserRoleChangeEventMo roleEventMo, Integer enterpriseId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper1.eq(TrainingPaperUser::getEnterpriseId, (Object)enterpriseId)).in(TrainingPaperUser::getRoleId, (Collection)roleEventMo.getRoleIds());
        List paperUsers = this.paperUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtil.isEmpty((Collection)paperUsers)) {
            List paperIds = paperUsers.stream().map(TrainingPaperUser::getPaperId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper2.in(TrainingPaper::getId, paperIds)).eq(TrainingPaper::getPaperState, (Object)3);
            List paperList = this.paperMapper.selectList((Wrapper)wrapper2);
            if (!CollectionUtil.isEmpty((Collection)paperList) && !CollectionUtil.isEmpty((Collection)roleEventMo.getUserIds())) {
                ArrayList<TrainingAppShow> appShowList = new ArrayList<TrainingAppShow>();
                for (TrainingPaper paper : paperList) {
                    for (Integer userId : roleEventMo.getUserIds()) {
                        TrainingAppShow appShow = new TrainingAppShow();
                        appShow.setUserId(userId);
                        appShow.setProjectId(paper.getId());
                        appShow.setTaskType(Integer.valueOf(2));
                        appShow.setRemoveType(Integer.valueOf(1));
                        appShow.setCreateTime(new Date());
                        appShow.setEnterpriseId(paper.getEnterpriseId());
                        appShowList.add(appShow);
                    }
                }
                if (!CollectionUtil.isEmpty(appShowList)) {
                    this.appShowMapper.insertList(appShowList);
                }
            }
            LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper3.in(TrainingPaper::getId, paperIds)).in(TrainingPaper::getPaperState, Arrays.asList(1, 2));
            List papers = this.paperMapper.selectList((Wrapper)wrapper3);
            if (!CollectionUtil.isEmpty((Collection)papers)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                TaskMessageBody body = new TaskMessageBody();
                body.setType(64);
                String zName = "\u81f3";
                String paperTimeName = "\u8003\u8bd5\u65f6\u95f4";
                String startName = "\u5f00\u8003";
                String endName = "\u622a\u6b62";
                String nullName = "\u4e0d\u9650";
                for (TrainingPaper paper : papers) {
                    StringBuffer s = new StringBuffer(paperTimeName).append("\uff1a");
                    if (Objects.nonNull(paper.getStartTime()) && Objects.nonNull(paper.getEndTime())) {
                        s.append(df.format(paper.getStartTime()));
                        s.append(zName);
                        s.append(df.format(paper.getEndTime()));
                    } else if (Objects.nonNull(paper.getStartTime()) && Objects.isNull(paper.getEndTime())) {
                        s.append(df.format(paper.getStartTime()));
                        s.append(startName);
                    } else if (Objects.isNull(paper.getStartTime()) && Objects.nonNull(paper.getEndTime())) {
                        s.append(df.format(paper.getEndTime()));
                        s.append(endName);
                    } else {
                        s.append(nullName);
                    }
                    body.setTaskJson(JSONObject.toJSONString((Object)paper));
                    String pushs = MessageFormat.format("\u60a8\u6709\u4e00\u4e2a\u65b0\u8003\u8bd5\u3010{0}\u3011\uff0c\u70b9\u51fb\u67e5\u770b~", paper.getTitle());
                    for (Integer userId : roleEventMo.getUserIds()) {
                        try {
                            this.jPushService.sendWebSocket(paper.getTitle(), pushs, userId, paper.getEnterpriseId(), paper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paper), paper.getEndTime(), 1, 1, "training.paper.new.push", paper.getTitle());
                            this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", userId, paper.getTitle(), pushs + "\n" + s, body);
                        }
                        catch (Exception e) {
                            log.error("\u89d2\u8272kafaka\u63a8\u9001\u8003\u8bd5", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void deletePaperRoleUsers(KafkaUserRoleChangeEventMo roleEventMo, Integer enterpriseId) {
        if (!CollectionUtil.isEmpty((Collection)roleEventMo.getRoleIds())) {
            LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper1.eq(TrainingPaperUser::getEnterpriseId, (Object)enterpriseId)).in(TrainingPaperUser::getRoleId, (Collection)roleEventMo.getRoleIds());
            List paperUsers = this.paperUserMapper.selectList((Wrapper)wrapper1);
            if (!CollectionUtil.isEmpty((Collection)paperUsers)) {
                List paperIds = paperUsers.stream().map(TrainingPaperUser::getPaperId).distinct().collect(Collectors.toList());
                LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.in(TrainingPaper::getId, paperIds)).eq(TrainingPaper::getEnterpriseId, (Object)enterpriseId)).in(TrainingPaper::getPaperState, Arrays.asList(1, 2));
                List paperList = this.paperMapper.selectList((Wrapper)wrapper2);
                if (!CollectionUtil.isEmpty((Collection)paperList) && !CollectionUtil.isEmpty((Collection)roleEventMo.getUserIds())) {
                    for (TrainingPaper paper : paperList) {
                        for (Integer userId : roleEventMo.getUserIds()) {
                            this.jPushService.deleteMessages(paper.getId(), "TYPE_PAPER_SYSTEM", userId, null, 1);
                        }
                    }
                }
            }
        }
    }
}

