/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.exam.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.training.mo.KaFKaWorkCircleArticleAddMo;
import com.ovopark.training.mo.KaFKaWorkCircleArticleMo;
import com.ovopark.training.model.JPush;
import com.ovopark.training.model.TaskMessageBody;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.KafkaProducerService;
import com.ovopark.training.service.exam.IMessagePushService;
import com.ovopark.training.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MessagePushServiceImpl
implements IMessagePushService {
    private static final Logger log = LoggerFactory.getLogger(MessagePushServiceImpl.class);
    @Resource
    private JPushService jPushService;
    @Resource
    private KafkaProducerService kafkaProducerService;

    @Override
    @Async(value="createExamThreadPool")
    public void sendAddKafkaWorkCircleArticleAddMo(String title, String childModuleName, Integer circleId, Integer createBy, Integer groupId, Integer publicFlag, Integer sourceId, List<Integer> canSeeUserList) {
        KaFKaWorkCircleArticleMo kaFKaWorkCircleArticleMo = new KaFKaWorkCircleArticleMo();
        KaFKaWorkCircleArticleAddMo addMo = new KaFKaWorkCircleArticleAddMo();
        addMo.setTitle(title);
        addMo.setChildModuleName(childModuleName);
        addMo.setCircleId(circleId);
        addMo.setCreateAt(DateUtils.format(new Date(), DateUtils.FORMAT_LONG));
        addMo.setCreateBy(createBy);
        addMo.setGroupId(groupId);
        addMo.setPublicFlag(publicFlag);
        addMo.setSourceId(sourceId);
        addMo.setCanSeeUserList(canSeeUserList);
        kaFKaWorkCircleArticleMo.setAddMo(addMo);
        kaFKaWorkCircleArticleMo.setType("ADD");
        this.kafkaProducerService.sndMesForTemplate(kaFKaWorkCircleArticleMo);
    }

    @Override
    @Async(value="createExamThreadPool")
    public void sendPaperMessage(List<Integer> allUsers, TrainingPaper paper) {
        StringBuffer s = new StringBuffer("\u8003\u8bd5\u65f6\u95f4\uff1a");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (Objects.nonNull(paper.getStartTime()) && Objects.nonNull(paper.getEndTime())) {
            s.append(df.format(paper.getStartTime()));
            s.append("\u81f3");
            s.append(df.format(paper.getEndTime()));
        } else if (Objects.nonNull(paper.getStartTime()) && Objects.isNull(paper.getEndTime())) {
            s.append(df.format(paper.getStartTime()));
            s.append("\u5f00\u8003");
        } else if (Objects.isNull(paper.getStartTime()) && Objects.nonNull(paper.getEndTime())) {
            s.append(df.format(paper.getEndTime()));
            s.append("\u622a\u6b62");
        } else {
            s.append("\u4e0d\u9650");
        }
        TaskMessageBody body = new TaskMessageBody();
        body.setType(64);
        body.setTaskJson(JSONObject.toJSONString((Object)paper));
        for (Integer id : allUsers) {
            try {
                this.jPushService.sendWebSocket(paper.getTitle(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u8003\u8bd5\u3010" + paper.getTitle() + "\u3011\uff0c\u70b9\u51fb\u67e5\u770b~", id, paper.getEnterpriseId(), paper.getId(), "TYPE_PAPER_SYSTEM", JSONObject.toJSONString((Object)paper), paper.getEndTime(), 1, 1, "training.paper.new.push", paper.getTitle());
                if (!Objects.nonNull(paper.getIsSendMessage()) || paper.getIsSendMessage() != 1) continue;
                this.jPushService.pushNotification(JPush.MASSAGE_TYPE_NOTIFY, "TYPE_PAPER_SYSTEM", id, paper.getTitle(), "\u60a8\u6709\u4e00\u4e2a\u65b0\u8003\u8bd5\uff0c\u70b9\u51fb\u67e5\u770b~\n" + s, body);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8003\u8bd5\u4fe1\u606f\u5931\u8d25\u3002\u9519\u8bef\u5806\u6808\u4e3a\uff1a{}", (Object)JSONUtil.toJsonStr((Object)e));
            }
        }
    }
}

