/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.service.exam.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.ovopark.cloud.log.model.LogPojo;
import com.ovopark.cloud.log.sdk.LogApi;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.UserAndParentNameMo;
import com.ovopark.organize.common.model.mo.UserTagMo;
import com.ovopark.organize.common.model.mo.UsersAndOrgsMo;
import com.ovopark.organize.common.model.pojo.DepAndTagsPojo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import com.ovopark.organize.sdk.api.TagApi;
import com.ovopark.organize.sdk.api.UserApi;
import com.ovopark.organize.sdk.api.UserOrganizeApi;
import com.ovopark.privilege.api.RoleApi;
import com.ovopark.training.bo.JsonResult;
import com.ovopark.training.bo.Page;
import com.ovopark.training.bo.UserBo;
import com.ovopark.training.dto.ProjectInfoDto;
import com.ovopark.training.enums.PaperSourceEnum;
import com.ovopark.training.enums.PaperStateEnum;
import com.ovopark.training.enums.UserPaperStateEnum;
import com.ovopark.training.enums.YesNoEnum;
import com.ovopark.training.mapper.TrainingExamMapper;
import com.ovopark.training.mapper.TrainingExaminerMapper;
import com.ovopark.training.mapper.TrainingMaterialTypeMapper;
import com.ovopark.training.mapper.TrainingPaperMapper;
import com.ovopark.training.mapper.TrainingPaperUserMapper;
import com.ovopark.training.mapper.TrainingUserPaperMapper;
import com.ovopark.training.mapper.TrainingUserQuestionAttaMapper;
import com.ovopark.training.mapper.TrainingUserQuestionMapper;
import com.ovopark.training.mapper.TrainingUserQuestionPictureMapper;
import com.ovopark.training.mo.KaFKaWorkCircleArticleAddMo;
import com.ovopark.training.model.Authenticator;
import com.ovopark.training.model.Role;
import com.ovopark.training.model.TrainingExam;
import com.ovopark.training.model.TrainingExaminer;
import com.ovopark.training.model.TrainingMaterialType;
import com.ovopark.training.model.TrainingPaper;
import com.ovopark.training.model.TrainingPaperUser;
import com.ovopark.training.model.TrainingUserPaper;
import com.ovopark.training.model.TrainingUserQuestion;
import com.ovopark.training.model.TrainingUserQuestionAtta;
import com.ovopark.training.model.TrainingUserQuestionPicture;
import com.ovopark.training.model.Users;
import com.ovopark.training.request.ExamineeDetailRequest;
import com.ovopark.training.request.ItemAnalysisRequest;
import com.ovopark.training.request.PaperManagementRequest;
import com.ovopark.training.request.TrainingPapersListRequest;
import com.ovopark.training.request.TrainingPapersModifyRequest;
import com.ovopark.training.response.TrainingPaperDetailResponse;
import com.ovopark.training.service.JPushService;
import com.ovopark.training.service.TrainingExamService;
import com.ovopark.training.service.UserUtilService;
import com.ovopark.training.service.exam.IMessagePushService;
import com.ovopark.training.service.exam.ITrainingPaperRefactorService;
import com.ovopark.training.service.examChannel.ExamChannel;
import com.ovopark.training.service.examChannel.ExamChannelFactory;
import com.ovopark.training.service.materialtype.MaterialTypeService;
import com.ovopark.training.service.paperChannel.PaperChannel;
import com.ovopark.training.service.paperChannel.PaperChannerlFactory;
import com.ovopark.training.service.paperChannel.PaperUtil;
import com.ovopark.training.util.CommonUtil;
import com.ovopark.training.util.ListUtil;
import com.ovopark.training.util.StringsUtils;
import com.ovopark.training.vo.ItemInfoVo;
import com.ovopark.training.vo.OrgVo;
import com.ovopark.training.vo.PaperAnswerDetailVo;
import com.ovopark.training.vo.PaperManagementBaseInfoVo;
import com.ovopark.training.vo.PaperManagementExamineeDetailVo;
import com.ovopark.training.vo.PaperManagementItemAnalysisVo;
import com.ovopark.training.vo.PaperManagementItemDetailVo;
import com.ovopark.training.vo.PaperVo;
import com.ovopark.training.vo.TagVo;
import com.ovopark.training.vo.TrainingExamQuestionVo;
import com.ovopark.training.vo.TrainingOptionsVo;
import com.ovopark.training.vo.UserPaperRecordVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TrainingPaperRefactorServiceImpl
implements ITrainingPaperRefactorService {
    private static final Logger log = LoggerFactory.getLogger(TrainingPaperRefactorServiceImpl.class);
    @Resource
    private MessageSource messageSource;
    @Resource
    private TagApi tagApi;
    @Resource
    private UserApi userApi;
    @Resource
    private RoleApi roleApi;
    @Resource
    private DepartmentApi departmentApi;
    @Resource
    private UserOrganizeApi userOrganizeApi;
    @Resource
    private OrganizeApi organizeApi;
    @Resource
    private com.ovopark.privilege.api.UserApi priUserApi;
    @Resource
    private TrainingExamService examService;
    @Resource
    private UserUtilService userUtilService;
    @Resource
    private IMessagePushService messagePushService;
    @Resource
    private TrainingExamService trainingExamService;
    @Resource
    private TrainingPaperMapper paperMapper;
    @Autowired
    private MaterialTypeService materialTypeService;
    @Autowired
    private TrainingPaperUserMapper trainingPaperUserMapper;
    @Autowired
    private TrainingUserPaperMapper trainingUserPaperMapper;
    @Autowired
    private TrainingExamMapper trainingExamMapper;
    @Autowired
    private TrainingMaterialTypeMapper trainingMaterialTypeMapper;
    @Resource
    private TrainingExaminerMapper trainingExaminerMapper;
    @Autowired
    private PaperChannerlFactory paperChannerlFactory;
    @Autowired
    private ExamChannelFactory examChannelFactory;
    @Autowired
    private JPushService jPushService;
    @Autowired
    private LogApi logApi;
    @Autowired
    private TrainingUserQuestionMapper trainingUserQuestionMapper;
    @Autowired
    private TrainingUserQuestionPictureMapper userQuestionPictureMapper;
    @Autowired
    private TrainingUserQuestionAttaMapper trainingUserQuestionAttaMapper;

    @Override
    public Integer saveOrEditTrainingPaperInfo(TrainingPapersModifyRequest request, Users users) {
        Date now = new Date();
        if (request.getId() == null) {
            TrainingPaper paper = new TrainingPaper();
            BeanUtils.copyProperties((Object)request, (Object)paper);
            paper.setTitle(request.getPaperName());
            paper.setCreater(users.getId());
            paper.setCreateTime(now);
            paper.setUpdater(users.getId());
            paper.setUpdateTime(now);
            paper.setScoreSelect(Integer.valueOf(0));
            paper.setAllowViewPaperScore("" + request.getAllowViewPaperScore() + request.getAllowPaperScoreRightOrWrong() + request.getAllowPaperScorePassState());
            paper.setAllowViewPaperDetail("" + request.getAllowViewPaperDetail() + request.getAllowPaperDetailRightOrWrong() + request.getAllowPaperDetailShowError() + request.getAllowPaperDetailViewAnswer() + request.getAllowViewPaperTimeRange() + request.getAllowTimeRangeType());
            if (request.getPassLineType().equals(1)) {
                TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(request.getExamId());
                paper.setPassLineFixScore(request.getPassLine());
                BigDecimal ratio = new BigDecimal(request.getPassLine()).divide(trainingExam.getScore(), 2, 5).multiply(new BigDecimal(100));
                paper.setPassLine(Integer.valueOf(ratio.intValue()));
            }
            if (paper.getExamId() == null && paper.getPaperState() == null) {
                paper.setPaperState(Integer.valueOf(1));
            }
            if (paper.getPaperState() != null && paper.getPaperState() > 0) {
                if (request.getEndTime() != null && request.getEndTime().before(now)) {
                    paper.setPaperState(Integer.valueOf(3));
                } else {
                    paper.setPaperState(Integer.valueOf(1));
                }
            }
            if (request.getPaperState() == 1 && paper.getExamId() != null && (StringUtils.isEmpty((Object)paper.getPaperType()) || paper.getPaperType() == 1)) {
                paper.setExamId(this.examService.updateCopyExam(paper.getExamId(), users.getId()));
                paper.setPublishTime(now);
            }
            if (ObjectUtils.isEmpty((Object)request.getStartTime()) && paper.getPaperState() != null && paper.getPaperState() > 0 && paper.getIsTraining() != null && paper.getIsTraining() != 1 && paper.getExamId() != null) {
                paper.setStartTime(now);
            }
            if (request.getPaperState() == 1) {
                paper.setPublishTime(now);
            }
            this.paperMapper.insert(paper);
            this.pushExamMessage(paper, request, users, 0);
            return paper.getId();
        }
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(request.getId());
        Integer oldPaperState = paper.getPaperState();
        paper.setTitle(request.getPaperName());
        paper.setIsImportant(request.getIsImportant());
        paper.setTypeId(request.getTypeId());
        if (ObjectUtils.isEmpty((Object)request.getStartTime()) && paper.getPaperState() != null && paper.getPaperState() > 0 && paper.getIsTraining() != null && paper.getIsTraining() != 1 && request.getExamId() != null) {
            paper.setStartTime(now);
        }
        if (!ObjectUtils.isEmpty((Object)request.getStartTime())) {
            paper.setStartTime(request.getStartTime());
        }
        if (request.getEndTime() != null) {
            paper.setEndTime(request.getEndTime());
        } else {
            paper.setEndTime(null);
        }
        paper.setUpdateTime(now);
        paper.setUpdater(users.getId());
        paper.setReviewerType(request.getReviewerType());
        paper.setDescription(request.getDescription());
        paper.setIsAllAnswer(request.getIsAllAnswer());
        paper.setIsUnifyExamMinutes(request.getIsUnifyExamMinutes());
        if (YesNoEnum.YES.getKey().equals(paper.getIsUnifyExamMinutes()) && null != request.getPaperTime()) {
            paper.setPaperTime(request.getPaperTime());
        }
        paper.setIsAllowRepeatJoinExam(request.getIsAllowRepeatJoinExam());
        paper.setIsLimitExamTimes(request.getIsLimitExamTimes());
        if (YesNoEnum.YES.getKey().equals(request.getIsAllowRepeatJoinExam()) && YesNoEnum.YES.getKey().equals(request.getIsLimitExamTimes())) {
            if (!request.getRepetitionNum().equals(paper.getRepetitionNum())) {
                this.replaceRepetitionNumOperations(request, paper);
            }
            paper.setRepetitionNum(request.getRepetitionNum());
        }
        paper.setIsAllowRepeatJoinExamIfPassed(request.getIsAllowRepeatJoinExamIfPassed());
        paper.setIsMustLink(request.getIsMustLink());
        paper.setIsTimingTerminateExam(request.getIsTimingTerminateExam());
        if (YesNoEnum.YES.getKey().equals(request.getIsTimingTerminateExam())) {
            paper.setTimingEndExamDate(request.getTimingEndExamDate());
        }
        paper.setIsRemindExaming(request.getIsRemindExaming());
        paper.setIsRemindExampre(request.getIsRemindExampre());
        paper.setRemindExampreHour(request.getRemindExampreHour());
        paper.setIsRemindUnexamDays(request.getIsRemindUnexamDays());
        paper.setIsRemindUnexam(request.getIsRemindUnexam());
        paper.setRemindUnexamHour(request.getRemindUnexamHour());
        paper.setIsQuestion(request.getIsQuestion());
        paper.setIsOption(request.getIsOption());
        paper.setIsScreen(request.getIsScreen());
        paper.setScreenNum(request.getScreenNum());
        paper.setIsAutoRead(request.getIsAutoRead());
        paper.setIsGapAutoRead(request.getIsGapAutoRead());
        paper.setAllowViewPaperScore("" + request.getAllowViewPaperScore() + request.getAllowPaperScoreRightOrWrong() + request.getAllowPaperScorePassState());
        paper.setAllowViewPaperDetail("" + request.getAllowViewPaperDetail() + request.getAllowPaperDetailRightOrWrong() + request.getAllowPaperDetailShowError() + request.getAllowPaperDetailViewAnswer() + request.getAllowViewPaperTimeRange() + request.getAllowTimeRangeType());
        if (!StringUtils.isEmpty((Object)request.getIsTraining())) {
            paper.setIsTraining(request.getIsTraining());
        }
        if (request.getPaperState() == null && request.getStartTime() != null && request.getStartTime().after(now)) {
            paper.setPaperState(Integer.valueOf(1));
        }
        if (!StringUtils.isEmpty((Object)request.getPicUrl())) {
            paper.setPicUrl(request.getPicUrl());
        }
        if (request.getEnterpriseId() != null) {
            paper.setEnterpriseId(request.getEnterpriseId());
        }
        if (request.getPaperTime() != null) {
            paper.setPaperTime(request.getPaperTime());
        }
        if (request.getShowOptions() != null) {
            paper.setShowOptions(request.getShowOptions());
        }
        paper.setPaperType(request.getPaperType());
        paper.setQuestionClass(request.getQuestionClass());
        paper.setLookLevel(request.getLookLevel());
        if (oldPaperState == 0 && request.getPaperState() == 1) {
            paper.setPublishTime(now);
            if (!StringUtils.isEmpty((Object)request.getExamId()) && (StringUtils.isEmpty((Object)paper.getPaperType()) || paper.getPaperType() == 1)) {
                paper.setExamId(this.examService.updateCopyExam(request.getExamId(), users.getId()));
            }
        }
        this.paperMapper.updateById(paper);
        this.pushExamMessage(paper, request, users, oldPaperState);
        return paper.getId();
    }

    private void replaceRepetitionNumOperations(final TrainingPapersModifyRequest request, final TrainingPaper paper) {
        CommonUtil.handleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId())).eq(TrainingUserPaper::getEnterpriseId, (Object)paper.getEnterpriseId())).isNotNull(TrainingUserPaper::getUserId)).orderByAsc(TrainingUserPaper::getId);
                    List userPaperList = TrainingPaperRefactorServiceImpl.this.trainingUserPaperMapper.selectList((Wrapper)wrapper);
                    if (!CollectionUtils.isEmpty((Collection)userPaperList)) {
                        Map<Integer, List> userPaperListMap = userPaperList.stream().collect(Collectors.toMap(TrainingUserPaper::getUserId, e -> new ArrayList<TrainingUserPaper>(Arrays.asList(e)), (oldList, newList) -> {
                            oldList.addAll(newList);
                            return oldList;
                        }));
                        List userList = userPaperList.stream().map(TrainingUserPaper::getUserId).distinct().collect(Collectors.toList());
                        int repetitionNum = StringUtils.isEmpty((Object)request.getRepetitionNum()) ? 999 : request.getRepetitionNum();
                        for (Integer usersId : userList) {
                            List userPaperIdList = userPaperListMap.get(usersId);
                            for (int i = 0; i < userPaperIdList.size(); ++i) {
                                TrainingUserPaper userPaper = (TrainingUserPaper)userPaperIdList.get(i);
                                if (StringUtils.isEmpty((Object)userPaper.getSubmitTime())) {
                                    userPaper.setPaperCount(Integer.valueOf(repetitionNum));
                                } else {
                                    int counts = repetitionNum - 1 - i;
                                    userPaper.setPaperCount(Integer.valueOf(Math.max(counts, 0)));
                                }
                                TrainingPaperRefactorServiceImpl.this.trainingUserPaperMapper.updateByPrimaryKeySelective(userPaper);
                            }
                        }
                        TrainingUserPaper userPaper = new TrainingUserPaper();
                        userPaper.setPaperCount(Integer.valueOf(repetitionNum - 1));
                        LambdaUpdateWrapper userPaperWrapper = new LambdaUpdateWrapper();
                        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)userPaperWrapper.eq(TrainingUserPaper::getTrainingPaperId, (Object)paper.getId())).eq(TrainingUserPaper::getEnterpriseId, (Object)paper.getEnterpriseId())).isNull(TrainingUserPaper::getUserId);
                        TrainingPaperRefactorServiceImpl.this.trainingUserPaperMapper.update(userPaper, (Wrapper)userPaperWrapper);
                    }
                }
                catch (Exception e2) {
                    log.error("\u65b0\u589e\u903b\u8f91\uff0c\u4fee\u6539\u8003\u6b21\u9700\u8981\u540c\u6b65\u4fee\u6539\u7528\u6237\u8003\u8bd5\u8bb0\u5f55\u91cc\u7684\u8003\u6b21", (Throwable)e2);
                }
            }
        });
    }

    @Override
    public TrainingPaperDetailResponse showPaperDetail(Integer paperId) {
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        TrainingPaperDetailResponse paperDetailResponse = new TrainingPaperDetailResponse();
        if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
            TrainingMaterialType trainingMaterialType;
            if (trainingPaper.getPassLineType() == 1) {
                trainingPaper.setPassLine(trainingPaper.getPassLineFixScore());
            }
            Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
            paperDetailResponse.setPaperName(trainingPaper.getTitle());
            BeanUtils.copyProperties((Object)trainingPaper, (Object)paperDetailResponse);
            this.getAnswerSetting(trainingPaper, paperDetailResponse);
            if (!StringUtils.isEmpty((Object)trainingPaper.getExamId())) {
                List<TrainingExamQuestionVo> trainingExamQuestionVos = this.trainingExamService.selectExamQuestion(trainingPaper.getExamId());
                paperDetailResponse.setTrainingExamQuestionVos(trainingExamQuestionVos);
                TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
                if (!ObjectUtils.isEmpty((Object)trainingExam)) {
                    String examName = trainingExam.getName();
                    BigDecimal totalScore = trainingExam.getScore();
                    paperDetailResponse.setTotalScore(totalScore);
                    paperDetailResponse.setExamName(examName);
                }
            }
            StringBuffer sb = new StringBuffer("");
            ArrayList<UserBo> users = new ArrayList<UserBo>();
            if (trainingPaper.getLookLevel() != null && trainingPaper.getLookLevel() == 1) {
                List<Integer> whoCanSeeList = this.trainingPaperUserMapper.selectUserIdsByPaperId(paperDetailResponse.getId());
                if (!CollectionUtils.isEmpty(whoCanSeeList)) {
                    BaseResult base = this.userApi.getUserByIdList(whoCanSeeList);
                    if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                        List pojoList = (List)base.getData();
                        for (UsersPojo pojo : pojoList) {
                            UserBo bo = new UserBo();
                            bo.setId(pojo.getId());
                            bo.setShowName(pojo.getShowName());
                            sb.append(pojo.getShowName()).append("\uff0c");
                            users.add(bo);
                        }
                    }
                    sb.delete(sb.length() - 1, sb.length());
                }
            } else {
                sb.append(this.messageSource.getMessage("training.all.people", null, locale));
            }
            LambdaQueryWrapper roleWrapper = new LambdaQueryWrapper();
            roleWrapper.eq(TrainingPaperUser::getPaperId, (Object)paperId);
            roleWrapper.isNotNull(TrainingPaperUser::getRoleId);
            List roleUserList = this.trainingPaperUserMapper.selectList((Wrapper)roleWrapper);
            if (!CollectionUtils.isEmpty((Collection)roleUserList)) {
                List roleIds = roleUserList.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                com.ovopark.privilege.response.BaseResult base = this.roleApi.getRolePojoByIdList(roleIds);
                ArrayList<Role> rolesList = new ArrayList<Role>();
                if (base != null && !CollectionUtils.isEmpty((Collection)((Collection)base.getData()))) {
                    for (Object pojo : (List)base.getData()) {
                        Role role = new Role();
                        role.setId(pojo.getId());
                        role.setRoleName(pojo.getRoleName());
                        rolesList.add(role);
                        if (sb.length() > 1) {
                            sb.append("," + pojo.getRoleName());
                            continue;
                        }
                        sb.append(pojo.getRoleName());
                    }
                }
                paperDetailResponse.setRoleList(rolesList);
            }
            LambdaQueryWrapper tagWrapper = new LambdaQueryWrapper();
            tagWrapper.eq(TrainingPaperUser::getPaperId, (Object)paperId);
            tagWrapper.isNotNull(TrainingPaperUser::getTagId);
            List tagUserList = this.trainingPaperUserMapper.selectList((Wrapper)tagWrapper);
            if (!CollectionUtils.isEmpty((Collection)tagUserList)) {
                List tagIds = tagUserList.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                ArrayList<TagVo> tagList = new ArrayList<TagVo>();
                for (Integer tagId : tagIds) {
                    BaseResult result = this.tagApi.getUsersTagById(tagId);
                    if (result.getIsError().booleanValue() || result.getData() == null) continue;
                    UserTagMo pojo = (UserTagMo)result.getData();
                    TagVo tag = new TagVo();
                    tag.setId(pojo.getId());
                    tag.setName(pojo.getTagName());
                    tagList.add(tag);
                    if (sb.length() > 1) {
                        sb.append("," + pojo.getTagName());
                        continue;
                    }
                    sb.append(pojo.getTagName());
                }
                paperDetailResponse.setTagList(tagList);
            }
            LambdaQueryWrapper orgWrapper = new LambdaQueryWrapper();
            orgWrapper.eq(TrainingPaperUser::getPaperId, (Object)paperId);
            orgWrapper.isNotNull(TrainingPaperUser::getOrganizeId);
            List orgUserList = this.trainingPaperUserMapper.selectList((Wrapper)orgWrapper);
            if (!CollectionUtils.isEmpty((Collection)orgUserList)) {
                List organizeIds = orgUserList.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                ArrayList<OrgVo> orgList = new ArrayList<OrgVo>();
                for (String organizeId : organizeIds) {
                    String[] depSplit;
                    OrgVo org;
                    OrganizePojo pojo;
                    BaseResult result;
                    if (organizeId.startsWith("O_")) {
                        String[] orgSplit = organizeId.split("O_");
                        result = this.organizeApi.getOrganizeById(Integer.valueOf(Integer.parseInt(orgSplit[1])));
                        if (result.getIsError().booleanValue() || result.getData() == null) continue;
                        pojo = (OrganizePojo)result.getData();
                        org = new OrgVo();
                        org.setId(organizeId);
                        org.setName(pojo.getName());
                        orgList.add(org);
                        if (sb.length() > 1) {
                            sb.append("," + pojo.getName());
                            continue;
                        }
                        sb.append(pojo.getName());
                        continue;
                    }
                    if (!organizeId.startsWith("S_") || (result = this.departmentApi.getDepartmentById(Integer.valueOf(Integer.parseInt((depSplit = organizeId.split("S_"))[1])))).getIsError().booleanValue() || result.getData() == null) continue;
                    pojo = (DepartmentPojo)result.getData();
                    org = new OrgVo();
                    org.setId(organizeId);
                    org.setName(pojo.getName());
                    orgList.add(org);
                    if (sb.length() > 1) {
                        sb.append("," + pojo.getName());
                        continue;
                    }
                    sb.append(pojo.getName());
                }
                paperDetailResponse.setOrganizeList(orgList);
            }
            ArrayList<UserBo> examiners = new ArrayList<UserBo>();
            StringBuffer sbExaminer = new StringBuffer("");
            if (paperDetailResponse.getReviewerType() != null) {
                List<Integer> userIdList = new ArrayList<Integer>();
                if (paperDetailResponse.getReviewerType() == 1) {
                    userIdList.add(paperDetailResponse.getCreater());
                } else if (paperDetailResponse.getReviewerType() == 4) {
                    LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                    queryWrapper.eq(TrainingExaminer::getTrainingPaperId, (Object)paperId);
                    queryWrapper.eq(Objects.nonNull(trainingPaper.getEnterpriseId()), TrainingExaminer::getEnterpriseId, (Object)trainingPaper.getEnterpriseId());
                    List trainingExaminerList = this.trainingExaminerMapper.selectList((Wrapper)queryWrapper);
                    if (!CollectionUtils.isEmpty((Collection)trainingExaminerList)) {
                        userIdList = trainingExaminerList.stream().map(TrainingExaminer::getUserId).collect(Collectors.toList());
                    }
                }
                if (!CollectionUtils.isEmpty(userIdList)) {
                    Map<Integer, UsersPojo> usersPojoMap = this.userUtilService.selectUserMap(userIdList);
                    for (Integer userId : userIdList) {
                        UserBo userBo = new UserBo();
                        UsersPojo usersPojo = usersPojoMap.get(userId);
                        userBo.setId(userId);
                        userBo.setShowName(usersPojo.getShowName());
                        userBo.setUserName(usersPojo.getUserName());
                        examiners.add(userBo);
                    }
                    if (!CollectionUtils.isEmpty(examiners)) {
                        examiners.stream().forEach(u -> sbExaminer.append(u.getShowName()).append("\uff0c"));
                        sbExaminer.delete(sbExaminer.length() - 1, sbExaminer.length());
                    }
                }
            }
            paperDetailResponse.setExaminerNames(sbExaminer.toString());
            paperDetailResponse.setPaperUserNames(sb.toString());
            paperDetailResponse.setExaminerList(examiners);
            paperDetailResponse.setPaperUserList(users);
            if (paperDetailResponse.getTypeId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterialType = (TrainingMaterialType)this.trainingMaterialTypeMapper.selectById(paperDetailResponse.getTypeId())))) {
                paperDetailResponse.setTypeName(trainingMaterialType.getMaterialTypeName());
                paperDetailResponse.setMaterialTypeLevel(trainingMaterialType.getMaterialTypeLevel());
                paperDetailResponse.setSourceId(trainingMaterialType.getSourceId());
                paperDetailResponse.setOriginId(trainingMaterialType.getOriginId());
            }
        }
        return paperDetailResponse;
    }

    private void getAnswerSetting(TrainingPaper trainingPaper, TrainingPaperDetailResponse paperDetailResponse) {
        String allowViewPaperScoreString = trainingPaper.getAllowViewPaperScore();
        int allowViewPaperScore = Integer.parseInt(allowViewPaperScoreString.substring(0, 1));
        paperDetailResponse.setAllowViewPaperScore(Integer.valueOf(allowViewPaperScore));
        int allPaperScoreRightOrWrong = Integer.parseInt(allowViewPaperScoreString.substring(1, 2));
        paperDetailResponse.setAllowPaperScoreRightOrWrong(Integer.valueOf(allPaperScoreRightOrWrong));
        int allPaperScorePassState = Integer.parseInt(allowViewPaperScoreString.substring(2, 3));
        paperDetailResponse.setAllowPaperScorePassState(Integer.valueOf(allPaperScorePassState));
        String allowViewPaperDetailString = trainingPaper.getAllowViewPaperDetail();
        int allViewPaperDetail = Integer.parseInt(allowViewPaperDetailString.substring(0, 1));
        paperDetailResponse.setAllowViewPaperDetail(Integer.valueOf(allViewPaperDetail));
        int allPaperDetialRightOrWrong = Integer.parseInt(allowViewPaperDetailString.substring(1, 2));
        paperDetailResponse.setAllowPaperDetailRightOrWrong(Integer.valueOf(allPaperDetialRightOrWrong));
        int allowPaperDetailShowError = Integer.parseInt(allowViewPaperDetailString.substring(2, 3));
        paperDetailResponse.setAllowPaperDetailShowError(Integer.valueOf(allowPaperDetailShowError));
        int allowPaperDetailViewAnswer = Integer.parseInt(allowViewPaperDetailString.substring(3, 4));
        paperDetailResponse.setAllowPaperDetailViewAnswer(Integer.valueOf(allowPaperDetailViewAnswer));
        int allowViewPaperTimeRange = Integer.parseInt(allowViewPaperDetailString.substring(4, 5));
        paperDetailResponse.setAllowViewPaperTimeRange(Integer.valueOf(allowViewPaperTimeRange));
        int allowTimeRangeType = Integer.parseInt(allowViewPaperDetailString.substring(5, 6));
        paperDetailResponse.setAllowTimeRangeType(Integer.valueOf(allowTimeRangeType));
    }

    @Override
    public void processPaperHistory(Integer enterpriseId) {
        for (PaperSourceEnum paperSourceEnum : PaperSourceEnum.values()) {
            PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperSourceEnum.getPaperTableValue());
            paperChannel.handleOldData(enterpriseId);
            paperChannel.handleOldDataTwo(enterpriseId);
            paperChannel.handleOldDataThree(enterpriseId);
        }
    }

    @Override
    public PaperManagementBaseInfoVo getPaperManagementBaseInfo(PaperManagementRequest request) {
        TrainingExam trainingExam;
        TrainingMaterialType trainingMaterialType;
        PaperVo paperVo = this.paperMapper.getTrainingPaperById(request.getPaperId());
        if (ObjectUtils.isEmpty((Object)paperVo)) {
            throw new RuntimeException("\u8003\u8bd5\u4e0d\u5b58\u5728");
        }
        PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperVo, request.getShiftId());
        PaperManagementBaseInfoVo paperBaseInfo = new PaperManagementBaseInfoVo();
        BeanUtils.copyProperties((Object)paperVo, (Object)paperBaseInfo);
        paperBaseInfo.setPaperId(paperVo.getId());
        if (paperBaseInfo.getCategoryId() != null && !ObjectUtils.isEmpty((Object)(trainingMaterialType = (TrainingMaterialType)this.trainingMaterialTypeMapper.selectById(paperBaseInfo.getCategoryId())))) {
            paperBaseInfo.setCategoryName(trainingMaterialType.getMaterialTypeName());
        }
        paperBaseInfo.setPaperState(PaperStateEnum.getFrontEndValueByDatabaseValue((Integer)paperBaseInfo.getPaperState()));
        if (!StringUtils.isEmpty((Object)paperBaseInfo.getExamId()) && !ObjectUtils.isEmpty((Object)(trainingExam = (TrainingExam)this.trainingExamMapper.selectById(paperBaseInfo.getExamId())))) {
            String examName = trainingExam == null ? "" : trainingExam.getName();
            BigDecimal totalScore = trainingExam.getScore();
            paperBaseInfo.setPaperTotalScore(totalScore);
            paperBaseInfo.setExamName(examName);
            BigDecimal passScore = PaperUtil.getPassScore(paperVo.getPassLineType(), paperVo.getPassLine(), paperVo.getPassLineFixScore(), trainingExam.getScore());
            paperBaseInfo.setPaperPassScore(passScore);
        }
        paperBaseInfo.setPaperSource(PaperSourceEnum.getFrontEndValueByPaperTableValue((Integer)paperBaseInfo.getProjectShow()));
        ProjectInfoDto projectInfo = paperChannel.getSourceProjectInfo(paperBaseInfo.getProjectId());
        paperBaseInfo.setSourceProjectName(projectInfo != null ? projectInfo.getProjectName() : "");
        return paperBaseInfo;
    }

    @Override
    public Page<PaperManagementExamineeDetailVo> getPaperManagementExamineeDetails(ExamineeDetailRequest request) {
        Page<PaperManagementExamineeDetailVo> page = new Page<PaperManagementExamineeDetailVo>();
        request.setCountType(PaperChannel.COUNT_EFFECTIVE);
        List<PaperManagementExamineeDetailVo> dataList = this.selectExamineeDetails(request);
        if (!CollectionUtils.isEmpty(dataList)) {
            page = ListUtil.myPage(dataList, request.getPageNumber(), request.getPageSize());
        }
        return page;
    }

    @Override
    public List<PaperManagementExamineeDetailVo> selectExamineeDetails(ExamineeDetailRequest request) {
        PaperVo paperVo = this.paperMapper.getTrainingPaperById(request.getPaperId());
        if (ObjectUtils.isEmpty((Object)paperVo)) {
            throw new RuntimeException("\u8003\u8bd5\u4e0d\u5b58\u5728");
        }
        PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperVo, request.getShiftId());
        List<PaperManagementExamineeDetailVo> res = paperChannel.selectExamineeDetails(request, paperVo, request.getUser());
        return res;
    }

    @Override
    public Page<PaperManagementItemAnalysisVo> getPaperManagementItemAnalysis(ItemAnalysisRequest request) {
        Page<PaperManagementItemAnalysisVo> page = new Page<PaperManagementItemAnalysisVo>();
        List<PaperManagementItemAnalysisVo> dataList = this.selectItemAnalysis(request);
        if (!CollectionUtils.isEmpty(dataList)) {
            page = ListUtil.myPage(dataList, request.getPageNumber(), request.getPageSize());
        }
        return page;
    }

    @Override
    public String deletePaper(Integer paperId, LogPojo pojo) {
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!pojo.getEnterpriseId().equals(paper.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        this.paperMapper.deleteById(paperId);
        if (!StringUtils.isEmpty((Object)paperId)) {
            try {
                this.jPushService.deleteMessages(paperId, "TYPE_PAPER_SYSTEM", null, null, 1);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
        pojo.setI18nParam(paper.getTitle());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public void updatePaperState(Integer paperId, Integer paperState, Users user) {
        Date now = new Date();
        TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!ObjectUtils.isEmpty((Object)trainingPaper)) {
            Integer papeStateOld = trainingPaper.getPaperState();
            if (paperState != null && paperState != 3) {
                if (StringUtils.isEmpty((Object)trainingPaper.getStartTime()) || trainingPaper.getStartTime().compareTo(new Date()) <= 0) {
                    paperState = 2;
                }
                if (!StringUtils.isEmpty((Object)trainingPaper.getEndTime()) && trainingPaper.getEndTime().compareTo(new Date()) < 0) {
                    paperState = 3;
                }
            }
            trainingPaper.setUpdater(user.getId());
            trainingPaper.setUpdateTime(now);
            trainingPaper.setPaperState(paperState);
            if (trainingPaper.getPaperState() == 3) {
                trainingPaper.setCloseTime(now);
                trainingPaper.setIsClose(Integer.valueOf(1));
            }
            if (!(StringUtils.isEmpty((Object)trainingPaper.getPaperState()) || StringUtils.isEmpty((Object)paperState) || trainingPaper.getPaperState() != 0 || trainingPaper.getPaperType() != 1 || paperState != 1 && paperState != 2 || StringUtils.isEmpty((Object)trainingPaper.getExamId()))) {
                trainingPaper.setExamId(this.examService.updateCopyExam(trainingPaper.getExamId(), user.getId()));
            }
            this.paperMapper.updateById(trainingPaper);
            if (trainingPaper.getIsTraining() == 0 && trainingPaper.getPaperState() == 3) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.jPushService.updateMessagesByObjectType(trainingPaper.getId(), "TYPE_PAPER_SYSTEM", null, null, 1, format.format(new Date()));
                this.jPushService.deleteMessages(trainingPaper.getId(), "TYPE_PAPER_SYSTEM", null, null, 1);
                if (trainingPaper.getLookLevel() != null && trainingPaper.getLookLevel() == 1) {
                    this.updateUsersByClose(paperId, user.getId(), user.getGroupId());
                }
            }
            if (trainingPaper.getIsTraining() == 0 && papeStateOld == 1 && paperState == 0) {
                this.jPushService.deleteMessages(trainingPaper.getId(), "TYPE_PAPER_SYSTEM", null, null, 1);
            }
        }
    }

    @Override
    public void updateUsersByClose(Integer paperId, Integer userId, Integer groupId) {
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(TrainingPaperUser::getPaperId, (Object)paperId);
        List paperUserList = this.trainingPaperUserMapper.selectList((Wrapper)wrapper1);
        if (!CollectionUtils.isEmpty((Collection)paperUserList)) {
            List orgIds;
            List tagIds;
            List userIdList = paperUserList.stream().map(TrainingPaperUser::getUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> roleList = paperUserList.stream().map(TrainingPaperUser::getRoleId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<Integer> pojoList = this.userUtilService.selectUsersByRoles(roleList, groupId);
            if (!CollectionUtils.isEmpty(pojoList)) {
                pojoList.removeAll(userIdList);
                userIdList.addAll(pojoList);
                ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
                for (Integer pojoId : pojoList) {
                    TrainingPaperUser paperUser = new TrainingPaperUser();
                    paperUser.setPaperId(paperId);
                    paperUser.setUserId(pojoId);
                    paperUser.setEnterpriseId(groupId);
                    paperUsers.add(paperUser);
                }
                this.trainingPaperUserMapper.insertList(paperUsers);
            }
            if (!CollectionUtils.isEmpty(tagIds = paperUserList.stream().map(TrainingPaperUser::getTagId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                DepAndTagsPojo pojo = new DepAndTagsPojo();
                pojo.setGroupId(groupId);
                pojo.setTagIds(tagIds);
                pojo.setUserId(userId);
                BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
                    for (Map map : (List)tagResult.getData()) {
                        Integer id = (Integer)map.get("id");
                        if (userIdList.contains(id)) continue;
                        userIdList.add(id);
                        TrainingPaperUser paperUser = new TrainingPaperUser();
                        paperUser.setPaperId(paperId);
                        paperUser.setUserId(id);
                        paperUser.setEnterpriseId(groupId);
                        paperUsers.add(paperUser);
                    }
                    this.trainingPaperUserMapper.insertList(paperUsers);
                }
            }
            if (!CollectionUtils.isEmpty(orgIds = paperUserList.stream().map(TrainingPaperUser::getOrganizeId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(groupId);
                mo.setOrganizeIds(orgIds);
                BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    List users = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    ArrayList<TrainingPaperUser> paperUsers = new ArrayList<TrainingPaperUser>();
                    users.removeAll(userIdList);
                    if (!CollectionUtils.isEmpty(users)) {
                        for (Integer id : users) {
                            TrainingPaperUser paperUser = new TrainingPaperUser();
                            paperUser.setPaperId(paperId);
                            paperUser.setUserId(id);
                            paperUser.setEnterpriseId(groupId);
                            paperUsers.add(paperUser);
                        }
                        this.trainingPaperUserMapper.insertList(paperUsers);
                    }
                }
            }
            LambdaUpdateWrapper wrapper2 = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)wrapper2.eq(TrainingPaperUser::getPaperId, (Object)paperId)).isNull(TrainingPaperUser::getUserId);
            this.trainingPaperUserMapper.delete((Wrapper)wrapper2);
        }
    }

    @Override
    public List<UserPaperRecordVo> getUserPaperRecordList(PaperManagementRequest request) {
        PaperVo paperVo = this.paperMapper.getTrainingPaperById(request.getPaperId());
        if (ObjectUtils.isEmpty((Object)paperVo)) {
            throw new RuntimeException("\u8003\u8bd5\u4e0d\u5b58\u5728");
        }
        PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperVo, request.getShiftId());
        List<TrainingUserPaper> trainingUserPapers = paperChannel.getUserPaperList(paperVo, request.getUserId(), request.getUserType());
        List paperPassingUserPaperIdList = trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getPassState().equals(1)).map(TrainingUserPaper::getId).collect(Collectors.toList());
        ArrayList<UserPaperRecordVo> res = new ArrayList<UserPaperRecordVo>();
        trainingUserPapers.forEach(trainingUserPaper -> {
            UserPaperRecordVo vo = new UserPaperRecordVo();
            vo.setUserPaperId(trainingUserPaper.getId());
            vo.setCreateTime(trainingUserPaper.getCreateTime());
            vo.setSubmitTime(trainingUserPaper.getSubmitTime());
            vo.setUserPaperState(UserPaperStateEnum.getFrontEndValueByDatabaseValue((Integer)trainingUserPaper.getPaperStatus()));
            if (UserPaperStateEnum.PAPER_END.getDatabaseValue().equals(trainingUserPaper.getPaperStatus())) {
                vo.setUserPassState(Integer.valueOf(0));
                if (paperPassingUserPaperIdList.contains(trainingUserPaper.getId())) {
                    vo.setUserPassState(Integer.valueOf(1));
                }
            }
            vo.setScore(trainingUserPaper.getScore());
            res.add(vo);
        });
        res.sort(Comparator.comparing(UserPaperRecordVo::getCreateTime));
        return res;
    }

    @Override
    public PaperManagementItemDetailVo getPaperManagementItemDetail(PaperManagementRequest request) {
        PaperVo paperVo = this.paperMapper.getTrainingPaperById(request.getPaperId());
        if (ObjectUtils.isEmpty((Object)paperVo)) {
            throw new RuntimeException("\u8003\u8bd5\u4e0d\u5b58\u5728");
        }
        PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperVo, request.getShiftId());
        List<Object> trainingUserPapers = paperChannel.getUserPaperList(paperVo, null, null);
        if (request.getUserType() != null) {
            trainingUserPapers = request.getUserType() == 0 ? trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() != null).collect(Collectors.toList()) : trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getLoginUserId() != null).collect(Collectors.toList());
        }
        List<Integer> userPaperIdList = trainingUserPapers.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        request.setLocale(locale);
        TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(paperVo.getExamId());
        ExamChannel examChannel = this.examChannelFactory.getExamChannel(trainingExam.getExamClass());
        PaperManagementItemDetailVo itemDetail = examChannel.getItemDetail(request, trainingExam, userPaperIdList);
        return itemDetail;
    }

    @Override
    public String removeUserPaperRecord(Integer paperId, Integer userId, Integer userType, Integer shiftId, LogPojo pojo) {
        TrainingPaper paper = (TrainingPaper)this.paperMapper.selectById(paperId);
        if (!pojo.getEnterpriseId().equals(paper.getEnterpriseId())) {
            return JsonResult.error((String)"NO_PERMISSION", (Object)"\u65e0\u6743\u9650\u5220\u9664");
        }
        PaperVo paperVo = this.paperMapper.getTrainingPaperById(paperId);
        PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperVo, shiftId);
        List<TrainingUserPaper> trainingUserPapers = paperChannel.getUserPaperList(paperVo, userId, userType);
        List idList = trainingUserPapers.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(TrainingUserPaper::getId, idList);
        this.trainingUserPaperMapper.delete((Wrapper)wrapper);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TrainingUserQuestion::getUserPaperId, idList);
        this.trainingUserQuestionMapper.delete((Wrapper)queryWrapper);
        if (!StringUtils.isEmpty((Object)paperId)) {
            try {
                this.jPushService.deleteMessages(paperId, "TYPE_PAPER_SYSTEM", null, null, 1);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u63a8\u9001\u4fe1\u606f", (Throwable)e);
            }
        }
        pojo.setI18nParam(paper.getTitle());
        this.logApi.save(pojo);
        return JsonResult.success();
    }

    @Override
    public PaperAnswerDetailVo getUserPaperAnswerDetail(PaperManagementRequest request) {
        TrainingUserPaper userPaper = (TrainingUserPaper)this.trainingUserPaperMapper.selectById(request.getUserPaperId());
        PaperVo paper = this.paperMapper.getTrainingPaperById(userPaper.getTrainingPaperId());
        if (ObjectUtils.isEmpty((Object)paper)) {
            throw new RuntimeException("\u8003\u8bd5\u4e0d\u5b58\u5728");
        }
        PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paper, request.getShiftId());
        BigDecimal passScore = PaperUtil.getPassScore(paper.getPassLineType(), paper.getPassLine(), paper.getPassLineFixScore(), paper.getExamScore());
        PaperAnswerDetailVo vo = new PaperAnswerDetailVo();
        vo.setPaperName(paper.getPaperName());
        vo.setTotalScore(paper.getExamScore());
        vo.setSubmitTime(userPaper.getSubmitTime());
        UsersPojo pojo = this.userUtilService.selectUser(userPaper.getUserId());
        vo.setUserName(pojo != null ? pojo.getShowName() : "");
        Map<Integer, List<String>> userOrganizeMap = this.userUtilService.selectOrganizeMap(Arrays.asList(userPaper.getUserId()), userPaper.getEnterpriseId());
        List<String> userStr = userOrganizeMap.get(userPaper.getUserId());
        if (!CollectionUtils.isEmpty(userStr)) {
            vo.setDeptName(String.join((CharSequence)";", userStr));
        }
        vo.setPaperState(UserPaperStateEnum.getFrontEndValueByDatabaseValue((Integer)userPaper.getPaperStatus()));
        Boolean hasScore = PaperUtil.isHasScore(userPaper);
        if (hasScore.booleanValue()) {
            vo.setUserPassState(Integer.valueOf(userPaper.getScore().compareTo(passScore) > 0 ? 1 : 0));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingUserQuestion::getUserId, (Object)userPaper.getUserId())).eq(TrainingUserQuestion::getPaperId, (Object)userPaper.getTrainingPaperId())).eq(TrainingUserQuestion::getUserPaperId, (Object)userPaper.getId());
        List userQuestionList = this.trainingUserQuestionMapper.selectList((Wrapper)wrapper);
        ArrayList<ItemInfoVo> itemInfoVoList = new ArrayList<ItemInfoVo>();
        if (!CollectionUtils.isEmpty((Collection)userQuestionList)) {
            List userQuestionEssayIdList = userQuestionList.stream().filter(trainingUserQuestion -> 1 == trainingUserQuestion.getQuestionType()).map(trainingUserQuestion -> trainingUserQuestion.getId()).collect(Collectors.toList());
            Map<Object, Object> picMap = new HashMap();
            if (!CollectionUtils.isEmpty(userQuestionEssayIdList)) {
                LambdaQueryWrapper picWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)picWrapper.in(TrainingUserQuestionPicture::getUserQuestionId, userQuestionEssayIdList)).eq(TrainingUserQuestionPicture::getPictureType, (Object)1)).eq(TrainingUserQuestionPicture::getIsDelete, (Object)0);
                List userQuestionPictures = this.userQuestionPictureMapper.selectList((Wrapper)picWrapper);
                if (!CollectionUtils.isEmpty((Collection)userQuestionPictures)) {
                    picMap = userQuestionPictures.stream().collect(Collectors.groupingBy(TrainingUserQuestionPicture::getUserQuestionId));
                }
            }
            for (TrainingUserQuestion userQuestion : userQuestionList) {
                ItemInfoVo itemInfoVo = new ItemInfoVo();
                BeanUtils.copyProperties((Object)userQuestion, (Object)itemInfoVo);
                if (request.getIsShowRightAnswer() == null || request.getIsShowRightAnswer() == 0) {
                    itemInfoVo.setRemark(null);
                }
                List<Object> optionsList = new ArrayList();
                if (!StringUtils.isEmpty((Object)itemInfoVo.getOptionsData())) {
                    optionsList = JSONObject.parseArray((String)itemInfoVo.getOptionsData(), TrainingOptionsVo.class);
                    if (itemInfoVo.getQuestionType() == 2 && !CollectionUtils.isEmpty(optionsList)) {
                        for (TrainingOptionsVo trainingOptionsVo : optionsList) {
                            List<String> optionsLists = StringsUtils.String2List(trainingOptionsVo.getOptionsName(), "&");
                            if (!CollectionUtils.isEmpty(optionsLists)) {
                                if (!StringUtils.isEmpty((Object)trainingOptionsVo.getAnswer()) && optionsLists.contains(trainingOptionsVo.getAnswer().trim())) {
                                    trainingOptionsVo.setIsCorrect(Integer.valueOf(1));
                                    continue;
                                }
                                trainingOptionsVo.setIsCorrect(Integer.valueOf(0));
                                continue;
                            }
                            trainingOptionsVo.setIsCorrect(Integer.valueOf(1));
                        }
                    }
                }
                if (request.getIsShowRightAnswer() == null || request.getIsShowRightAnswer() == 0) {
                    optionsList = optionsList.stream().peek(option -> option.setIsAnswer(null)).collect(Collectors.toList());
                }
                itemInfoVo.setOptionList(optionsList);
                if (userQuestion.getQuestionType() == 1) {
                    List questionPictureList = (List)picMap.get(userQuestion.getId());
                    itemInfoVo.setUserQuestionPictureList(questionPictureList);
                    LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                    lambdaQueryWrapper.eq(TrainingUserQuestionAtta::getUserQuestionId, (Object)userQuestion.getId());
                    List list = this.trainingUserQuestionAttaMapper.selectList((Wrapper)lambdaQueryWrapper);
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        itemInfoVo.setAttaList(list);
                    }
                }
                itemInfoVoList.add(itemInfoVo);
            }
        }
        vo.setItemInfoVoList(itemInfoVoList);
        vo.setPaperScore(userPaper.getScore());
        vo.setPassScore(passScore);
        vo.setIsShowRightAnswer(request.getIsShowRightAnswer());
        return vo;
    }

    @Override
    @Transactional
    public void initializationPassState() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{TrainingUserPaper::getId, TrainingUserPaper::getTrainingPaperId, TrainingUserPaper::getScore, TrainingUserPaper::getSubmitTime, TrainingUserPaper::getPaperStatus});
        List userPaperList = this.trainingUserPaperMapper.selectList(null);
        Map<Integer, List<TrainingUserPaper>> userPaperMapByPaperId = userPaperList.stream().collect(Collectors.groupingBy(TrainingUserPaper::getTrainingPaperId));
        userPaperMapByPaperId.forEach((paperId, userPaperListByPaperId) -> {
            TrainingPaper trainingPaper = (TrainingPaper)this.paperMapper.selectById((Serializable)paperId);
            BigDecimal org_score = new BigDecimal("100");
            if (trainingPaper.getExamId() != null) {
                TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(trainingPaper.getExamId());
                if (!ObjectUtils.isEmpty((Object)trainingExam)) {
                    org_score = trainingExam.getScore();
                }
                int passLine = trainingPaper.getPassLine();
                for (TrainingUserPaper trainingUserPaper : userPaperListByPaperId) {
                    BigDecimal score;
                    int pass;
                    if (Objects.nonNull(trainingUserPaper.getSubmitTime()) && trainingUserPaper.getPaperStatus() == 2 && (pass = this.isPass(org_score, score = trainingUserPaper.getScore(), passLine)) == 3) {
                        trainingUserPaper.setPassState(Integer.valueOf(1));
                    }
                    this.trainingUserPaperMapper.updateById(trainingUserPaper);
                }
            }
        });
    }

    private int isPass(BigDecimal org_score, BigDecimal score, int passLine) {
        BigDecimal percent = new BigDecimal(passLine).divide(new BigDecimal(100));
        BigDecimal result = org_score.multiply(percent);
        if (score.compareTo(result) >= 0) {
            return 3;
        }
        return 4;
    }

    private List<PaperManagementItemAnalysisVo> selectItemAnalysis(ItemAnalysisRequest request) {
        PaperVo paperVo = this.paperMapper.getTrainingPaperById(request.getPaperId());
        if (ObjectUtils.isEmpty((Object)paperVo)) {
            throw new RuntimeException("\u8003\u8bd5\u4e0d\u5b58\u5728");
        }
        PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperVo, request.getShiftId());
        List<Object> trainingUserPapers = paperChannel.getUserPaperList(paperVo, null, null);
        if (request.getUserType() != null) {
            trainingUserPapers = request.getUserType() == 0 ? trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getUserId() != null).collect(Collectors.toList()) : trainingUserPapers.stream().filter(trainingUserPaper -> trainingUserPaper.getLoginUserId() != null).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(trainingUserPapers)) {
            return new ArrayList<PaperManagementItemAnalysisVo>();
        }
        List<Integer> userPaperIdList = trainingUserPapers.stream().map(TrainingUserPaper::getId).collect(Collectors.toList());
        Locale locale = Authenticator.getInstance().getCurrentClient().getLocale();
        request.setLocale(locale);
        TrainingExam trainingExam = (TrainingExam)this.trainingExamMapper.selectById(paperVo.getExamId());
        ExamChannel examChannel = this.examChannelFactory.getExamChannel(trainingExam.getExamClass());
        List<PaperManagementItemAnalysisVo> itemAnalysisList = examChannel.getItemAnalysisList(request, userPaperIdList);
        return itemAnalysisList;
    }

    private void pushExamMessage(TrainingPaper paper, TrainingPapersModifyRequest request, Users users, Integer oldPaperState) {
        if (paper.getIsMustLink() != null && paper.getIsMustLink() == 0 && !CollectionUtils.isEmpty((Collection)request.getExamUserRangeTypes()) && request.getExamUserRangeTypes().contains(0) && oldPaperState == 0 && request.getPaperState() == 1) {
            com.ovopark.privilege.response.BaseResult baseResult;
            List<Integer> allUsers = null;
            if (StringUtils.isEmpty((Object)request.getWhoCanSeeIds()) && StringUtils.isEmpty((Object)request.getRoles()) && StringUtils.isEmpty((Object)request.getTags()) && StringUtils.isEmpty((Object)request.getOrganizes())) {
                baseResult = this.userApi.getUserByGroupIdAndKey(null, paper.getEnterpriseId(), null, null, null, Integer.valueOf(0));
                if (baseResult != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                    List usersPojoList = (List)baseResult.getData();
                    allUsers = usersPojoList.stream().map(UsersPojo::getId).collect(Collectors.toList());
                }
            } else {
                allUsers = StringsUtils.StringToList(request.getWhoCanSeeIds(), ",");
            }
            if (!StringUtils.isEmpty((Object)request.getRoles()) && (baseResult = this.priUserApi.getUserByRoleIds(request.getRoles(), users.getGroupId())) != null && !CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
                List pojo = ((List)baseResult.getData()).stream().map(com.ovopark.privilege.pojo.UsersPojo::getId).distinct().collect(Collectors.toList());
                allUsers.addAll(pojo);
            }
            if (!StringUtils.isEmpty((Object)request.getTags())) {
                ArrayList<Integer> tagIds = new ArrayList<Integer>();
                String[] tagStrs = request.getTags().split(",");
                for (int i = 0; i < tagStrs.length; ++i) {
                    tagIds.add(Integer.parseInt(tagStrs[i]));
                }
                DepAndTagsPojo pojo = new DepAndTagsPojo();
                pojo.setGroupId(users.getGroupId());
                pojo.setTagIds(tagIds);
                pojo.setUserId(users.getId());
                BaseResult tagResult = this.tagApi.getUsersByTags(pojo);
                if (!tagResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)tagResult.getData()))) {
                    for (Map map : (List)tagResult.getData()) {
                        Integer id = (Integer)map.get("id");
                        allUsers.add(id);
                    }
                }
            }
            if (!StringUtils.isEmpty((Object)request.getOrganizes())) {
                ArrayList<String> orgIds = new ArrayList<String>();
                String[] organizeStrs = request.getOrganizes().split(",");
                for (int i = 0; i < organizeStrs.length; ++i) {
                    orgIds.add(organizeStrs[i]);
                }
                UsersAndOrgsMo mo = new UsersAndOrgsMo();
                mo.setGroupId(users.getGroupId());
                mo.setOrganizeIds(orgIds);
                BaseResult userResult = this.userOrganizeApi.getUserByOrganizeIdsOrDepId(mo);
                if (!userResult.getIsError().booleanValue() && !CollectionUtils.isEmpty((Collection)((Collection)userResult.getData()))) {
                    List usersIds = ((List)userResult.getData()).stream().map(UserAndParentNameMo::getUserId).distinct().collect(Collectors.toList());
                    allUsers.addAll(usersIds);
                }
            }
            if (!CollectionUtils.isEmpty(allUsers)) {
                this.messagePushService.sendPaperMessage(allUsers.stream().distinct().collect(Collectors.toList()), paper);
            }
        }
        try {
            if (paper != null) {
                this.messagePushService.sendAddKafkaWorkCircleArticleAddMo(paper.getTitle(), "TEXT_PAPER", KaFKaWorkCircleArticleAddMo.circle_training, users.getId(), paper.getEnterpriseId(), "1".equals(paper.getLookLevel() == null ? "0" : paper.getLookLevel().toString()) ? 0 : 1, paper.getId(), StringsUtils.StringToList(request.getWhoCanSeeIds(), ","));
            }
        }
        catch (Exception e) {
            log.info("saveTrainingPaper================sendAddKaFKaWorkCircleArticleAddMo", (Throwable)e);
        }
    }

    @Override
    public Page<PaperVo> getPaperList(TrainingPapersListRequest request, Users user) {
        Map<String, Object> userMap;
        if (request.getPaperTypeId() != null) {
            request.setPaperTypeIdList(this.getCategoryIdList(request.getPaperTypeId(), request.getIsContainChild(), user));
        }
        List<Object> creaters = Lists.newArrayList();
        if (!StringUtils.isEmpty((Object)request.getSearch()) && (userMap = this.userUtilService.getCheckParameters(request.getSearch(), null, null, user)).get("isEffect").toString().equals("1")) {
            List userList = (List)userMap.get("userList");
            creaters.addAll(userList);
            creaters = creaters.stream().distinct().collect(Collectors.toList());
        }
        request.setCreateUserIdList((List)creaters);
        request.setGroupId(user.getGroupId());
        com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page((long)request.getPageNumber().intValue(), (long)request.getPageSize().intValue());
        List<PaperVo> list = this.paperMapper.getTrainingPaperList((com.baomidou.mybatisplus.extension.plugins.pagination.Page<PaperVo>)page, request);
        Page res = new Page();
        res.setPageSize(request.getPageSize().intValue());
        res.setPageNumber(request.getPageNumber().intValue());
        res.setPageCount(Long.valueOf(page.getPages()));
        res.setTotalCount(Long.valueOf(page.getTotal()));
        res.setContent(list);
        if (CollectionUtils.isEmpty(list)) {
            return res;
        }
        List materialTypeIdList = list.stream().map(PaperVo::getCategoryId).filter(Objects::nonNull).collect(Collectors.toList());
        List trainingMaterialTypes = this.trainingMaterialTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrainingMaterialType::getId, materialTypeIdList)).select(new SFunction[]{TrainingMaterialType::getId, TrainingMaterialType::getMaterialTypeName}));
        Map<Integer, String> materialTypeMap = trainingMaterialTypes.stream().collect(Collectors.toMap(TrainingMaterialType::getId, TrainingMaterialType::getMaterialTypeName));
        Map<Integer, PaperVo> otherPaperInfoMap = this.handleOtherPaperInfoByPaperId(list, user);
        Set createrSet = list.stream().filter(paperVo -> paperVo.getCreateUserId() != null).map(PaperVo::getCreateUserId).collect(Collectors.toSet());
        Map<Integer, UsersPojo> pojoMap = this.userUtilService.selectUserMap(Lists.newArrayList(createrSet));
        list.forEach(paperVo -> {
            Integer id = paperVo.getId();
            paperVo.setCategoryName((String)materialTypeMap.get(paperVo.getCategoryId()));
            paperVo.setPaperState(PaperStateEnum.getFrontEndValueByDatabaseValue((Integer)paperVo.getPaperState()));
            PaperVo otherInfo = otherPaperInfoMap.containsKey(id) ? (PaperVo)otherPaperInfoMap.get(id) : new PaperVo();
            paperVo.setRegisteredParticipants(otherInfo.getRegisteredParticipants());
            paperVo.setSubmittedParticipants(otherInfo.getSubmittedParticipants());
            paperVo.setPassedParticipants(otherInfo.getPassedParticipants());
            paperVo.setPassRate(otherInfo.getPassRate());
            Integer paperSource = PaperSourceEnum.getFrontEndValueByPaperTableValue((Integer)paperVo.getProjectShow());
            paperVo.setPaperSource(paperSource);
            if (paperVo.getCreateUserId() != null && pojoMap.containsKey(paperVo.getCreateUserId())) {
                paperVo.setCreateUser(((UsersPojo)pojoMap.get(paperVo.getCreateUserId())).getShowName());
            }
            paperVo.setIsVisitorShare(Integer.valueOf(paperVo.getExamUserRangeTypes().contains(1) ? 1 : 0));
        });
        res.setContent(list);
        return res;
    }

    private Map<Integer, PaperVo> handleOtherPaperInfoByPaperId(List<PaperVo> paperVoList, Users user) {
        HashMap<Integer, PaperVo> result = new HashMap<Integer, PaperVo>();
        for (PaperSourceEnum paperSourceEnum : PaperSourceEnum.values()) {
            List<PaperVo> paperList = paperVoList.stream().filter(paperVo -> {
                if (paperSourceEnum.getPaperTableValue() == null) {
                    return paperSourceEnum.getPaperTableValue() == paperVo.getProjectShow();
                }
                return paperSourceEnum.getPaperTableValue().equals(paperVo.getProjectShow());
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(paperList)) continue;
            PaperChannel paperChannel = this.paperChannerlFactory.getPaperChannel(paperSourceEnum.getPaperTableValue());
            Map<Integer, PaperVo> paperSituationMap = paperChannel.handlePaperSituation(paperList, user);
            result.putAll(paperSituationMap);
        }
        return result;
    }

    private List<Integer> getCategoryIdList(Integer typeId, Integer isContainChild, Users user) {
        int moduleType2 = 3;
        boolean coverChild = isContainChild == null || isContainChild == 1;
        List<Integer> materialTypeIds = this.materialTypeService.getMaterialTypeByPermissionAndTypeIdList(user, 3, moduleType2, typeId, coverChild);
        if (materialTypeIds == null || CollectionUtils.isEmpty(materialTypeIds)) {
            return new ArrayList<Integer>();
        }
        return materialTypeIds;
    }
}

